<?php
function wayfair_autoload($class_name){
    if(!strstr($class_name,'wayfair')){
        return false;
    }
    $file = realpath(__DIR__).DIRECTORY_SEPARATOR.str_replace('\\','/',$class_name).'.php';
    if(file_exists($file)){
      require_once($file);
    }
}
spl_autoload_register('wayfair_autoload');


require_once(DIR_FS_CATALOG.'lang/german/modules/order_total/ot_total.php');
require_once(DIR_FS_CATALOG.'lang/german/modules/order_total/ot_subtotal.php');
require_once(DIR_FS_CATALOG.'lang/german/modules/order_total/ot_tax.php');

class wayfair {
	const WAYFAIR_TESTMODE = false;
	const WAYFAIR_DATA_DIR = YES_SYSTEM_HOME_DIRECTORY.'wayfair';
	const WAYFAIR_ORDERS_ADDRESS_FORMAT_ID = 5;
	const WAYFAIR_ORDERS_PAYMENT_METHOD = 'moneyorder';
	const WAYFAIR_ORDERS_STATUS = 1;
	const ALLOWANCE_CODES = [
		'AA' => 'Advertising Co-op',
		'DA' => 'Allowance for Damages/ Defects',
		'SF' => 'Allowance for Returns',
		'SF' => 'Allowance for Damage/ Defects/ Returns',
		'EAB' => 'Early Pay Discount',
		'EAB' => 'Pay in Advance',
		'CAG' => 'Pricing Discount',
		'PAD' => 'Promotional Discount',
		'SF' => 'Allowance for Damages/ Returns',
	];
	const SCAC_CODES = [
		'BJS Distribution'=>'BJSH',
		'C.H. Robinson - Europe'=>'CHRB',
		'DHL Freight DEU'=>'DFDE',
		'DHL Freight Network'=>'DFFN',
		'DHL Home Delivery GmbH'=>'DHWG',
		'DHL Paket DEU'=>'DHDE',
		'DHL Paket UK'=>'DHUK',
		'DHL Parcel UK'=>'UKML',
		'DPD'=>'DPDD',
		'DPD DEU'=>'DPDE',
		'DX Freight - 1 Man'=>'NIDW',
		'GEL Express Logistik GmbH'=>'GEL1',
		'GLS - UK'=>'GLUK',
		'GLS DEU'=>'GLDE',
		'Hermes Einrichtungs Service'=>'HRMS',
		'Hermes World'=>'HUK1',
		'Hermes World'=>'HRSP',
		'IDS Logistik GmbH'=>'IDS',
		'Jan Krediet'=>'JANK',
		'LGT Logistics A/S'=>'LGTL',
		'Network 4 - 2 man'=>'NWUK',
		'Panther'=>'PROM',
		'Rhenus 2.0 - (Only Temporary / Testing Account)'=>'RHE20',
		'Rhenus Home Delivery'=>'RSHD',
		'Rhenus Poland [FN]'=>'RHPLFN',
		'SEUR'=>'SEUR',
		'Supplier Own Account'=>'SSOA',
		'SUUS 2.0 - (Only Temporary / Testing Account)'=>'SUUS',
		'SUUS Logistics SA'=>'SUUS',
		'UPS - DEU'=>'UPDE',
		'UPS - UK'=>'UPUK',
		'XDP'=>'XDPE'
	];
	const VERSANDGESCHWINDIGKEIT_CODES = [
		'2D'=>'2ND DAY',
		'2D2'=>'2ND DAY ? HI/AK/PR',
		'3D'=>'3RD DAY',
		'APO'=>'APO/FPO',
		'ND'=>'NEXT DAY',
		'TRB'=>'TRUCK/BACK OF TRUCK',
		'TRI'=>'TRUCK/IN HOUSE',
		'BWG'=>'Basic White Glove',
		'WGB2'=>'White Glove Basic',
		'WGB'=>'White Glove Bronze',
		'WGS'=>'White Glove Silver',
		'WGG'=>'White Glove Gold',
		'WGP'=>'White Glove Platinum',
		'CTO'=>'European Line Haul'
	];

	const DROPSHIP_QUALIFIERS = [
		'DS' => 'Dropship Purchase Order',
		'CO' => 'Stocking Purchase Order'
	];

	const CSV_EOL = PHP_EOL;
	const CSV_SEPARATOR = "|";

	var $data_dir;
    
	public function importInvoice($csv_string){
		$wi = new wayfair_invoice($csv_string);
		$wi->create_yes_order();
	}
	public function importOrders($csv_string){
		$rows = explode(self::CSV_EOL,$csv_string);
		$orders = [];
		$new_order = 0;
		foreach($rows as $row_nr=>$row){
			$cols = explode(self::CSV_SEPARATOR,$row);
			if(sizeOf($cols) < 2){
				continue;
			}
			if($cols[0] == 'IH'){
				$new_order++;
				$orders[ $new_order ] = new wayfair_order($cols);
			}else{
				$orders[ $new_order ]->addItem( $cols );
			}
		}
		foreach($orders as $wayfair_order){
			$orders_id = $wayfair_order->create_yes_order();
			if($orders_id > 0){
				printf("  Import successful - orders_id: %d\r\n\r\n",$orders_id);
			}
		}
		return true;
	}

	public function __construct(){
		$this->data_dir = main::get_secure_path();
		if(!defined('MODULE_OTHER_YES_WAYFAIR_DUMMY_PRODUCTS_ID') or MODULE_OTHER_YES_WAYFAIR_DUMMY_PRODUCTS_ID < 1){
			throw new Exception('Please configure the dummy products_id in the yes_wayfair module.');
		}
	}

	public function get_order_files(){
		$files = array();
		if ($handle = opendir(self::WAYFAIR_DATA_DIR)) {
			while (false !== ($entry = readdir($handle))) {
				if ($entry != "." && $entry != "..") {
					$files[] = self::WAYFAIR_DATA_DIR.DIRECTORY_SEPARATOR.$entry;
				}
			}
			closedir($handle);
		}else{
			throw new Exception('Cant open wayfair data dir');
		}
		return $files;
	}
}


$wayfair = new wayfair;
$order_files = $wayfair->get_order_files();
if(!sizeOf($order_files)){
	echo "No wayfair order files to process\r\n";
}
foreach($order_files as $file) {
	printf("Process datafile %s\r\n",$file);
	if($wayfair->importOrders(file_get_contents($file)) === True){
		printf("  delete file %s\r\n",$file);
		unlink($file);
	}
}



//$wayfair->importInvoice('');
