<?php
class wayfair_order{
    var $Record_Identifier; // (Always *IH* for Item Header)
    var $Supplier_ID;
    var $PO_Number;
    var $PO_Date;
    var $Dropship_Qualifier;
    var $VAT_Number;
    var $ISO_Currency_Code;
    var $Ship_to_Name;
    var $Ship_to_Address;
    var $Ship_to_Address2; // *note* this could be delivery instructions entered by the customer
    var $Ship_to_City;
    var $Ship_to_Province; //County
    var $Ship_to_Postal_Code;
    var $Ship_to_Country;
    var $Ship_to_Phone; // *note* multiple phone numbers can be entered by the customer
    var $Items;
    
    function getRecord_Identifier() {
        return $this->Record_Identifier;
    }

    function getSupplier_ID() {
        return $this->Supplier_ID;
    }

    function getPO_Number() {
        return $this->PO_Number;
    }

    function getPO_Date() {
        return $this->PO_Date;
    }

    function getDropship_Qualifier() {
        return $this->Dropship_Qualifier;
    }

    function getVAT_Number() {
        return $this->VAT_Number;
    }

    function getISO_Currency_Code() {
        return $this->ISO_Currency_Code;
    }

    function getShip_to_Name() {
        return $this->Ship_to_Name;
    }

    function getShip_to_Address() {
        return $this->Ship_to_Address;
    }

    function getShip_to_Address2() {
        return $this->Ship_to_Address2;
    }

    function getShip_to_City() {
        return $this->Ship_to_City;
    }

    function getShip_to_Province() {
        return $this->Ship_to_Province;
    }

    function getShip_to_Postal_Code() {
        return $this->Ship_to_Postal_Code;
    }

    function getShip_to_Country() {
        return $this->Ship_to_Country;
    }

    function getShip_to_Phone() {
        return $this->Ship_to_Phone;
    }

    function setRecord_Identifier($Record_Identifier) {
        $this->Record_Identifier = $Record_Identifier;
    }

    function setSupplier_ID($Supplier_ID) {
        $this->Supplier_ID = $Supplier_ID;
    }

    function setPO_Number($PO_Number) {
        $this->PO_Number = $PO_Number;
    }

    function setPO_Date($PO_Date) {
        $this->PO_Date = $PO_Date;
    }

    function setDropship_Qualifier($Dropship_Qualifier) {
        $this->Dropship_Qualifier = $Dropship_Qualifier;
    }

    function setVAT_Number($VAT_Number) {
        $this->VAT_Number = $VAT_Number;
    }

    function setISO_Currency_Code($ISO_Currency_Code) {
        $this->ISO_Currency_Code = $ISO_Currency_Code;
    }

    function setShip_to_Name($Ship_to_Name) {
        $this->Ship_to_Name = $Ship_to_Name;
    }

    function setShip_to_Address($Ship_to_Address) {
        $this->Ship_to_Address = $Ship_to_Address;
    }

    function setShip_to_Address2($Ship_to_Address2) {
        $this->Ship_to_Address2 = $Ship_to_Address2;
    }

    function setShip_to_City($Ship_to_City) {
        $this->Ship_to_City = $Ship_to_City;
    }

    function setShip_to_Province($Ship_to_Province) {
        $this->Ship_to_Province = $Ship_to_Province;
    }

    function setShip_to_Postal_Code($Ship_to_Postal_Code) {
        $this->Ship_to_Postal_Code = $Ship_to_Postal_Code;
    }

    function setShip_to_Country($Ship_to_Country) {
        $this->Ship_to_Country = $Ship_to_Country;
    }

    function setShip_to_Phone($Ship_to_Phone) {
        $this->Ship_to_Phone = $Ship_to_Phone;
    }
    
    function getItems() {
        return $this->Items;
    }

    function setItems(wayfair_order_items $Items) {
        $this->Items = $Items;
    }
    
    function addItem( $csv ){
        $this->Items[] = new wayfair_order_item($csv);
    }

    
    function __construct( $csv ){
        $col = 0;
        $this->setRecord_Identifier($csv[$col++]);
        $this->setSupplier_ID($csv[$col++]);
        $this->setPO_Number($csv[$col++]);
        $this->setPO_Date($csv[$col++]);
        $this->setDropship_Qualifier($csv[$col++]);
        $this->setVAT_Number($csv[$col++]);
        $this->setISO_Currency_Code($csv[$col++]);
        $this->setShip_to_Name($csv[$col++]);
        $this->setShip_to_Address($csv[$col++]);
        $this->setShip_to_Address2($csv[$col++]);
        $this->setShip_to_City($csv[$col++]);
        $this->setShip_to_Province($csv[$col++]);
        $this->setShip_to_Postal_Code($csv[$col++]);
        $this->setShip_to_Country($csv[$col++]);
        $this->setShip_to_Phone($csv[$col++]);
    }

	private function get_order_comments(){
		$comments = '';
		foreach($this->getItems() as $item){
			if( $item->getCustom_Comments() != ''){
				$comments .= "<br />\r\n".$item->getItem_Description().': '.$item->getCustom_Comments();
			}
		}
		return $comments;
	}

	private function get_shipping_method( $target_scac = null ){
		$methods = array();
		foreach($this->getItems() as $item){
			foreach(wayfair::SCAC_CODES as $scac_name => $scac){
				if($scac == $item->getSCAC()){
					if($target_scac !== NULL and $target_scac == $scac){
						return $scac_name;
					}
					if(!in_array($scac_name,$methods)){
						$methods[] = $scac_name;
					}
				}
			}
		}
		return $methods;
	}

	private function get_versender(string $shipping_method){
		if(strstr('DHL',$shipping_method)){
			return 'DHL';
		}elseif(strstr('DPD',$shipping_method)){
			return 'DPD';
		}elseif(strstr('GLS',$shipping_method)){
			return 'GLS';
		}elseif(strstr('Hermes',$shipping_method)){
			return 'Hermes';
		}elseif(strstr('UPS',$shipping_method)){
			return 'UPS';
		}
		return '';
	}

	private function get_yes_country_name(){
		switch($this->getShip_to_Country()){
			case 'UK':
				return 'United Kingdom';
				break;
			case 'DE':
				return 'Germany';
				break;
			case 'AT':
				return 'Austria';
				break;
		}
		$country_id = yes_get_country_id_from_iso2( $this->getShip_to_Country() );
		return xtc_get_country_name($country_id);
	}

	public function is_imported(){
		$query = xtc_db_query(sprintf(
			"SELECT orders_id FROM wayfair_orders WHERE po_number='%s'",
			$this->getPO_Number()
		));
		return xtc_db_num_rows($query);
	}

	public function create_yes_order(){
		if(wayfair::WAYFAIR_TESTMODE === True){
			printf("  PROCESS PO NUMBER %s\r\n",$this->getPO_Number());
		}
		if($this->is_imported()){
			printf("\torder exists\r\n");
			return false;
		}
		$cID = wayfair_yes::get_customers_id( $this->getSupplier_ID() );
		$cs = xtc_get_customer_status($cID);
		$q = xtc_db_query(sprintf(
			"SELECT * FROM customers_status WHERE customers_status_id='%d'",
			$cs['customers_status']
		));
		$r = xtc_db_fetch_array($q);
		$add_tax = $r['customers_status_add_tax_ot'] == 1;
		$customer_data = wayfair_yes::get_customers_data( $cID );
		$ab = wayfair_yes::get_address_book_data( $customer_data['customers_default_address_id'] );
		foreach($this->getItems() as $item){
			$query = xtc_db_query(sprintf(
				"SELECT products_id FROM %s WHERE products_id='%d'",
				TABLE_PRODUCTS,$item->getItem_Number() 
			));
			if(!xtc_db_num_rows($query)){
				$item->setItem_Number(MODULE_OTHER_YES_WAYFAIR_DUMMY_PRODUCTS_ID);
			}
		}

		$shipping_methods = $this->get_shipping_method();
		$shipping_method = current($shipping_methods);
		$shipping_comments = 'Wayfair Versandvorgabe zum '.xtc_date_short($this->getPO_Date());
		if(sizeOf($shipping_methods) > 1){
			$shipping_comments .= sprintf("\r\n%d versch. Versandarten. %s",sizeOf($shipping_methods),implode(',',$shipping_methods));
		}else{
			$shipping_comments .= sprintf("\r\nVersandart: %s",current($shipping_methods));
		}

		$insert_sql_array = array(
		    'orders_status'=>ORDERS_STATUS_BEZAHLT,
		    'customers_id'=>$cID,
		    'customers_status'=>$cs['customers_status'],
		    'customers_status_name'=>$cs['customers_status_name'],
		    'customers_status_image'=>$cs['customers_status_image'],
		    'customers_status_discount'=>$cs['customers_status_discount'],
		    'customers_name'=>$ab['entry_firstname'].' '.$ab['entry_lastname'],
		    'customers_company'=>$ab['entry_company'],
		    'customers_street_address'=>$ab['entry_street_address'],
		    'customers_suburb'=>$ab['entry_suburb'],
		    'customers_city'=>$ab['entry_city'],
		    'customers_postcode'=>$ab['entry_postcode'],
		    'customers_state'=>$ab['entry_state'],
		    'customers_country'=>xtc_get_country_name($ab['entry_country_id']),
		    'customers_telephone'=>$customer_data['customers_telephone'],
		    'customers_mobile'=>$customer_data['mobile'],
		    'customers_email_address'=>$customer_data['customers_email_address'],
		    'customers_address_format_id'=>wayfair::WAYFAIR_ORDERS_ADDRESS_FORMAT_ID,
		    'delivery_name'=>$this->getShip_to_Name(),
		    'delivery_company'=>$ab['entry_company'],
		    'delivery_street_address'=>$this->getShip_to_Address(),
		    'delivery_suburb'=>$this->getShip_to_Address2(),
		    'delivery_city'=>$this->getShip_to_City(),
		    'delivery_postcode'=>$this->getShip_to_Postal_Code(),
		    'delivery_state'=>$this->getShip_to_Province(),
		    'delivery_country'=>$this->get_yes_country_name(),
		    'delivery_address_format_id'=>wayfair::WAYFAIR_ORDERS_ADDRESS_FORMAT_ID,
		    'delivery_email_address'=>$customer_data['customers_email_address'],
		    'delivery_telephone'=>$this->getShip_to_Phone(),
		    'billing_name'=>$ab['entry_firstname'].' '.$ab['entry_lastname'],
		    'billing_company'=>$ab['entry_company'],
		    'billing_street_address'=>$ab['entry_street_address'],
		    'billing_suburb'=>$ab['entry_suburb'],
		    'billing_city'=>$ab['entry_city'],
		    'billing_postcode'=>$ab['entry_postcode'],
		    'billing_state'=>$ab['entry_state'],
		    'billing_country'=>xtc_get_country_name($ab['entry_country_id']),
		    'billing_address_format_id'=>wayfair::WAYFAIR_ORDERS_ADDRESS_FORMAT_ID,
		    'payment_method'=>wayfair::WAYFAIR_ORDERS_PAYMENT_METHOD,
		    'comments'=>'[Wayfair Order #'.$this->getPo_Number().'] '.$this->get_order_comments(),
		    'last_modified'=>'now()',
		    'date_purchased'=>'now()',
		    'date_payment'=>'',
		    'orders_status'=>wayfair::WAYFAIR_ORDERS_STATUS,
		    'orders_date_finished'=>'',
		    'currency'=>$this->getISO_Currency_Code(),
		    'currency_value'=>1,
		    'account_type'=>'',
		    'payment_class'=>wayfair::WAYFAIR_ORDERS_PAYMENT_METHOD,
		    'shipping_method'=>'wayfair',
		    'shipping_class'=>'wayfair',
		    'language'=>'german',
		    'versender'=>$this->get_versender($shipping_method),
		    'comments_visible'=>'',
		    'source'=>'wayfair',
		    'source_editor_id'=>0,
		    'shipping_comments'=>$shipping_comments
		);
		if(wayfair::WAYFAIR_TESTMODE === True){
			printf("\t:: orders\r\n");
			//print_r($insert_sql_array);
			$orders_id = 111111;
		}else{
			xtc_db_perform(TABLE_ORDERS,$insert_sql_array);
			$orders_id = xtc_db_insert_id();
		}
		$brutto = 0;
		$netto = 0;
		foreach($this->getItems() as $nr=>$item){
			$products_tax = 0;
			if($add_tax){
                            $country_id = $ab['entry_country_id'];
                            $zone_id = $ab['entry_zone_id'];
                            
                            // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                            /*if(!yes_eu_oss_use_country_handling($country_id)){
                                $country_id = STORE_COUNTRY;
                                $zone_id = 0;
                            }*/
                            // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                            
                            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                                $item->getItem_Number(),$country_id
                            );
                            $products_tax = xtc_get_tax_rate($products_tax_class_id,
                                $country_id, // country id vom customer
                                $zone_id // zone_id vom customer
                            );
			}
			$insert_sql_array = array(
				'orders_id'=>$orders_id,
				'products_id'=>$item->getItem_Number(),
				'products_name'=>$item->getItem_Description(),
				'products_price'=>$item->getWholesale_Price() / $item->getQuantity(),
				'final_price'=>$item->getWholesale_Price(),
				'products_quantity'=>$item->getQuantity(),
				'products_tax'=>$products_tax,
				'allow_tax'=>($add_tax)?1:0,
				'date_added'=>'now()'
			);
			$brutto += $item->getWholesale_Price();
			if($add_tax){
				$netto += $item->getWholesale_Price() / ((100+$products_tax)/100);
			}
			if(wayfair::WAYFAIR_TESTMODE === True){
				printf("\t:: orders_products #%d\r\n",$nr);
				//print_r($insert_sql_array);
			}else{
				xtc_db_perform(TABLE_ORDERS_PRODUCTS,$insert_sql_array);
				$orders_products_id = xtc_db_insert_id();
			}
		}
		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'title'=>MODULE_ORDER_TOTAL_SUBTOTAL_TITLE,
			'text'=>number_format($brutto,2,',','.').' '.$this->getISO_Currency_Code(),
			'value'=>$brutto,
			'class'=>'ot_subtotal'
		);
		if(wayfair::WAYFAIR_TESTMODE === True){
			printf("\t:: orders_total (ot_subtotal)\r\n");
			//print_r($insert_sql_array);
		}else{
			xtc_db_perform(TABLE_ORDERS_TOTAL,$insert_sql_array);
		}
		if($add_tax){
			$ot_tax_title = sprintf('%s %s%%',MODULE_ORDER_TOTAL_TAX_TITLE,
				number_format($products_tax,0)
			);
			$insert_sql_array = array(
				'orders_id'=>$orders_id,
				'title'=>$ot_tax_title,
				'text'=>number_format($brutto-$netto,2,',','.').' '.$this->getISO_Currency_Code(),
				'value'=>$brutto-$netto,
				'class'=>'ot_tax'
			);
			if(wayfair::WAYFAIR_TESTMODE === True){
				printf("\t:: orders_total (ot_tax)\r\n");
				//print_r($insert_sql_array);
			}else{
				xtc_db_perform(TABLE_ORDERS_TOTAL,$insert_sql_array);
			}
		}
		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'title'=>MODULE_ORDER_TOTAL_TOTAL_TITLE,
			'text'=>'<b>'.number_format($brutto,2,',','.').' '.$this->getISO_Currency_Code().'</b>',
			'value'=>$brutto,
			'class'=>'ot_total'
		);
		if(wayfair::WAYFAIR_TESTMODE === True){
			printf("\t:: orders_total (ot_total)\r\n");
			//print_r($insert_sql_array);
		}else{
			xtc_db_perform(TABLE_ORDERS_TOTAL,$insert_sql_array);
		}
		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'orders_status_id'=>wayfair::WAYFAIR_ORDERS_STATUS,
			'date_added'=>'now()',
			'customer_notified'=>false,
			'comments'=>'wayfair Import order #'.$this->getPo_Number()
		);
		if(wayfair::WAYFAIR_TESTMODE === True){
			printf("\t:: orders_status_history\r\n");
			//print_r($insert_sql_array);
		}else{
			xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY,$insert_sql_array);
		}
		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'date_added'=>'now()',
			'po_number'=>$this->getPo_Number(),
			'supplier_id'=>$this->getSupplier_ID(),
			'dropship_qualifier'=>$this->getDropship_Qualifier(),
        		'vat_number'=>$this->getVAT_Number()
		);
		if(wayfair::WAYFAIR_TESTMODE === True){
			printf("\t:: wayfair_orders\r\n");
			//print_r($insert_sql_array);
		}else{
			xtc_db_perform('wayfair_orders',$insert_sql_array);
		}
		return $orders_id;
	}
}

