<?php
require_once(DIR_FS_CATALOG.'admin/includes/classes/yesEbayItem_product.php');
class yesEbayItem{
    var $item;
    var $db_text_array_separator = "\n";
    var $config;
    var $last_products_master_id = 0;
    var $language_id;
    var $languages;
    
    function __construct($item,$config){
	$this->item = $item;
	$this->config = $config;
	$this->language_id = $this->getYesLanguage_id();
	$this->languages = xtc_get_languages();
    }
    
    public function getYesLanguage_id(){
        foreach(\YES4Trade\Model\languages::get_list() as $l){
            if($l['code'] == strtolower($this->item->Country)){
                return $l['languages_id'];
            }
        }
	die(sprintf(
		"Auktion %s: Lokales Sprachpaket fuer %s nicht installiert.\r\n",
		$this->item->Country
	));
    }
    
    function getIsNew(){
	if($this->item->ConditionID and in_array($this->item->ConditionID,$this->config['conditions_id_new'])){
	    return true;
	}
	    return false;
    }
    function getYesTaxClassID(){
	$query = xtc_db_query(sprintf(
		"SELECT tr.tax_class_id FROM tax_class tc LEFT JOIN tax_rates tr USING(tax_class_id) WHERE tr.tax_rate='%s' AND tax_zone_id='%s'",
		$this->getTaxRate(),$this->config['tax_zone_id']
	));
	if(!xtc_db_num_rows($query)){
	    die(sprintf(
		    "ERROR: Fuer Auktion %s konnte keine MwSt Klasse ermittelt werden (%s)\r\n",
		    $this->item->ItemID,$this->getTaxRate()
	    ));
	}
	$record = xtc_db_fetch_array($query);
	return $record['tax_class_id'];
    }
    
    function getTaxRate(){
	if($this->item->VATDetails){
	    return $this->item->VATDetails->VATPercent;
	}else{
	    return $this->config['default_tax_rate'];
	}
    }
    
    function removeTax($amount,$tax_rate){
	return $amount / (($tax_rate+100)/100);
    }
    
    function getPrice(){
	$price = 0;
	switch($this->item->ListingType){
	    case 'Chinese':
		if($this->item->ListingDetails->ConvertedBuyItNowPrice->value > 0){
		    $price = $this->item->ListingDetails->ConvertedBuyItNowPrice->value;
		}else{
		    $price = $this->item->ListingDetails->ConvertedStartPrice->value;
		}
		break;
	    default:
		$price = $this->item->ListingDetails->ConvertedStartPrice->value;
		break;
	}
	return $price;
    }
    
    function getPriceNetto($price,$tax){
	if($tax > 0){
	    $price = $this->removeTax($price,$tax);
	}
	return $price;
    }
    
    function getImages(){
	switch($this->item->PictureDetails->PhotoDisplay){
	    case 'None':
		if($this->item->PictureDetails->GalleryURL){
		    return array($this->item->PictureDetails->GalleryURL);
		}
		break;
	    default:
		$images = array();
		if(!is_array($this->item->PictureDetails->PictureURL)){
		    return $images;
		}
		foreach($this->item->PictureDetails->PictureURL as $picture){
		    $images[] = $picture;
		}
		return $images;
		break;
	}
    }
    
    function getPrimaryCategoryID(){
	if(is_object($this->item->PrimaryCategory)){
	    return $this->item->PrimaryCategory->CategoryID;
	}
	return '';
    }
    function getSecondaryCategoryID(){
	if(is_object($this->item->SecondaryCategory)){
	    return $this->item->SecondaryCategory->CategoryID;
	}
	return '';
    }
    
    function exists(){
	$query = xtc_db_query(sprintf(
		"SELECT _YEI_products_id FROM _YEI_products WHERE item_id='%s'",
		$this->item->getItemID()
	));
	if(xtc_db_num_rows($query))
	    return true;
	return false;
    }
    
    function getYesShippingStatusID(){
	if(!$this->item->DispatchTimeMax or $this->item->DispatchTimeMax == 0){
	    return $this->config['dispatch_scheme'][0];
	}
	$value = $this->config['dispatch_scheme'][0];
	foreach($this->config['dispatch_scheme'] as $duration=>$id){
	    if($duration <= $this->item->DispatchTimeMax){
		$value = $id;
	    }
	}
	return $value;
    }
    
    
    function saveYEI_product($products_id_array){
	    if(!$this->item->Variations){
		$insert_sql_array = array(
		    'sku'=>$this->item->SKU,
		    'images'=>implode($this->db_text_array_separator,$this->getImages()),
		    'item_id'=>$this->item->getItemID(),
		    'price'=>$this->getPrice(),
		    'primary_category'=>$this->getPrimaryCategoryID(),
		    'secondary_category'=>$this->getSecondaryCategoryID(),
		    'products_id'=>current($products_id_array),
		    'site'=>$this->item->Site
		);
		xtc_db_perform('_YEI_products',$insert_sql_array);
	    }else{
		$insert_sql_array = array(
		    'sku'=>$this->item->getSKU(),
		    'images'=>implode($this->db_text_array_separator,$this->getImages()),
		    'item_id'=>$this->item->getItemID(),
		    'price'=>0,
		    'primary_category'=>$this->getPrimaryCategoryID(),
		    'secondary_category'=>$this->getSecondaryCategoryID(),
		);
		xtc_db_perform('_YEI_products',$insert_sql_array);
		$yeipID = xtc_db_insert_id();
		foreach($this->item->Variations->Variation as $vnr=>$variation){
		    $insert_sql_array = array(
			'_YEI_products_id'=>$yeipID,
			'sku'=>$variation->SKU,
			'images'=>implode($this->db_text_array_separator,$this->getImagesFromVariation($variation->VariationSpecifics)),
			'price'=>$variation->StartPrice->value,
			'products_id'=>$products_id_array[$vnr]
		    );
		    xtc_db_perform('_YEI_products_variations',$insert_sql_array);
		}
	    }
    }
    
    function getImagesFromVariation($variationVS){
	$images = array();
	foreach($variationVS as $nvl){
	    foreach($this->item->Variations->Pictures as $pt){
		if($pt->VariationSpecificName != $nvl->Name){
		    continue;
		}
		foreach($pt->VariationSpecificPictureSet as $varSpPicSet){
		    foreach($nvl->Value as $val){
			if($val != $varSpPicSet->VariationSpecificValue){
			    continue;
			}
			foreach($varSpPicSet->PictureURL as $img){
			    $images[] = $img;
			}
		    }
		}
	    }
	}
	return $images;
    }
    
    private function importDescription($products_id){
	foreach($this->languages as $lang){
	    $insert_sql_array = array(
		'products_id'=>$products_id,
		'language_id'=>$lang['id'],
		'products_name'=>$this->prepareString($this->item->Title),
		'ebay_title'=>$this->prepareString($this->item->Title),
		'products_description'=>$this->prepareString($this->item->Description,true),
		'slave_title'=>(($this->last_products_master_id > 0) ? $this->prepareString($this->item->Title) : '')
	    );
	    xtc_db_perform('products_description',$insert_sql_array);
	}
    }
    
    function import(){
	if($this->item->Variations){
	    $products_id_array = array();
	    foreach($this->item->Variations->Variation as $k=>$variation){
		$product = new yesEbayItem_product();
		$product->setProducts_model( $this->getProductsModel($variation));
		$product->setProducts_ean($this->getProductsEAN($variation));
		$product->setImages($this->getImagesFromVariation($variation->VariationSpecifics));
		if($k == 0){
		    $product->setProducts_master_status(1);
		}else{
		    $product->setProducts_master($this->last_products_master_id);
		}
		$product->setProducts_quantity($variation->Quantity);
		if($this->config['save_sku_as_products_model'] === true){
		    $product->setProducts_model($variation->SKU);
		}
		if($this->config['save_sku_as_products_ean'] === true){
		    $product->setProducts_ean($variation->SKU);
		}
		$product->setProducts_price($this->getPriceNetto($variation->StartPrice->value,$this->getTaxRate()));
		$this->add_product_default_values($product);
		$products_id = $product->import();
		
		$this->importDescription($products_id);
		
		if($product->getProducts_master_status() == 1){
		    $this->processVariationSpecificsSetsForMaster($products_id);
		    $this->last_products_master_id = $products_id;
		}
		foreach($variation->VariationSpecifics as $nlv){
		    $this->processVariationSpecificsSetsForSlave($products_id,$nlv->Name,current($nlv->Value));
		}
		$products_id_array[] = $products_id;
	    }
	    $this->saveYEI_product($products_id_array);
	    return true;
	}
	$product = new yesEbayItem_product();
	$product->setProducts_model( $this->getProductsModel());
	$product->setProducts_ean($this->getProductsEAN());
	$product->setImages($this->getImages());
	if($this->config['save_sku_as_products_model'] === true){
	    $product->setProducts_model($this->item->SKU);
	}
	if($this->config['save_sku_as_products_ean'] === true){
	    $product->setProducts_ean($this->item->SKU);
	}
	$product->setProducts_price($this->getPriceNetto($this->getPrice(),$this->getTaxRate()));
	$product->setProducts_quantity($this->item->Quantity);
	$this->add_product_default_values($product);
	$products_id = $product->import();
	$this->importDescription($products_id);
	$this->saveYEI_product(array($products_id));
	return true;
    }
    
    private function processVariationSpecificsSetsForSlave($products_id,$title,$value){
	$pmkID = $this->getYesProducts_master_key_id($title,$this->last_products_master_id);
	foreach($this->languages as $lang){
	    $insert_sql_array = array(
		'products_master_key_id'=>$pmkID,
		'products_id'=>$products_id,
		'title'=>$this->prepareString($value),
		'language_id'=>$lang['id']
	    );
	    xtc_db_perform('products_master_slave_values',$insert_sql_array);
	}
    }
    private function processVariationSpecificsSetsForMaster($products_id){
	foreach($this->item->Variations->VariationSpecificsSet as $sort=>$nvl){
	    $insert_sql_array = array(
		'products_id'=>$products_id,
		'sort_order'=>$sort
	    );
	    xtc_db_perform('products_master_keys',$insert_sql_array);
	    $pmkID = xtc_db_insert_id();
	    foreach($this->languages as $lang){
		$insert_sql_array = array(
		    'products_master_keys_id'=>$pmkID,
		    'title'=>$this->prepareString($nvl->Name),
		    'language_id'=>$lang['id']
		);
		xtc_db_perform('products_master_keys_description',$insert_sql_array);
	    }
	}
    }
    
    function getYesProducts_master_key_id($title,$master_products_id){
	$query = xtc_db_query(sprintf(
		"SELECT pmkd.products_master_keys_id FROM products_master_keys_description pmkd LEFT JOIN products_master_keys pmk USING(products_master_keys_id) WHERE title='%s' AND language_id='%s' AND pmk.products_id='%s'",
		$this->prepareString($title),$this->language_id,$master_products_id
	));
	if(xtc_db_num_rows($query)){
	    $record = xtc_db_fetch_array($query);
	    return $record['products_master_keys_id'];
	}
	return 0;
    }
    
    private function getProductsModel($variation = false){
	if($this->config['save_sku_as_products_model'] !== true){
	    return '';
	}
	if(!$variation){
	    return $this->item->SKU;
	}else{
	    return $variation->SKU;
	}
    }
    
    private function getProductsEAN($variation = false){
	if($this->config['save_sku_as_products_ean'] !== true){
	    return '';
	}
	if(!$variation){
	    return $this->item->SKU;
	}else{
	    return $variation->SKU;
	}
    }
    
    public function add_product_default_values(&$product){
	$product->setProducts_date_added('now()');
	$product->setProducts_shipping_time($this->getYesShippingStatusID());
	$product->setProducts_status( (($product->getProducts_quantity() > 0) ? 1 : 0));
	$product->setProducts_tax_class_id( $this->getYesTaxClassID());
	$product->setProducts_master($product->getProducts_master());
	$product->setProducts_master_status($product->getProducts_master_status());
	$product->setProducts_listing_status((($product->getProducts_quantity() > 0) ? 1 : 0));
	$product->setIs_new($this->getIsNew());
	$product->setIn_auction($product->getProducts_quantity());
    }
    
    private function prepareString($string,$isDescription=false){
	if($isDescription){
	    if(isset($this->config['replace_description_pattern']) and $this->config['replace_description_pattern'] != ''){
		$replaced = preg_replace($this->config['replace_description_pattern'], '', $string);
		$string = $replaced;
	    }
	}
	return $string;
    }
}