<?php
// nur auf dev - solange bis neue DOMPDF Version auf den Systemen ist
//use Dompdf\Dompdf;
class yes_pdf {
    var $instance,$headerTemplate,$footerTemplate,$headerandfooter;
    
    private function get_new_instance(){
		// Optionen für dompdf konfigurieren
		$options = new \Dompdf\Options();
		$options->set('DOMPDF_ENABLE_REMOTE', true);  // Externe Ressourcen wie Bilder erlauben
		$options->set('isHtml5ParserEnabled', true);  // HTML5 Parser aktivieren
		$options->set('isPhpEnabled', true);         // PHP-Funktionen aktivieren (falls benötigt)
		$options->set('isRemoteEnabled',true);
		$this->instance = new \Dompdf\Dompdf($options);
    }
    function __construct($headerandfooter=false){
		$this->headerandfooter = $headerandfooter;
		$this->get_new_instance();
    }
    
    function yesHeaderAndFooter(string $html = ''){
    	$canvas = $this->instance->get_canvas();
    	$header = $canvas->open_object();
    
		// PHP8 Bugfix?
		//$font = Font_Metrics::get_font("helvetica", "bold");
		$this->instance->getFontMetrics()->registerFont(
			['family' => 'helvetica', 'style' => 'normal', 'weight' => 'bold'],
			$fontDirectory . '/muli-v20-latin-regular.ttf'
		); // you have to set the style (e.g
    
    
		$date = date("Y-m-d H:i:s");
		$canvas->page_text(35, 25, "HiveDesk Screenshot Report", $font, 8, array(0, 0, 0));
		$canvas->page_text(490, 25, "hivedesk.com", $font, 8, array(0, 0, 0));
		$image = "images/ebay.png";
		$canvas->image($image,'png', 400, 25, 100, 25);
		$canvas->close_object();
		$canvas->add_object($header, "all");
    }
    
    public function set_html($html){
        if(main::isDev(true)){
            $this->instance->loadHtml(yes_encode_string($html));
        }else{
            $this->instance->load_html(yes_encode_string($html));
        }
    }
    
    public function output($filename){
		$this->instance->render();
		if($this->headerandfooter){
	    	$this->yesHeaderAndFooter();
		}
        $this->instance->stream($filename);
    }
    
   
    public function save($filename){
		$this->instance->render();
		$pdf = $this->instance->output();
        $pathinfo = pathinfo($filename);
        if(!is_dir($pathinfo['dirname'])){
            mkdir($pathinfo['dirname']);
        }
		file_put_contents($filename, $pdf) or die('Unable to write PDF');
    }
    
    public function set_landscape(){
		$this->instance->set_paper('a4', 'landscape');	
    }
    
    function set_paper($paper_size){
		$this->instance->set_paper($paper_size);
    }
    
    public function save_large_file($tmpfilepath,$html_array,$landscape = false,$target_dir = ''){
		$basics = new basics;
		$path_parts = pathinfo($tmpfilepath);
		if(empty($target_dir))
			$target_dir = 'VORVERSANDLISTE-'.@date('Ymd_His');
		$save_path = $path_parts['dirname'];
		$zip_files_path = $save_path.'/'.$target_dir;
		if(!is_dir($save_path)){
			mkdir($save_path);
		}
		
		if(!is_dir($zip_files_path)){
			mkdir($zip_files_path);
		}
		ini_set('memory_limit', '-1');	
		ini_set('max_execution_time', 0);
		set_time_limit(0);	
		$merges = array();
		foreach($html_array as $c => $html) {
			if( strlen("$c") == 1 ){
			$cn = '000'.$c;
			}elseif( strlen("$c") == 2 ){
			$cn = '00'.$c;
			}elseif( strlen("$c") == 3 ){
			$cn = '0'.$c;
			}else{
			$cn = $c;
			}
			$tmp_file = 'VVL_PART_'.$cn.'.pdf';
				$tmp = fopen($zip_files_path.'/'.$tmp_file, 'w');
			$this->get_new_instance();
			if($landscape) $this->set_landscape();
			$this->instance->load_html($html);
			$this->instance->render();
			$output = $this->instance->output();
	//	    $this->save($tmpfilepath."-PART".$c);
			unset($this->instance);
			fwrite($tmp, $output);
			fclose($tmp);
			$merges[] = $zip_files_path.'/'.$tmp_file;
		}
		//echo '</ol>';
		$this->merge($merges,$save_path.'/'.$path_parts['filename'].'.pdf');
		$basics->rmdir($zip_files_path);

	//	$target_name = $path_parts['filename'].'.zip';
	//	$basics->zip_files($target_dir, $target_name, $save_path.'/', true/*$delete_dir*/);
    }
    function merge($merges,$target_file){
	//	system("php5 pdf_merger.php $target_file ".implode(' ',$merges));
			$cmd = "gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=$target_file ";
			//Add each pdf file to the end of the command
			foreach($merges as $file) {
					$cmd .= $file." ";
			}
			$result = shell_exec($cmd);            
			
		//exec("php5 pdf_merger.php $target_file ".implode(' ',$merges));
    }
    
    public function getHeaderTemplate() {
		if(is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/DOMPDF_global_header.html')){
			return DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/DOMPDF_global_header.html';
		}
		return '';
    }
    
    public function getFooterTemplate() {
		if(is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/DOMPDF_global_footer.html')){
			return DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/DOMPDF_global_footer.html';
		}
		return '';
    }

}
