<?php
if( is_file(realpath(__DIR__).DIRECTORY_SEPARATOR.'YESShippingItem.php') ){
    require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'shippings_v2_sql.php');
    require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'YESShippingItem.php');
}
class yes_shipping
{
    var $id;
    var $tracking_id_array = array();
    var $tracking_id_array_full = array();
    var $orders_id;
    var $reclamations_id;
    var $versender;
    var $packages;
    var $date_finished;
    var $products = array();
    var $additional_params;
    var $stop_recreate;
    var $weight;
    
    const URL_DHL = 'https://nolp.dhl.de/nextt-online-public/de/search?piececode=%s';
    const URL_DPD = 'https://tracking.dpd.de/cgi-bin/delistrack?typ=1&lang=de&pknr=%s';
    const URL_GLS = 'https://gls-group.eu/DE/de/paketverfolgung?match=%s';
    
    function __construct( $id = 0 ){
	if($id > 0){
	    $query = xtc_db_query(sprintf(
		    "SELECT * FROM shippings WHERE id='%s'",
		    $id
	    ));
            $this->setId($id);
	    $record = xtc_db_fetch_array($query);
	    $this->setOrders_id($record['orders_id']);
	    $this->setReclamations_id($record['reclamations_id']);
	    $this->setVersender($record['versender']);
	    $this->setPackages($record['packages']);
	    $this->setDate_finished($record['date_finished']);
            $this->setAdditional_params($record['additional_params']);
            $this->setStop_recreate($record['stop_recreate']);
            $this->setWeight($record['weight']);
	    
	    // VERALTETES HANDLING - tracking_id DIREKT IM shippings DATENSATZ
	    if($record['tracking_id'] != ''){
		$this->tracking_id_array[] = $record['tracking_id'];
	    }else{
		$query = xtc_db_query(sprintf(
			"SELECT * FROM shippings_tracking_numbers WHERE shippings_id='%s' ORDER BY date_added",
			$id
		));
		while($record = xtc_db_fetch_array($query)){
                    $record['link'] = $this->get_tracking_link($record['tracking_number']);
                    if($this->getVersender() == 'DHL'){
                        $record['dhl_delete_link'] = xtc_href_link('dhl_print_label.php','action=confirm_delete&stnID='.$record['shippings_tracking_numbers_id'].'&tracking_number='.$record['tracking_number']);
                    }
                    $record['link'] = $this->get_tracking_link($record['tracking_number']);
                    
		    $this->tracking_id_array[] = $record['tracking_number'];
                    $this->tracking_id_array_full[] = $record;
		}
	    }
            $products = array();
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM shippings_products WHERE shippings_id='%s'",
                    $id
            ));
            while($record = xtc_db_fetch_array($query)){
                $products[] = $record;
            }
            $this->setProducts($products);
	}
    }
    function getId() {
        return $this->id;
    }

    function setId($id) {
        $this->id = $id;
    }

    public function getTracking_id_array() {
	return $this->tracking_id_array;
    }

    public function setTracking_id_array($tracking_id_array) {
	$this->tracking_id_array = $tracking_id_array;
    }

    function getTracking_id_array_full() {
        return $this->tracking_id_array_full;
    }

    function setTracking_id_array_full($tracking_id_array_full) {
        $this->tracking_id_array_full = $tracking_id_array_full;
    }

    public function getOrders_id() {
	return $this->orders_id;
    }

    public function setOrders_id($orders_id) {
	$this->orders_id = $orders_id;
    }

    public function getReclamations_id() {
	return $this->reclamations_id;
    }

    public function setReclamations_id($reclamations_id) {
	$this->reclamations_id = $reclamations_id;
    }

    public function getVersender() {
	return $this->versender;
    }

    public function setVersender($versender) {
	$this->versender = $versender;
    }

    public function getPackages() {
	return $this->packages;
    }

    public function setPackages($packages) {
	$this->packages = $packages;
    }

    public function getDate_finished() {
	return $this->date_finished;
    }

    public function setDate_finished($date_finished) {
	$this->date_finished = $date_finished;
    }
    
    function getProducts() {
        return $this->products;
    }

    function setProducts($products) {
        $this->products = $products;
    }
    
    public function getWeight() {
        return $this->weight;
    }

    public function setWeight($weight){
        $this->weight = $weight;
    }

    
    public function delete_trackingnumber($trackingnumber, $stop_recreate = false,$sequence_number = 1){
        xtc_db_query(sprintf(
                "DELETE FROM shippings_tracking_numbers WHERE shippings_id='%s' AND tracking_number='%s'",
                $this->getId(),$trackingnumber
        ));
        if($stop_recreate){
            $update_sql_array = array(
                'stop_recreate'=>1
            );
            xtc_db_perform('shippings',$update_sql_array,'update',"id='".$this->getId()."'");
        }
        if(is_file($this->get_secure_path().'DHL_label/'.$this->getId().'_'.$sequence_number.'.pdf')){
            // ALTES HANDLING, DA WURDE EINE LAUFENDE NR GESPEICHERT ALS DATEI-
            // NAME. DAS FUEHRTE ZU FEHLERN. DESHALB IST DAS NEUE HANDLING
            // BASIEREND DARAUF, DASS DIE TRACKINGNUMMER IM DATEINAMEN ENTHALTEN
            // IST - 2021/01
            unlink($this->get_secure_path().'DHL_label/'.$this->getId().'_'.$sequence_number.'.pdf');
        }else if(is_file($this->get_secure_path().'DHL_label/'.$this->getId().'_'.$trackingnumber.'.pdf')){
            unlink($this->get_secure_path().'DHL_label/'.$this->getId().'_'.$trackingnumber.'.pdf');
        }
    }
    
    public function getAdditional_params() {
        return $this->additional_params;
    }

    public function setAdditional_params($additional_params) {
        $this->additional_params = $additional_params;
    }
    
    public function delete(){
        if($this->getReclamations_id() > 0){
            $obj = new reclamation($this->getReclamations_id());
            $obj_status = $obj->info['reclamations_status'];
        }else{
            $obj = new order($this->getOrders_id());
            $obj_status = $obj->info['orders_status'];
        }
        $obj->add_history($obj_status, false, 'Versanddaten (#'.$this->getId().') geloescht.');
        
        xtc_db_query(sprintf(
            "DELETE FROM shippings WHERE id='%d'",
            $this->getId()
        ));
        xtc_db_query(sprintf(
            "DELETE FROM shippings_products WHERE shippings_id='%d'",
            $this->getId()
        ));
        xtc_db_query(sprintf(
            "DELETE FROM shippings_tracking_numbers WHERE shippings_id='%d'",
            $this->getId()
        ));
        
    }

    /**
     * Bessere Version von add_tracking_number basierend auf dem shippings 
     * Datensatz
     * @param int $shippings_id
     * @param string $tracking_number
     * @returns int inserted shipping_tracking_numbers_id
     */
    function insert_tracking_number($tracking_number){
        $insert_sql_array = array(
            'tracking_number'=>$tracking_number,
            'shippings_id'=>$this->getId(),
            'date_added'=>'now()'
        );
        xtc_db_perform('shippings_tracking_numbers',$insert_sql_array);
        return xtc_db_insert_id();
    }

    /**
     * Es ist moeglich Shipping-Tracking-Nummern schon vor Versandabschluss zu
     * Auftrag oder Reklamation zu hinterlegen. Dazu speichere ich -wenn kein
     * shippings Datensatz existiert- die Daten in der Tabelle 
     * shippings_tracking_numbers_temp
     * 
     * Mit dieser Funktion, werden die temporaeren Trackingnummern in die 
     * Tabelle shippings_tracking_numbers uebertragen und anschliessend aus der
     * _temp Tabelle geloescht
     * 
     * @throws exception when called without a saved instance
     */
    public function convert_temp_tracking_number_to_shipment(){
        if(!isset($this->id) or $this->getId() < 1){
            throw new exception('convert_temp_tracking_number_to_shipment needs a shippings_id');
        }
	if($this->getReclamations_id() > 0){
                $type = 'reclamation';
		$field = 'reclamations_id';
		$table = 'reclamations';
		$class_status_id = 'reclamations_status';
        }else{
                $type = 'order';
		$field = 'orders_id';
		$table = 'orders';
		$class_status_id = 'orders_status';
	}
        
        $query = xtc_db_query(sprintf(
                "SELECT * FROM shippings_tracking_numbers_temp WHERE target_type='%s' and target_type_id='%d'",
                $type,
                $this->getOrders_id()
        ));
        if(xtc_db_num_rows($query)){
            while($record = xtc_db_fetch_array($query)){
                $insert_sql_array = array(
                    'tracking_number'=>$record['transaction_id'],
                    'shippings_id'=>$this->getId(),
                    'date_added'=>'now()'
                );
                xtc_db_perform('shippings_tracking_numbers',$insert_sql_array);
                xtc_db_query(sprintf(
                        "DELETE FROM shippings_tracking_numbers_temp WHERE shippings_tracking_numbers_temp_id='%d'",
                        $record['shippings_tracking_numbers_temp_id']
                ));
            }
        }
    }
        /**
     * Speichert eine Trackingnummer zu einem Versanddatensatz in der Tabelle
     * shippings_transaction_numbers
     * 
     * gibt false zurueck, wenn kein Versanddatensatz ermittelt werden konnte
     * needed classes:
     *    order.php
     *    reclamation.php
     * 
     * @param String $id (orders_id oder reclamations_id, mit R davor)
     * @param STRING $transaction_id
     * @param string $type (order oder recla)
     * @param string Versender default (wenn noch kein Versanddatensatz 
         * existiert, wird hier der Versender eingetragen zu dem die TrackingID 
         * gehoert)
     * @return boolean
     */
    public function add_tracking_number($id,$transaction_id,$type='order', $versender_default = ''){
	switch($type){
	    case 'order':
		$field = 'orders_id';
		$table = 'orders';
		$class_status_id = 'orders_status';
		break;
	    case 'reclamation':
		$field = 'reclamations_id';
		$table = 'reclamations';
		$class_status_id = 'reclamations_status';
                $id = (strpos($id, 'R')>-1)?substr($id,1,strlen($id)) : $id;
		break;
	}
	$query = xtc_db_query(sprintf(
		"SELECT id,versender,%s FROM shippings WHERE %s='%s' ORDER BY date_added DESC",
		$field, $field,(int)xtc_db_input($id)
	));
	if(xtc_db_num_rows($query)){
	    $record = xtc_db_fetch_array($query);
	    $insert_sql_array = array(
		'tracking_number'=>$transaction_id,
		'shippings_id'=>$record['id'],
		'date_added'=>'now()'
	    );
	    xtc_db_perform('shippings_tracking_numbers',$insert_sql_array);
	    $class = new $type($id);
	    $class->add_history($class->info[$class_status_id],false,$record['versender'].' Tracking ID: '.$transaction_id);
	    if($table == 'reclamations'){
		$order = new order($class->info['orders_id']);
		$order->add_history($order->info['orders_status'],false,'[Rekl '.$id.'] '.$record['versender'].' Tracking ID: '.$transaction_id);
	    }
	    return true;
	}else{
            // BOF - TICKET 3048 - WENN KEIN shippings DATENSATZ VORHANDEN IST, TROTZDEM SPEICHERN
            $insert_sql_array = array(
                'target_type'=>$type,
                'target_type_id'=>$id,
                'transaction_id'=>$transaction_id,
                'versender'=>$versender_default,
                'date_added'=>'now()'
            );
	    xtc_db_perform('shippings_tracking_numbers_temp',$insert_sql_array);
	    $class = new $type($id);
	    $class->add_history($class->info[$class_status_id],false,$versender_default.' Tracking ID: '.$transaction_id);
	    if($table == 'reclamations'){
		$order = new order($class->info['orders_id']);
		$order->add_history($order->info['orders_status'],false,'[Rekl '.$id.'] '.$versender_default.' Tracking ID: '.$transaction_id);
	    }
            return true;
            // EOF - TICKET 3048 - WENN KEIN shippings DATENSATZ VORHANDEN IST, TROTZDEM SPEICHERN
        }
	return false;
    }
    
    public function get_tracking_link($tracking_id){
        if(defined('yes_shipping::URL_'.strtoupper($this->getVersender()))){
            return sprintf(constant('yes_shipping::URL_'.strtoupper($this->getVersender())),$tracking_id);
        }
        return '';
    }
    
    public static function shipping_exists($id, $type='order'){
        switch($type){
            case 'order':
                $sql_field = 'orders_id';
                break;
            case 'reclamation':
                $sql_field = 'reclamations_id';
                break;
        }
        $query = xtc_db_query(sprintf(
                "SELECT id FROM shippings WHERE %s='%s'",
                $sql_field,$id
        ));
        return xtc_db_num_rows($query);
    }
    
    public static function get_dhl_items_from_shippings_id(int $shippings_id){
        if(!defined('DHL_VERSENDEN_APPLICATION_ID') or DHL_VERSENDEN_APPLICATION_ID == ''){
            return [];
        }
        $query = xtc_db_query(sprintf(
            "SELECT id,packages,date_finished,orders_id,reclamations_id FROM shippings WHERE id='%d'",
            $shippings_id
        ));
        $record = xtc_db_fetch_array($query);
        return [$record];
    }
    
    public static function get_dhl_items_with_missing_tracking_ids(){
        $max_date = date('Y-m-d',time()-(60*60*24*28));
        $completed_dhl_shippings = array();
        $dhl_trackings_missing = array();
        if(!defined('DHL_VERSENDEN_APPLICATION_ID') or DHL_VERSENDEN_APPLICATION_ID == ''){
            return $dhl_trackings_missing;
        }
        $query = xtc_db_query(sprintf(
                "SELECT id,packages,date_finished,orders_id,reclamations_id FROM shippings WHERE versender='DHL' AND status=1 AND date_finished>'%s' and stop_recreate=0 ORDER BY id",
                $max_date
        ));
        while($record = xtc_db_fetch_array($query)){
            $completed_dhl_shippings[] = $record;
        }
        foreach($completed_dhl_shippings as $cds){
            $query = xtc_db_query(sprintf(
                    "SELECT shippings_tracking_numbers_id FROM shippings_tracking_numbers WHERE shippings_id='%s'",
                    $cds['id']
            ));
            if(xtc_db_num_rows($query) < $cds['packages']){
                $dhl_trackings_missing[] = $cds;
            }
        }
        return $dhl_trackings_missing;
    }
    
    public function get_secure_path(){
        $secure_path = main::get_secure_path();
        return $secure_path;
    }
    
    function getStop_recreate() {
        return $this->stop_recreate;
    }

   function setStop_recreate($stop_recreate) {
        $this->stop_recreate = $stop_recreate;
    }
    
    private static function get_source_object(string $source, int $id){
        switch($source){
            case 'orders':
            case 'block_orders':
            case 'orders_arrear':
                return new order($id);
            case 'reclamations':
            case 'block_reclamations':
                return new reclamation($id);
        }
    }
    public static function get_source_sql_table_definitions(string $source){
        switch($source){
            case 'orders':
            case 'block_orders':
            case 'orders_arrear':
            case 'rueckstand':
            case 'otc':
                $definitions = array(
                    'source_table'=>TABLE_ORDERS,
                    'source_table_id_field'=>'orders_id',
                    'source_table_status_field'=>'orders_status',
                    'source_products_table'=>TABLE_ORDERS_PRODUCTS,
                    'source_products_table_id_field'=>'orders_products_id',
                    'source_products_id_field_in_class'=>'opID',
                    'v1_source'=>'order',
                    'source_table_required_status'=>ORDERS_STATUS_BEZAHLT
                );
                break;
            case 'reclamations':
            case 'block_reclamations':
                $definitions = array(
                    'source_table'=>'reclamations',
                    'source_table_id_field'=>'reclamations_id',
                    'source_table_status_field'=>'reclamations_status',
                    'source_products_table'=>'reclamations_products',
                    'source_products_table_id_field'=>'reclamations_products_id',
                    'source_products_id_field_in_class'=>'rpID',
                    'v1_source'=>'reclamation',
                    'source_table_required_status'=>2
                );
                break;
        }
        return $definitions;
    }

    private static function check_storage_filter($source, $id){
        if(in_array($source,array('reclamations','block_reclamations')) ){
            return true;
        }
        if(!isset($_GET['storage_filter']) or $_GET['storage_filter'] == ''){
            return true;
        }
        $stID = (int)xtc_db_input($_GET['storage_filter']);
        $products_query = xtc_db_query(sprintf(
                "SELECT products_id as id FROM orders_products WHERE orders_id='%d'",
                $id
        ));
        if(!xtc_db_num_rows($products_query)){
            return true;
        }
        $_records = array();
        while($op = xtc_db_fetch_array($products_query)){
            $_records[] = $op;
        }
        foreach($_records as $op){
            $collies = xtc_get_product_collies($op['id']);
            if(!sizeOf($collies)){
                $storages_query = xtc_db_query(sprintf(
                        "SELECT id FROM storage_products WHERE products_id='%d' and storage_id='%d'",
                        $op['id'],$stID
                ));
                if(xtc_db_num_rows($storages_query)){
                    return true;
                }else{
                    $default_query = xtc_db_query(sprintf(
                            "SELECT products_id FROM products WHERE products_id='%d' and default_storage='%d'",
                            $op['id'],$stID
                    ));
                    if(xtc_db_num_rows($default_query)){
                        return true;
                    }
                }
            }else{
                foreach($collies as $colli){
                    $storages_query = xtc_db_query(sprintf(
                            "SELECT id FROM storage_products WHERE products_id='%d' and storage_id='%d'",
                            $colli['collie_products_id'],$stID
                    ));
                    if(xtc_db_num_rows($storages_query)){
                        return true;
                    }else{
                        $default_query = xtc_db_query(sprintf(
                                "SELECT products_id FROM products WHERE products_id='%d' and default_storage='%d'",
                                $colli['collie_products_id'],$stID
                        ));
                        if(xtc_db_num_rows($default_query)){
                            return true;
                        }
                    }
                }
            }
        } // end foreach order products
        return false;
    }
    
    public static function v2_count_in_shipping_items(){
        $query = xtc_db_query(
               "SELECT count(id) as anz FROM shippings WHERE status=0"
        );
        $record = xtc_db_fetch_array($query);
        return $record['anz'];
    }
    
    public static function count_shippable_items(string $source = 'orders', bool $group_by_source_objects = false){
        $table_definitions = self::get_source_sql_table_definitions($source);
        
        $SSQL = new shippings_v2_sql($source);
        if(isset($_GET['order_source_filter']) and $_GET['order_source_filter'] != ''){
            $SSQL->setOrder_source_filter($_GET['order_source_filter']);
        }
        if(isset($_GET['payment_method_filter']) and $_GET['payment_method_filter'] != ''){
            $SSQL->setPayment_method_filter($_GET['payment_method_filter']);
        }
        if(isset($_GET['shipping_class_filter']) and $_GET['shipping_class_filter'] != ''){
            $SSQL->setShipping_class_filter($_GET['shipping_class_filter']);
        }
        if(isset($_GET['customers_status']) and sizeOf($_GET['customers_status'])){
            $SSQL->setCustomers_status_filter($_GET['customers_status']);
        }
        
        if(isset($_GET['default_products_shipper']) and $_GET['default_products_shipper'] != ''){
            $SSQL->setDefault_products_shipper($_GET['default_products_shipper']);
        }
        if(isset($_GET['orders_not_de']) and $_GET['orders_not_de'] == 1){
            $SSQL->setOrders_not_de(true);
        }
        if(isset($_GET['has_part_delivery']) and $_GET['has_part_delivery'] == '1'){
            $SSQL->setHas_part_delivery(true);
        }
        if(isset($_GET['sperrgut']) and $_GET['sperrgut'] == '1'){
            $SSQL->setSperrgut(true);
        }
        $query = xtc_db_query( $SSQL->getSQL() );
        $num = 0;
        $diff_source_objects = array();
        while($record = xtc_db_fetch_array($query)){
            if(!self::check_storage_filter($source,$record[ $table_definitions['source_table_id_field'] ])){
                continue;
            }
            if(!yes_shipping::shipping_exists($record[$table_definitions['source_table_id_field']],$table_definitions['v1_source'])){
                $query2 = xtc_db_query(sprintf("SELECT SUM(products_quantity) as anz FROM %s WHERE %s='%d'",
                        $table_definitions['source_products_table'], 
                        $table_definitions['source_table_id_field'], 
                        $record[ $table_definitions['source_table_id_field'] ]
                ));
                $record2 = xtc_db_fetch_array($query2);
               if($record2['anz'] > 0){
                    if($group_by_source_objects === True){
                        $diff_source_objects[ $record[ $table_definitions['source_table_id_field'] ] ] = true;
                    }else{
                        $num++;
                    }
               }
            }else{
                $rest = self::count_shippable_items_rest_quantity($record[$table_definitions['source_table_id_field']],$source);
                if($rest > 0){
                    if($group_by_source_objects === True){
                        $diff_source_objects[ $record[$table_definitions['source_table_id_field']] ] = true;
                    }else{
                        $num++;
                    }
                }
            }
        }
        if($group_by_source_objects === True){
            return sizeOf($diff_source_objects);
        }
        return $num;
    }
    
    /**
     * Order/Rekla mit Artikel?
     * 
     * Prueft ob eine order/rekla mind. 1 Artikel hat
     * 
     * @param string $table
     * @param string $table_id_field
     * @param int $id
     * @return bool
     */
    private static function has_source_products(string $table, string $table_id_field, int $id){
        $query = xtc_db_query(sprintf(
            "SELECT SUM(products_quantity) as anz FROM %s WHERE %s='%d'",
            $table,
            $table_id_field, 
            $id
        ));
        $record = xtc_db_fetch_array($query);
        return ($record['anz']<1)?false:true;
    }
    
    private static function count_shippable_items_rest_quantity(int $id, string $source){
        $table_definitions = self::get_source_sql_table_definitions($source);
        $op_array = array();
        $op_total = 0;
        $query = xtc_db_query(sprintf(
                "SELECT %s,products_id,products_quantity FROM %s WHERE %s='%d'",
                $table_definitions['source_products_table_id_field'],
                $table_definitions['source_products_table'], 
                $table_definitions['source_table_id_field'], 
                $id
        ));
        while($record = xtc_db_fetch_array($query)){
            if(!isset($op_array[$record['products_id']])){
                $op_array[$record[ $table_definitions['source_products_table_id_field'] ]] = 0;
            }
            $op_array[$record[ $table_definitions['source_products_table_id_field'] ]] += $record['products_quantity'];
            $op_total += $record['products_quantity'];
        }
        
        $query = xtc_db_query(sprintf(
                "SELECT shp.* FROM shippings_products shp LEFT JOIN shippings s ON s.id=shp.shippings_id WHERE s.%s='%d'",
                $table_definitions['source_table_id_field'],
                $id
        ));
        if(!xtc_db_num_rows($query)){
            return $op_total;
        }
        $rest_array = array();
        while($record = xtc_db_fetch_array($query)){
            if(isset($op_array[ $record['source_products_id'] ])){
                if(!isset($rest_array[ $record['source_products_id'] ])){
                    $rest_array[ $record['source_products_id'] ] = $op_array[$record['source_products_id']];
                }
                $rest_array[ $record['source_products_id'] ] -= $record['quantity'];
                $op_array[ $record['source_products_id'] ] -= $record['quantity'];
            }
        }
        $rest_total = 0;
        foreach($rest_array as $anz){
            $rest_total += $anz;
        }
        if(sizeOf($rest_array) < sizeOf($op_array)){
            foreach($op_array as $source_pID=>$qty){
                if(!isset($rest_array[ $source_pID ])){
                    $rest_total += $qty;
                }
            }
        }
        return $rest_total; 
    }
    
    public static function get_shippable_items(string $source = 'orders',int $page = 0){
        $SSQL = new shippings_v2_sql($source);
        if(isset($_GET['order_source_filter']) and $_GET['order_source_filter'] != ''){
            $SSQL->setOrder_source_filter($_GET['order_source_filter']);
        }
        if(isset($_GET['payment_method_filter']) and $_GET['payment_method_filter'] != ''){
            $SSQL->setPayment_method_filter($_GET['payment_method_filter']);
        }
        if(isset($_GET['shipping_class_filter']) and $_GET['shipping_class_filter'] != ''){
            $SSQL->setShipping_class_filter($_GET['shipping_class_filter']);
        }
        if(isset($_GET['customers_status']) and sizeOf($_GET['customers_status'])){
            $SSQL->setCustomers_status_filter($_GET['customers_status']);
        }
        if(isset($_GET['default_products_shipper']) and $_GET['default_products_shipper'] != ''){
            $SSQL->setDefault_products_shipper($_GET['default_products_shipper']);
        }
        if(isset($_GET['orders_not_de']) and $_GET['orders_not_de'] == 1){
            $SSQL->setOrders_not_de(true);
        }
        
        if(isset($_GET['has_part_delivery']) and $_GET['has_part_delivery'] == 1){
            $SSQL->setHas_part_delivery(true);
        }
        if(isset($_GET['sperrgut']) and $_GET['sperrgut'] == '1'){
            $SSQL->setSperrgut(true);
        }
        $query = xtc_db_query( $SSQL->getSQL() );
        $table_definitions = self::get_source_sql_table_definitions($source);
        $items = array();
        $counter = 0;
        $from_counter = $page * MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
        $to_counter = ($page * MAX_DISPLAY_SEARCH_RESULTS_ADMIN)+MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
        $_records = array();
        while($record = xtc_db_fetch_array($query)){
            $_records[] = $record;
        }
        foreach($_records as $record){
            if(!self::check_storage_filter($source,$record[ $table_definitions['source_table_id_field'] ])){
                continue;
            }
            if(!self::has_source_products(
                $table_definitions['source_products_table'],
                $table_definitions['source_table_id_field'],
                $record[$table_definitions['source_table_id_field']]
            )){
                continue; // keine artikel in order/recla
            }
            $add_flag = false;
            if($counter >= $from_counter and $counter <= $to_counter){
                $add_flag = true;
            }
            if(!self::shipping_exists($record[$table_definitions['source_table_id_field']],$table_definitions['v1_source'])){
                if($add_flag){
                     $items[] = $record[$table_definitions['source_table_id_field']];
                }
                $counter++;
            }else{
                $rest = self::count_shippable_items_rest_quantity($record[$table_definitions['source_table_id_field']],$source);
                if($rest > 0){
                    if($add_flag){
                        $items[] = $record[$table_definitions['source_table_id_field']];
                    }
                    $counter++;
                }
            }
            if(sizeOf($items) >= MAX_DISPLAY_SEARCH_RESULTS_ADMIN){
                break;
            }
        }
        return $items;
    }
    
    private static function v2_get_shippings_address_fields($source,$srcObj){
        switch($source){
            case 'orders':
            case 'block_orders':
            case 'orders_arrear':
                return array(
                    'customers_id'=>$srcObj->customer['ID'],
                    'ebay_id'=>$srcObj->info['ebay_id'],
                    'company'=>$srcObj->delivery['company'],
                    'name1'=>$srcObj->delivery['name'],
                    'street1'=>$srcObj->delivery['street_address'],
                    'street2'=>$srcObj->delivery['suburb'],
                    'postcode'=>$srcObj->delivery['postcode'],
                    'city'=>$srcObj->delivery['city'],
                    'email'=>($srcObj->delivery['email_address'] != '') ? $srcObj->delivery['email_address'] : $srcObj->customer['email_address'],
                    'country_name'=>$srcObj->delivery['country'],
                    'country_id'=>$srcObj->delivery['country_id'],
                );
            case 'reclamations':
            case 'block_reclamations':
                return array(
                    'customers_id'=>$srcObj->customer['ID'],
                    'ebay_id'=>'',
                    'company'=>$srcObj->delivery['company'],
                    'name1'=>$srcObj->delivery['name'],
                    'street1'=>$srcObj->delivery['street_address'],
                    'street2'=>$srcObj->delivery['suburb'],
                    'postcode'=>$srcObj->delivery['postcode'],
                    'city'=>$srcObj->delivery['city'],
                    'email'=>$srcObj->customer['email_address'],
                    'country_name'=>$srcObj->delivery['country']
                );
        }
        
    }
    
    public static function v2_get_products_id_from_source_products_id(int $source_products_id, string $source, $srcObj){
        $table_definitions = self::get_source_sql_table_definitions($source);
        $source_field = $table_definitions['source_products_id_field_in_class'];
        foreach($srcObj->products as $p){
            if($p[$source_field] == $source_products_id){
                return $p['id'];
            }
        }
    }
    
    public static function v2_add_part_delivery(array $values = []){
        $table_definitions = self::get_source_sql_table_definitions($values['source']);
        $srcObj = self::get_source_object($values['source'], $values['id']);
        
        $addr_values = self::v2_get_shippings_address_fields($values['source'], $srcObj);
        $additional_params = array();
        if($values['versender'] == 'DHL'){
            $add_params = $values['additional_params'];
        }else{
            foreach($values['additional_params'] as $shipper=>$add_param){
                if($shipper != $values['versender']){
                    continue; // sollte eigentlich nicht vorkommen, aber wer weiss
                }
                foreach($add_param as $add_key=>$add_value){
                    $additional_params[] = sprintf('%s::%s',
                            $add_key, $add_value
                    );
                }
            }
            $add_params = implode('|',$additional_params);
        }
        $insert_sql_array = array(
            $table_definitions['source_table_id_field'] => $values['id'],
            'customers_id'=>$srcObj->customer['ID'],
            'weight'=>$values['weight'],
            'packages'=>$values['packages'],
            'versender'=>$values['versender'],
            'date_added'=>'now()',
            'name1'=>$addr_values['name1'],
            'name2'=>'',
            'company'=>$addr_values['company'],
            'street1'=>$addr_values['street1'],
            'street2'=>$addr_values['street2'],
            'postcode'=>$addr_values['postcode'],
            'city'=>$addr_values['city'],
            'country_id'=>$addr_values['country_id'],
            'country_name'=>$addr_values['country_name'],
            'ebay_id'=>$addr_values['ebay_id'],
            'email'=>$addr_values['email'],
            'additional_params'=>$add_params,
        );
        xtc_db_perform('shippings',$insert_sql_array);
        $shippings_id = xtc_db_insert_id();
        foreach($values['products'] as $id=>$qty){
            if($qty < 1){
                continue;
            }
            $products_id = self::v2_get_products_id_from_source_products_id($id, $values['source'], $srcObj);
            $insert_sql_array = array(
                'shippings_id'=>$shippings_id,
                'products_id'=>$products_id,
                'quantity'=>$qty,
                'source_products_id'=>$id
            );
            xtc_db_perform('shippings_products',$insert_sql_array);
        }
        return $shippings_id;
    }
    
    public static function v2_add_delivery(array $values = []){
        $table_definitions = self::get_source_sql_table_definitions($values['source']);
        $source_product_identifier = $table_definitions['source_products_id_field_in_class'];
        $table_id_field = $table_definitions['source_table_id_field'];
        $srcObj = self::get_source_object($values['source'],$values['id']);
        $addr_values = self::v2_get_shippings_address_fields($values['source'], $srcObj);
        
        if($values['versender'] != 'DHL'){
            $additional_params = array();
            foreach($values['additional_params'] as $shipper=>$add_param){
                if($shipper != $values['versender']){
                    continue; // sollte eigentlich nicht vorkommen, aber wer weiss
                }
                foreach($add_param as $add_key=>$add_value){
                    $additional_params[] = sprintf('%s::%s',
                            $add_key, $add_value
                    );
                }
            }
            $save_add_params = implode('|',$additional_params);
        }else{
            $save_add_params = $values['additional_params'];
        }
        $rest = self::count_shippable_items_rest_quantity($values['id'],$values['source']);
        if($rest < 1){
            return false;
        }
        
        $insert_sql_array = array(
            $table_id_field => $values['id'],
            'customers_id'=>$srcObj->customer['ID'],
            'weight'=>$values['weight'],
            'packages'=>$values['packages'],
            'versender'=>$values['versender'],
            'date_added'=>'now()',
            'name1'=>$addr_values['name1'],
            'name2'=>'',
            'company'=>$addr_values['company'],
            'street1'=>$addr_values['street1'],
            'street2'=>$addr_values['street2'],
            'postcode'=>$addr_values['postcode'],
            'city'=>$addr_values['city'],
            'country_id'=>$addr_values['country_id'],
            'country_name'=>$addr_values['country_name'],
            'ebay_id'=>$addr_values['ebay_id'],
            'email'=>$addr_values['email'],
            'additional_params'=>$save_add_params,
        );
        xtc_db_perform('shippings',$insert_sql_array);
        $shippings_id = xtc_db_insert_id();
        
        foreach($srcObj->products as $sp){
            $in_shipping_quantity = self::v2_get_source_object_product_shipped_quantity($values['id'], $sp[$source_product_identifier], $values['source']);
            if(($sp['qty']-$in_shipping_quantity) > 0){
                $insert_sql_array = array(
                    'shippings_id'=>$shippings_id,
                    'products_id'=>$sp['id'],
                    'quantity'=>($sp['qty']-$in_shipping_quantity),
                    'source_products_id'=>$sp[$source_product_identifier]
                );
                xtc_db_perform('shippings_products',$insert_sql_array);
            }
        }
        return $shippings_id;
    }
    
    /**
     * Rekla/Order product Anzahl im Versandmodul
     * 
     * Ermittelt anhand eines Auftrag-/Reklaartikels mit welcher Menge dieser
     * bereits im Versandmodul gespeichert ist. Da es Teillieferungen geben kann
     * kann sich dieser Wert aus verschiedenen shippings_products Eintraegen
     * zusammen setzen
     * 
     * @param int $source_id
     * @param int $source_products_id
     * @param string $source
     */
    public static function v2_get_source_object_product_shipped_quantity(int $source_id, int $source_products_id, string $source){
        $table_definitions = self::get_source_sql_table_definitions($source);
        $in_shipping = 0;
        $query = xtc_db_query(sprintf(
            "SELECT sp.* FROM shippings_products sp LEFT JOIN shippings s ON s.id=sp.shippings_id WHERE s.%s='%d' AND sp.source_products_id='%d'",
            $table_definitions['source_table_id_field'],
            $source_id,
            $source_products_id
        ));
        while ($record = xtc_db_fetch_array($query)) {
            $in_shipping += $record['quantity'];
        }
        return $in_shipping;
    }

    /**
     * barcode_scan_string wird verwendet wenn im Scannermodus zb nach einer
     * rekla oder einer orders_id gesucht wurde
     * 
     * @param int $page
     * @param string $shipper
     * @param string $barcode_scan_string
     * @return type
     */
    public static function v2_get_in_shipping_items(int $page = 0, string $shipper = '', string $barcode_scan_string = ''){
        $from_counter = $page * MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
        $shipper_sql = '';
        $search_sql = '';
        if($shipper != ''){
            $shipper_sql = sprintf(" AND versender='%s'", $shipper);
        }
        if($barcode_scan_string != ''){
            $search_sql .= sprintf(" AND (orders_id='%d' or reclamations_id='%d')",
                    $barcode_scan_string,$barcode_scan_string
            );
        }
        
        $shippings = array();
        if($page === -1){
            $query = xtc_db_query(sprintf(
                "SELECT id FROM shippings WHERE status=0 %s",
                $shipper_sql
            ));
        }else{
            $query = xtc_db_query(sprintf(
                "SELECT id FROM shippings WHERE status=0 %s %s LIMIT %d, %d",
                $shipper_sql, $search_sql,
                $from_counter,MAX_DISPLAY_SEARCH_RESULTS_ADMIN
            ));
        }
        while($record = xtc_db_fetch_array($query)){
            $shippings[] = $record['id'];
        }
        return $shippings;
    }
    
    /*
     * Versandabschluss ID Liste
     * 
     * Gibt ein Array aller shippings Eintraege wieder die momentan im Versand-
     * abschluss sind (shippings.status=0). Mit dem Parameter shipper kann man
     * filtern nach dem gespeicherten Versender (shippings.shipper)
     * 
     * @param string $shipper gespeicherter Versender zb "DHL"
     * @param array $sql_field_filter zb array(array('csv_status'=> 1))
     * @return array
     */
    public static function get_shippings_id_list( $shipper = Null, array $sql_field_filter = [] ){
        $shipping_id = array();
        $shipper_sql = ($shipper !== Null) ? "AND s.shipper='".$shipper."'" : '';
        $sql_field_filter_string = '';
        $status = 0;
        if(sizeOf($sql_field_filter)){
            foreach($sql_field_filter as $field=>$value){
                if($field == 'status'){
                    $status = $value;
                    continue;
                }
                $sql_field_filter_string .= sprintf(" AND %s='%s'",$field, $value);
            }
        }
        $query = xtc_db_query(sprintf(
                "SELECT id FROM shippings s WHERE s.status=%d %s %s ORDER BY id",
                $status,
                $shipper_sql, $sql_field_filter_string
        ));
        if(!xtc_db_num_rows($query)){
            return $shipping_id;
        }
        while($record = xtc_db_fetch_array($query)){
            $shipping_id[] = $record['id'];
        }
        return $shipping_id;
    }
    
    public static function v2_get_in_shipping_different_shipper(){
        $shipper = array();
        $query = xtc_db_query(
            "SELECT DISTINCT(versender) as shipper FROM shippings WHERE status=0"
        );
        while($record = xtc_db_fetch_array($query)){
            $shipper[] = $record['shipper'];
        }
        return $shipper;
    }
    
    public static function get_wemalo_items_not_submitted(){
        $not_submitted = [];
        $query = xtc_db_query(
                "SELECT id,packages,date_finished,orders_id,reclamations_id FROM shippings WHERE versender='wemalo' AND status=1 and stop_recreate=0 ORDER BY id"
        );
        while($record = xtc_db_fetch_array($query)){
            $not_submitted[] = $record;
        }
        $response = [];
        foreach($not_submitted as $ns){
            $query = xtc_db_query(sprintf(
                    "SELECT wemalo_id FROM wemalo WHERE shipping_id='%d' AND wemalo_status='0'",
                    $ns['id']
            ));
            if(!xtc_db_num_rows($query)){
                $response[] = $ns;
            }
        }
        return $response;
    }

    /**
     * prueft ob die DHL Angaben eine rekla/order valide sind (Vor uebergabe
     * in Versandabschluss)
     * @param string $produkt zb VO1PAK
     * @param object $srcObj rekla oder order instanz
     */
    public static function validate_dhl( string $produkt, $srcObj ){
        try{
            $obj = DHL_Paket_DE_Versenden_REST_API::get_from_post( $produkt );
        }catch( Exception $e ){
            die(json_encode([
                'ACK'=>'Error',
                'type'=>'DHL',
                'MSG'=>$e->getMessage()
            ]));
        }
        $DHL = new DHL_Paket_DE_Versenden_REST_API;
        if($obj->customs){
            $obj->customs->permitNo = "approval / permit";
            $obj->customs->attestationNo = "confirmation / attestation";
            $items = [];
            foreach($srcObj->products as $sp){
                $items[] = new DHL_customs_item([
                  "itemDescription" => $sp['name'],
                  "packagedQuantity" => $sp['qty'],
                  //"hsCode" => "123456",
                  //"countryOfOrigin" => "FRA",
                  "itemValue" =>new \DHL_Service_Amount([
                      'currency'=>'EUR',
                      'value'=>(float)$sp['price'],
                  ]),
                  "itemWeight"=>new DHL_Weight([
                      "uom" => "g",
                      "value" => (int)(xtc_get_ext_products_weight($sp['id'])*1000)
                  ])
                ]);
            }
            $obj->customs->items = $items;
        }
        $res = $DHL->validate_or( $obj, $srcObj );
        return [
            'ACK'=>($res['ERROR'] == 1) ? 'Error':'Success',
            'ERRORS'=> DHL_Paket_DE_Versenden_REST_API::get_response_errors(json_decode($res['RESPONSE']))
        ];
    }

    /**
     * Prueft (Vor Uebergabe in Versandmodul) die eBay Transaktionen eines Auftrags
     * on CheckoutStatus und CompleteStatus abgeschlossen sind
     * 
     * @param order $order
     */
    public static function validate_order_ebay_transaction_status( order $order ){
        if(main::isDev(true)){ // auf dev keine checkoutstatus pruefung
            return [
                'ACK'=>'Success',
                'MSG'=>'',
                'TITLE'=>TEXT_ORDER.' '.$order->info['id']
            ];
        }
        $EBAYAPI = new ebayApi;
        $statuses = array();
        foreach($order->get_auction_array() as $ebay_id){
            $query = xtc_db_query(sprintf(
                    "SELECT transactionid FROM ebay_transactions WHERE ebayid='%s' AND orders_id='%d'",
                    $ebay_id, $order->info['id']
            ));
            if(!xtc_db_num_rows($query)){
                continue;
            }
            $record = xtc_db_fetch_array($query);
            $statuses[] = $EBAYAPI->get_item_transaction_status($ebay_id, $record['transactionid']);
        }
        $ack = 'Success';
        $msg = array();
        $message = '';
        if(sizeOf($statuses)){
            $smarty = new yesSmarty();
            foreach($statuses as $status){
                if($status['CompleteStatus'] != 'Complete'){
                    $ack = 'Error';
                    $lang_conf = $smarty->configLoad(DIR_FS_CATALOG.'lang/german/admin/german.conf', 'ebay');
                    $msg[] = sprintf("Auktion %s / Transaktion %s</b><br />CompleteStatus %s, CheckoutStatus %s\r\nFehler: %s\n",
                        $status['EBAY_ID'], $status['TRANSACTION_ID'],$status['CompleteStatus'],$status['CheckoutStatus'],$status['ERROR']
                    );
                }
            }
            
            if(sizeOf($msg)){
                $message = sprintf("\n%s\n",$lang_conf->config_vars['ebay_transaction_status_warning']);
                $message .= implode("\n",$msg);
            }
        }
        return [
            'ACK'=>$ack,
            'MSG'=>$message,
            'TITLE'=>TEXT_ORDER.' '.$order->info['id']
        ];
    }
    
    /**
     * Prueft ebay transaction Status sowie DHL Parameter auf Gueltigkeit
     * @param string $id_param zb orders_6 oder reclamation_4
     * @return array
     */
    public static function validate( string $id_param ){
        if(empty($id_param)){
            die(json_encode([
                'ACK'=>'Error',
                'MSG'=>'No orders/reclamations id'
            ]));
        }
        $id_parts = explode('_',$id_param);

        if($id_parts[0] == 'orders'){
            $srcObj = new order($id_parts[1]);
            if($srcObj->info['source'] == 'ebay'){
                $res = self::validate_order_ebay_transaction_status($srcObj);
                if($res['ACK'] == 'Error'){
                    return [
                        'ACK'=>'Error',
                        'MSG_TITLE'=>'eBay Transaktion Auftrag '.$id_parts[1].' nicht abgeschlossen',
                        'type'=>'ebay',
                        'MSG'=>$res['MSG']
                    ];
                }
            }
        }else{
            $srcObj = new reclamation($id_parts[1]);
        }
        
        $produkt = null;
        if(isset($_GET['versender_params']['DHL'])){
            $produkt = $_GET['versender_params']['DHL']['produkt'];
        }elseif(isset($_GET['produkt'])){
            $produkt = $_GET['produkt'];
        }
        if($produkt !== null){
            try{
                $res = self::validate_dhl($produkt, $srcObj);
                if($res['ACK'] == 'Error'){
                    return [
                        'ACK'=>'Error',
                        'MSG_TITLE'=>'DHL '.$res->status->title." ".$res->status->detail,
                        'type'=>'DHL',
                        'MSG'=>$res['ERRORS']
                    ];
                }
            }catch( Exception $e){
                return [
                    'ACK'=>'Error',
                    'type'=>'DHL',
                    'MSG_TITLE'=>'DHL Validierung fehlgeschlagen',
                    'MSG'=>$e->getMessage()
                ];
            }
        }
        return [
            'ACK'=>'Success',
            'type'=>'',
            'MSG_TITLE'=>(isset($res['ERRORS']) and is_countable($res['ERRORS']))?implode('<br />',$res['ERRORS']):'',
            'MSG'=>''
        ];
    }
}