<?php
/* -----------------------------------------------------------------------------------------
   $Id: YES_PAYMODULE_products_fake_sets.php,v 1.4 2015/03/30 08:49:44 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2005 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com 
   (c) 2003	 nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_TEXT_DESCRIPTION', 'Export - Fake Sets');
define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_IMPORT_TITLE', 'Fake Sets - Import');
define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_TEXT_TITLE', 'Fake Sets - CSV');
define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_STATUS_DESC','Modulstatus');
define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_STATUS_TITLE','Status');
define('MSG_ERROR_PAYMODULE','Dies ist ein kostenpflichtiges Modul und muss erst durch YES websolutions freigegeben werden.');
define('MSG_PFS_EXPORT_NO_DATA','Keine Fake Set Artikeldatens&auml;tze zum Exportieren');
define('MSG_PFS_EXPORT_INVALID_DATA_FILE','Importdatei kann nicht verarbeitet werden.');
define('MSG_PFS_EXPORT_SUCCESS','Fake Set Import erfolgreich. %s Artikel aktualisiert.');
// include needed functions


class YES_PAYMODULE_products_fake_sets{
    var $code, $title, $description, $enabled,$sort_order;
    function __construct() {
	$this->code = 'YES_PAYMODULE_products_fake_sets';
	$this->title = YES_PAYMODULE_PRODUCTS_FAKE_SETS_TEXT_TITLE;
	$this->description = YES_PAYMODULE_PRODUCTS_FAKE_SETS_TEXT_DESCRIPTION;
	$this->sort_order = (defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS_SORT_ORDER')) ? YES_PAYMODULE_PRODUCTS_FAKE_SETS_SORT_ORDER : 0;
	$this->enabled = ((defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS_STATUS') and YES_PAYMODULE_PRODUCTS_FAKE_SETS_STATUS == 'True') ? true : false);
    }


    function process() {
	global $messageStack;
	if(isset($_FILES['pfs_upload_file']) and isset($_FILES['pfs_upload_file']['name']) and $_FILES['pfs_upload_file']['name'] != ''){
	    $valid_fields = array('products_id','artnr_1','qty_1','artnr_2','qty_2','artnr_3','qty_3','artnr_4','qty_4','artnr_5','qty_5');
	    $uploaddir = \main::get_importdata_path();
	    $uploadfile = $uploaddir . basename($_FILES['pfs_upload_file']['name']);
	    if (move_uploaded_file($_FILES['pfs_upload_file']['tmp_name'], $uploadfile)) {
		if (($handle = fopen($uploadfile, "r")) !== FALSE) {
		    $row = 0;
		    $updated = 0;
		    while (($data = fgetcsv($handle, 1000, "\t")) !== FALSE) {
			if($row == 0){ // csv header pruefen
			    foreach($data as $field){
				if(!in_array($field,$valid_fields)){
				    $messageStack->add_session(MSG_PFS_EXPORT_INVALID_DATA_FILE,'error');
				    xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('action')) ));
				}
			    }
			    $keys = $data;
			}else{
			    xtc_db_query(sprintf(
				    "DELETE FROM products_fake_sets WHERE products_id='%s'",
				    $data[0]
			    ));
			    $check_query = xtc_db_query(sprintf(
				    "SELECT products_id FROM %s WHERE products_id='%s'",
				    TABLE_PRODUCTS,(int)xtc_db_input($data[0])
			    ));
			    if(xtc_db_num_rows($check_query)){
				$insert_sql_array = array();
				foreach($keys as $nr=>$key){
				    $insert_sql_array[$key] = $data[$nr];
				}
				xtc_db_perform('products_fake_sets',$insert_sql_array);
				$updated++;
			    }
			}
			$row++;
		    }
		    fclose($handle);
		    unlink($uploadfile);
		    $messageStack->add_session(sprintf(MSG_PFS_EXPORT_SUCCESS,$updated),'success');
		    xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('action')) ));
		}
	    } else {
		$messageStack->add_session(MSG_PFS_EXPORT_INVALID_DATA_FILE,'error');
		xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('action')) ));
	    }
	}
        @xtc_set_time_limit(0);
	$data = array();
	$query = xtc_db_query(
		"SELECT products_id,artnr_1,qty_1,artnr_2,qty_2,artnr_3,qty_3,artnr_4,qty_4,artnr_5,qty_5 FROM products_fake_sets"
	);
	$counter = 0;
	while($record = xtc_db_fetch_array($query)){
	    unset($record['products_fake_sets_id']);
	    if($counter == 0){
		$data[] = array_keys($record);
	    }
	    $counter++;
	    $data[] = $record;
	}
	if($counter < 1){
	    $messageStack->add_session(MSG_PFS_EXPORT_NO_DATA,'error');
	    xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('action')) ));
	}
	$buffer = '';
	foreach($data as $p){
	    $buffer .= implode("\t",$p)."\r\n";
	}
	// create File
	header('Content-type: application/x-octet-stream');
	header('Content-disposition: attachment; filename=' . 'FAKE_SETS_EXPORT_'.date('Y-m-d_His').'.csv');
	echo $buffer;
	exit;
    }

    
    function display() {
	return array('text' => "<script type=\"text/javascript\">
			 $().ready(function(){
			    $('a.pfs_upload').click(function(){
				$('div.pfs_upload_div').toggle();
				$('input.pfs_submit').toggle();
				$(this).toggle();
			    });
			 });
			</script>".
			'<div class="pfs_upload_div" style="display: none;"><input type="file" name="pfs_upload_file" /><br /><input type="submit" value="'.IMAGE_UPLOAD.'" class="ui-corner-all ui-state-highlight" /></div>'.
			yes_draw_href_link('Import','javascript:;','pfs_upload','width: 140px;').'<br /><br />'.
	    
			yes_draw_href_button(IMAGE_EXPORT,'','width: 140px;','submit','ui-button ui-corner-all ui-state-default pfs_submit').'&nbsp;'.
			yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set']),'width:140px;')
	);


    }

    function check() {
	if(!defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS') or YES_PAYMODULE_PRODUCTS_FAKE_SETS != 'True'){
	    return false;
	}
	if (!isset($this->_check)) {
	    $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'YES_PAYMODULE_PRODUCTS_FAKE_SETS_STATUS'");
	    $this->_check = xtc_db_num_rows($check_query);
	}
	return $this->_check;
    }

    function install() {
	global $messageStack;
	if(!defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS') or YES_PAYMODULE_PRODUCTS_FAKE_SETS != 'True'){
	    $messageStack->add_session(MSG_ERROR_PAYMODULE,'error');
	}else{
	    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('YES_PAYMODULE_PRODUCTS_FAKE_SETS_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	}
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
	return array('YES_PAYMODULE_PRODUCTS_FAKE_SETS_STATUS');
    }
}
