<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'google_product_feed_export.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
if(!isset($_SESSION['languages_id'])) $_SESSION['languages_id'] = 2;
define('MODULE_GOOGLE_PRODUCT_FEED_TEXT_DESCRIPTION', 'Dieses Modul erm&ouml;glicht die Bereitstellung von Produktdaten f&uuml;r Googles Daten Feeds.');
define('MODULE_GOOGLE_PRODUCT_FEED_TEXT_TITLE', 'Google Daten Feed - CSV');
define('MODULE_GOOGLE_PRODUCT_FEED_SORT_ORDER_TITLE', 'Sortierung');
define('MODULE_GOOGLE_PRODUCT_FEED_SORT_ORDER_DESC', 'Sortierung innerhalb Exportmodule');
define('MODULE_GOOGLE_PRODUCT_FEED_APPAREL_TITLE','Eingabefelder Kleidung');
define('MODULE_GOOGLE_PRODUCT_FEED_APPAREL_DESC','Zus&auml;tzliche Eingabem&ouml;glichkeiten f&uuml;r Kleidung verwenden');
define('MODULE_GOOGLE_PRODUCT_FEED_APPAREL_DESC_PRODUCTS_DESCRIPTION','Produktbeschreibung');
define('MODULE_GOOGLE_PRODUCT_FEED_APPAREL_DESC_EXTRATEXT','Extratext');
define('MODULE_GOOGLE_PRODUCT_FEED_APPAREL_DESC_SHORT_DESCRIPTION','Kurzbeschreibung');
define('MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_CONDITION_TITLE','Standard Zustand');
define('MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_CONDITION_DESC','Legen Sie fest, welcher Zustand bei Neuanlage eines Artikels gespeichert werden soll.');
define('MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_AVAILABILITY_TITLE','Standard Verfügbarkeit');
define('MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_AVAILABILITY_DESC','Legen Sie fest, welche Verfügbarkeit bei Neuanlage eines Artikels gespeichert werden soll.');
$description_src_array = array(
    0=>array(
    'id'=>'products_description',
    'text'=>MODULE_GOOGLE_PRODUCT_FEED_APPAREL_DESC_PRODUCTS_DESCRIPTION
    ),
    1=>array(
    'id'=>'short_description',
    'text'=>MODULE_GOOGLE_PRODUCT_FEED_APPAREL_DESC_SHORT_DESCRIPTION
    ),
    2=>array(
    'id'=>'extratext',
    'text'=>MODULE_GOOGLE_PRODUCT_FEED_APPAREL_DESC_EXTRATEXT
    ),
);

if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
    define('MODULE_GOOGLE_PRODUCT_FEED_APPAREL_DESC_APPAREL','Beschreibung (Kleidung)');
    $description_src_array[] = array(
        'id'=>'apparel',
        'text'=>MODULE_GOOGLE_PRODUCT_FEED_APPAREL_DESC_APPAREL
    );
}



define('MODULE_GOOGLE_PRODUCT_FEED_FIELD_DESCRIPTION_TITLE','Beschreibung aus:');

define('MODULE_GOOGLE_PRODUCT_FEED_STATUS_TITLE','Status');
define('MODULE_GOOGLE_PRODUCT_FEED_STATUS_DESC','Modulstatus');
define('MODULE_GOOGLE_PRODUCT_FEED_EXPORTTEXT','<br />Es wird im CSV Format exportiert, der Texttrenner ist Tabulator.');

// include needed functions

class google_product_feed extends products_export{
    var $code, $title, $description, $enabled,$sort_order,$_check;


    function __construct(){
      $this->code = 'google_product_feed';
      $this->title = MODULE_GOOGLE_PRODUCT_FEED_TEXT_TITLE;
      $this->description = MODULE_GOOGLE_PRODUCT_FEED_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_GOOGLE_PRODUCT_FEED_SORT_ORDER')) ? MODULE_GOOGLE_PRODUCT_FEED_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_GOOGLE_PRODUCT_FEED_STATUS') and MODULE_GOOGLE_PRODUCT_FEED_STATUS == 'True') ? true : false);
    }


    function process() {
		$basics = new basics;
		$gpf = new google_product_feed_export($_SESSION['languages_id']);
                $created_file_name = $gpf->get_csv_data();
		$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
		$filename = sprintf('google_product_feed_%s.csv',$crypt_file);
		$filepath = \main::get_exportdata_path();
                if(!copy($created_file_name,$filepath.$filename)){
                    unlink($created_file_name);
                    throw new Exception(sprintf('Cant copy %s to %s',$created_file_name,$filepath.$filename));
                }else{
                    unlink($created_file_name);
                }
		$basics->zip_file($filepath,$filename,$filename.'.zip',true);

		$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
		unlink($filepath.$filename.'.zip');
		// send File to Browser
		$file = 'google_product_feed_'.date('Y-m-d_H_i_s').'.zip';
		header('Content-Type: application/octet-stream');
		header('Content-Transfer-Encoding: binary');
		header('Content-disposition: attachment; filename=' . $file);
		echo $file_contents;
		exit;
    }


    function display() {
        global $description_src_array;
        $description_src = (isset($_REQUEST['description_src'])) ? $_REQUEST['description_src'] : '';
		$array = array(
			'text' => MODULE_GOOGLE_PRODUCT_FEED_FIELD_DESCRIPTION_TITLE.'&nbsp;'.
                    xtc_draw_pull_down_menu('description_src',$description_src_array,$description_src).'<br />'.
                    yes_draw_href_button(IMAGE_EXPORT,'','width:120px;','submit') . '&nbsp;' .
			yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=google_product_feed'),'width:120px;')
		);
		return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_GOOGLE_PRODUCT_FEED_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_GOOGLE_PRODUCT_FEED_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_GOOGLE_PRODUCT_FEED_APPAREL', 'False',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");	  
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_GOOGLE_PRODUCT_FEED_SORT_ORDER', '0',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_CONDITION', 'new',  '6', '5', 'xtc_cfg_select_gpf_conditions(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_AVAILABILITY', 'in_stock',  '6', '5', 'xtc_cfg_select_gpf_availabilities(', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_GOOGLE_PRODUCT_FEED_STATUS','MODULE_GOOGLE_PRODUCT_FEED_SORT_ORDER','MODULE_GOOGLE_PRODUCT_FEED_APPAREL','MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_AVAILABILITY','MODULE_GOOGLE_PRODUCT_FEED_DEFAULT_CONDITION');
    }
    
  public static function get_gpf_conditions(){
	  return array(
		  array('id'=>'new','text'=>'Neu'),
		  array('id'=>'used','text'=>'Gebraucht'),
		  array('id'=>'refurbished','text'=>'Erneuert')
	  );
  }
  
  public static function get_gpf_availabilities(){
	    return array(
		    array('id'=>'in_stock','text'=>'Auf Lager'),
		    array('id'=>'available for order','text'=>'Bestellbar'),
		    array('id'=>'out of stock','text'=>'Vergriffen'),
		    array('id'=>'preorder','text'=>'Vorbestellt')
	    );
	}
}
