<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_ORDERS_PRODUCTS_STATS_TEXT_DESCRIPTION', 'Export der erzielten Preise von verkauften Artikel f&uuml;r einen Zeitraum. (Tab getrennt)');
define('MODULE_ORDERS_PRODUCTS_STATS_TEXT_TITLE', 'Erzielte Artikelverkaufspreise');
define('MODULE_ORDERS_PRODUCTS_STATS_STATUS_DESC','Modulstatus');
define('MODULE_ORDERS_PRODUCTS_STATS_STATUS_TITLE','Status');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
@define('TABLE_PERSONAL_OFFERS_BY','personal_offers_by_customers_status_');
define('MODULE_ORDERS_PRODUCTS_STATS_STARTDATE','Startdatum');
define('MODULE_ORDERS_PRODUCTS_STATS_ENDDATE','Enddatum');
define('MODULE_ORDERS_PRODUCTS_STATS_SORT_ORDER_TITLE','Sortierreihenfolge');
define('MODULE_ORDERS_PRODUCTS_STATS_SORT_ORDER_DESC','Sortierreihenfolge innerhalb der Export Module');
define('MODULE_ORDERS_PRODUCTS_ORDERS_STATUS','Zeige verkaufte Artikel aus Auftr&auml;gen mit Status:');
// include needed functions


class orders_products_stats extends products_export{
    var $code, $title, $description, $enabled,$csv_separator,$sort_order, $_check;
    function __construct() {
		$this->code = 'orders_products_stats';
		$this->title = MODULE_ORDERS_PRODUCTS_STATS_TEXT_TITLE;
		$this->description = MODULE_ORDERS_PRODUCTS_STATS_TEXT_DESCRIPTION;
		$this->sort_order = (defined('MODULE_ORDERS_PRODUCTS_STATS_SORT_ORDER')) ? MODULE_ORDERS_PRODUCTS_STATS_SORT_ORDER : 0;
		$this->enabled = ((defined('MODULE_ORDERS_PRODUCTS_STATS_STATUS') and MODULE_ORDERS_PRODUCTS_STATS_STATUS == 'True') ? true : false);
		$this->csv_separator = "\t";
	}



    function process($file) {
		$basics = new basics;
		@xtc_set_time_limit(0);
		$stats = array();
		$items = array();
		$where = '';
		if(isset($_REQUEST['date_from'])){
			$where .= sprintf("AND o.date_purchased>'%s 00:00:00' ",xtc_db_input($_REQUEST['date_from']));
		}
		if(isset($_REQUEST['date_to'])){
			$where .= sprintf("AND o.date_purchased < '%s 23:59:59' ",xtc_db_input($_REQUEST['date_to']));
		}
		if(isset($_REQUEST['orders_status']) and is_array($_REQUEST['orders_status'])){
		    $orders_statuses = array();
		    foreach($_REQUEST['orders_status'] as $os){
			$orders_statuses[] = (int)xtc_db_input($os);
		    }
		    $where .= sprintf(' AND o.orders_status IN(%s) ',implode(',',$orders_statuses));
		}
		if(isset($_REQUEST['manufacturers_id']) and $_REQUEST['manufacturers_id'] > 0){
		    $where .= sprintf(" AND p.manufacturers_id='%s'",(int)xtc_db_input($_REQUEST['manufacturers_id']));
		}
		$query_raw = "SELECT p.manufacturers_id,op.products_price,op.products_id,op.products_tax FROM orders o LEFT JOIN `orders_products` op USING(orders_id) LEFT JOIN products p USING(products_id) WHERE o.orders_id>0 $where";
		$query = xtc_db_query($query_raw);
		$tax = array();
		while($record = xtc_db_fetch_array($query)){
			if($record['products_tax']>0){
				if(!isset($tax[$record['products_tax']]))
					$tax[$record['products_tax']] = ( (100+ $record['products_tax']) / 100);
				$record['products_price'] = $record['products_price'] / $tax[$record['products_tax']];
			}
			if(!isset($items[ $record['products_id'] ])){
				$items[ $record['products_id'] ] = array(
					'counter'=>0,
					'price'=>0
				);
			}
			$items[ $record['products_id'] ]['counter'] += 1;
			$items[ $record['products_id'] ]['price'] += $record['products_price'];
		}
		foreach($items as $pID => $item){
			$stats[$pID]['avg'] = $item['price']/$item['counter'];
		}


		$items = array();
		$query = xtc_db_query(
			"SELECT op.products_price,op.products_id,op.products_tax,op.products_quantity FROM orders o LEFT JOIN `orders_products` op USING(orders_id) LEFT JOIN products p USING(products_id) WHERE o.orders_status !=7 $where"
		);
		$tax = array();
		$db_res = array();
		while($record = xtc_db_fetch_array($query)){
			$db_res[] = $record;
		}
		foreach($db_res as $record){
			if($record['products_tax']>0){
				if(!isset($tax[$record['products_tax']]))
					$tax[$record['products_tax']] = ( (100+ $record['products_tax']) / 100);
				$record['products_price'] = $record['products_price'] / $tax[$record['products_tax']];
			}
			if(!isset($items[ $record['products_id'] ]['min'])){
				$items[ $record['products_id'] ]['min'] = $record['products_price'];
			}
			if($items[ $record['products_id'] ]['min'] > $record['products_price']){
				$items[ $record['products_id'] ]['min'] = $record['products_price'];
			}
			if(!isset($items[ $record['products_id'] ]['max'])){
				$items[ $record['products_id'] ]['max'] = $record['products_price'];
			}
			if($items[ $record['products_id'] ]['max'] < $record['products_price']){
				$items[ $record['products_id'] ]['max'] = $record['products_price'];
			}
			if(!isset($items[ $record['products_id'] ]['qty'])){
				$items[ $record['products_id'] ]['qty'] = 0;
			}
			$items[ $record['products_id'] ]['qty'] += $record['products_quantity'];
		}
		foreach($items as $pID => $item){
			$stats[$pID]['min'] = $item['min'];
			$stats[$pID]['max'] = $item['max'];
			$stats[$pID]['qty'] = $item['qty'];
		}
		$buffer = implode($this->csv_separator,array('pID','Artikelname','Art-Nr','EAN','Durchschnitt','MIN Preis','MAX Preis','Verkauft'))."\r\n";
		foreach($stats as $pID=>$s){
                    $products_name = xtc_get_products_name($pID);
		    $pquery = xtc_db_query(sprintf(
			    "SELECT products_model, products_ean FROM products WHERE products_id='%s'",
			    $pID
		    ));
		    $p = xtc_db_fetch_array($pquery);
		    $buffer .= sprintf("%s\r\n",implode($this->csv_separator,array(
			$pID,
			$products_name,
			$p['products_model'],
			$p['products_ean'],
			$s['avg'],
			$s['min'],
			$s['max'],
			$s['qty']
		    ) ) );
		}
		// create File
		$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
		$filename = sprintf('products_price_stats_%s.csv',$crypt_file);
		$filepath = \main::get_exportdata_path();
		$basics->create_file($filepath.$filename,$buffer);
		$basics->zip_file($filepath,$filename,$filename.'.zip',true);

		$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
		unlink($filepath.$filename.'.zip');
		// send File to Browser
		$file = 'products_price_stats_'.date('Y-m-d_H_i_s').'.zip';
		header('Content-Type: application/octet-stream');
		header('Content-Transfer-Encoding: binary');
		header('Content-disposition: attachment; filename=' . $file);
		echo $file_contents;
		exit;
    }


    function display() {
		$from = yes_strftime('%Y-%m-%d',time()-60*60*24*7*4);
		$to = date('Y-m-d');
		$orders_status_str = '';
		foreach(xtc_get_orders_status() as $os){
		    $selected = (in_array($os['id'],array(ORDERS_STATUS_STORNIERT,ORDERS_STATUS_OFFER))) ? false : true;
		    $orders_status_str .= sprintf('%s&nbsp;%s<br />',xtc_draw_checkbox_field('orders_status[]',$os['id'],$selected),$os['text']);
		}
                $mID = (isset($_REQUEST['manufacturers_id'])) ? (int)xtc_db_input($_REQUEST['manufacturers_id']) : '';
                require_once(DIR_FS_INC.'xtc_get_manufacturers.inc.php');
		$array = array('text' => 
			'<script type="text/javascript">'.
			'  var dateStart = new ctlSpiffyCalendarBox("dateStart", "modules", "date_from","btnDate1","'.$from.'",scBTNMODE_CUSTOMBLUE);'.
			'  var dateEnd = new ctlSpiffyCalendarBox("dateEnd", "modules", "date_to","btnDate1","'.$to.'",scBTNMODE_CUSTOMBLUE);'.
			'</script>'.
			MODULE_ORDERS_PRODUCTS_STATS_STARTDATE.'<br /><script type="text/javascript">dateStart.writeControl(); dateStart.dateFormat="yyyy-MM-dd";</script><br />'.
			MODULE_ORDERS_PRODUCTS_STATS_ENDDATE.'<br /><script type="text/javascript">dateEnd.writeControl(); dateEnd.dateFormat="yyyy-MM-dd";</script><br /><br />'.
			MODULE_ORDERS_PRODUCTS_ORDERS_STATUS.'<br />'.$orders_status_str.
                        '<p>'.TEXT_MANUFACTURER.'<br />'.xtc_draw_pull_down_menu('manufacturers_id', xtc_array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),xtc_get_manufacturers()),$mID).'</p>'.
			'<br />' . xtc_image_submit('button_export.gif',IMAGE_EXPORT) .
			'<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=yes').'">'.xtc_image_button('button_cancel.gif',IMAGE_CANCEL).'</a>'
		);
		return $array;
    }

	function check() {
		if (!isset($this->_check)) {
			$check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDERS_PRODUCTS_STATS_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}

	function install() {
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDERS_PRODUCTS_STATS_SORT_ORDER', '0',  '6', '1', '', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDERS_PRODUCTS_STATS_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	}

    function remove() {
		xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
		return array('MODULE_ORDERS_PRODUCTS_STATS_STATUS','MODULE_ORDERS_PRODUCTS_STATS_SORT_ORDER');
    }
}
