<?php
define('MODULE_PENNERUNDRENNER_TEXT_DESCRIPTION', 'Export - Penner und Renner (Tab getrennt)');
define('MODULE_PENNERUNDRENNER_TEXT_TITLE', 'YES Produkte "Penner und Renner" - CSV');
define('MODULE_PENNERUNDRENNER_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_PENNERUNDRENNER_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_PENNERUNDRENNER_STATUS_DESC','Modulstatus');
define('MODULE_PENNERUNDRENNER_STATUS_TITLE','Status');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
define('MODULE_PENNERUNDRENNER_STARTDATE','Startdatum');
define('MODULE_PENNERUNDRENNER_ENDDATE','Enddatum');

// include needed functions

  class pennerundrenner extends products_export{
    var $code, $title, $description, $enabled,$categories_string,$TextSign,
            $selected_categories,$Groups,$language_id, $_check, $sort_order;


    function __construct() {
      $this->TextSign = '';
      $this->code = 'pennerundrenner';
      $this->title = MODULE_PENNERUNDRENNER_TEXT_TITLE;
      $this->description = MODULE_PENNERUNDRENNER_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_PENNERUNDRENNER_SORT_ORDER')) ? MODULE_PENNERUNDRENNER_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_PENNERUNDRENNER_STATUS') and MODULE_PENNERUNDRENNER_STATUS == 'True') ? true : false);
      $this->only_active_products = false;
      $this->only_active_categories = false;
	  $this->language_id = $_SESSION['languages_id'];
    }



    function process($file) {

        @xtc_set_time_limit(0);
		if((isset($_POST['cat']) and is_array($_POST['cat']) and sizeOf($_POST['cat'])>0) or (isset($_POST['allCat']) and $_POST['allCat'] == '1')){

		$export_query_raw = sprintf("SELECT p.products_id, p.products_ean, p.products_model, p.products_price,p.products_weight,p.products_status,
			(SELECT SUM(op.products_quantity) as anz FROM orders_products op LEFT JOIN orders o USING(orders_id) WHERE op.products_id=p.products_id AND o.date_purchased>'%s' AND o.date_purchased<'%s') as sells,
			(SELECT SUM(op.products_quantity) as anz FROM orders_products op LEFT JOIN orders o USING(orders_id) WHERE op.products_id=p.products_id AND o.date_purchased>'%s' AND o.date_purchased<'%s' AND o.orders_status='%s') as stornos 
			 FROM products_to_categories p2c LEFT JOIN products p USING (products_id) WHERE 
			p.products_id > 0 %s GROUP BY products_id ORDER BY sells DESC",
			xtc_db_input($_REQUEST['date_from']),
			xtc_db_input($_REQUEST['date_to']),
			xtc_db_input($_REQUEST['date_from']),
			xtc_db_input($_REQUEST['date_to']),
			ORDERS_STATUS_STORNIERT,
			$this->getP2CWhereSQLString(@$_POST['allCat'],@$_POST['cat'])
		);
		$export_query = xtc_db_query($export_query_raw);
		$schema =  "pID\tArtikelname\tEAN\tArt.-Nr\tNettopreis\tGewicht in kg\tStatus\tVerkauft\tDavon Storniert\tPhys. Bestand\tV1\tV2\r\n";
		while ($products = xtc_db_fetch_array($export_query)) {
	
			$pID = $products['products_id'];
			$SQ = new products_quantity($pID);

			$desc_query = xtc_db_query("SELECT * FROM products_description WHERE products_id='".$pID."' and language_id='".$this->language_id."'");
			$desc = xtc_db_fetch_array($desc_query);

			// BOF - USERALLOCATIONS

			$schema .=  $products['products_id'] ."\t".
					$this->prepare_string($desc['products_name'])."\t".
					$this->prepare_string($products['products_ean'])."\t".
					$this->prepare_string($products['products_model'])."\t".
					number_format($products['products_price'],4,',','')."\t".
					number_format(($products['products_weight']*1000),0,',','')."\t".
					$products['products_status']."\t".
					(int)$products['sells']."\t".
					(int)$products['stornos']."\t".
					$SQ->get_products_total_qty()."\t".
					$SQ->get_available1_qty()."\t".
					$SQ->get_available2_qty()."\r\n";
		}
		// create File
		$fp = fopen(DIR_FS_CATALOG.'../ebaymich/' . $file, "w+");
		fputs($fp, $schema);
		fclose($fp);

		$export_mode = (isset($_POST['export'])) ? $_POST['export'] : '';
		switch ($export_mode) {
        	case 'yes':
			// send File to Browser
			$extension = substr($file, -3);
			$fp = fopen(DIR_FS_CATALOG.'../ebaymich/' . $file,"rb");
			$buffer = fread($fp, filesize(DIR_FS_CATALOG.'../ebaymich/' . $file));
			fclose($fp);
			header('Content-type: application/x-octet-stream');
			header('Content-disposition: attachment; filename=' . $file);
			echo $buffer;
			exit;
			break;
        	}
	} // end if categories_array

    }


    function display() {
		if(!xtc_check_permission('f_bestand')){
				return array(0=>array('text'=>MODULE_ACCESS_ERROR));
		}
		$from = yes_strftime('%Y-%m-%d',time()-60*60*24*7*4);
		$to = date('Y-m-d');
		/* WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN */
		$array = array(
			'text' =>  $this->getCategoryJSString().'<br />'.
				'<script type="text/javascript">'.
				'  var dateStart = new ctlSpiffyCalendarBox("dateStart", "modules", "date_from","btnDate1","'.$from.'",scBTNMODE_CUSTOMBLUE);'.
				'  var dateEnd = new ctlSpiffyCalendarBox("dateEnd", "modules", "date_to","btnDate1","'.$to.'",scBTNMODE_CUSTOMBLUE);'.
				'</script>'.
				EXPORT_TYPE.'<br />'.
				EXPORT.'<br />'.
				xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br />'.
				xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br /><br />'.
				MODULE_PENNERUNDRENNER_STARTDATE.'<br /><script type="text/javascript">dateStart.writeControl(); dateStart.dateFormat="yyyy-MM-dd";</script><br />'.
				MODULE_PENNERUNDRENNER_ENDDATE.'<br /><script type="text/javascript">dateEnd.writeControl(); dateEnd.dateFormat="yyyy-MM-dd";</script><br />'.
				'<b>Exportiere Produkte aus Kategorie:</b><br />'.
				'<input type="checkbox" name="allCat" value="1" CHECKED onClick="allCatFunc();"> Alle Kategorien<br />'.
				$this->getCategoriesString().
				'<br />' . xtc_image_submit('button_export.gif','Exportieren') .
				'<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=pennerundrenner').'">'.xtc_image_button('button_cancel.gif','Abbrechen').'</a>'
		);
		return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PENNERUNDRENNER_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PENNERUNDRENNER_FILE', 'pennerundrenner_export.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PENNERUNDRENNER_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PENNERUNDRENNER_STATUS','MODULE_PENNERUNDRENNER_FILE');
    }

  }
