<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_TEXT_TITLE', 'Steuerklassen Zuweisung auf Artikelebene');
define('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_TEXT_DESCRIPTION', 'Steuerklassen können zu jedem einzelnen Artikel für die verschiedenen Steuerzonen konfiguriert werden. Wir empfehlen Ihnen, die Steuerklassen Zuweisungen über Produktgruppen vorzunehmen. Bei Fragen kontaktieren Sie uns gern.');
define('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_STATUS_DESC','Modulstatus');
define('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_STATUS_TITLE','Status');
define('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_IMPORT_LINK','<p class="helptable">Die CSV Datei k&ouml;nnen Sie &uuml;ber <a href="'.xtc_href_link(FILENAME_TAX_RATES,'action=import').'"><u>diesen Link</u></a> wieder in YES importieren.</p>');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()

class products_tax_class_allocations extends products_export{
    var $code, $title, $description, $enabled,$categories_string,$selected_categories,$Groups,$delimiter;
    var $from_cron,$save_path, $ACK, $_check, $sort_order, $TextSign;


    function __construct() {
        $this->ACK = new ACK;
      $this->TextSign = '';
      $this->code = 'products_tax_class_allocations';
      $this->title = MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_TEXT_TITLE;
      $this->description = MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_SORT_ORDER')) ? MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_STATUS') and MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_STATUS == 'True') ? true : false);
      $this->only_active_products = false;
      $this->only_active_categories = false;
      $this->Groups = xtc_get_customers_statuses();
      $this->delimiter = "\t";
    }

    function process($file, $cron_parameter = array()) {
        @xtc_set_time_limit(0);
        $max_items = 5000;
        if(strstr(HTTP_SERVER,'localhost')){
            $max_items = 500;
        }
        $basics = new basics;
        global $messageStack,$admin_access,$argv;
        
        $export_distributors_id = 0;
        if(isset($_REQUEST['distributors_id']) and $_REQUEST['distributors_id'] > 0){
            $export_distributors_id = (int)xtc_db_input($_REQUEST['distributors_id']);
        }elseif(isset($cron_parameter['distributors_id'])){
            $export_distributors_id = $cron_parameter['distributors_id'];
        }
        
        $export_linked_products = '';
        if(isset($_REQUEST['export_linked_products']) and $_REQUEST['export_linked_products'] == 1){
            $export_linked_products = 1;
        }elseif(isset($cron_parameter['export_linked_products']) and $cron_parameter['export_linked_products'] == 1){
            $export_linked_products = 1;
        }
                
        $cat = '';
        if(isset($_REQUEST['cat'])){
            $cat = $_REQUEST['cat'];
        }elseif(isset($cron_parameter['cat'])){
            $cat = $cron_parameter['cat'];
        }
        $allCat = false;
        if((isset($_REQUEST['allCat']) and $_REQUEST['allCat'] == '1') or $this->from_cron === true){
            $allCat = true;
        }elseif(isset($cron_parameter['allCat'])){
            $allCat = $cron_parameter['allCat'];
        }
                
		$export_params = array(
		    'export_linked_products'=>$export_linked_products,
		    'distributors_id'=>$export_distributors_id,
		    'particle_path'=>\main::get_exportdata_path().'PTCA_EXPORT/',
		    'start'=>0,
		    'cat'=>$cat,
		    'allCat'=>$allCat,
		    'export'=>(isset($_REQUEST['export']) and $_REQUEST['export'] == 'yes') ? 'yes' : 'no'
		);
                if(isset($_REQUEST['start'])){
                    $export_params['start'] = (int)xtc_db_input($_REQUEST['start']);
		}
		if($export_params['start'] == 0){
		    if(is_dir($export_params['particle_path'])){
			    $files = $basics->get_directory_content($export_params['particle_path']);
			    foreach($files as $f){
				    unlink($export_params['particle_path'].$f);
			    }
			    rmdir($export_params['particle_path']);
		    }
		    mkdir($export_params['particle_path']) or die(get_current_user().": cant create folder ".$export_params['particle_path']);
		}
		
		$languages = xtc_get_languages();	
                
		if($export_params['export_linked_products'] == 1){
			$linked_sql = "";
		}else{
			$linked_sql = " GROUP BY products_id ";
		}
		$distributor_from_sql = '';
		$distributor_where_sql = '';
		if($export_params['distributors_id'] > 0){
			$distributor_from_sql = ' LEFT JOIN products_distributors pdi USING(products_id) ';
			$distributor_where_sql = sprintf(
				' AND pdi.distributor_id=%s ',
				$export_params['distributors_id']
			);
		}
		if(isset($_REQUEST['products_id_export']) and $_REQUEST['products_id_export'] != ''){
                    $products_id_array = explode(',',$_REQUEST['products_id_export']);
                    $pid_prepared = array();
                    foreach($products_id_array as $products_id){
                        if((int)$products_id > 0){
                             $pid_prepared[] = (int)xtc_db_input($products_id);
                        }
                    }
                    if(sizeOf($pid_prepared)){
                        $export_query_raw = "SELECT
                            p.products_id,
                            p.products_ean,
                            p.products_model 
                            FROM
                            " . TABLE_PRODUCTS . " p LEFT JOIN 
                            products_to_categories p2c USING (products_id)
                            WHERE p.products_id IN(".implode(',',$pid_prepared).")
                            GROUP BY p.products_id ORDER BY
                            p.products_date_added DESC ";
                    }
		}else if(($export_params['cat'] != '' and is_array($export_params['cat']) and sizeOf($export_params['cat'])>0) or ($export_params['allCat'] === true )){
                    $count_export_query_raw = "SELECT p.products_id FROM
                        products_to_categories p2c LEFT JOIN
                        " . TABLE_PRODUCTS . " p USING (products_id)
                        " .$distributor_from_sql. "
                        WHERE p.products_id > 0
                        ".$this->getP2CWhereSQLString($export_params['allCat'],$export_params['cat'])." 
                        ".$distributor_where_sql."
                        ".$linked_sql;
			    
                    $export_query_raw = "SELECT
                        p.products_id,
                        p.products_ean,
                        p.products_model 
                        FROM
                        products_to_categories p2c LEFT JOIN
                        " . TABLE_PRODUCTS . " p USING (products_id)
                        " .$distributor_from_sql. "
                        WHERE p.products_id > 0
                        ".$this->getP2CWhereSQLString($export_params['allCat'],$export_params['cat'])." 
                        ".$distributor_where_sql."
                        ".$linked_sql." 
                        ORDER BY
                        p.products_date_added DESC";
		}
		if(isset($count_export_query_raw)){
		    $count_export_query = xtc_db_query($count_export_query_raw);
		    $num_total = xtc_db_num_rows($count_export_query);
		}elseif(isset($_REQUEST['products_id_export'])){
                    $num_total = sizeOf($pid_prepared);
                }
		
		
		if(isset($export_query_raw) and $export_query_raw != ''){
		    if(isset($count_export_query_raw)){
			$export_query_raw .= sprintf(" LIMIT %s, %s",$export_params['start'],$max_items);
		    }
		    $export_query = xtc_db_query($export_query_raw);
		}
		if(!isset($export_query_raw) or !xtc_db_num_rows($export_query)){
		    if($this->from_cron or sizeOf($cron_parameter)){
                        if(!sizeOf($cron_parameter)){
                            die("Es wurden keine Artikel exportiert.\r\n");
                        }else{
                            $this->ACK->add_error('Es wurden keine Artikel exportiert');
                            $this->ACK->set_success(false);
                            return false;
                        }
		    }else{
			$messageStack->add_session('Es wurden keine Artikel exportiert.','error');
			xtc_redirect(xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action'))));
		    }
		}
		$counter = 0;
                $header = ['products_id','Artikel (nur Info, kein Import)'];
                if(sizeOf($cron_parameter) and $cron_parameter['use_heading_row'] !== true){
                    $rows = array();
                }else{
                    $rows = array(implode("\t",$header));
                }
                $tax_rates_query = xtc_db_query(sprintf(
                        "SELECT tr.*, tc.tax_class_title FROM %s tr LEFT JOIN %s tc USING(tax_class_id) ORDER BY tr.tax_rates_id",
                        TABLE_TAX_RATES, TABLE_TAX_CLASS
                ));
                $rates = [];
                while($tax_rate = xtc_db_fetch_array($tax_rates_query)){
                    $rates[ $tax_rate['tax_zone_id'] ][$tax_rate['tax_rates_id']] = $tax_rate['tax_rates_id']
                            .': '
                            .$tax_rate['tax_class_title']
                            .' ('.number_format($tax_rate['tax_rate'],2,',','')
                            .'%)';
                }
                foreach($rates as $geo_zone_id => $tax_rates_array){
                    $header[] = sprintf("\"%s\r\n%s\"",
                        xtc_get_geo_zone_name($geo_zone_id),
                        implode("\r\n",$tax_rates_array)
                    );
                }
                $products_arr = [];
		while ($products = xtc_db_fetch_array($export_query)) {
                    $products_arr[] = $products;
                }
                foreach($products_arr as $products){
                    $pID = $products['products_id'];
                    $fields = [$pID,xtc_get_products_name($pID)];
                    foreach($rates as $geo_zone_id => $tax_rates_data){
                        $matched_id = Null;
                        foreach($tax_rates_data as $tax_rates_id => $tax_rate_desc){
                            $query = xtc_db_query(sprintf(
                                    "SELECT products_tax_rates_allocation_id FROM products_tax_rates_allocation WHERE products_id='%d' AND tax_rates_id='%d'",
                                    $pID, $tax_rates_id
                            ));
                            if(!xtc_db_num_rows($query)){
                                continue;
                            }
                            $matched_id = $tax_rates_id;
                        }
                        $fields[] = ($matched_id !== Null) ? $matched_id : '';
                    }
                    $schema .= implode($this->delimiter,$fields)."\r\n";
                    $counter++;
		}
                
		$filename = sprintf('PART_%s.csv',$export_params['start']);
		$basics->create_file($export_params['particle_path'].$filename, $schema);
		if( $export_params['start']+$max_items >= (int)$num_total ){
			// KOMPLETT ERZEUGEN
			$schema = implode($this->delimiter,$header)."\r\n";
			$files = $basics->get_directory_content($export_params['particle_path']);
			foreach($files as $f){
				$fp = fopen($export_params['particle_path'].$f,"rb") or die('cant open '.$export_params['particle_path'].$f.' in '.basename(__FILE__));
				$schema .= fread($fp, filesize($export_params['particle_path']. $f));
				fclose($fp);
				unlink($export_params['particle_path'].$f);
			}
			// create File
			if(!$this->from_cron){
			    $config_file = (isset($_REQUEST['export_config_file']) and $_REQUEST['export_config_file'] != '') ? '{'.basename($_REQUEST['export_config_file']).'}' : '';
			    $file = sprintf('ptca_export_%s_%s.csv',$config_file,date('Y-m-d_His'));
			}
			$directory_without_slash = substr($export_params['particle_path'],0,strlen($export_params['particle_path'])-1);
                        $zip = false;
			$csv_file = (substr($file,-3) == 'zip') ? $file.'.csv' : $file;
			$basics->create_file($export_params['particle_path'] . $csv_file, $schema);
                        if(!sizeOf($cron_parameter) or substr($file,-3) == 'zip'){
                            $zip = true;
				if(substr($file,-3) == 'zip'){
	                           $basics->zip_file($directory_without_slash, $csv_file, $file, true);
				}else{
	                           $basics->zip_file($directory_without_slash, $csv_file, $file.'.zip', true);
				}
                        }
			switch ($export_params['export']) {
				case 'yes':
//						unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);
					header($_SERVER['SERVER_PROTOCOL'].' 200 OK');
					header("Content-Type: application/zip");
					header("Content-Transfer-Encoding: Binary");
				if(substr($file,-3) != 'zip'){
					$file = $file.'.zip';
				}
					header("Content-Length: ".filesize($export_params['particle_path']. $file));
					header("Content-Disposition: attachment; filename=\"".$file."\"");
					readfile($export_params['particle_path']. $file);
					unlink($export_params['particle_path']. $file);
					exit;
					break;
				case 'no':
//				    unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);
				    $save_path = ($this->from_cron) ? $this->save_path.'/' : DIR_FS_CATALOG.'files/';
                                    if($zip){
                                        if(substr($file,-3) != 'zip'){
                                            $file = $file.'.zip';
                                        }
                                    }
                                    if(!@copy($export_params['particle_path']. $file,$save_path.$file)){
					$errors= error_get_last();
					echo "\r\nCOPY ERROR: ".$errors['type'];
					echo "\r\n".$errors['message']."\r\n";
				    }
                                    unlink($export_params['particle_path']. $file);
                                    $messageStack->add_session(sprintf(MSG_SUCCESS_FILE_EXPORTED,$file.'.zip'),'success');
				    break;
			}
		}else{
                    // redirect
                    if(isset($_POST['export'])){
                            $_GET["configuration[\"MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_FILE\"]"] = $file;
                            $_GET['status'] = $_REQUEST['status'];
                            $_GET['export'] = $_REQUEST['export'];
                            $_GET['distributors_id'] = $_REQUEST['distributors_id'];
                            $_GET['products_id_export'] = $_REQUEST['products_id_export'];
                            $_GET['export'] = $_REQUEST['export'];
                            $_GET['title'] = $_REQUEST['title'];
                            $_GET['allCat'] = $_REQUEST['allCat'];
                            $_GET['export_linked_products'] = ((isset($_REQUEST['export_linked_products']))?$_REQUEST['export_linked_products']:'');
                    }
                    $next_link = xtc_href_link('module_export.php',xtc_get_all_get_params(array('start')).'start='.($export_params['start']+$max_items));
                    xtc_redirect($next_link);
		}
    }

    function display() {
	/* WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN */
	$distributor_input_array = array(
		0=>array('id'=>'','text'=>'Alle')
	);
	$distributors_query = xtc_db_query("SELECT id,name FROM distributors ORDER BY name");
	while($distributors = xtc_db_fetch_array($distributors_query)){
		$distributor_input_array[] = array(
			'id'=>$distributors['id'],
			'text'=>$distributors['name']
		);
	}
	$distributor_input = xtc_draw_pull_down_menu('distributors_id',$distributor_input_array);
	$basics = new basics;
	
	$array = array('text' =>  $this->getCategoryJSString().MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_IMPORT_LINK.'<br />'.
		EXPORT_TYPE.'<br />'.
		EXPORT.'<br />'.
		xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br />'.
		xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br /><br />'.
		'<p><b>Exportiere Produkte des Lieferanten:</b><br />'.
		$distributor_input.'</p>'.
		'<b>Exportiere Produkte aus Kategorie:</b><br />'.
		'<input type="checkbox" name="allCat" value="1" CHECKED onClick="allCatFunc();"> Alle Kategorien<br />'.
		$this->getCategoriesString().
		'<input type="checkbox" name="export_linked_products" value="1" />'.EXPORT_LINKED_PRODUCTS.'<br />'.
		'<br />Exportiere folgende pID (kommagetrennt)<br /><input type="text" name="products_id_export" style="width:90%;" /><br />'.
		'<br />' . xtc_image_submit('button_export.gif','Exportieren') .
		'<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=ptcs').'">'.xtc_image_button('button_cancel.gif','Abbrechen').'</a>'
	);
	return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_FILE', 'Steuerklassen_export.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array(
          'MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_STATUS',
          'MODULE_PRODUCTS_TAX_CLASS_ALLOCATIONS_FILE'
      );
    }    
}
