<?php
require_once(DIR_FS_INC.'xtc_href_link_from_admin.inc.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_YES2_TEXT_DESCRIPTION', 'Konfigurierbarer YES Artikel Export (Tab getrennt)');
define('MODULE_YES2_TEXT_TITLE', 'YES Produkte Export konfigurierbar - CSV');
define('MODULE_YES2_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_YES2_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_YES2_STATUS_DESC','Modulstatus');
define('MODULE_YES2_STATUS_TITLE','Status');
define('MODULE_YES2_IMPORT_LINK','<p class="helptable">Die CSV Datei k&ouml;nnen Sie &uuml;ber <a href="'.xtc_href_link(FILENAME_CATEGORIES,'action=yes_import2').'"><u>diesen Link</u></a> wieder in YES importieren.</p>');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
@define('EXPORT_LINKED_PRODUCTS','Verlinkte Produkte mit exportieren');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
@define('TABLE_PERSONAL_OFFERS_BY','personal_offers_by_customers_status_');
// include needed functions

class yes2 extends products_export{
    var $code, $title, $description, $enabled,$categories_string,$selected_categories,$Groups,$delimiter;
    var $from_cron,$save_path, $ACK, $sort_order, $TextSign;


    function __construct() {
        $this->ACK = new ACK;
      $this->TextSign = '';
      $this->code = 'yes2';
      $this->title = MODULE_YES2_TEXT_TITLE;
      $this->description = MODULE_YES2_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_YES2_SORT_ORDER')) ? MODULE_YES2_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_YES2_STATUS') and MODULE_YES2_STATUS == 'True') ? true : false);
      $this->only_active_products = false;
      $this->only_active_categories = false;
      $this->Groups = xtc_get_customers_statuses();
      $this->from_cron = (isset($_SERVER['REMOTE_ADDR'])) ? false : true;
      $this->delimiter = "\t";
    }

    /**
     * Gibt True zurueck wenn ein Fehler auftritt
     * @param string $ini_file
     * @return boolean
     */
    public static function check_ini_sort($ini_file){
        $ini = self::get_ini($ini_file);
        $sorts = array();
        foreach($ini as $g=>$items){
            foreach($items as $i){
                if(!isset($sorts[$i])){
                    $sorts[$i] = 0;
                }
                $sorts[$i]++;
            }
        }
        $error = false;
        foreach($sorts as $s){
            if($s > 1){
                $error = true;
            }
        }
        return $error;
    }
    
    public static function get_ini($file){
		$filePath = \main::get_exportdata_path().'module_export_configs/';
		if(is_file($filePath.$file)){
	    	return parse_ini_file($filePath.$file,true);
        }
    }
    
    public function get_heading_row($header,$ini=array(),$languages=array(),$no_import_config=false){
	$heading_row = array('products_id');
	foreach($header as $group=>$fields){
	    if($no_import_config or isset($ini[$group])){
		switch($group){
		    case 'main':
		    case 'google_product_feed':
			foreach($fields['items'] as $field=>$field_title){
			    if($no_import_config or isset($ini[$group][$field]))
				$heading_row[] = $header[ $group ]['items'][$field];
			}
			break;
		    case 'description':
		    case 'google_product_feed_languages':
			foreach($fields['items'] as $field=>$field_title){
			    foreach($languages as $lang){
				if($no_import_config or isset($ini[$group][$field]))
				    $heading_row[] = $lang['name'] .': '.$header[ $group ]['items'][$field];
			    }
			}
			break;
		    case 'pics':
				for($j=1;$j<=MO_PICS;$j++){
					$heading_row[] = TEXT_EXPORT_CONFIG_GROUP_PICS.' #'.$j;
				}
				break;

		    case 'images':
				if(isset($ini['images']['export']) and $ini['images']['export'] == 1){
					$heading_row[] = 'Image (No Import)';
					for($j=1;$j<=MO_PICS;$j++){
						$heading_row[] = "Image #$j (No Import)";
					}
				}
				break;
			case 'characteristics':
				foreach($languages as $lang){
					$heading_row[] = 'Merkmale '.$lang['code'].' (No Import)';
				}
				break;
            case 'shipping_extra_charges':
				foreach(main::get_shipping_graduation_groups() as $sgg){
					$heading_row[] = $header[ $group ]['title'].' '.$sgg['text'];
				}
                break;
		    case 'cs_prices':
			foreach($this->Groups as $nr=>$gr){
			    if($nr > 0)
				$heading_row[] = $header[ $group ]['title'].' '.$gr['text'];
			}
			break;
		    default:
			$heading_row[] = $header[ $group ]['title'];
			break;
		}

	    }
	}
	return $heading_row;
    }
    function process($file, $cron_parameter = array()) {
        @xtc_set_time_limit(0);
        $max_items = 5000;
        if(strstr(HTTP_SERVER,'localhost')){
            $max_items = 500;
        }
        $basics = new basics;
        global $messageStack,$admin_access,$argv;
        $export_config_file = '';
        if(isset($_REQUEST['export_config_file']) and !empty($_REQUEST['export_config_file'])){
            $export_config_file = $_REQUEST['export_config_file'];
        }elseif(isset($cron_parameter['ini'])){
            $export_config_file = $cron_parameter['ini'];
        }
                
        if($this->from_cron){
            if(isset($argv[1]) and !empty($argv[1])){
                if(is_file(\main::get_exportdata_path().'module_export_configs/yes2_'.basename($argv[1]).'.ini')){
                    $export_config_file = $argv[1];
                }else{
                    die("Invalid yes2 Export Config Scheme '".$argv[1]."'\r\n");
                }
            }
        }
        
        $export_distributors_id = 0;
        if(isset($_REQUEST['distributors_id']) and $_REQUEST['distributors_id'] > 0){
            $export_distributors_id = (int)xtc_db_input($_REQUEST['distributors_id']);
        }elseif(isset($cron_parameter['distributors_id'])){
            $export_distributors_id = $cron_parameter['distributors_id'];
        }
        
		if($this->from_cron){
		    if(isset($argv[2]) and !empty($argv[2])){
			$export_distributors_id = $argv[2];
		    }
		}
                $export_linked_products = '';
                if(isset($_REQUEST['export_linked_products']) and $_REQUEST['export_linked_products'] == 1){
                    $export_linked_products = 1;
                }elseif(isset($cron_parameter['export_linked_products']) and $cron_parameter['export_linked_products'] == 1){
                    $export_linked_products = 1;
                }
                
                $cat = '';
                if(isset($_REQUEST['cat'])){
                    $cat = $_REQUEST['cat'];
                }elseif(isset($cron_parameter['cat'])){
                    $cat = $cron_parameter['cat'];
                }
                $allCat = false;
                if((isset($_REQUEST['allCat']) and $_REQUEST['allCat'] == '1') or $this->from_cron === true){
                    $allCat = true;
                }elseif(isset($cron_parameter['allCat'])){
                    $allCat = $cron_parameter['allCat'];
                }
                
		$export_params = array(
		    'export_config_file'=>$export_config_file,
		    'export_linked_products'=>$export_linked_products,
		    'distributors_id'=>$export_distributors_id,
		    'particle_path'=>\main::get_exportdata_path().'YES2_EXPORT/',
		    'start'=>0,
		    'cat'=>$cat,
		    'allCat'=>$allCat,
		    'export'=>(isset($_REQUEST['export']) and $_REQUEST['export'] == 'yes') ? 'yes' : 'no'
		);
		if($this->from_cron or sizeOf($cron_parameter)){
		    if(is_dir($export_params['particle_path'])){
			$files = $basics->get_directory_content($export_params['particle_path']);
			foreach($files as $f){
			    if(!strstr($f,'PART_')){
				continue;
			    }
			    $strpos1 = strpos($f,'_')+1;
			    $str1 = substr($f,$strpos1);
			    $strpos2 = strpos($str1,'.');
			    $_start = (int)substr($str1,0,$strpos2);
			    if($_start >= $export_params['start']){
				$export_params['start'] = $_start+$max_items;
			    }
			}
		    }
		}else{
		    if(isset($_REQUEST['start']))
			$export_params['start'] = (int)xtc_db_input($_REQUEST['start']);
		}
		if($export_params['start'] == 0){
		    if(is_dir($export_params['particle_path'])){
			    $files = $basics->get_directory_content($export_params['particle_path']);
			    foreach($files as $f){
				    unlink($export_params['particle_path'].$f);
			    }
			    rmdir($export_params['particle_path']);
		    }
		    mkdir($export_params['particle_path']) or die(get_current_user().": cant create folder ".$export_params['particle_path']);
		}
		
		$languages = xtc_get_languages();	
		$no_import_config = false;
		if(!empty($export_params['export_config_file'])){
		    $ini = $this->get_ini('yes2_'.basename($export_params['export_config_file'].'.ini'));
        }else{
            $ini = array();
        }
		$header = $this->get_header($ini);
		if(!empty($export_params['export_config_file'])){
		    $heading_row = $this->get_heading_row($header,$ini,$languages,$no_import_config);
		}else{
		    $no_import_config = true;
		    $heading_row = $this->get_heading_row($header,array(),$languages,$no_import_config);
		}
                
                if(sizeOf($cron_parameter)){
                    $heading_row = $this->sort_heading_row($heading_row, $cron_parameter, $ini);
                }
		if($export_params['export_linked_products'] == 1){
			$linked_sql = "";
		}else{
			$linked_sql = " GROUP BY products_id ";
		}
		$distributor_from_sql = '';
		$distributor_where_sql = '';
		if($export_params['distributors_id'] > 0){
			$distributor_from_sql = ' LEFT JOIN products_distributors pdi USING(products_id) ';
			$distributor_where_sql = sprintf(
				' AND pdi.distributor_id=%s ',
				$export_params['distributors_id']
			);
		}
		if(isset($_REQUEST['products_id_export']) and $_REQUEST['products_id_export'] != ''){
			$products_id_array = explode(',',$_REQUEST['products_id_export']);
			$pid_prepared = array();
			foreach($products_id_array as $products_id){
				if((int)$products_id > 0){
					$pid_prepared[] = (int)xtc_db_input($products_id);
				}
			}
			if(sizeOf($pid_prepared)){
				$export_query_raw = "SELECT
						p.products_id,
						p.products_ean,
						p.products_model,
						p.products_sort,
						p.products_price,
						DATE_FORMAT(p.products_date_available,'%d.%m.%y') as available,
						p.products_weight,
						p.products_weight_netto,
						p.products_status,
						p.products_fsk18,
						p.size_width,
						p.size_height,
						p.size_depth,
						p.products_listing_status,				
						p.products_startpage,
						p.products_startpage_sort,
						p.products_master,
						p.products_master_status,
						p.products_shippingtime,
						p.products_meldebestand,
						p.meldebestand_active,
						p.price_fixing,
						p.manufacturers_id,
                                                p.default_category,
						p.packaging_costs,
						uvp,
						p.products_conditions_id,
						p.mpn,
						amazon_fulfillmentlatency,
						amazon_revise,
						amazon_revise_qty,
						units_id,
						packagings_id,
						disable_cron_update_products_status,
						products_vpe,
						products_vpe_status,
						products_vpe_value,
                                                products_vpe_base_measure,
                                                no_yatego_export,
                                                p.comments,
                                                storage_comments,
                                                zollwarennummer,
                                                ebay_productreferenceid,
                                                products_image,
                                                cron_cancel_auctions_exclude,
                                                cron_cancel_auctions_max_quantity 
						FROM
						" . TABLE_PRODUCTS . " p LEFT JOIN 
						products_to_categories p2c USING (products_id)
						WHERE p.products_id IN(".implode(',',$pid_prepared).")
						GROUP BY p.products_id ORDER BY
						p.products_date_added DESC ";
			}
		}else if(($export_params['cat'] != '' and is_array($export_params['cat']) and sizeOf($export_params['cat'])>0) or ($export_params['allCat'] === true )){
			$count_export_query_raw = "SELECT p.products_id FROM
					products_to_categories p2c LEFT JOIN
					" . TABLE_PRODUCTS . " p USING (products_id)
					" .$distributor_from_sql. "
					WHERE p.products_id > 0
					".$this->getP2CWhereSQLString($export_params['allCat'],$export_params['cat'])." 
					".$distributor_where_sql."
					".$linked_sql;
			    
			$export_query_raw = "SELECT
					p.products_id,
					p.products_ean,
					p.products_model,
					p.products_sort,
					p.products_price,
					DATE_FORMAT(p.products_date_available,'%d.%m.%y') as available,
					p.products_weight,
					p.products_weight_netto,
					p.products_status,
					p.products_fsk18,
					p.size_width,
					p.size_height,
					p.size_depth,
					p.products_listing_status,				
					p.products_startpage,
					p.products_startpage_sort,
					p.products_master,
					p.products_master_status,
					p.products_shippingtime,
					p.products_meldebestand,
					p.meldebestand_active,
					p.price_fixing,
					p.manufacturers_id,
                                        p.default_category,
					p.packaging_costs,
					uvp,
					p.products_conditions_id,
					p.mpn,
					amazon_fulfillmentlatency,
					amazon_revise,
					amazon_revise_qty,
					units_id,
					packagings_id,
					default_storage,
					disable_cron_update_products_status,
					products_vpe,
					products_vpe_status,
					products_vpe_value,
                                        products_vpe_base_measure,
                                        no_yatego_export,
                                        p.comments,
                                        storage_comments,
                                        zollwarennummer,
                                        ebay_productreferenceid,
                                        p.products_image,
                                        cron_cancel_auctions_exclude,
                                        cron_cancel_auctions_max_quantity 
					FROM
					products_to_categories p2c LEFT JOIN
					" . TABLE_PRODUCTS . " p USING (products_id)
					" .$distributor_from_sql. "
					WHERE p.products_id > 0
					".$this->getP2CWhereSQLString($export_params['allCat'],$export_params['cat'])." 
					".$distributor_where_sql."
					".$linked_sql." 
					ORDER BY
					p.products_date_added DESC";
		}
		if(isset($count_export_query_raw)){
		    $count_export_query = xtc_db_query($count_export_query_raw);
		    $num_total = xtc_db_num_rows($count_export_query);
		}elseif(isset($_REQUEST['products_id_export'])){
			$num_total = (is_countable($pid_prepared)) ? sizeOf($pid_prepared) : 0;
		}		
		
		if(isset($export_query_raw) and $export_query_raw != ''){
		    if(isset($count_export_query_raw)){
				$export_query_raw .= sprintf(" LIMIT %s, %s",$export_params['start'],$max_items);
		    }
		    $export_query = xtc_db_query($export_query_raw);
		}
		if(!isset($export_query_raw) or !xtc_db_num_rows($export_query)){
		    if($this->from_cron or sizeOf($cron_parameter)){
				if(!sizeOf($cron_parameter)){
					die("Es wurden keine Artikel exportiert.\r\n");
				}else{
					$this->ACK->add_error('Es wurden keine Artikel exportiert');
					$this->ACK->set_success(false);
					return false;
				}
		    }else{
				$messageStack->add_session('Es wurden keine Artikel exportiert.','error');
				xtc_redirect(xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action'))));
		    }
		}
		$schema = '';
		$counter = 0;
		if(sizeOf($cron_parameter) and $cron_parameter['use_heading_row'] !== true){
			$rows = array();
		}else{
			$rows = array(implode("\t",$heading_row));
		}
		$_products = [];
		while ($products = xtc_db_fetch_array($export_query)) {
			$_products[] = $products;
		}
        foreach($_products as $products){
			$pID = intval($products['products_id']);
	    	for ($i = 0, $n = sizeOf($languages); $i < $n; $i++) {
				$groups_string[$languages[$i]['id']] = \product::get_groups_export_string($pID, $languages[$i]['id']);
			}
			$desc_fields = array();
			$desc_incl_char_fields = [];
			$desc_result = array();
			$price_fields = array();
			$pics_fields = array();
			$images_fields = [];
			$user_allocations_fields = array();
			$default_shipper = '';
			$tag_fields = array();
			$google_product_feed = array();
            $products['products_url'] = xtc_href_link_from_admin('product_info.php', 'products_id='.$pID);
                        
			$google_product_feed_languages = array();
			for($i=0;$i<4;$i++){
				foreach($languages as $lang){
					$google_product_feed_languages[] = '';
				}
			}
			if($no_import_config or (isset($ini['cs_prices']['export']) and $ini['cs_prices']['export'] == 1)){
			    reset($this->Groups);
			    foreach ($this->Groups as $cs_nr=>$cs_grp) {
                                if ($cs_nr < 1) {
                                    continue;
                                }
                                $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                                    $cs_grp['id'], $pID
                                );
                                $groupPrice = '';
                                foreach($group_prices_items as $GPI) {
                                    if ($GPI->personal_offer > 0) {
                                        $groupPrice .= $GPI->quantity.':'.$GPI->personal_offer.'::';
                                    }
                                }
                                $groupPrice .= ':';
                                $groupPrice = str_replace(':::', '', $groupPrice);
                                if ($groupPrice == ':'){
                                    $groupPrice = "";
                                }
                                $price_fields[] = $groupPrice;
			    }
			}

			if($no_import_config or (isset($ini['description']) and sizeOf($ini['description'])) ){
			    for ($i = 0, $n = sizeOf($languages); $i < $n; $i++) {
				    $desc_query = xtc_db_query("SELECT * FROM products_description WHERE products_id='".$pID."' and language_id='".$languages[$i]['id']."'");
				    $desc = xtc_db_fetch_array($desc_query);
					$desc['products_description_incl_characteristics'] = $desc['products_description']
						.\product::get_groups_export_string(intval($pID),intval($languages[$i]['id']));
				    $desc_result[ $languages[$i]['id'] ] = xtc_db_prepare_input($desc);
			    }
			    foreach($header['description']['items'] as $desc_field=>$enabled){
					if($no_import_config or isset($ini['description'][$desc_field])){
						for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
							$key = $desc_field;
							$desc_fields[] = $this->prepare_string($desc_result[$languages[$i]['id']][$key],true);
						}
					}
			    }
			}

			$characteristics = [];
			if($no_import_config or (isset($ini['characteristics']) and sizeOf($ini['characteristics'])) ){
			    for ($i = 0, $n = sizeOf($languages); $i < $n; $i++) {
				    $characteristics[ $languages[$i]['id'] ] = \product::get_groups_export_string(intval($pID),intval($languages[$i]['id']));
			    }
			}
			
			// SHOPANZEIGE MO_PICS START
			if($no_import_config or (isset($ini['pics']['export']) and $ini['pics']['export'] == 1)){
			    for($mpi=1;$mpi<=MO_PICS;$mpi++){
					$pics_fields[$mpi] = 0;
			    }
			    $pics_query = yes_db_query(sprintf("SELECT image_nr,noshop FROM products_images WHERE products_id='%s' ORDER by image_nr ASC",$pID));
			    if(yes_db_num_rows($pics_query)){
				    foreach($pics_query as $k=>$pic){
					if( ($k+1)>MO_PICS ) continue;
					$pics_fields[$pic['image_nr']] = (int)$pic['noshop'];
				    }
			    }
			}
                        
			// BILDER - NUR EXPORT
            $images_fields = [];
			if(isset($ini['images']['export']) and $ini['images']['export'] == 1){
				if($products['products_image'] != ''){
					$images_fields[0] = HTTPS_CATALOG_SERVER.'images/product_images/popup_images/'.$products['products_image'];
				}else{
					$images_fields[0] = '';
				}
			    for($mpi=1;$mpi<=MO_PICS;$mpi++){
					$images_fields[$mpi] = '';
			    }
			    $pics_query = yes_db_query(sprintf("SELECT image_name,image_nr FROM products_images WHERE products_id='%s' ORDER by image_nr ASC",$pID));
			    if(yes_db_num_rows($pics_query)){
				    foreach($pics_query as $k=>$pic){
						if( ($k+1)>MO_PICS ) continue;
						$images_fields[$pic['image_nr']] = HTTPS_CATALOG_SERVER.'images/product_images/popup_images/'.$pic['image_name'];
				    }
			    }
			}

			if($no_import_config or (isset($ini['meldebestand_user']['export']) and $ini['meldebestand_user']['export'] == 1 )){
			    // BOF - USERALLOCATIONS
                $pmc_list = \YES4Trade\Model\products_meldebestand_customers::get_by_products_id(intval($pID));
			    foreach($pmc_list as $pmc){
                	$user_allocations_fields[] = intval($pmc->customers_id);
			    }
			}
			if($no_import_config or (isset($ini['tags']['export']) and $ini['tags']['export'] == 1) ){
			    $tags_query = xtc_db_query(sprintf(
				    "SELECT t.tag FROM tags t LEFT JOIN tags_products tp USING(tags_id) WHERE t.type='product' AND tp.products_id='%s'",
				    $products['products_id']
			    ));
			    while($tags = xtc_db_fetch_array($tags_query)){
					$tag_fields[] = xtc_db_prepare_input(str_replace(',','.',$tags['tag']));
			    }
			}
			if($no_import_config or (isset($ini['default_shipper']['export']) and $ini['default_shipper']['export'] == 1 )){
				$default_shipper = yes_get_products_default_shipper($products['products_id']);
			}
			
			if($no_import_config or (isset($ini['google_product_feed']) and sizeOf($ini['google_product_feed'])) ){
				$query = xtc_db_query(sprintf(
					"SELECT google_condition,availability,gtin,mpn,adwords_grouping,adwords_labels FROM products_google_feed_data WHERE products_id='%s'",
					$products['products_id']
				));
				if(xtc_db_num_rows($query)){
				    $record = xtc_db_fetch_array($query);
				    foreach($record as $gpk=>$gpv){
						if($no_import_config or in_array($gpk,array_keys($ini['google_product_feed']))){
							$google_product_feed[] = $gpv;
						}
				    }
				}else{
				    foreach($header['google_product_feed']['items'] as $gpk=>$gpv){
						if($no_import_config or isset($ini['google_product_feed'][$gpk])){
							$google_product_feed[] = '';
						}
				    }
				}
			}
			if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
				if($no_import_config or (isset($ini['google_product_feed_languages']) and sizeOf($ini['google_product_feed_languages']))){
					$garr = array();
					foreach($languages as $lang){
							$query = xtc_db_query(sprintf(
									"SELECT gender,age_group,color,size FROM products_google_feed_apparel WHERE products_id='%s' AND language_id='%s'",
									$products['products_id'],$lang['id']
							));
							$record = xtc_db_fetch_array($query);

							if(is_array($record) and sizeOf($record)){
									foreach($record as $fk=>$f){
										if($no_import_config or in_array($fk,array_keys($ini['google_product_feed_languages'])))
											$garr[ $fk ][ $lang['id'] ] = $f;
									}
							}else{
								foreach($header['google_product_feed_languages']['items'] as $fk=>$tmp){
									if($no_import_config or in_array($fk,array_keys($ini['google_product_feed_languages'])))
										$garr[][ $lang['id'] ] = '';
								}
							}
					}
					$gpfl_c = 0;
					foreach($garr as $key => $lang){
						foreach($lang as $f){
							$google_product_feed_languages[$gpfl_c] = $this->prepare_string($f,true);
							$gpfl_c++;
						}
					}
				}
			}
			$shipping_extra_charges = array();
			if($no_import_config or (isset($ini['shipping_extra_charges']['export']) and $ini['shipping_extra_charges']['export'] == 1) ){
				foreach(main::get_shipping_graduation_groups() as $sgc){
					$shipping_extra_charges[] = main::get_product_shipping_extra_charges($products['products_id'], $sgc['id']);
				}
			}
			if(!sizeOf($cron_parameter)){
				$fields = array($products['products_id']);
			}else{
				$fields = array(); // BEI CRON EXPORTEN KEINE PRODUCTS_ID AN ERSTER STELLE
			}
			foreach($header as $group => $gr_fields){
			    if($no_import_config or isset($ini[$group])){
				switch($group){
				    case 'main':
					foreach($gr_fields['items'] as $field=>$what){
					    if($no_import_config or isset($ini[$group][$field])){
						switch($field){
						    case 'products_ean':
						    case 'products_model':
						    case 'comments':
						    case 'storage_comments':
						    case 'zollwarennummer':
                                                    case 'ebay_productreferenceid':
							$fields[] = $this->prepare_string($products[$field],true);
							break;
						    case 'products_sort':
						    case 'products_vpe':
                                                    case 'cron_cancel_auctions_max_quantity':
							$fields[] = (int)$products[$field];
							break;
						    case 'products_price':
						    case 'size_width':
						    case 'size_height':
						    case 'size_depth':
						    case 'packaging_costs':
						    case 'products_vpe_value':
                                                    case 'products_vpe_base_measure':
						    case 'uvp':
								$fields[] = number_format($products[$field],4,',','');
								break;
						    case 'products_date_available':
								$fields[] = (($products['available'] != '00.00.00')?$products['available']:'');
								break;
							case 'products_weight':
						    case 'products_weight_netto':
								$fields[] = number_format($products[$field],4,',','');
								break;
						    case 'products_status':
						    case 'products_fsk18':
						    case 'products_listing_status':
						    case 'products_startpage':
						    case 'products_startpage_sort':
						    case 'products_master':
						    case 'products_master_status':
						    case 'products_shippingtime':
						    case 'products_meldebestand':
						    case 'meldebestand_active':
						    case 'price_fixing':
						    case 'manufacturers_id':
						    case 'default_category':
						    case 'products_conditions_id':
						    case 'mpn':
						    case 'units_id':
						    case 'packagings_id':
						    case 'amazon_fulfillmentlatency':
						    case 'amazon_revise':
						    case 'amazon_revise_qty':
						    case 'default_storage':
						    case 'disable_cron_update_products_status':
						    case 'products_vpe_status':
							case 'cron_cancel_auctions_exclude':
							case 'products_url':
								$fields[] = $products[$field];
								break;
							case 'no_yatego_export':
							case 'no_google_product_feed_export':
								$fields[] = (int)$products[$field];
								break;
						}
					    }
					 }
					 break;
				    case 'description':
						foreach($desc_fields as $desc){
							$fields[] = $desc;
						}
						break;
				    case 'description_incl_characteristics':
						foreach($desc_incl_char_fields as $desc){
							$fields[] = $desc;
						}
						break;
				    case 'google_product_feed':
						foreach($google_product_feed as $gpf){
							$fields[] = $gpf;
						}
						break;
				    case 'google_product_feed_languages':
						if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
							foreach($google_product_feed_languages as $gpf){
								$fields[] = $gpf;
							}
						}
						break;
				    case 'cs_prices':
					foreach($price_fields as $price){
					    $fields[] = $price;
					}
					break;
				    case 'images':
					foreach($images_fields as $pic){
					    $fields[] = $pic;
					}
					break;
				    case 'pics':
					foreach($pics_fields as $pic){
					    $fields[] = $pic;
					}
					break;
				    case 'meldebestand_user':
					$fields[] = implode(',',$user_allocations_fields);
					break;
				    case 'tags':
					$fields[] = implode(',',$tag_fields);
					break;
				    case 'default_shipper':
						$fields[] = $default_shipper;
						break;
					case 'shipping_extra_charges':
						foreach($shipping_extra_charges as $sec){
							$fields[] = $sec;
						}
						break;
					case 'characteristics':
						foreach($characteristics as $ch){
							$fields[] = $ch;
						}
						break;
				}
			    }
			}
			$rows[] = implode("\t",$fields);
			$schema .= implode($this->delimiter,$fields)."\r\n";
			$counter++;
		}
		$filename = sprintf('PART_%s.csv',$export_params['start']);
		$basics->create_file($export_params['particle_path'].$filename, $schema);
		if( $export_params['start']+$max_items >= (int)$num_total ){
			// KOMPLETT ERZEUGEN
			$schema = implode($this->delimiter,$heading_row)."\r\n";
			$files = $basics->get_directory_content($export_params['particle_path']);
			foreach($files as $f){
				$fp = fopen($export_params['particle_path'].$f,"rb") or die('cant open '.$export_params['particle_path'].$f.' in '.basename(__FILE__));
				$schema .= fread($fp, filesize($export_params['particle_path']. $f));
				fclose($fp);
				unlink($export_params['particle_path'].$f);
			}
			// create File
			if(!$this->from_cron){
			    $config_file = (isset($_REQUEST['export_config_file']) and $_REQUEST['export_config_file'] != '') ? '{'.basename($_REQUEST['export_config_file']).'}' : '';
			    $file = sprintf('yes2_export_%s_%s.csv',$config_file,date('Y-m-d_His'));
			}
			$directory_without_slash = substr($export_params['particle_path'],0,strlen($export_params['particle_path'])-1);
                        $zip = false;
			$csv_file = (substr($file,-3) == 'zip') ? $file.'.csv' : $file;
			$basics->create_file($export_params['particle_path'] . $csv_file, $schema);
                        if(!sizeOf($cron_parameter) or substr($file,-3) == 'zip'){
                            $zip = true;
				if(substr($file,-3) == 'zip'){
	                           $basics->zip_file($directory_without_slash, $csv_file, $file, true);
				}else{
	                           $basics->zip_file($directory_without_slash, $csv_file, $file.'.zip', true);
				}
                        }
			switch ($export_params['export']) {
				case 'yes':
//						unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);
					header($_SERVER['SERVER_PROTOCOL'].' 200 OK');
					header("Content-Type: application/zip");
					header("Content-Transfer-Encoding: Binary");
				if(substr($file,-3) != 'zip'){
					$file = $file.'.zip';
				}
					header("Content-Length: ".filesize($export_params['particle_path']. $file));
					header("Content-Disposition: attachment; filename=\"".$file."\"");
					readfile($export_params['particle_path']. $file);
					unlink($export_params['particle_path']. $file);
					exit;
					break;
				case 'no':
//				    unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);
				    $save_path = ($this->from_cron) ? $this->save_path.'/' : DIR_FS_CATALOG.'files/';
                                    if($zip){
                                        if(substr($file,-3) != 'zip'){
                                            $file = $file.'.zip';
                                        }
                                    }
                                    if(!@copy($export_params['particle_path']. $file,$save_path.$file)){
					$errors= error_get_last();
					echo "\r\nCOPY ERROR: ".$errors['type'];
					echo "\r\n".$errors['message']."\r\n";
				    }
                                    unlink($export_params['particle_path']. $file);
				    if($this->from_cron or sizeOf($cron_parameter)){
                                        if(sizeOf($cron_parameter)){
                                           $cron_parameter['yce']->update_current_export(0);
                                           $cron_parameter['yce']->update_last_export('now()');
                                           $this->ACK->add_message('Cron Export '.$cron_parameter['yce']->getName().' '.$this->save_path.'/'.$file." wurde erzeugt");
                                           $this->ACK->set_success(true);
                                           return true;    
                                        }else{
                                           die($this->save_path.'/'.$file.".zip wurde erzeugt\r\n");
                                        }
				    }else{
					$messageStack->add_session(sprintf(MSG_SUCCESS_FILE_EXPORTED,$file.'.zip'),'success');
				    }
				    break;
			}
		}else{
		    if($this->from_cron or sizeOf($cron_parameter)){
                        if(!sizeOf($cron_parameter)){
                            die("\r\nGENERATED FILE: $filename\r\n".'Start: '.$export_params['start'].' / Generated: '.($counter-1).' / Total: '.$num_total." / MAX: $max_items\r\n");
                        }else{
                            $this->ACK->add_message("GENERATED FILE: $filename\r\n".'Start: '.$export_params['start'].' / Generated: '.($counter-1).' / Total: '.$num_total." / MAX: $max_items");
                            $this->ACK->set_success(true);
                            return true;
                        }
		    }else{
			// redirect
			if(isset($_POST['export'])){
				$_GET["configuration[\"MODULE_YES2_FILE\"]"] = $file;
				$_GET['status'] = $_REQUEST['status'];
				$_GET['export'] = $_REQUEST['export'];
				$_GET['export_config_file'] = $_REQUEST['export_config_file'];
				$_GET['distributors_id'] = $_REQUEST['distributors_id'];
				$_GET['products_id_export'] = $_REQUEST['products_id_export'];
				$_GET['export'] = $_REQUEST['export'];
				$_GET['title'] = $_REQUEST['title'];
				$_GET['allCat'] = $_REQUEST['allCat'];
				$_GET['export_linked_products'] = ((isset($_REQUEST['export_linked_products']))?$_REQUEST['export_linked_products']:'');
			}
			$next_link = xtc_href_link('module_export.php',xtc_get_all_get_params(array('start')).'start='.($export_params['start']+$max_items));
			xtc_redirect($next_link);
		    }
		}
    }

    function display() {
	/* WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN */
	$distributor_input_array = array(
		0=>array('id'=>'','text'=>'Alle')
	);
	$distributors_query = xtc_db_query("SELECT id,name FROM distributors ORDER BY name");
	while($distributors = xtc_db_fetch_array($distributors_query)){
		$distributor_input_array[] = array(
			'id'=>$distributors['id'],
			'text'=>$distributors['name']
		);
	}
	$distributor_input = xtc_draw_pull_down_menu('distributors_id',$distributor_input_array);
	$export_config_files = array(array('id'=>'','text'=>TEXT_SELECT));
	$filePath = \main::get_exportdata_path().'module_export_configs/';
	if(!is_dir($filePath)){
	    mkdir($filePath);
	}
	$basics = new basics;
	$dir = $basics->get_directory_content($filePath);
	foreach($dir as $fn){
	    if(substr($fn,0,strlen($this->code)) == $this->code){
		$export_config_files[] = array(
		    'id'=>str_replace(array('.ini','yes2_'),'',$fn),
		    'text'=>str_replace(array('.ini','yes2_'),'',$fn)
		);
	    }
	}
	
	$array = array('text' =>  $this->getCategoryJSString().MODULE_YES2_IMPORT_LINK.'<br />'.
		EXPORT_TYPE.'<br />'.
		EXPORT.'<br />'.
		xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br />'.
		xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br /><br />'.
		'<script type="text/javascript">'.
		'$(function(){'.
		'   $(\'input.button_export_config\').click(function(){'.
		'	$("#modal_window").dialog({width:"800px",height:"auto",modal: true,title: $(this).val()}).load(\''.xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'action=export_config').'\');'.
		'   });'.
	    "
		    $('a.delete_config_file').click(function(){
			var fn = $('select[name=\"export_config_file\"]').val();
			if(fn.length > 0){
			    if(confirm('".CONFIRM_DELETE_CONFIG_FILE."')){
				window.location.href = '".xtc_href_link('module_export.php',xtc_get_all_get_params(array('action','file')).'action=delete_config_file')."&file='+fn;
			    }
			}
		    });
		    $('a.edit_config_file').click(function(){
			var fn = $('select[name=\"export_config_file\"]').val();
			if(fn.length > 0){
                            $('#modal_window').dialog({width:'800px',height:'auto',modal: true,title: '".IMAGE_EDIT."'}).load('".xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'action=edit_export_config')."&export_config='+fn);
			}
		    });
		".
		'});'.
		'</script>'.
		'<p class="formArea" style="padding: 4px;"><b>'.TEXT_USE_EXPORT_CONFIG.':</b><br />'.xtc_draw_pull_down_menu('export_config_file',$export_config_files).
		'&nbsp;<a href="javascript:;" class="delete_config_file"><img src="images/basicons/delete82.png" width="15" height="15" title="'.IMAGE_DELETE.'" /></a> '.
		'&nbsp;<a href="javascript:;" class="edit_config_file"><img src="images/basicons/black406.png" width="15" height="15" title="'.IMAGE_EDIT.'" /></a> '.
                '<br /><br />'.
		'<input class="ui-state-higlight ui-corner-all button_export_config" type="button" value="Neue Exportkonfiguration anlegen" />'.
		'</p>'.
		'<p><b>Exportiere Produkte des Lieferanten:</b><br />'.
		$distributor_input.'</p>'.
		'<b>Exportiere Produkte aus Kategorie:</b><br />'.
		'<input type="checkbox" name="allCat" value="1" CHECKED onClick="allCatFunc();"> Alle Kategorien<br />'.
		$this->getCategoriesString().
		'<input type="checkbox" name="export_linked_products" value="1" />'.EXPORT_LINKED_PRODUCTS.'<br /><br />'.
		'<br />Exportiere folgende pID (kommagetrennt)<br /><input type="text" name="products_id_export" style="width:90%;" /><br />'.
		'<br />' . xtc_image_submit('button_export.gif','Exportieren') .
		'<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=yes').'">'.xtc_image_button('button_cancel.gif','Abbrechen').'</a>'
	);
	return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_YES2_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_YES2_FILE', 'yes2_export.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_YES2_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_YES2_STATUS','MODULE_YES2_FILE');
    }
    
    public function get_header($ini = array()){
		$lieferstatii = '';
		$shipping_status_query = yes_db_query(sprintf("SELECT shipping_status_id,shipping_status_name FROM shipping_status WHERE language_id='%s'",$_SESSION['languages_id']),true);
		if(yes_db_num_rows($shipping_status_query)){
			foreach($shipping_status_query as $k=>$status){
				$lieferstatii .= $status['shipping_status_name'] .'='.$status['shipping_status_id'].'|';
			}
			$lieferstatii = substr($lieferstatii,0,(strlen($lieferstatii)-1));
		}
		$languages = xtc_get_languages();

		$lang_fields = array(
			0=>array('products_name','Produkttitel'),
			1=>array('products_extra_text','Extratext'),
			2=>array('products_description','Beschreibung'),
			3=>array('products_short_description','Kurzbeschreibung'),
			4=>array('products_meta_title','Meta-Tag Titel'),
			5=>array('products_meta_description','Meta-Tag Beschreibung'),
			6=>array('products_meta_keywords','Meta-Tag Keywords'),
			7=>array('ebay_title','eBaytitel'),
			8=>array('amazon_title','Amazontitel'),
			9=>array('slave_title','Slave-Titel'),
			10=>array('products_description_incl_characteristics','Beschreibung und Produktgruppen (no import)'),
		);
		if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
		    for($agk=1;$agk<=5;$agk++){
			$lang_fields[] = array('amazon_generic_keywords'.$agk,'Amazon Suchwoerter '.$agk);
		    }
		    $lang_fields[] = array('amazon_flatfile','Amazon Dateivorlage');
		    $lang_fields[] = array('amazon_browse_node_id','Amazon Kategorie');
		    $lang_fields[] = array('products_description_amazon','Amazon Beschreibung');
		}

		$google_lang_schema = array();
		if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
			$google_lang_schema = array(
				'gender'=>TEXT_EXPORT_CONFIG_GOOGLE_PF_APPAREL_GENDER,
				'age_group'=>TEXT_EXPORT_CONFIG_GOOGLE_PF_APPAREL_AGE_GROUP,
				'color'=>TEXT_EXPORT_CONFIG_GOOGLE_PF_APPAREL_COLOR,
				'size'=>TEXT_EXPORT_CONFIG_GOOGLE_PF_APPAREL_SIZE
			);
		}
		$schema_lang = array();
		for($j=0;$j<sizeOf($lang_fields);$j++){
		    $schema_lang[$lang_fields[$j][0]] = str_replace("\t"," ",$lang_fields[$j][1]);
		}
		$units_array = array();
		$units_query = xtc_db_query("SELECT * FROM units ORDER BY units_title");
		while($unit = xtc_db_fetch_array($units_query)){
		    $units_array[] = $unit['units_id'].' = '.$unit['units_title'];
		}
		$units_string = '';
		if(sizeOf($units_array)){
		    $units_string = '('.implode(',',$units_array).')';
		}
		
		$packagings_array = array();
		$packagings_query = xtc_db_query("SELECT packagings_id,title FROM packagings ORDER BY title");
		while($packagings = xtc_db_fetch_array($packagings_query)){
		    $packagings_array[] = $packagings['packagings_id'].' = '.$packagings['title'];
		}
		$packagings_string = '';
		if(sizeOf($packagings_array)){
		    $packagings_string = '('.implode(',',$packagings_array).')';
		}
		
		$storages_array = array();
		$storages_query = xtc_db_query("SELECT id,name FROM storages ORDER BY name");
		while($storage = xtc_db_fetch_array($storages_query)){
		    $storages_array[] = $storage['id'].' = '.$storage['name'];
		}
		$storages_string = '';
		if(sizeOf($storages_array)){
		    $storages_string = '('.implode(',',$storages_array).')';
		}
		$header = array(
			'main'=>array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_MAIN)
		);
		if(isset($ini['images']) and isset($ini['images']['export']) and $ini['images']['export'] == 1){
			$header['images'] = array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_IMAGES);
		}
		$header['description'] = array('items'=>$schema_lang,'languages'=>true,'title'=>TEXT_EXPORT_CONFIG_GROUP_DESC);
		
	    $header['cs_prices'] = array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_CS_PRICES,'no_items'=>true);
	    $header['pics'] = array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_PICS);
	    $header['images'] = array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_IMAGES);
	    $header['default_shipper'] = array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_DEFAULT_SHIPPER);
	    $header['tags'] = array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_TAGS);
	    $header['meldebestand_user'] = array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_MELDEBESTAND);
	
	if(defined('MODULE_GOOGLE_PRODUCT_FEED_STATUS') and MODULE_GOOGLE_PRODUCT_FEED_STATUS == 'True'){
	    $header['google_product_feed'] = array('items'=>array(),'languages'=>false,'title'=>'Google Product Feeds');
	    if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
			$header['google_product_feed_languages'] = array('items'=>array(),'languages'=>true,'title'=>'Google Product Feed (Mode)');
	    }
	}
    $header['shipping_extra_charges'] = array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_SHIPPING_EXTRA_CHARGES);
	$header['characteristics'] = array('items'=>array(),'languages'=>true,'title'=>TEXT_EXPORT_CONFIG_CHARACTERISTICS);

	$main_array = array(
	    'products_ean',
	    'products_model',
	    'products_sort',
	    'products_price',
	    'products_date_available',
	    'products_weight',
	    'products_weight_netto',
	    'products_status',
	    'products_fsk18',
	    'size_width',
	    'size_height',
	    'size_depth',
	    'products_listing_status',
	    'products_startpage',
	    'products_startpage_sort',
	    'products_master',
	    'products_master_status',
	    'products_shippingtime',
	    'products_meldebestand',
	    'meldebestand_active',
	    'price_fixing',
	    'manufacturers_id',
	    'default_category',
	    'packaging_costs',
	    'uvp',
	    'products_conditions_id',
	    'mpn',
	    'units_id',
	    'packagings_id',
	    'amazon_fulfillmentlatency',
	    'amazon_revise',
	    'amazon_revise_qty',
	    'default_storage',
	    'disable_cron_update_products_status',
	    'products_vpe',
	    'products_vpe_status',
	    'products_vpe_value',
		'products_vpe_base_measure',
		'comments',
		'storage_comments',
		'no_yatego_export',
		'no_google_product_feed_export',
		'zollwarennummer',
		'ebay_productreferenceid',
		'cron_cancel_auctions_exclude',
		'cron_cancel_auctions_max_quantity',
		'products_url',
	);
	foreach($main_array as $it){
	    switch($it){
		case 'products_vpe':
		    $query = xtc_db_query(sprintf(
			    "SELECT products_vpe_id,products_vpe_name FROM products_vpe WHERE language_id='%s'",
			    $_SESSION['languages_id']
		    ));
		    $vpe_keys = array();
		    while($record = xtc_db_fetch_array($query)){
			$vpe_keys[] = sprintf('%s=%s',$record['products_vpe_id'],xtc_db_prepare_input($record['products_vpe_name']));
		    }
		    $header['main']['items'][$it] = constant('TEXT_EXPORT_CONFIG_'.strtoupper($it)).' ('.implode(', ',$vpe_keys).')';
		    break;
		default:
		    $header['main']['items'][$it] = constant('TEXT_EXPORT_CONFIG_'.strtoupper($it));
		    break;
	    }
	}
	if(defined('MODULE_GOOGLE_PRODUCT_FEED_STATUS') and MODULE_GOOGLE_PRODUCT_FEED_STATUS == 'True'){
	    $header['google_product_feed']['items'] = array('google_condition'=>TEXT_EXPORT_CONFIG_GOOGLE_PF_CONDITION,
		    'availability'=>TEXT_EXPORT_CONFIG_GOOGLE_PF_AVAILABILITY,
		    'gtin'=>'[Google Product Feed] GTIN',
		    'mpn'=>'[Google Product Feed] MPN',
		    'adwords_grouping'=>TEXT_EXPORT_CONFIG_GOOGLE_PF_ADWORDS_GROUPING,
		    'adwords_labels'=>'[Google Product Feed] Adwords Label'
	    );
	    if(defined('MODULE_GOOGLE_PRODUCT_FEED_STATUS') and MODULE_GOOGLE_PRODUCT_FEED_STATUS == 'True'){
		    if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
			$header['google_product_feed_languages']['items'] = $google_lang_schema;
		    }
	    }
	}
	return $header;
		
    }
    
    private static function get_heading_row_name($header, $module, $field = ''){
        $return = '';
        if(isset($header[ $module ])){
            if($field == ''){
                $return = $header[ $module ][ 'title' ];
            }else{
                if(isset($header[ $module ]['items'][ $field])){
                    $return = $header[ $module ]['items'][ $field];
                }
            }
        }
        return $return;
    }
    
    public function sort_heading_row($heading_row, $cron_parameter, $ini, $replace = true){
        $sort = array();
        if($cron_parameter['use_heading_row'] !== true){
            return $sort;
        }
        array_shift($heading_row); // die statische products_id wird entfernt
        $header = $this->get_header();
        foreach($ini as $group=>$group_val){
            if(isset($group_val['export'])){
                $sort[ $group_val['export'] ] = $this->get_heading_row_name($header, $group);
            }else{
                foreach($group_val as $m=>$sorting){
                    $sort[ $sorting ] = $this->get_heading_row_name($header, $group, $m);
                }
            }
        }
        if($replace === true){
            foreach($cron_parameter['header_rows'] as $hr){
                $sort[ $hr->sort_order ] = $hr->name;
            }
        }
        return $sort;
    }

}
