<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'order.php');
require_once(DIR_WS_CLASSES.'customer.php');
require_once(DIR_FS_INC.'xtc_is_shipping_before_payment.inc.php');
require_once(DIR_WS_CLASSES.'class.payment.php');
require_once(DIR_WS_CLASSES.'class.ebay.php');
require_once(DIR_WS_CLASSES.'class.incoming_payments.php');
require_once(DIR_WS_CLASSES.'class.csv.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_WS_CLASSES.'class.ebaymail.php');

require_once(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require_once(DIR_FS_INC.'xtc_get_auction_site.inc.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');

$EBAYAPI = new ebayAPI();
define('TABLE_EBAY_FEEDBACK','ebay_feedback');
define('FILENAME_EBAY_FEEDBACK','ebayapi_feedback.php');
function _match_string($string){
	if(strlen($string)){
		return sprintf('<div class="errorText">%s</div>',$string);
	}
	return $string;
}
$tolerance = 1.00;
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');


$PAY = new incoming_payment;
$query = xtc_db_query("SELECT text FROM ebay_textitems WHERE module='feedback' and value='positive'");
while($row = xtc_db_fetch_array($query)){
	$PAY->feedback_text_array[] = xtc_db_prepare_input($row['text']);
}
$notice_users = main::get_notice_recipients('ebayapi_feedback');
if(is_countable($notice_users) and sizeOf($notice_users)){
    $PAY->feedback_recs = $notice_users;
}
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch($action){
	case 'delete_payment_order':
		$oID = intval(xtc_db_input($_GET['oID']));
		$pID = intval(xtc_db_input($_GET['id']));
		$update_confirmed = (isset($_GET['update_confirmed']) and $_GET['update_confirmed'] == '1') ? true : false;
		if($oID > 0 and $pID > 0){
			$PAY->delete_payment_order($pID,$oID,$update_confirmed);
			$PAY->_init($pID);
			$order = new order($oID);
			$comments = sprintf(HISTORY_DELETE_PAYMENT_ORDER,$PAY->get_text_raw(),$PAY->get_betrag(),$PAY->get_buchungstag());
			$order->add_history($order->info['orders_status'], $notified=false, $comments);
			die('1');
		}
		die('-1');
		break;
	case 'autofilter_allocation':
		// orders updaten
		if(is_array($_POST['alloc'])){
			foreach($_POST['alloc'] as $allocation ){
				$allocation_array = explode('-',$allocation);
				$orders_id = (int)xtc_db_input($allocation_array[0]);
				$pID = (int)xtc_db_input($allocation_array[1]);
				$check_query = xtc_db_query("SELECT count(1) as anzahl FROM payment_orders WHERE payment_id='".$pID."' AND orders_id='".$orders_id."'");
				$check = xtc_db_fetch_array($check_query);
				if($check['anzahl'] < 1){
					xtc_db_query("INSERT INTO payment_orders SET payment_id='".$pID."', orders_id='".$orders_id."', created=now()");
				}
				xtc_db_query("UPDATE incoming_payments SET confirmed=1 WHERE id='".$pID."'");
				$order = new order($orders_id);
				$payment_method_query = xtc_db_query(sprintf(
					"SELECT payment_method FROM orders WHERE orders_id='%s'",
					$order->info['id']
				));
				$payment_method = xtc_db_fetch_array($payment_method_query);
				if( $order->info['orders_status'] == ORDERS_STATUS_VERSENDET ){
				    $order->update_orders_status(ORDERS_STATUS_ABGESCHLOSSEN);
				    $order->add_history(ORDERS_STATUS_ABGESCHLOSSEN,false,TEXT_HISTORY_ALLOCATED_ORDER_AUTOMATIC);
				}else{
				    $order->update_orders_status(ORDERS_STATUS_BEZAHLT);
				    $order->add_history(ORDERS_STATUS_BEZAHLT,false,TEXT_HISTORY_ALLOCATED_ORDER_AUTOMATIC);
				}				
				// DOPPELT!
				/*
				$order->update_orders_status(ORDERS_STATUS_BEZAHLT);
				$order->add_history(ORDERS_STATUS_BEZAHLT,false,TEXT_HISTORY_ALLOCATED_ORDER_AUTOMATIC);
				 * 
				 */
				$customer = new customer($order->customer['ID']);
				$customer->update_current_account_value();
				if(defined('PAYMENT_CONFIRMATION_EMAIL_ACTIVE') and PAYMENT_CONFIRMATION_EMAIL_ACTIVE == 'true'){
					$mail_smarty = new yesSmarty;
					$mail_smarty->assign('language', $_SESSION['language']);

					$mail_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
					$mail_smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
					$adresse  = $order->delivery['name']."<br />";
					$adresse .= (!empty($order->delivery['company'])) ? $order->delivery['company']."<br />" : '';
					$adresse .= $order->delivery['street_address']."<br />";
					if($order->delivery['suburb'] != '')
						$adresse .= $order->delivery['suburb']."<br />";
					$adresse .= "<br />";
					$adresse .= $order->delivery['postcode'] . " " . $order->delivery['city'] . "<br />";
					$adresse .= $order->delivery['country']."<br />";
					$adresse_text = str_replace("<br />","\r\n",$adresse);

					$products_string = '';
					foreach ($order->products as $k=>$products) {
						$products_string .= $products['qty'] . " x " . $products['model'] . "- " . $products['name']."<br />\n";
					}
					$mail_smarty->assign('ADDRESS_TEXT',$adresse_text);
					$mail_smarty->assign('ADDRESS',$adresse);
					$mail_smarty->assign('PRODUCTS',$products_string);
					$mail_smarty->assign('NAME',$order->billing['name']);
					$mail_smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
					$mail_html = $mail_smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/payment_confirmation.html');
					$mail_txt = $mail_smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/payment_confirmation.txt');
					xtc_php_mail(EMAIL_BILLING_ADDRESS,
						EMAIL_BILLING_NAME,
						$order->customer['email_address'],
						$order->customer['name'],
						'',
						EMAIL_BILLING_REPLY_ADDRESS,
						EMAIL_BILLING_REPLY_ADDRESS_NAME,
						'',
						'',
						sprintf(PAYMENT_CONFIRMATION_EMAIL_SUBJECT,$orders_id),
						$mail_html,
						$mail_txt
					);
					$dbMail = new DBmail('0');
					$dbMail->save_mail(
						sprintf(PAYMENT_CONFIRMATION_EMAIL_SUBJECT,$order->info['id']),
						$order->customer['email_address'],
						EMAIL_BILLING_REPLY_ADDRESS_NAME,
						EMAIL_BILLING_REPLY_ADDRESS,
						$mail_html,
						date('Y-m-d H:i:s'), 
						$order->info['ebay_id'],
						$order->customer['ID'],
						$order->info['id']
					);
				}
			}
		}else{
			$messageStack->add_session(TEXT_ERROR_ALLOCATE_MISSING_ELEMENTS, 'error');
			xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS));
		}
		$messageStack->add_session(TEXT_MESSAGE_ALLOCATION_SUCCESS, 'success');
		xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS));
		break;
	case 'save_notiz':
		if(mb_detect_encoding($_POST['notiz'] ) == 'UTF-8')
			$_POST['notiz'] = yes_decode_string($_POST['notiz']);
		xtc_db_query("UPDATE incoming_payments SET name='".xtc_db_input($_POST['notiz'])."' WHERE id='".intval(xtc_db_input($_GET['id']))."'");
		header('Content-Type: text/html; charset='.CHARSET);
		printf('<br /><i>%s %s</i>',TEXT_NOTICE,$_POST['notiz']);
		exit;
		break;
	case 'allocate':
		if(!is_array($_GET['delpayID'])){
			if($_GET['change_order'] == '1'){
				require('incoming_payments_allocate.php');
			}else{
				$oID = (int)xtc_db_input($_GET['orders_id']);
				if($oID < 1){
					$messageStack->add_session(TEXT_MESSAGE_NO_ORDER_SELECTED, 'error');
					xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS));
					exit;
				}
				if( is_array($_GET['payment_id']) ){
					foreach($_GET['payment_id'] as $k=>$pID ){
						$PAY->allocate_filter( intval(xtc_db_input($pID)),array($oID),false);
					}
					$messageStack->add_session(TEXT_MESSAGE_PAYMENTPART_ALLOCATED, 'success');
				}else{
					$messageStack->add_session(TEXT_MESSAGE_NO_PAYMENT_SELECTED, 'error');
					xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS));
				}
				xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS));
				exit;
			}
		}
		break;
	case 'allocate_process':
		if(!is_array($_GET['delpayID'])){
			// fehlende zuordnungen speichern
			if(is_array($_POST['allocPay'])){
				foreach($_POST['allocPay'] as $pIDString => $oID ){
					$pIDArr = explode('_',$pIDString);
					$pID = (int)xtc_db_input($pIDArr[0]);
					$oID = (int)xtc_db_input($oID);

					$check_query_raw = sprintf(
						"SELECT count(1) as anzahl FROM payment_orders WHERE payment_id=%s AND orders_id=%s",
						$pID,$oID
					);
					$check_query = xtc_db_query($check_query_raw);
					$check = xtc_db_fetch_array($check_query);
					if($check['anzahl'] < 1){
						xtc_db_query(sprintf(
							"INSERT INTO payment_orders SET payment_id=%s, orders_id=%s, created=now()",
							$pID,$oID
						));
					}
					xtc_db_query("UPDATE incoming_payments SET confirmed=1 WHERE id='".$pID."'");
				}
			}else{
				die(TEXT_ERROR_ALLOCATE_MISSING_ELEMENTS);
			}

			// orders updaten
			if(is_array($_POST['oID'])){
				foreach($_POST['oID'] as $k => $orders_id ){
					$orders_id = (int)xtc_db_input($orders_id);
					$order = new order($orders_id);
					$auctions = $order->get_auction_array(true);
					if(defined('PAYMENT_CONFIRMATION_EMAIL_ACTIVE') and PAYMENT_CONFIRMATION_EMAIL_ACTIVE == 'true'){
						$mail_smarty = new yesSmarty;
						$mail_smarty->assign('language', $_SESSION['language']);
		
						$mail_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
						$mail_smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
						$adresse  = $order->delivery['name']."<br />";
						$adresse .= (!empty($order->delivery['company'])) ? $order->delivery['company']."<br />" : '';
						$adresse .= $order->delivery['street_address']."<br />";
						if($order->delivery['suburb'] != '')
							$adresse .= $order->delivery['suburb']."<br />";
						$adresse .= "<br />";
						$adresse .= $order->delivery['postcode'] . " " . $order->delivery['city'] . "<br />";
						$adresse .= $order->delivery['country']."<br />";
						$adresse_text = str_replace("<br />","\r\n",$adresse);
						
						$products_string = '';
						foreach ($order->products as $k=>$products) {
							$products_string .= $products['qty'] . " x " . $products['model'] . "- " . $products['name']."<br />\n";
						}
						$mail_smarty->assign('ADDRESS_TEXT',$adresse_text);
						$mail_smarty->assign('ADDRESS',$adresse);
						$mail_smarty->assign('PRODUCTS',$products_string);
						$mail_smarty->assign('NAME',$order->billing['name']);
						$mail_smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
						$mail_html = $mail_smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/payment_confirmation.html');
						$mail_txt = $mail_smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/payment_confirmation.txt');
						xtc_php_mail(EMAIL_BILLING_ADDRESS,
							EMAIL_BILLING_NAME,
							$order->customer['email_address'],
							$order->customer['name'],
							'',
							EMAIL_BILLING_REPLY_ADDRESS,
							EMAIL_BILLING_REPLY_ADDRESS_NAME,
							'',
							'',
							sprintf(PAYMENT_CONFIRMATION_EMAIL_SUBJECT,$orders_id),
							$mail_html,
							$mail_txt
						);
						$dbMail = new DBmail('0');
						$dbMail->save_mail(
							sprintf(PAYMENT_CONFIRMATION_EMAIL_SUBJECT,$order->info['id']),
							$order->customer['email_address'],
							EMAIL_BILLING_REPLY_ADDRESS_NAME,
							EMAIL_BILLING_REPLY_ADDRESS,
							$mail_html,
							date('Y-m-d H:i:s'), 
							$order->info['ebay_id'],
							$order->customer['ID'],
							$order->info['id']
						);
					}
					$payment_method_query = xtc_db_query(sprintf(
						"SELECT payment_method FROM orders WHERE orders_id='%s'",
						$order->info['id']
					));
					$payment_method = xtc_db_fetch_array($payment_method_query);
					if( $order->info['orders_status'] == ORDERS_STATUS_VERSENDET ){
					    $order->update_orders_status(ORDERS_STATUS_ABGESCHLOSSEN);
					    $order->add_history(ORDERS_STATUS_ABGESCHLOSSEN,false,TEXT_HISTORY_ALLOCATED_ORDER_AUTOMATIC);
					}else{
					    $order->update_orders_status(ORDERS_STATUS_BEZAHLT);
					    $order->add_history(ORDERS_STATUS_BEZAHLT,false,TEXT_HISTORY_ALLOCATED_ORDER_AUTOMATIC);
					}				
					
					$customer = new customer($order->customer['ID']);
					$customer->update_current_account_value();
				}
			}else{
				die(TEXT_ERROR_ALLOCATE_MISSING_ELEMENTS);
			}
			$messageStack->add_session(TEXT_MESSAGE_ALLOCATION_SUCCESS, 'success');
			xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS),  xtc_get_all_get_params(array('action')));
		}
		break;
	// im versandmodul muessen die order-details als lbOn geproggt werden
	case 'autofilter':
		$valid_orders_statuses = array(1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_VERSENDET,PAYPAL_ORDER_STATUS_SUCCESS_ID);
		$orders_status_where = sprintf(' and o.orders_status IN (%s)',
			implode(',',$valid_orders_statuses)
		);
		if(isset($_SESSION['payment_day_selected']) and !empty($_SESSION['payment_day_selected'])){
			$open_payments_query_raw = sprintf(
				"SELECT * FROM incoming_payments
					WHERE confirmed=0 and buchungstag='%s' ORDER BY sorting",
				xtc_db_input($_SESSION['payment_day_selected'])
			);
		}else{
			$open_payments_query_raw = "SELECT * FROM incoming_payments WHERE confirmed=0 ORDER BY sorting";
		}
		$open_payments_query = xtc_db_query($open_payments_query_raw);
		while($op = xtc_db_fetch_array($open_payments_query)){
			$oi = xtc_db_prepare_input($op);
			$vwz_text_raw = '';
			for($i=1;$i<20;$i++){
				if($oi['verwendungszweck'.$i] != '') {
					$vwz_text_raw .= $oi['verwendungszweck'.$i].' ';
				}
			}
			$vwz_text_raw .= $oi['name'].' ';

			// EBAYID CHECK
			$ebay_id_list = array();
			$ebay_id_replace = array(',','.',':','-','(',')','=',"'",'"','/','\\');
			$text_raw_ebay_id = str_replace($ebay_id_replace,' ',$vwz_text_raw);
			preg_match_all('([0-9]{10,20})',$text_raw_ebay_id,$ebay_id_list);
			if(is_array($ebay_id_list) and sizeOf($ebay_id_list)>0){
				foreach($ebay_id_list as $k=>$ebay_id_matches){
					foreach($ebay_id_matches as $ek=>$ebay_id){
						$ebay_id_check_query_raw = "SELECT o.orders_id FROM orders o WHERE o.ebay_id='".xtc_db_input($ebay_id)."' ".$orders_status_where;
						$ebay_id_check_query = xtc_db_query($ebay_id_check_query_raw);
						while($ebay_id_check = xtc_db_fetch_array($ebay_id_check_query)){
							$matched_orders[ $oi['id'] ][ $ebay_id_check['orders_id'] ]['ebay_id'] = $ebay_id;
						}
						$ebay_id_check_query_raw = "SELECT od.combined_orders_id FROM orders od WHERE od.combined_orders_id > 0 and od.ebay_id='".xtc_db_input($ebay_id)."' and od.orders_status='".ORDERS_STATUS_STORNIERT."' and od.combined_orders_id IN(SELECT o.orders_id FROM orders o WHERE od.orders_id != o.orders_id ".$orders_status_where.")";
						$ebay_id_check_query = xtc_db_query($ebay_id_check_query_raw);
						while($ebay_id_check = xtc_db_fetch_array($ebay_id_check_query)){
							$matched_orders[ $oi['id'] ][ $ebay_id_check['combined_orders_id'] ]['ebay_id'] = $ebay_id;
						}
					}
				}
			}

			// orders_id check
			$orders_id_list = array();
			$orders_id_replace = array(',','.',':','-','(',')','=',"'",'"','/','\\');
			$text_raw_orders_id = str_replace($orders_id_replace,' ',$vwz_text_raw);
			preg_match_all('([0-9]{1,9})',$text_raw_orders_id,$orders_id_list);

			if(is_array($orders_id_list) and sizeOf($orders_id_list)){
				foreach($orders_id_list as $k=>$orders_id_matches){
					foreach($orders_id_matches as $ok=>$orders_id){
                        if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
							$orders_id_check_query_raw = sprintf(
								"SELECT o.orders_id FROM orders o LEFT JOIN orders_fibunumbers ofb ON o.orders_id=ofb.orders_id WHERE (o.orders_id='%d' OR ofb.fibunumber='%d') %s",
									intval($orders_id),
									intval($orders_id),
									$orders_status_where
							);
                        }else{
							$orders_id_check_query_raw = sprintf(
								"SELECT o.orders_id FROM orders o WHERE orders_id='%d' %s",
								intval($orders_id),
								$orders_status_where
							);
                        }
						$orders_id_check_query = xtc_db_query($orders_id_check_query_raw);
						while($orders_id_check = xtc_db_fetch_array($orders_id_check_query)){
							$matched_orders[ $oi['id'] ][ $orders_id_check['orders_id'] ]['orders_id'] = $orders_id;
						}
					}
				}
			}

			// payment check
			$min = (float)$oi['betrag']/$tolerance;
			$max = (float)$oi['betrag']*$tolerance;
				$orders_id_check_query_raw = sprintf(
					"SELECT ot.orders_id FROM orders o LEFT JOIN orders_total ot USING(orders_id) WHERE ROUND(value,2)>=%s and ROUND(value,2)<=%s  and class='ot_total' %s",
					number_format($min,2,'.',''),
					number_format($max,2,'.',''),
					$orders_status_where
				);

			$orders_id_check_query = xtc_db_query($orders_id_check_query_raw);
			while($orders_id_check = xtc_db_fetch_array($orders_id_check_query)){
				$matched_orders[ $oi['id'] ][ $orders_id_check['orders_id'] ]['betrag'] = $oi['betrag'];
			}

			// ebayuser check
			$ebayuser_list = array();
			$ebayuser_replace = array(',','=',"'",'"','/','\\');
			$text_raw_ebayuser = str_replace($ebayuser_replace,' ',$vwz_text_raw);
			$ebayuser_list = explode(' ',$text_raw_ebayuser);
			if(is_array($ebayuser_list) and sizeOf($ebayuser_list)>0){
				foreach($ebayuser_list as $k=>$ebayuser){
					if(strlen(trim($ebayuser))>2){

						$ebayuser_check_query_raw = "SELECT orders_id FROM orders o LEFT JOIN customers c USING(customers_id) WHERE customers_ebay_userid='".xtc_db_input($ebayuser)."' ".$orders_status_where;
						$ebayuser_check_query = xtc_db_query($ebayuser_check_query_raw);
						while($ebayuser_check = xtc_db_fetch_array($ebayuser_check_query)){
							$matched_orders[ $oi['id'] ][ $ebayuser_check['orders_id'] ]['ebayuser']=$ebayuser;
						}
					}
				}
			}
                        
			// name check
			$name_list = array();
			$payment_transaction_id_list = array();
			$name_replace = array(',','=',"'",'"','/','\\');
			$text_raw_name = str_replace($name_replace,' ',$vwz_text_raw);
			$name_list = explode(' ',$text_raw_name);
			if(is_array($name_list) and sizeOf($name_list)>0){
				foreach($name_list as $k=>$name){
					if(strlen(trim($name))>2){
						$name_check_query_raw = "SELECT orders_id FROM orders o WHERE (customers_name LIKE '%".xtc_db_input($name)."%' or delivery_name LIKE '%".xtc_db_input($name)."%' or billing_name LIKE '%".xtc_db_input($name)."%' or customers_company LIKE '%".xtc_db_input($name)."%' or delivery_company LIKE '%".xtc_db_input($name)."%' or billing_company LIKE '%".xtc_db_input($name)."%') ".$orders_status_where;
						$name_check_query = xtc_db_query($name_check_query_raw);
						while($name_check = xtc_db_fetch_array($name_check_query)){
							$matched_orders[ $oi['id'] ][ $name_check['orders_id'] ]['name']=$name;
						}
						
						$ptid_check_query_raw =  "SELECT orders_id FROM orders o WHERE payment_transaction_id LIKE '%".xtc_db_input($name)."%' ".$orders_status_where;
						$ptid_check_query = xtc_db_query($ptid_check_query_raw);
						while($ptid_check = xtc_db_fetch_array($ptid_check_query)){
							$matched_orders[ $oi['id'] ][ $ptid_check['orders_id'] ]['payment_transaction_id'] = $name;
						}
						
					}
				}
			}
		}

		//echo $great_sql;

		$output = array();
		if(sizeOf($matched_orders) > 0){
			$ip_matches = array();
			foreach($matched_orders as $ipID => $iparray){
				foreach($iparray as $oID => $matches){
					/**
					 * WENN PAYMENT NICHT UEBEREINSTIMMT - ABBRUCH
					 */
					$match_betrag = false;
					$match_count = 0;
					foreach($matches as $match_key => $match_value){
						switch($match_key){
							case 'betrag':
								$match_betrag = true;
								break;
							default:
								$match_count++;
								break;
						}
					}
					if($match_count >= 2 and $match_betrag){
						$ip_matches[$ipID]++;
						$order = new order($oID);
						// match betrag ist ja vorher geprueft - also als matched setzen
						$match_betrag = _match_string(number_format($matches['betrag'],2,',','.'));
						$td_class_string = ' class="highlight"';
						$mOrder = ($matches['orders_id']) ? $td_class_string : '';
						$mEbayID = ($matches['ebay_id']) ? $td_class_string : '';
						$mEbayuser = ($matches['ebayuser']) ? $td_class_string : '';
						$mName = ($matches['name']) ? $td_class_string : '';
						$mTotal = ($matches['betrag']) ? $td_class_string : '';
						$match_name = ($matches['name'] and $order->billing['name'] != $matches['name']) ? $matches['name'] : '';
						$payment_transaction_id = ($matches['payment_transaction_id']) ? $matches['payment_transaction_id'] : '';
						$show_name = '';
						if($order->billing['company'] != '') $show_name = $order->billing['company'].', ';
						$show_name .= $order->billing['name'];
						$output[] = array(
							'ipID'=>$ipID,
							'mOrder'=>$mOrder,
							'mEbayID'=>$mEbayID,
							'mEbayuser'=>$mEbayuser,
							'mName'=>$mName,
							'mTotal'=>$mTotal,
							'oID'=>$oID,
							'ebay_id'=>implode(', ',$order->get_auction_array()),
							'ebayuser'=>$order->info['ebay_userid'],
							'name'=>$show_name._match_string($match_name),
							'betrag'=>$total.$match_betrag,
							'payment_transaction_id'=>$payment_transaction_id
						);
					}
				}
			}
		}
?>
	<div class="main">
	<p class="main"><?php echo sprintf(TEXT_AUTOFILTER_COMPLETED,$_SESSION['payment_day_selected'],sizeOf($output));?></p>
	<form name="autofilter_allocation" action="<?php echo xtc_href_link('incoming_payments.php','action=autofilter_allocation');?>" method="post" onsubmit="return check_allocations()">
	<table class="yesListTable" width="100%">
	<thead>
	<tr>
		<th>&nbsp;</th>
		<th><?php echo TABLE_HEADING_ORDERS_ID; ?></th>
		<th><?php echo TABLE_HEADING_EBAY_ID; ?></th>
		<th><?php echo TABLE_HEADING_VWZ; ?></th>
		<th><?php echo TABLE_HEADING_NAME; ?></th>
		<th align="right"><?php echo TABLE_HEADING_AMOUNT; ?></th>
	</tr>
	</thead>
	<tfoot>
	<tr>
		<th scope="col" colspan="6" align="center"><input type="submit" value="<?php echo IMAGE_SAVE; ?>" class="ui-button ui-corner-all ui-state-default" /></th>
	</tr>
	</tfoot>
	<tbody>

<?php
	for($i=0;$i<sizeOf($output);$i++){
?>

	<tr<?php if( $i%2 == 0 ){ echo ' class="odd"'; } ?>>
		<td <?php echo $output[$i]['mOrder']; ?>><?php
		if($ip_matches[ $output[$i]['ipID'] ] == 1){
			echo xtc_draw_checkbox_field('alloc[]',sprintf('%s-%s',$output[$i]['oID'],$output[$i]['ipID']),true);
		}else{
			echo xtc_image('images/icons/error.gif',TEXT_AUTOMATIC_DOUBLE_MATCHES);
		}
		?></td>
		<td <?php echo $output[$i]['mOrder']; ?>><a href="<?php echo xtc_href_link('orders.php','action=edit&oID='.$output[$i]['oID']); ?>" target="_blank" title="<?php echo TEXT_ORDER_SHORT.': '.$output[$i]['oID'] ?>"><u><?php echo $output[$i]['oID'] ?></u></a></td>
		<td <?php echo $output[$i]['mEbayID']; ?>><?php echo $output[$i]['ebay_id']; ?>&nbsp;</td>
		<td><?php
			$query = xtc_db_query(sprintf(
				"SELECT * FROM incoming_payments WHERE id='%s'",
				$output[$i]['ipID']
			));
			$record = xtc_db_fetch_array($query);
			for( $vwz = 1; $vwz<20; $vwz++ ){
				if( trim( $record['verwendungszweck'.$vwz] ) !=''  ) {
					echo $record['verwendungszweck'.$vwz]."<br />\n";
				}
			}
			if($record['name'] != ''){
				printf('<br /><i>%s %s</i>',TEXT_NOTICE,$record['name']);
			}
		?>
		</td>
		<td <?php echo $output[$i]['mName']; ?>><?php echo $output[$i]['name']; ?>
			<?php if( $output[$i]['ebayuser'] ){ ?>
			<?php echo '<br />'.TEXT_EBAYUSER.': '.$output[$i]['ebayuser']; ?>
			<?php } ?>
			<?php if( $output[$i]['payment_transaction_id'] ){ ?>
			<?php echo '<br />Payment Transaktion: '.$output[$i]['payment_transaction_id']; ?>
			<?php } ?>
		</td>
		<td <?php echo $output[$i]['mTotal']; ?> align="right"><nobr><?php echo $output[$i]['betrag']; ?></nobr></td>
	</tr>

<?php
	}
?>

	</tbody>
	</table>
	</form>

	<p class="smallText"><?php echo TEXT_INTRO_AUTOFILTER1; ?></p>
	<p class="smallText"><?php echo TEXT_INTRO_AUTOFILTER2; ?></p>
	<p class="smallText"><?php echo TEXT_INTRO_AUTOFILTER3; ?></p>

	</div>

<?php
		exit;
		break;
}

if(isset($_GET['import']) and $_GET['import'] == '1'){

	$probe = $_FILES['probe']['tmp_name'];
	if (isset($probe)){

		// Bugfix f�r: http://www.securityfocus.com/archive/1/80106
		if ( isset($_COOKIE["probe"]) || isset($_POST["probe"]) || isset($_GET["probe"]) ) die("Aus Sicherheitsgruenden stirbt das Script jetzt.");
                $sorting_query = xtc_db_query(
                        "SELECT MAX(sorting) as maxsort FROM incoming_payments"
                );
                $sorting = xtc_db_fetch_array($sorting_query);
                $maxsort = $sorting['maxsort']+1;
		if($_POST['bankingtype'] == 'postbank_xml_2016'){
		    if(copy($probe, DIR_FS_ADMIN.'postbank/pb.xml')) {
			$dom = simplexml_load_file(DIR_FS_ADMIN.'postbank/pb.xml');
			$array = array();
			foreach($dom->BkToCstmrAcctRpt->Rpt->Ntry as $Ntry){
			    if($Ntry->CdtDbtInd != 'CRDT')
				continue;
			    $detail = $Ntry->NtryDtls->TxDtls;
			    $name = '';
			    $vwz = array();
			    if(isset($detail->RmtInf)){
				foreach($detail->RmtInf->Ustrd as $ik=>$info){
				    if(!empty($info) and $info != 'Verwendungszweck' and $info != 'Referenz NOTPROVIDED'){
					if($ik == 0){
					    $vwz[] = $info;
					    // vwz2 ist der name (warumauchimmer)
					    if(isset($detail->RltdPties->Dbtr->Nm) and $detail->RltdPties->Dbtr->Nm != ''){
						$vwz[] = $detail->RltdPties->Dbtr->Nm;
					    }
					}
				    }
				}
			    }
			    if(!sizeOf($vwz)){
				    if(isset($detail->RltdPties->Dbtr->Nm) and $detail->RltdPties->Dbtr->Nm != ''){
					$vwz[] = $detail->RltdPties->Dbtr->Nm;
				    }
			    }
			    foreach($vwz as $vwk=>$vwv){
				$vwz[ $vwk ] = yes_decode_string($vwv);
			    }
			    $array[] = array(
				'datum_date'=>$Ntry->BookgDt->Dt,
				'datum'=>date("d.m.Y", strtotime($Ntry->BookgDt->Dt)),
				'vwz'=>$vwz,
				'betrag'=>(float)$Ntry->Amt,
				'waehrung'=>(string)$Ntry->Amt['Ccy']
			    );
			}
			$doubles = 0;
			foreach($array as $entry){
			    $vwz_where = '';
			    $j = 0;
			    foreach($entry['vwz'] as $zaehler=>$vwz){
				if(strlen(trim($vwz))>=2 and $zaehler < 19){
                                    $vwz = str_replace("'",' ',$vwz);
					$vwz_where .= "verwendungszweck".($j+1)."='".xtc_db_input($vwz)."'  AND ";
					$j++;
				}
			    }
			    $double_query_raw = sprintf(
				"SELECT * FROM incoming_payments WHERE FORMAT(betrag,2) = FORMAT('%s',2) AND waehrung='%s' AND buchungstag='%s' AND %s confirmed='0'",
				str_replace(',','.',$entry['betrag']),$entry['waehrung'],$entry['datum'],
				$vwz_where
			    );
			    $double_query = xtc_db_query($double_query_raw);
			    if(!xtc_db_num_rows($double_query)){
				$j = 0;
				$vwz_insert = '';
				foreach($entry['vwz'] as $vwz){
				    if(strlen(trim($vwz))>=2 and $j < 19){
					$vwz_insert .= "verwendungszweck".($j+1)."='".str_replace("'",' ',$vwz)."',";
					$j++;
				    }
				}
				$query = sprintf("INSERT INTO incoming_payments SET betrag='%F',waehrung='%s',buchungstag='%s',buchungstag_date='%s', %s confirmed=0,sorting=%s",
				    $entry['betrag'],$entry['waehrung'],
				    $entry['datum'],$entry['datum_date'],
				    $vwz_insert,
                                    $maxsort
				);
				xtc_db_query($query);
                                $maxsort++;
			    }else{
				$doubles++;
			    }
			} // foreach
			unlink(DIR_FS_ADMIN.'postbank/pb.xml');
			if($doubles>0){
			    $messageStack->add_session(sprintf(TEXT_MESSAGE_PAYMENTFILE_ENTRY_EXISTS,$doubles), 'error');
			}
			$messageStack->add_session(TEXT_MESSAGE_PAYMENTFILE_SAVED, 'success');
		    }else{
                        die('WHAT?!');
			$messageStack->add_session(TEXT_MESSAGE_PAYMENTFILE_ERROR, 'error');
		    }
		    xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS));
		}else{
			// neues handling
			$ip = new incoming_payments($_POST['bankingtype']);
			if($ip->process($probe))
				$messageStack->add_session($ip->message_string, 'success');
			else
				$messageStack->add_session(TEXT_MESSAGE_PAYMENTFILE_ERROR, 'error');
			xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS));
		}
	}
}

if(isset($_GET['delpayID']) and is_array($_GET['delpayID'])){
	$msg = '';
	foreach($_GET['delpayID'] as $k=>$payID){
		if( $PAY->delete_payment($payID) )
			$msg .= '('.$payID.') ';
		else
			$msg .= '[! '.$payID.'] ';
	}
	$messageStack->add_session(TEXT_MESSAGE_PAYMENTS_DELETE." ".$msg, 'success');
	xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS));
}


if(isset($_GET['filter']) and $_GET['filter']=='1'){
	$PAY->set_payment_tolerance(1.1); // 10% abweichung bei zahlung
	$filters = $PAY->filter();
        $messageStack->add_session(sprintf(TEXT_MESSAGE_PAYMENTS_ALLOCATED,$filters), 'success');
        xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS));
}

if(isset($_GET['save_allocate']) and $_GET['save_allocate'] == '1'){
	if(!empty($_POST['template_title']) && !empty($_POST['template_zweck1']) && !empty($_POST['template_zweck2']) && !empty($_POST['template_name']) && !empty($_POST['template_betrag'])){

		$title = xtc_db_prepare_input($_POST['template_title']);
		$zweck1 = xtc_db_prepare_input($_POST['template_zweck1']);
		$zweck2 = xtc_db_prepare_input($_POST['template_zweck2']);
		$name = xtc_db_prepare_input($_POST['template_name']);
		$betrag = xtc_db_prepare_input($_POST['template_betrag']);
		$insert_id = $PAY->save_csv_template($title,$zweck1,$zweck2,$name,$betrag);

		if( $PAY->get_active_template() < 1 ){
			$PAY->save_active_template($insert_id);
		}
	}else{

		$messageStack->add_session(TEXT_MESSAGE_ALLOCATION_ERROR, 'error');
		xtc_redirect(xtc_href_link(FILENAME_INCOMING_PAYMENTS,'allocate=1'));
	}

}

if (isset($_GET['action']) and $_GET['action'] == 'showorder' && (int)$_GET['oID'] > 0){
	require('incoming_payments_showorder.php');
}


if(isset($_POST['payment_day_selected']) and $_POST['payment_day_selected'] != ''){
	$datum = explode('-',$_POST['payment_day_selected']);
	$neudatum = $datum[2].'.'.$datum[1].'.'.$datum[0];
	$_SESSION['payment_day_selected'] = $neudatum;
	$_SESSION['payment_day_all'] = '';
}

if(isset($_GET['view'])){
	switch($_GET['view']){
		case 'orders':
			require('incoming_payments_ordersview.php');
			break;
		case 'notizen':
			require('incoming_payments_notizen.php');
			break;
		case 'bank':
			require('incoming_payments_bankview.php');
			break;
		case 'filterview':
			require('incoming_payments_filterview.php');
			break;
		case 'select_date':
			$open_query = xtc_db_query("SELECT COUNT(id) as anz, buchungstag FROM incoming_payments WHERE confirmed='0' GROUP BY buchungstag ORDER BY sorting DESC");
			$sort = array();
			$open_days = array();
			while($open = xtc_db_fetch_array($open_query)){
				$datum = explode('.',$open['buchungstag']);
				$neudatum = $datum[2].'-'.$datum[1].'-'.$datum[0];
				$open_days[] = array('id'=>$neudatum,'text'=>$neudatum.' ('.$open['anz'].')');
			}
			sort($open_days);
			$open_days = array_reverse($open_days);
			$select_array = array('id'=>'','text'=>TEXT_SELECT);
			array_unshift($open_days,$select_array);
			echo xtc_draw_form('setdate','incoming_payments.php','action=set_date');
			printf('<b>%s:</b> ', TEXT_DAY);
			$default = ( isset($_SESSION['payment_day_selected']) && xtc_not_null($_SESSION['payment_day_selected']) ) ? $_SESSION['payment_day_selected'] : '';
			if($default != ''){
				$default = implode('-',array_reverse(explode('.',$_SESSION['payment_day_selected'])));
			}
			echo xtc_draw_pull_down_menu('payment_day_selected',$open_days,$default,'onchange="check_setdate(this);" class="ui-button ui-corner-all ui-state-default"');
			echo '</form>';
			exit;
			break;
	}
}
if(isset($_REQUEST['old'])){
?>
<!DOCTYPE html>
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $_SESSION['language_charset']
; ?>">
<title><?php echo TITLE; ?></title>
<!-- header //-->
<?php
    require(DIR_WS_INCLUDES . 'header.php'); 
}else{
    yes_draw_pre_header();
    yes_draw_header(TITLE);
}
$buttons = array();
$smarty->assign(array(
    'HEADING_TITLE'=>PAGE_HEADING,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->display('incoming_payments.html');
?>
<!-- header_eof //-->

<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript">
<!--
var ONLOADFUNC = '';
$(document).ready(function(){
	$("#preloader").hide(); 
	$('#zahlungen').load('incoming_payments.php?view=bank');
	$('#bestellungen').load('incoming_payments.php?view=orders');

	<?php if(isset($_SESSION['payment_day_selected']) and $_SESSION['payment_day_selected'] == 'all'){ ?>

	$('#'+element.id).removeClass("ui-state-default");
	$('#'+element.id).addClass("ui-state-active");

	<?php } ?>


	$('#payment_action_select').change(function(){
		selected_payments = checkbox_get_checked(document.forms['paymentform'],'payment_id[]');
		if(selected_payments.length < 1)
			return false;
		switch($('#payment_action_select').val()){
			case 'delete':
				yes = confirm('<?php echo JS_MESSAGE_DELETE_PAYMENTS; ?>');
				if(yes){
					params = 'delpayID[]=';
					params += selected_payments.join('&delpayID[]=');
					window.location.href='incoming_payments.php?action=delete&'+params;
				}
			break;
		}
		$(this).val(0);
	});

	$('#search_button').click(function(){
		sv = document.forms['search'].elements['searchword'].value;
		if( !sv || sv.length < 1 )
			return false;
		showPreloader();
		$.ajax({
			type: "POST",
			url: $('#search_form').attr('action'),
			data: $('#search_form').serialize(),
			success: function(result){
				$('#bestellungen').html(result);
				hidePreloader();
			}
		});
	});

	$('#allocate_payment_button').click(function(){
		if(!document.forms['paymentform']){
			alert('<?php echo JS_ERROR_SELECT_ALLOCATION_PAYMENTS; ?>');
			return false;
		}
		selected_payments = checkbox_get_checked(document.forms['paymentform'],'payment_id[]');
		if(selected_payments.length < 1){
			alert('<?php echo JS_ERROR_SELECT_ALLOCATION_PAYMENTS; ?>');
			return false;
		}
		if(!document.forms['orders']){
			alert('<?php echo JS_ERROR_SELECT_ALLOCATION_ORDERS; ?>');
			return false;
		}
		orders_id_array = document.forms['orders'].elements['orders_id'];
		orders_id = false;
		var radioLength = orders_id_array.length;
		if(radioLength == undefined){
			if(orders_id_array.checked)
				orders_id = orders_id_array.value;
		}else{
			for(var i = 0; i < radioLength; i++) {
				if(orders_id_array[i].checked == true) {
					orders_id = orders_id_array[i].value;
				}
			}
		}
		if(!orders_id){
			alert('<?php echo JS_ERROR_SELECT_ALLOCATION_ORDERS; ?>');
			return false;
		}

		params = "?action=allocate";
		change_status = (document.forms['t'].change_status.checked == false) ? 0 : 1;
		params = params + '&change_order='+change_status;
		params = params + '&orders_id='+orders_id;
		params += '&payment_id[]=';
		params += selected_payments.join('&payment_id[]=');
                window.location.href='incoming_payments.php'+params;
	});
});

function check_setdate(selector){
	if(selector.value != ''){
		selector.form.submit();
	}
}

function check_allocations(){ // AUTOFILTER SUBMIT
	selected_payments = checkbox_get_checked(document.forms['autofilter_allocation'],'alloc[]');
	if(selected_payments.length < 1)
		return false;
}
var show_all_payments = false; // wird negiert beim ersten autom. aufruf
function refresh_zahlungen(element){
	showPreloader();
	var url = '<?php echo xtc_href_link('incoming_payments.php',xtc_get_all_get_params(array('buchungstag','all','view')).'view=bank'); ?>';
	if(!show_all_payments){
		url += '&all=on';
		$('#'+element.id).removeClass("ui-state-default");
		$('#'+element.id).addClass("ui-state-active");
		show_all_payments = true;
	}else{
		$('#'+element.id).removeClass("ui-state-active");
		$('#'+element.id).addClass("ui-state-default");
		show_all_payments = false;
	}
	$('#zahlungen').load(url,{},hidePreloader);
}
function refresh_bestellungen(url){
	showPreloader();
	$('#bestellungen').load(url,{},hidePreloader);
}
//-->
</script>

<div id="dialog_container_main" style="overflow:auto;"></div>
<div id="dialog_container_bankview" style="display:none;overflow: auto;height:500px;width:100%;"></div>

<table border="0" width="100%" cellspacing="0" cellpadding="0">
<tr valign="top">
      	<td class="main">
		<br />
		<a title="<?php echo TEXT_CHOOSE_A_DAY; ?>" class="lbOn ui-button-text-only ui-widget ui-state-default ui-corner-all" id="<?php echo xtc_href_link('incoming_payments.php',xtc_get_all_get_params(array('view','action')).'view=select_date'); ?>" href="javascript:;" style="text-decoration:none;"><span class="ui-button-icon-primary ui-icon ui-icon-newwin"></span><?php echo TEXT_CHOOSE_A_DAY; ?></a>

		<a onclick="refresh_zahlungen(this);" id="show_all_button" class="lbOn_nofunc ui-button-text-only ui-widget ui-state-default ui-corner-all" href="javascript:;"><?php echo TEXT_LINK_SHOW_ALL; ?></a>

		<?php if(isset($_SESSION['payment_day_selected']) and $_SESSION['payment_day_selected'] != 'all'){ ?>

		<a title="<?php echo TEXT_LINK_ALLOCATE_AUTOMATIC; ?>" id="<?php echo xtc_href_link('incoming_payments.php',xtc_get_all_get_params(array('action','buchungstag')).'action=autofilter&buchungstag='.$_GET['buchungstag']); ?>" class="lbOn bigWidth ui-button-text-only ui-widget ui-state-default ui-corner-all" href="javascript:;"><span class="ui-button-icon-primary ui-icon ui-icon-newwin"></span><?php echo TEXT_LINK_ALLOCATE_AUTOMATIC; ?></a>

		<?php } ?>

		<a href="#upload_anchor" title="<?php echo BUTTON_IMPORT; ?>"  class="lbOn_nofunc ui-button-text-only ui-widget ui-state-default ui-corner-all"><span class="ui-button-icon-primary ui-icon ui-icon-circle-arrow-e"></span><?php echo BUTTON_IMPORT; ?></a>
		
		<br /><br />
		<div id="zahlungen_title" style="width:1000px;margin-bottom:10px;" class="main"></div>
		<div id="zahlungen" style="width:1000px;height:480px;overflow: auto;" class="ui-widget-content"></div>
		<br clear="all" />
		<button onclick="checkbox_check('paymentform','payment_id[]',true);" class="ui-state-default ui-corner-all" type="button"><?php echo TEXT_SELECT_ALL; ?></button>
		<button onclick="checkbox_check('paymentform','payment_id[]',false);" class="ui-state-default ui-corner-all" type="button"><?php echo TEXT_UNSELECT_ALL; ?></button>
		<select id="payment_action_select">
		<option value=""><?php echo TEXT_SELECT; ?></option>
		<option value="delete"><?php echo IMAGE_DELETE; ?></option>
		</select>
		<br clear="all" /><br />
		<?php echo xtc_draw_separator('pixel_black.gif',1000); ?>
		<br /><br />
<?php
echo xtc_draw_form('search','incoming_payments.php',xtc_get_all_get_params(array('view')).'view=orders','POST','id="search_form" onsubmit="return false;"');
echo xtc_draw_hidden_field('view_orders','1');
?>
		<b><?php echo TEXT_SEARCH_IN_ORDERS; ?></b><br />
		<table border="0"  width="1000" class="yesListTable_minimal">
                        <tr>
                            <td>
		<?php
                            echo xtc_draw_input_field('searchword',((isset($_POST['searchword']))?$_POST['searchword']:''));
                            echo xtc_draw_input_field('submitter',IMAGE_SEARCH,'id="search_button"','','button');
		?>
                            </td>
                            <td>
		<?php
                            echo xtc_draw_checkbox_field('search_ebayuser','1',((isset($_POST['search_ebayuser']) and $_POST['search_ebayuser']==1)?true:false));
		?> eBay Username
                            </td>
                            <td>
		<?php
                            echo xtc_draw_checkbox_field('search_orderid','1',((isset($_POST['search_orderid']) and $_POST['search_orderid']==1)?true:false));
                            echo TEXT_FILTER_ORDERS_ID_FIBUNUMBER; ?>
                            </td>
                            <td>
		<?php
                            echo xtc_draw_checkbox_field('search_ebayid','1',(((isset($_POST['search_ebayid']) and $_POST['search_ebayid']==1) or !isset($_POST['submitted']))?true:false));
                            echo TEXT_EBAY_USERID;
		?>
                            </td>
                            <td>
		<?php
                            echo xtc_draw_checkbox_field('search_name','1',(((isset($_POST['search_name']) and $_POST['search_name']==1) or !isset($_POST['submitted']))?true:false));
                            echo TEXT_FILTER_CUSTOMERNAME;
		?>
                            </td>
                            <td>
		<?php
                            echo xtc_draw_checkbox_field('search_plz','1',((isset($_POST['search_plz']) and $_POST['search_plz']==1)?true:false));
                            echo str_replace(':','',ENTRY_POST_CODE);
		?>
                            </td>
                            <td>
		<?php
                            echo xtc_draw_checkbox_field('search_city','1',((isset($_POST['search_city']) and $_POST['search_city']==1)?true:false));
                            echo str_replace(':','',ENTRY_CITY);
		?>
                            </td>
                        </tr>
		</table>
<?php
echo "</form>";
?>
		<div id="bestellungen" style="width:1000px;height:500px;overflow: auto;" class="ui-widget-content"></div>






		<form action="<?php echo FILENAME_INCOMING_PAYMENTS; ?>" name="t">
		<input type="button" value="<?php echo TEXT_BUTTON_ALLOCATE; ?>" id="allocate_payment_button" class="ui-button ui-corner-all ui-state-default" />
		&nbsp; <span style="background-color:#00FF00;color=#000000;font-size:11px;"><?php echo xtc_draw_checkbox_field('change_status','1',((PAYMENTFILTER_ALLOCATE_CHECKED == '1') ? true : false )); ?>&nbsp;<?php echo TEXT_SET_ORDER_BEZAHLT; ?> &nbsp;</span>
		</form>
	</td>
      </tr>
      <tr>
	<td class="main">
<?php
	if(isset($_GET['allocate']) and $_GET['allocate'] == '1'){
?>
<br />
<br />
<hr noshade="noshade" />
<p><font size="2"><b><?php echo TEXT_PAYMENT_MASK; ?></b></font></p>
<p><?php echo TEXT_PAYMENT_MASK_INTRO; ?></p>
<br />
<?php
echo xtc_draw_form('allocate', FILENAME_INCOMING_PAYMENTS,'save_allocate=1');
?>
<table class="yesListTable_minimal">
	<thead>
		<tr>
			<th>Name</th>
			<th><?php echo TABLE_HEADING_VWZ; ?> 1</th>
			<th><?php echo TABLE_HEADING_VWZ; ?> 2</th>
			<th><?php echo TABLE_HEADING_PRICE; ?></th>
		</tr>
	</thead>
<?php
	$select = [];
	$CSV = new CSVfile(DIR_FS_ADMIN.'starmoney/temp.csv');
	$CSV->open('r');
	while($row = $CSV->readRow()) {
		$data[] = $row;
	}
	$CSV->close();
	if(is_countable($data[0])) {
		foreach($data[0] as $k=>$v){
			$select[] = array('id'=>$k,'text'=>$v);
		}
	}
?>
	<tbody>
		<tr>
			<td><?php echo xtc_draw_pull_down_menu('template_name',$select,'',0); ?></td>
			<td><?php echo xtc_draw_pull_down_menu('template_zweck1',$select,'',0); ?></td>
			<td><?php echo xtc_draw_pull_down_menu('template_zweck2',$select,'',0); ?></td>
		</tr>
	</tbody>
	<tfoot>
		<tr>
			<th colspan="2"><?php echo TEXT_ASK_FOR_ALLOCATION_NAME; ?> &nbsp;  &nbsp; <input type="text" name="template_title" size="16" maxlength="64" /></th>
			<th colspan="2" align="right"><input type="submit" value="<?php echo IMAGE_SAVE_ALLOCATION; ?>" />
			</th>
	</tr>
	</tfoot>
</table>
</form>

<?php
	}
?>
								<br /><hr noshade="noshade" /><br />
								<p><b><?php echo TEXT_IMPORT_INTRO; ?></b></p>
								<form action="<?php echo FILENAME_INCOMING_PAYMENTS; ?>?import=1" method="post" enctype="multipart/form-data">
									<input type="file" name="probe" />
									<input type="submit" value="<?php echo TEXT_BUTTON_IMPORT; ?>" class="ui-button ui-corner-all ui-state-default" />
									<?php
									$path = DIR_FS_ADMIN.DIR_WS_INCLUDES;
									
									$banking_array = array(
										array('id'=>'starmoney','text'=>'Starmoney Export'),
										array('id'=>'postbank_xml_2016','text'=>'Postbank XML'),
									);
									if ($handle = opendir($path)) {
										/* Das ist der korrekte Weg, ein Verzeichnis zu durchlaufen. */
										while (false !== ($file = readdir($handle))) {
											if(strstr($file,'ip_') and strstr($file,'.conf')){
												$ip_module = str_replace('.conf','',$file);
												$ip_module = str_replace('ip_','',$ip_module);
												$ip = new incoming_payments($ip_module);
												$banking_array[] = array('id'=>$ip_module,'text'=>$ip->conf['title']);
											}
										}

										closedir($handle);
									}

									echo xtc_draw_pull_down_menu( 'bankingtype', $banking_array, BANKINGDEFAULT );
									?>
								</form>
								<hr noshade="noshade" />
								<br /><br /><br />
								<a name="upload_anchor"></a>
							</td>
				  		</tr>
				  		</table>
					</td>
            </tr>
		    </table>
		    </td>
		  </tr>
    </table>
		    </td>
		  </tr>
    </table>

<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
