<?php
include('includes/application_top.php');
include('includes/classes/class.csv.php');

// initiate template engine for mail
$smarty = new yesSmarty;
$buttons = array();

$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE  ,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));

$save_file = \main::get_importdata_path().'paypal.csv';
$parse_cols = array('Datum','Name','Brutto','Geb�hr','Netto','Von E-Mail-Adresse','Transaktionscode','Verwendungszweck','Artikelnummer','K�ufer-ID','Adresszeile 1','Adresszeile 2/Bezirk','Stadt','PLZ','Land');
$action = isset($_GET['action']) ? $_GET['action'] : '';
switch($action){
	case 'save_payments':
		$CSV = new csvfile($save_file);
		$CSV->delimiter = "\t";
		$CSV->open('r');
		$counter = 0;
		$valid_cols = array();
		$mail_col = 0; // emailadresse = eindeutiger key

		$sorting_query = xtc_db_query("SELECT sorting FROM incoming_payments order by sorting DESC limit 1");
		$sorting_res = xtc_db_fetch_array($sorting_query);
		$sorting = ($sorting_res['sorting']+1);

		$saved = 0;

		while($row = $CSV->readRow()){
			if($counter == 0){
				foreach($row as $k=>$v){
					$v = trim($v);
					if(in_array($v,$parse_cols)){
						$valid_cols[] = $k;
						if($v == 'Von E-Mail-Adresse'){
							$mail_col = $k;
						}
					}
				}
			}else{
				if( $row[$mail_col] != '' ){ // NUR DATENSAETZE MIT EMAILADRESSE
					$new_row = array();
					foreach($row as $k=>$v){
						if(in_array($k,$valid_cols)){
							$charset = mb_detect_encoding($v);
							if($charset == 'UTF-8'){
								$v = yes_decode_string($v);
							}
							$new_row[] = $v;
						}
					}		
				}

				if( (float)str_replace(',','.',str_replace('.','',$new_row[2])) > 0 ){ // nur zahlungseingaenge
					$check_query = xtc_db_query("SELECT id FROM incoming_payments WHERE betrag='".xtc_db_input(str_replace(',','.',str_replace('.','',$new_row[2])))."' and buchungstag='".xtc_db_input($new_row[0])."' and verwendungszweck2='".xtc_db_input($new_row[1].' '.$new_row[8].' '.$new_row[9])."' and verwendungszweck1 = '".xtc_db_input($new_row[10].' '.$new_row[11].' '.$new_row[12].' '.$new_row[13])."' and verwendungszweck3='".xtc_db_input('TACode: '.$new_row[6].' '.$new_row[7])."'");
					if(!xtc_db_num_rows($check_query)){
						$insert_sql_array = array(
							'betrag'=>str_replace(',','.',str_replace('.','',$new_row[2])),
							'waehrung'=>DEFAULT_CURRENCY,
							'buchungstag'=>$new_row[0],
							'bankleitzahl'=>'',
							'kontonummer'=>'',
							'verwendungszweck2'=>$new_row[1].' '.$new_row[8].' '.$new_row[9],
							'verwendungszweck1'=>$new_row[10].' '.$new_row[11].' '.$new_row[12].' '.$new_row[13],
							'verwendungszweck3'=>'TACode: '.$new_row[6].' '.$new_row[7],
							'confirmed'=>0,
							'sorting'=>$sorting
						);
						$sorting++;
						xtc_db_perform('incoming_payments',$insert_sql_array);
						$saved++;
					}
				}
			}
			$counter++;
		}
		$CSV->close();
		unlink($save_file);
		$messageStack->add_session($saved.' Paypal-Import-Datens&auml;tze wurden als Zahlungseing&auml;nge gespeichert.','success');
		xtc_redirect(xtc_href_link('incoming_payments.php'));
		break;
	case 'import_process':
		if($_FILES and isset($_FILES['importfile']['tmp_name'])){
			// Bugfix f�r: http://www.securityfocus.com/archive/1/80106
			if ( isset($_COOKIE["probe"]) || isset($_POST["probe"]) || isset($_GET["probe"]) ) die("Aus Sicherheitsgr�nden stirbt das Script jetzt.");
			if(copy($_FILES['importfile']['tmp_name'], $save_file)) {
				$messageStack->add_session('Paypal-Datei wurde erfolgreich importiert.','success');
				xtc_redirect(xtc_href_link('incoming_payments_paypal.php','action=view'));
			}else{
				$messageStack->add_session('Kann Datei nicht schreiben.','error');
				xtc_redirect(xtc_href_link('incoming_payments_paypal.php'));
			}
		}else{
			$messageStack->add_session('Keine Datei &uuml;bergeben.','error');
			xtc_redirect(xtc_href_link('incoming_payments_paypal.php'));
		}
		exit;
		break;
	case 'view':
		$smarty->assign('action','view');
		$CSV = new csvfile($save_file);
		$CSV->delimiter = "\t";
		$CSV->open('r');
		$rows = array();
		$header = array();
		$counter = 0;
		$valid_cols = array();
		$mail_col = 0; // emailadresse = eindeutiger key
		while($row = $CSV->readRow()){
			if($counter == 0){
				foreach($row as $k=>$v){
					$v = trim($v);
					if(in_array($v,$parse_cols)){
						$header[] = array('name'=>$v);
						$valid_cols[] = $k;
						if($v == 'Von E-Mail-Adresse'){
							$mail_col = $k;
						}
					}
				}
			}else{
				$new_row = array();
				if( $row[$mail_col] != '' ){ // NUR DATENSAETZE MIT EMAILADRESSE
					foreach($row as $k=>$v){
						if(in_array($k,$valid_cols)){
							$charset = mb_detect_encoding($v);
							if($charset == 'UTF-8'){
								$v = yes_decode_string($v);
							}
							$new_row[] = $v;
						}
					}		
					$rows[] = $new_row;
				}
			}
			$counter++;
		}
		$CSV->close();
		$smarty->assign('rows',$rows);
		$smarty->assign('header',$header);
		$smarty->assign('SAVE_AS_PAYMENT_LINK',xtc_href_link('incoming_payments_paypal.php','action=save_payments'));
		$smarty->assign('CANCEL_LINK',xtc_href_link('incoming_payments_paypal.php'));
		$html = $smarty->fetch('incoming_payments_paypal.html');
		break;
	default:
		$smarty->assign('action','import');
		$smarty->assign('FORM',xtc_draw_form('import','incoming_payments_paypal.php','action=import_process','POST','enctype="multipart/form-data"'));
		$html = $smarty->fetch('incoming_payments_paypal.html');
		break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
echo $html;
?>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>

