function selectall(formname,elementname,mymodus) {
	el = document.forms[""+formname].length;
	for(i = 0; i<el; i++) {
		if(document.forms[""+formname].elements[i].name == elementname)
			document.forms[formname].elements[i].checked = mymodus;
	}
}

/**
 * versieht ein DOM element (img) mit onclick bei dem das Bild im #modal_window
 * angezeigt wird
 * @param {img DOM element} el
 */
function jq_img_click_preview(el){
    $(el).css('cursor','pointer');
    $(el).click(function(){
	uri = $(el).attr('src');
	uriParts = uri.split("/");
	$('#modal_window').dialog({
	    modal: true,
	    resizable: false,
	    draggable: true,
	    width: 'auto',
	    title: uriParts[uriParts.length - 1],
	       close: function(){
		    $('#modal_window').dialog('destroy');
	       }
	}).html('<img src="'+uri+'" />');
    });
}

function lightenColor(color, percent) {
  const num = parseInt(color.slice(1),16),
        amt = Math.round(2.55 * percent),
        R = (num >> 16) + amt,
        G = (num >> 8 & 0x00FF) + amt,
        B = (num & 0x0000FF) + amt;
  return "#" + (
    0x1000000 +
    (R<255?R<1?0:R:255)*0x10000 +
    (G<255?G<1?0:G:255)*0x100 +
    (B<255?B<1?0:B:255)
  ).toString(16).slice(1);
}

$(function(){
    $.extend($.ui.dialog.prototype.options, {
        dialogClass: ''
    });
    $('table.yesListTable_minimal tbody, table.yesListTable tbody').addClass('ui-widget-content');

    $('table.yesListTable_minimal tbody tr,table.yesListTable tbody tr').hover(function(){
        if($(this).data('activerow') != 1){
            $(this).addClass('ui-state-active');
        }
    },function(){
        if(parseInt($(this).data('activerow')) != 1){
            $(this).removeClass('ui-state-active');
        }
    });
    $('table.yesListTable_minimal thead,table.yesListTable thead').addClass('ui-widget-header');

    

    $('.branches_qty').each(function(){
	$(this).css('cursor','pointer');
	$( this ).bind (
		"click",
		function(){
		    var _pid = $(this).attr('id');
		    $('#modal_window').dialog({
		       title: $(this).attr('title'),
		       modal: true,
		       width: 'auto',
		       height: 'auto'
		    }).load('branch_products.php?action=show_products_branches_qty&products_id='+_pid);
		}
	);
    });
    $('table .table_extendable').each(function( te_index ){
        let te_size = 25;
        if($(this).hasClass('table_extendable_size_5')){
            te_size = 5;
        }
        if($(this).hasClass('table_extendable_size_10')){
            te_size = 10;
        }
        var te_rows = $(this).find('tbody tr');
        // wenn zeilenanzahl kleiner gleich maximal anzahl
        if(te_rows.length <= te_size){
            return;
        }
        var te_column_count = $(this).find('tr:first td, tr:first th').length;
        var te_rows_hided = te_rows.length-te_size;
        te_rows.slice(te_size).hide();
        $(this).append('<tfoot><tr><th colspan="'+te_column_count+'"><a href="javascript:;" onclick="table_extendable_showall(\''+te_index+'\')" style="text-decoration: none;color: black;"><button type="button" class="ui-button ui-corner-all ui-state-highlight">'+sprintf(TABLES_EXTENDABLE_NAVIGATION_INFO,te_rows_hided)+'</button></a></th></tr></tfoot>');

    });
});
function table_extendable_showall( te_index ){
    $('table .table_extendable').eq(te_index).find('tbody tr').show();
    $('table .table_extendable').eq(te_index).find('tfoot').remove();
}
/**
 * ermittelt die Daten (w, h, type) einer Bilddatei fuer das meta-opengraph Modul
 * und gibt diese als alert() Meldung aus
 * @param string input feld name
 */
function get_meta_opengraph_image_properties( input_field ){
    console.log('get_meta_opengraph_image_properties: '+input_field);
    var url = $('input[name="'+input_field+'"]').val();
    url = url.replace('https:','http:');
    if(url.length < 5){
        alert('no image url specified');
    }else{
        var img = new Image();
        img.src = url;
        var type = 'unknown';
        var _type = url.substring( url.length-3 );
        switch(_type.toLowerCase()){
            case 'png':
                type = 'image/png';
                break;
            case 'gif':
                type = 'image/gif';
                break;
            case 'jpg':
            case 'jpeg':
                type = 'image/jpeg';
                break;
            case 'bmp':
                type = 'image/bmp';
                break;
        }
        if(!IsImageOk(img)){
            alert('Grafikdaten konnten nicht ermittelt werden, versuchen Sie es erneut oder geben Sie die Angaben zu Typ und Abmessungen manuell ein.');
        }else{
            alert('BxH: '+img.width+'x'+img.height+"\r\nTyp: "+type);
        }
    }
}

function IsImageOk(img) {
    // During the onload event, IE correctly identifies any images that
    // weren?t downloaded as not complete. Others should too. Gecko-based
    // browsers act like NS4 in that they report this incorrectly.
    if (!img.complete) {
        console.log('loading '+img.src+' ...');
        return false;
    }

    // However, they do have two very useful properties: naturalWidth and
    // naturalHeight. These give the true size of the image. If it failed
    // to load, either of these should be zero.
    if (typeof img.naturalWidth !== "undefined" && img.naturalWidth == 0) {
        console.log('kein natwi');
        return false;
    }

    // No other way of checking: assume it?s ok.
    return true;
}

function yes_confirm_link(href, confirm_text){
    if(!confirm(confirm_text)){
        return false;
    }
    window.location.href = href;
}

/**
 * Header Meldung ebay_orders_oos
 * 
 * @param {int} ebay_orders_oos_id
 * @param {string} confirmText
 * @returns {none}
 */
function delete_ebay_orders_oos_item(ebay_orders_oos_id, confirmText ){
    if(confirm(confirmText)){
        $.ajax({
            url: 'start.php?action=ebay_orders_oos&delete_id='+ebay_orders_oos_id,
            dataType: 'json',
            success: function( json ){
                if(json.MSG != ''){
                    alert(json.MSG);
                }else{
                    // start.php
                    $('table#ebay_orders_oos_table tr[data-ebayordersoosid="'+ebay_orders_oos_id+'"]').remove();
                }
            }
        });
    }
}

function yesDialogLink(title,link){
    $('#modal_window').dialog({
        title: title,
        width: 'auto',
        height: 'auto',
        modal: true,
    }).load(link);
}

function yesConfirmLink(text,link){
    if(!confirm(text)){
        return false;
    }
    window.location.href=link;
}

function yesIsValidFloat(wert) {
    // Überprüfung auf Integer-Wert
    if (Number.isInteger(wert)) {
        return true;
    }
    
    // Überprüfung auf Float-Wert
    if (!isNaN(parseFloat(wert)) && !isNaN(wert * 1000000)) {
        return true;
    }
    return false;
}

function yesIsValidInt(input) {
    if (input === null) {
        return false;
    }
        
    if (!input || isNaN(input)) {
        return false;
    }
    return true;
}
