<?php
/* --------------------------------------------------------------
   $Id: modules.php,v 1.27 2020/06/16 06:11:13 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(modules.php,v 1.45 2003/05/28); www.oscommerce.com 
   (c) 2003	 nextcommerce (modules.php,v 1.23 2003/08/19); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'DHL_Paket_DE_Versenden_REST_API.php');
if(isset($_POST['dhl_api'])){
    $PRODUKTE = DHL_Paket_DE_Versenden_REST_API::PRODUKTE;
    // DHL Teilnahme Config
    $json_array = [];
    foreach($_POST['dhl_api'] as $produkt_id=>$active){
        if($active != 1){
            continue;
        }
        foreach($PRODUKTE as $p){
            if($p['id'] != $produkt_id){
                continue;
            }
            $json_array[ $produkt_id ] = $p['GKV_API'].$p['Verfahren'].$_POST['Teilnahme'][$produkt_id];
        }
    }
    $value = (sizeOf($json_array))?json_encode($json_array):'';
    main::update_configuration_value('MODULE_SHIPPING_DHLGKAPI_TEILNAHME', $value);
}

if(isset($_GET['shipper_profiles_action'])){
    switch($_GET['shipper_profiles_action']){
        case 'delete':
            \YES4Trade\Model\shipper_profiles::delete($_GET['profile_name']);
            xtc_db_query(sprintf(
                "DELETE FROM products_default_shipper WHERE shipper_profile='%s'",
                $_GET['profile_name']
            ));
            if(defined('SHIPPING_DEFAULT_VERSENDER_VALUE') and SHIPPING_DEFAULT_VERSENDER_VALUE == $_GET['profile_name']){
                main::update_configuration_value('SHIPPING_DEFAULT_VERSENDER_VALUE', '');
            }
            $messageStack->add_session(sprintf(
                    MSG_SUCCESS_SHIPPER_PROFILES_DELETE,
                    $profile_name
            ),'success');
            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['shipper_profiles_action'])));
            break;
        case 'update':
            $default_shipper_params = [];
            $shipper = $_POST['default_shipper'];
            if($shipper == 'DHL'){
                $convert_product_value = false;
                $newDHLConfig = \DHL_Paket_DE_Versenden_REST_API::get_from_post(
                    $_POST['versender_params'][$shipper]['produkt'],
                    $convert_product_value
                );
                $newDHLConfig->product = $_POST['versender_params'][$shipper]['produkt'];
                $default_shipper_params_str = json_encode($newDHLConfig);
            }else{
                if(isset($_POST['versender_params'][xtc_db_input($_REQUEST['default_shipper'])]) and sizeOf($_POST['versender_params'][xtc_db_input($_REQUEST['default_shipper'])])){
                    foreach($_POST['versender_params'][xtc_db_input($_REQUEST['default_shipper'])] as $vk=>$vp){
                        $default_shipper_params[] = sprintf('%s:%s',
                                $vk,$vp
                        );
                    }
                }
                $default_shipper_params_str = implode(',',$default_shipper_params);
            }
            $profile_name = main::filesanitize($_POST['profile_name'],true,false);
            $shp = new \YES4Trade\Model\shipper_profiles([
                'profile_name'=>$profile_name,
                'versender'=>$_POST['default_shipper'],
                'versender_params'=>$default_shipper_params_str
            ]);
            $shp->update();
            $messageStack->add_session(sprintf(
                    MSG_SUCCESS_SHIPPER_PROFILES_UPDATE,
                    $profile_name
            ),'success');
            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['shipper_profiles_action'])));
            break;
        case 'add':
            $shipper = $_POST['default_shipper'];
            $default_shipper_params = [];
            $convert_product_value = false;
            if($shipper == 'DHL'){
                $newDHLConfig = \DHL_Paket_DE_Versenden_REST_API::get_from_post(
                    $_POST['versender_params'][$shipper]['produkt'], 
                    $convert_product_value
                );
                $newDHLConfig->product = $_POST['versender_params'][$shipper]['produkt'];
                $default_shipper_params_str = json_encode($newDHLConfig);
            }else{
                if(isset($_POST['versender_params'][xtc_db_input($_REQUEST['default_shipper'])]) and sizeOf($_POST['versender_params'][xtc_db_input($_REQUEST['default_shipper'])])){
                    foreach($_POST['versender_params'][xtc_db_input($_REQUEST['default_shipper'])] as $vk=>$vp){
                        $default_shipper_params[] = sprintf('%s:%s',
                                $vk,$vp
                        );
                    }
                }
                $default_shipper_params_str = implode(',',$default_shipper_params);
            }
            $profile_name = main::filesanitize($_POST['profile_name'],true,false);
            $shp = new \YES4Trade\Model\shipper_profiles([
                'profile_name'=>$profile_name,
                'versender'=>$_POST['default_shipper'],
                'versender_params'=>$default_shipper_params_str
            ]);
            try{
                $shp->create();
                $messageStack->add_session(sprintf(
                        MSG_SUCCESS_SHIPPER_PROFILES_ADD,
                        $profile_name
                ),'success');
            }catch( Exception $e ){
                $messageStack->add_session(sprintf(
                        MSG_ERROR_SHIPPER_PROFILES_ADD_EXISTS,
                        $profile_name
                ),'error');
            }
            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['shipper_profiles_action'])));
            break;
    }
}
if(isset($_GET['yesDSGVO_action'])){
    $content = [];
    if(!empty(MODULE_OTHER_YESDSGVO_ADMIN_CONSENT_CONFIGURATIONS)){
        $content_encoded = json_decode(MODULE_OTHER_YESDSGVO_ADMIN_CONSENT_CONFIGURATIONS);
        foreach($content_encoded as $c){
            $content[] = (array) $c;
        }
    }
    switch($_GET['yesDSGVO_action']){
        case 'delete':
            $nr = (int)$_GET['yesDSGVO_consent_select'] - 1;
            unset($content[$nr]);
            main::update_configuration_value('MODULE_OTHER_YESDSGVO_ADMIN_CONSENT_CONFIGURATIONS', json_encode(array_values($content)));
            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['yesDSGVO_action','yesDSGVO_consent_select'])));
            break;
	case 'add':
        case 'update':
            if(isset($_GET['yesDSGVO_consent_select'])){
                $nr = (int)$_GET['yesDSGVO_consent_select'] - 1;
                unset($content[$nr]);
            }
            $arr = [];
            if($_POST['yesDSGVO_consent_type'] == 'file'){
                    $arr['script_src'] = $_POST['yesDSGVO_consent_value'];
                    $arr['use_function'] = Null;
            }else{
                    $arr['script_src'] = Null;
                    $arr['use_function'] = $_POST['yesDSGVO_consent_value'];
            }
            $arr['description'] = $_POST['yesDSGVO_consent_description'];
            $arr['code'] = $_POST['yesDSGVO_consent_code'];
            $content[] = $arr;
            main::update_configuration_value('MODULE_OTHER_YESDSGVO_ADMIN_CONSENT_CONFIGURATIONS', json_encode(array_values($content)));
            die('OK');
            break;
    } // end switch yesDSGVO action
} // end if yesDSGVO action


// include needed functions (for modules)
$set = (isset($_GET['set'])) ? $_GET['set'] : '';
switch ($set) {
    case 'other':
      $module_type = 'other';
      $module_directory = DIR_FS_CATALOG_MODULES . 'other/';
      $module_key = 'MODULE_OTHER_INSTALLED';
      define('HEADING_TITLE', 'Diverse Module');
      break;

    case 'shipping':
      $module_type = 'shipping';
      $module_directory = DIR_FS_CATALOG_MODULES . 'shipping/';
      $module_key = 'MODULE_SHIPPING_INSTALLED';
      define('HEADING_TITLE', HEADING_TITLE_MODULES_SHIPPING);
      break;

    case 'ordertotal':
      $module_type = 'order_total';
      $module_directory = DIR_FS_CATALOG_MODULES . 'order_total/';
      $module_key = 'MODULE_ORDER_TOTAL_INSTALLED';
      define('HEADING_TITLE', HEADING_TITLE_MODULES_ORDER_TOTAL);
      break;

    case 'payment':
    default:
      $module_type = 'payment';
      $module_directory = DIR_FS_CATALOG_MODULES . 'payment/';
      $module_key = 'MODULE_PAYMENT_INSTALLED';
      define('HEADING_TITLE', HEADING_TITLE_MODULES_PAYMENT);
      if (isset($_GET['error'])) {
          $messageStack->add($_GET['error'], 'error');
        }
      break;
  }
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
    case 'shipper_profiles':
        $additional_shipper_params = '';
        $versender_options = [['id'=>'','text'=>TEXT_SELECT]];
        foreach($VERSENDER as $v){
            $versender_options[] = ['id'=>$v,'text'=>$v];
            if(is_file('includes/modules/shipping.versender_'.$v.'.php')){
                include('includes/modules/shipping.versender_'.$v.'.php');
                $add_input = array();
                foreach($shipping_versender_extra_fields as $ai){
                    $add_input_name_pref = sprintf('versender_params[%s]',
                            $v
                    );
                    $default_value = '';
                    $params = '';
                    if(isset($ai['content_load_url'])){
                        $params .= 'data-contentloadurl="'.$ai['content_load_url'].'"';
                    }
                    $add_input[] = array(
                        'name'=>$ai['name'],
                        'input'=>xtc_draw_pull_down_menu($add_input_name_pref."[".$ai['name']."]",$ai['values'],$default_value, $params)
                    );
                }
                if(sizeOf($add_input)){
                    $additional_shipper_params .= sprintf('<div class="hidden_additional_shipper_params" data-shipper="%s"><b>Versandkonfiguration %s</b>',$v,$v);
                    $additional_shipper_params .= '<ul class="additional_params_entry">';
                    foreach($add_input as $ai){   
                        $additional_shipper_params .= sprintf("<li>%s: %s</li>",$ai['name'],$ai['input']);
                    }
                    $additional_shipper_params .= '</ul><div class="ui-helper-clearfix"></div></div>';
                }
            }
        }
	$smarty->assign('INPUT_DEFAULT_SHIPPER',xtc_draw_pull_down_menu('default_shipper',$versender_options,  '','onchange="display_additional_shipper_params(this)"')
            .$additional_shipper_params
        );
        $profiles = \YES4Trade\Model\shipper_profiles::get_list();
        foreach($profiles as $k=>$p){
            if(!empty($p['versender_params'])){
                $obj = json_decode($p['versender_params']);
                $profiles[$k]['display_array'] = [
                    'versender'=>'DHL',
                    'additional_params'=>$p['versender_params'],
                ];
            }
        }
        $smarty->assign([
            'TITLE'=>TEXT_SHIPPER_PROFILES,
            'INTRO'=>TEXT_SHIPPER_PROFILES_INTRO,
            'TEXT_SHIPPER_PROFILES_NAME'=>TEXT_SHIPPER_PROFILES_NAME,
            'TEXT_SHIPPER_PROFILES_VERSENDER'=>TEXT_SHIPPER_PROFILES_VERSENDER,
            'TEXT_SHIPPER_PROFILES_VERSENDER_PARAMS'=>TEXT_SHIPPER_PROFILES_VERSENDER_PARAMS,
            'TEXT_SHIPPER_PROFILES_NO_DATA'=>TEXT_SHIPPER_PROFILES_NO_DATA,
            'TEXT_SHIPPER_PROFILES_ADD'=>TEXT_SHIPPER_PROFILES_ADD,
            'TEXT_SHIPPER_PROFILES_UPDATE'=>TEXT_SHIPPER_PROFILES_UPDATE,
            'INPUT_NAME'=>xtc_draw_input_field('profile_name','','size="32" maxlength="32" id="profile_name"'),
            'IMAGE_SAVE'=>IMAGE_SAVE,
            'IMAGE_UPDATE'=>IMAGE_UPDATE,
            'TEXT_SHIPPER_PROFILES_NAME_RULES'=>TEXT_SHIPPER_PROFILES_NAME_RULES,
            'PROFILES'=>$profiles,
            'JS_CONFIRM_REALLY_DELETE_PROFILE'=>JS_CONFIRM_REALLY_DELETE_PROFILE,
        ]);
        break;
    case 'save':
	switch($_REQUEST['set']){
	    case 'other':
		$_REQUEST['module'] = str_replace(array('/','.','\\','~'),'',$_REQUEST['module']);
		if(is_file(DIR_FS_CATALOG.'includes/modules/other/'.$_REQUEST['module'].'.php')){
            require_once(DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/other/' . $_REQUEST['module'].'.php');
		    require_once(DIR_FS_CATALOG.'includes/modules/other/'.$_REQUEST['module'].'.php');
		}
		$module = new $_REQUEST['module'];
		if(in_array('configuration_save_handler',get_class_methods($module))){
		    $module->configuration_save_handler();
		}
		break;
	}
      // php8 bugfix
      //while (list($key, $value) = each($_POST['configuration'])) {
      foreach($_POST['configuration'] as $key => $value) {
        if (is_array($value)) {
            $value = implode(',', $value);
        }
        main::update_configuration_value($key, $value);
      }
      $InstanceCache->deleteItem('configuration');
      xtc_redirect(xtc_href_link(FILENAME_MODULES, 'set=' . $_GET['set'] . '&module=' . $_GET['module']));
      break;

    case 'install':
    case 'remove':
      $class = basename($_GET['module']);
      $set = (isset($_GET['set']) and !empty($_GET['set']))?$_GET['set']:'payment';
      if($set == 'ordertotal'){
        $inc_set = 'order_total';
      }else{
        $inc_set = $set;
      }
      $lang_include_file = DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/' . $inc_set . '/' . $class.'.php';

      if(is_file($lang_include_file)){
        require_once($lang_include_file);
      }else{
        throw new Exception("Cant include language file $lang_include_file");
      }
      $file_extension = substr($_SERVER['PHP_SELF'], strrpos($_SERVER['PHP_SELF'], '.'));
      if (file_exists($module_directory . $class . $file_extension)) {
        include($module_directory . $class . $file_extension);
        $module = new $class(0);
        if ($_GET['action'] == 'install') {
          if($module->install() === false){
              $messageStack->add_session(TEXT_EXTENSION_NOT_INSTALLED,'error');
          }
        } elseif ($_GET['action'] == 'remove') {
          $module->remove();
        }
      }
      $InstanceCache->deleteItem('configuration');
      xtc_redirect(xtc_href_link(FILENAME_MODULES, 'set=' . $_GET['set'] . '&module=' . $class));
      break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<link rel="stylesheet" type="text/css" href="includes/javascript/spiffyCal/spiffyCal_v2_1.css">
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript" src="includes/javascript/spiffyCal/spiffyCal_v2_1.js"></script>

<!-- header //-->
<?php
$buttons = array();
switch($set){
    case 'shipping':
        if($action == 'shipper_profiles'){
            $buttons[] = [
                'text'=>IMAGE_BACK,
                'link'=>xtc_href_link(basename(__FILE__),'set='.$set),
                'lbOn'=>false,
                'auth'=>true
            ];
        }else{
            $buttons[] = [
                'text'=>TEXT_SHIPPER_PROFILES,
                'link'=>xtc_href_link(basename(__FILE__),'action=shipper_profiles&set='.$set),
                'lbOn'=>false,
                'auth'=>true
            ];
        }
        break;
}

$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
switch($action){
    case 'shipper_profiles':
        $smarty->display('shipper_profiles.html');
        require(DIR_WS_INCLUDES . 'footer.php');
        require(DIR_WS_INCLUDES . 'application_bottom.php');
        exit;
        break;
    default:
        $smarty->display('modules.html');
}
?>
<!-- header_eof //-->
<div id="spiffycalendar" class="text"></div>

<table border="0" width="100%" cellspacing="0" cellpadding="0">
<tr>
	<td>
		<table border="0" width="100%" cellspacing="2" cellpadding="0">
          <tr>
            <td valign="top" class="ui-widget-content">
				<table class="yes-ui-table">
					<thead>
						<tr class="ui-widget-header">
							<th><?php echo TABLE_HEADING_MODULES; ?></th>
							<th><?php echo TABLE_HEADING_FILENAME; ?></th>
							<th align="right"><?php echo TABLE_HEADING_SORT_ORDER; ?></th>
							<th align="right"><?php echo TABLE_HEADING_ACTION; ?></th>
						</tr>
					</thead>
					<tfoot>
						<tr>
							<td colspan="4"><?php echo TEXT_MODULE_DIRECTORY . ' ' . $module_directory; ?></td>
						</tr>
					</tfoot>
					<tbody>
<?php
  $file_extension = substr($_SERVER['PHP_SELF'], strrpos($_SERVER['PHP_SELF'], '.'));
  $directory_array = array();
  if ($dir = @dir($module_directory)) {
    while ($file = $dir->read()) {
      if (!is_dir($module_directory . $file)) {
        if (substr($file, strrpos($file, '.')) == $file_extension) {
          $directory_array[] = $file;
        }
      }
    }
    sort($directory_array);
    $dir->close();
  }

$installed_modules = array();
for ($i = 0, $n = sizeof($directory_array); $i < $n; $i++) {
    $file = $directory_array[$i];
    $class = substr($file, 0, strrpos($file, '.'));
    if(is_file(DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/' . $module_type . '/' . $file)){
        include(DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/' . $module_type . '/' . $file);
    }else{
        die("Cant include language file $file");
    }
        
    try{
        include($module_directory . $file);
    }catch(Exception $e){
        die("Cant include $file<br />".$e->getMessage());
    }

    if (xtc_class_exists($class)) {
        $module = new $class($xtPrice);
        if ($module->check() > 0) {
            if ($module->sort_order > 0) {
                if(!isset($installed_modules[$module->sort_order])):
                    $installed_modules[$module->sort_order] = $file;
		else:
                    $installed_modules[] = $file;
		endif;
            } else {
                $installed_modules[] = $file;
            }
        }
        if (((!isset($_GET['module'])) || (isset($_GET['module']) and $_GET['module'] == $class)) && (!isset($mInfo))) {
            $module_info = array('code' => $module->code,
                'title' => $module->title,
                'description' => $module->description,
                'status' => $module->check()
            );
            $module_keys = $module->keys();

            $keys_extra = array();
            for ($j = 0, $k = sizeof($module_keys); $j < $k; $j++) {
                $key_value_query = xtc_db_query(sprintf(
                    "select configuration_key,configuration_value, use_function, set_function from %s where configuration_key = '%s'",
                    TABLE_CONFIGURATION,$module_keys[$j]
                ));
                if(xtc_db_num_rows($key_value_query)){
                    $key_value = xtc_db_fetch_array($key_value_query);
                    $keys_extra[$module_keys[$j]]['title'] = constant(strtoupper($key_value['configuration_key'] .'_TITLE'));
                    $keys_extra[$module_keys[$j]]['value'] = $key_value['configuration_value'];
                    $keys_extra[$module_keys[$j]]['description'] = constant(strtoupper($key_value['configuration_key'] .'_DESC'));
                    $keys_extra[$module_keys[$j]]['use_function'] = $key_value['use_function'];
                    $keys_extra[$module_keys[$j]]['set_function'] = $key_value['set_function'];
                }else{
                    $title = defined(strtoupper($module_keys[$j].'_TITLE'))?constant(strtoupper($module_keys[$j].'_TITLE')):'unbekannt';
                    $desc = defined(strtoupper($module_keys[$j].'_DESC'))?constant(strtoupper($module_keys[$j].'_DESC')):'unbekannt';
                    $keys_extra[$module_keys[$j]] = [
                        'title'=>$title,
                        'value'=>'',
                        'description'=>$desc,
                        'use_function'=>'',
                        'set_function'=>'',
                    ];
                }
            }
            $module_info['keys'] = $keys_extra;

            $mInfo = new objectInfo($module_info);
        }

        if ( isset($mInfo) and (is_object($mInfo)) && ($class == $mInfo->code) ) {
            if ($module->check() > 0) {
                echo '              <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_MODULES, 'set=' . $_GET['set'] . '&module=' . $class . '&action=edit') . '\'" class="ui-state-highlight">' . "\n";
            } else {
                echo '              <tr class="ui-state-highlight">' . "\n";
            }
        } else {
            echo '              <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_MODULES, 'set=' . @$_GET['set'] . '&module=' . $class) . '\'">' . "\n";
        }
?>
                <td><?php echo $module->title; ?></td>
                <td><?php echo str_replace('.php','',$file); ?></td>
                <td align="right"><?php if (property_exists($module,'sort_order') and  is_numeric($module->sort_order)){ echo $module->sort_order; }else{ echo '0'; } ?>&nbsp;</td>
                <td align="right"><?php if ( (isset($mInfo) and is_object($mInfo)) && ($class == $mInfo->code) ) { echo xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif'); } else { echo '<a href="' . xtc_href_link(FILENAME_MODULES, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . $class) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
    }
}
ksort($installed_modules);
if(main::configuration_key_exists($module_key)){
    $cv = main::get_configuration_value($module_key);
    if ($cv != implode(';', $installed_modules)) {
        main::update_configuration_value($module_key, implode(';', $installed_modules));
    }
} else {
    main::add_configuration([
        'configuration_key'=>$module_key,
        'configuration_value'=>implode(';', $installed_modules),
        'configuration_group_id'=>6, 
        'sort_order'=>0
    ]);
}
?>
	</tbody>
    </table>
</td>
<?php
$heading = array();
$contents = array();
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
// BOF - Tomcraft - 2009-10-03 - Paypal Express Modul
	case 'removepaypal':
		$heading[] = array('text' => '<b>' . $mInfo->title . '</b>');
		$contents = array ('form' => xtc_draw_form('modules', FILENAME_MODULES, 'set=' . $_GET['set'] . '&module=' . $_GET['module'] . '&action=remove'));
		$contents[] = array ('text' => '<br />'.TEXT_INFO_DELETE_PAYPAL.'<br /><br />'.$mInfo->description);
		$contents[] = array ('text' => '<br />'.xtc_draw_checkbox_field('paypaldelete').' '.BUTTON_MODULE_REMOVE);
		$contents[] = array ('align' => 'center', 'text' => '<br /><input type="submit" class="button" onClick="this.blur();" value="'. BUTTON_START .'"><a class="button" onClick="this.blur();" href="'.xtc_href_link(FILENAME_MODULES, 'set=' . $_GET['set'] . '&module=' . $_GET['module']).'">' . BUTTON_CANCEL . '</a>');
		break;
// EOF - Tomcraft - 2009-10-03 - Paypal Express Modul
    case 'edit':
      $keys = '';
	if(isset($mInfo->keys) and is_countable($mInfo->keys)){
	    reset($mInfo->keys);
    }
	if(is_countable($mInfo->keys) and sizeOf($mInfo->keys)){
            // php8 bugfix
	    //while (list($key, $value) = each($mInfo->keys)) {
	    foreach($mInfo->keys as $key => $value) {
	     // if($value['description']!='_DESC' && $value['title']!='_TITLE'){ 
		$keys .= '<b>' . $value['title'] . '</b><br>' .  $value['description'].'<br>';
		if ($value['set_function']) {
		    eval('$keys .= ' . $value['set_function'] . "'" . $value['value'] . "', '" . $key . "');");
		} else {
		    $keys .= xtc_draw_input_field('configuration[' . $key . ']', $value['value']);
		}
		$keys .= '<br><br>';
	    }
	}
      $keys = substr($keys, 0, strrpos($keys, '<br><br>'));

      $heading[] = array('text' => '<b>' . $mInfo->title . '</b>');

      $contents = array('form' => xtc_draw_form('modules', FILENAME_MODULES, 'set=' . $_GET['set'] . '&module=' . $_GET['module'] . '&action=save'));
      $contents[] = array('text' => $keys);
      $contents[] = array('align' => 'center', 'text' => '<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:140px','submit').
		  '&nbsp;'.
		  yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULES, 'set=' . $_GET['set'] . '&module=' . $_GET['module']),'width:140px')
      );
      break;

    default:
      $heading[] = array('text' => '<b>' . $mInfo->title . '</b>');

      if ($mInfo->status == '1') {
        $keys = '';
        reset($mInfo->keys);
        foreach($mInfo->keys as $value){
			$v_title = (isset($value['title'])) ? $value['title'] : 'unbekannt';
          $keys .= '<b>' . $v_title . '</b><br />';
          if ($value['use_function']) {
            $use_function = $value['use_function'];
            if (stristr($use_function,'->')) {
              $class_method = explode('->', $use_function);
              if (!is_object(${$class_method[0]})) {
                include(DIR_WS_CLASSES . $class_method[0] . '.php');
                ${$class_method[0]} = new $class_method[0]();
              }
              $keys .= xtc_call_function($class_method[1], $value['value'], ${$class_method[0]});
            } else {
              $keys .= xtc_call_function($use_function, $value['value']);
            }
          } else {
		  if(strlen($value['value']) > 30) {
		  $keys .=  substr($value['value'],0,30) . ' ...';
		  } else {
            $keys .=  $value['value'];
			}
          }
          $keys .= '<br><br>';
        }
        $keys = substr($keys, 0, strrpos($keys, '<br><br>'));

        $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_MODULE_REMOVE,xtc_href_link(FILENAME_MODULES, 'set=' . $_GET['set'] . '&module=' . $mInfo->code . '&action=remove'),'width:140px;').
			'&nbsp;'.
			yes_draw_href_button(IMAGE_EDIT,xtc_href_link(FILENAME_MODULES, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . ((isset($_GET['module']))?$_GET['module']:'') . '&action=edit'),'width:140px')
		);
        $contents[] = array('text' => '<br />' . $mInfo->description);
        $contents[] = array('text' => '<br />' . $keys);
      } else {
        $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_MODULE_INSTALL,xtc_href_link(FILENAME_MODULES, 'set=' . $_GET['set'] . '&module=' . $mInfo->code . '&action=install'),'width:140px;'));
        $contents[] = array('text' => '<br />' . $mInfo->description);
      }
      break;
  }

  if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    echo '            <td width="25%" valign="top" class="ui-widget-content">' . "\n";

    $box = new box;
    echo $box->infoBox($heading, $contents);

    echo '            </td>' . "\n";
  }
?>
          </tr>
        </table></td>
      </tr>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->

<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
