<?php
if(!isset($_GET['oID'])){
    die(json_encode([
        'MSG'=>'Invalid oID'
    ]));
}
$oID = intval($_GET['oID']);
$order = new \order($oID);
if(isset($_GET['delete_opiid'])){
    $opiID = intval($_GET['delete_opiid']??0);
    if($opiID < 1){
        $messageStack->add_session('Invalid order pallet item','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['delete_opiid'])));
    }
    \YES4Trade\Model\orders_pallets_items::delete($opiID);
    $messageStack->add_session('Order pallet position deleted','success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['delete_opiid'])));
}
if(isset($_POST['opID'])){
    $opsID = intval($_POST['opsID']??0);
    if($opsID < 1){
        $messageStack->add_session('Invalid order pallet','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params()));
    }
    if(!is_countable($_POST['opID'])){
        $messageStack->add_session('Invalid order pallet positions','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params()));
    }
    foreach($_POST['opID'] as $opID_raw=>$qty_raw){
        $qty = intval($qty_raw);
        $opID = intval($opID_raw);
        if($qty > 0){
            $new = new \YES4Trade\Model\orders_pallets_items([
                'orders_pallets_id'=>$opsID,
                'orders_products_id'=>$opID,
                'quantity'=>$qty
            ]);
            $new->create();
        }
    }
    $messageStack->add_session('Order pallet position added','success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params()));
}
if(isset($_GET['delete'])){
    if(intval($_GET['delete'])<1){
        $messageStack->add_session('Invalid order pallet','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['delete'])));
    }
    \YES4Trade\Model\orders_pallets::delete(intval($_GET['delete']));
    $messageStack->add_session('Order pallet deleted','success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['delete'])));
}
if(isset($_GET['update_field'])){
    $opsID = intval($_GET['opsID']??0);
    if($opsID < 1){
        $messageStack->add_session('Invalid order pallet','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['opsID','update_field','value'])));
    }
    $update_field = $_GET['update_field'];
    $value = $_GET['value'];
    switch($update_field){
        case 'notes':
            $upd = new \YES4Trade\Model\orders_pallets([
                'notes'=>$value,
                'orders_pallets_id'=>$opsID
            ]);
            $upd->update();
            break;
        case 'weight_total':
            $value = str_replace(',','.',$value);
            if(floatval($value) < 0){
                $messageStack->add_session('Invalid weight','error');
                xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['opsID','update_field','value'])));
            }
            $upd = new \YES4Trade\Model\orders_pallets([
                'weight_total'=>floatval($value),
                'orders_pallets_id'=>$opsID
            ]);
            $upd->update();
            break;
        case 'quantity':
            if(intval($value) < 1){
                $messageStack->add_session('Invalid Quantity. Minimum 1','error');
                xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['opsID','update_field','value'])));
            }
            $upd = new \YES4Trade\Model\orders_pallets([
                'quantity'=>intval($value),
                'orders_pallets_id'=>$opsID
            ]);
            $upd->update();
            break;
        case 'size':
            $sizes = explode('-',$_GET['value']);
            if(sizeOf($sizes) != 3){
                $messageStack->add_session('Invalid size values','error');
                xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['opsID','update_field','value'])));
            }
            $value = implode(' x ',$sizes);
            $upd = new \YES4Trade\Model\orders_pallets([
                'length'=>floatval(str_replace(',','.',$sizes[0])),
                'width'=>floatval(str_replace(',','.',$sizes[1])),
                'height'=>floatval(str_replace(',','.',$sizes[2])),
                'orders_pallets_id'=>$opsID
            ]);
            $upd->update();
            break;
    }
    $messageStack->add_session('Order pallet updated - '.$update_field.': '.$value,'success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['opsID','update_field','value'])));
}
if(isset($_POST['quantity'])){
    $update = false;
    if(isset($_POST['orders_paletts_id'])){
        $update = true;
        $opsID = intval($_POST['orders_paletts_id']);
    }
    $item = new \YES4Trade\Model\orders_pallets([
        'orders_id'=>$oID,
        'quantity'=>intval($_POST['quantity']??1),
        'length'=>floatval($_POST['length']??0),
        'width'=>floatval($_POST['width']??0),
        'height'=>floatval($_POST['height']??0),
        'weight_total'=>floatval($_POST['weight']??0),
        'notes'=>$_POST['notes']??'',
    ]);
    if($update){
        $item->orders_pallets_id = $opsID;
        $item->update();
    }else{
        $opsID = intval($item->create());
        $item->orders_pallets_id = $opsID;
    }
    $order->add_history($order->info['orders_status'],false,'Pallet added ('.$item->quantity.'x '.$item->weight_total.'kg)');
    $messageStack->add_session('Pallet added','success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params()));
}

$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal order_pallets" style="width: auto;"';
$contents = [[
    ['text'=>TEXT_QUANTITY,'th'=>true],
    ['text'=>ORDER_PALLETS_SIZES,'th'=>true],
    ['text'=>ORDER_PALLETS_WEIGHT,'th'=>true],
    ['text'=>ORDER_PALLETS_POSITIONS,'th'=>true],    
    ['text'=>ORDER_PALLETS_NOTES,'th'=>true],    
    ['text'=>'Actions','th'=>true],    
    
]];
$saved_items = \YES4Trade\Model\orders_pallets::get_by_orders_id($oID);
foreach($saved_items as $si){
    $size_str = sprintf('<span class="length">%s</span> x <span class="width">%s</span> x <span class="height">%s</span>',$si->length,$si->width, $si->height);
    $positions_obj = \YES4Trade\Model\orders_pallets_items::get_by_orders_pallets_id(intval($si->orders_pallets_id));
    $positions = [];
    foreach($positions_obj as $pos){
        foreach($order->products as $op){
            if(intval($op['opID']) == intval($pos->orders_products_id)){
                $currop = $op;
            }
        }
        $name = $currop['name'];
        if(strlen($name)>30){
            $name = substr($currop['name'],0,30).'...';
        }
        $positions[] = sprintf('<div class="opp" data-opiid="%s" data-opid="%d" data-qty="%d">'
            .'<span class="quantity">%s</span>x&nbsp;'
            .'<span class="product"><b>pID %s</b> %s</span>'
            .'&nbsp;<span onclick="remove_opiid(%s)" class="remove" title="%s">🗑</span>'
            .'</div>',
            $pos->orders_pallets_items_id,
            $currop['opID'],
            $pos->quantity,
            $pos->quantity,
            $currop['id'],
            $name,
            $pos->orders_pallets_items_id,
            IMAGE_DELETE
        );
    }
    $contents[] = [
        'params'=>'id="'.$si->orders_pallets_id.'"',
        ['text'=>$si->quantity,'params'=>'class="quantity" onclick="edit_pallet('.$si->orders_pallets_id.',\'quantity\')"'],
        ['text'=>$size_str,'params'=>'class="size" onclick="edit_pallet('.$si->orders_pallets_id.',\'size\')"'],
        ['text'=>$si->weight_total,'params'=>'class="weight_total" onclick="edit_pallet('.$si->orders_pallets_id.',\'weight_total\')"'],
        ['text'=>implode('',$positions),'params'=>'class="positions"'],
        ['text'=>$si->notes,'params'=>'class="notes" onclick="edit_pallet('.$si->orders_pallets_id.',\'notes\')"'],
        ['text'=>yes_draw_href_button(ORDER_PALLETS_ADD_POSITION,'javascript:add_pallet_position('.$si->orders_pallets_id.')','width: 150px;','button','ui-button ui-corner-all ui-state-default')
            .'&nbsp;'
            .yes_draw_href_button(IMAGE_DELETE,'javascript: delete_pallet('.$si->orders_pallets_id.')','width: 150px;','button','ui-button ui-corner-all ui-state-error'),
            'params'=>'class="actions"'
        ],
    ];
}



$order_products = [];
foreach($order->products as $op){
    $options = [];
    for($i=0;$i<=intval($op['qty']);$i++){
        $options[] = ['id'=>$i,'text'=>$i];
    }
    $op['input'] = xtc_draw_pull_down_menu('opID['.$op['opID'].']',$options,0);
    $order_products[] = $op;
}

yes_draw_pre_header();
yes_draw_header('Pallets');
$buttons = [
    [
        'text'=>IMAGE_BACK,
        'link' => xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['action']).'action=edit'),
        'lbOn'=>false,
        'auth'=>true,
    ],
    [
        'text'=>ITEM_ADD,
        'link' => 'javascript:add_pallet_show()',
        'lbOn'=>false,
        'auth'=>true,
    ]
];
$table_html = (sizeOf($contents)>1) ? $table->tableBlock_draw($contents) : '';
$smarty->assign([
    'HEADING_TITLE'=>ORDER_PALLETS,
    'ADDITIONAL_HEADING_TITLE'=>$order->get_title().' '.$oID,
    'ORDER_TITLE'=>$order->get_title(),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'FORM_ADD_PALETTE'=>xtc_draw_form('add_palette_form',FILENAME_ORDERS,xtc_get_all_get_params(),'POST'),
    'BASEURL'=>xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params()),
    'SAVED_PALLETS'=>json_encode($saved),
    'YES_ORDERS_PRODUCTS'=>$order->get_order_positions(),
    'ORDERS_PRODUCTS'=>$order_products,
    'TABLE'=>$table_html,
]);
echo $smarty->fetch('orders.edit_pallets.html');
require(DIR_WS_INCLUDES . 'footer.php');
include('includes/application_botton.php');
exit;