<?php
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/customers_status.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_subtotal.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_subtotal_no_tax.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_total.php');

$oID = $_GET['oID']??0;
if($oID === 0){
    die('Invalid Parameter');
}
$order = new order($oID);
$cID = intval($_GET['cID']??0);
if($cID > 0){
    $recreate_customer_status = \YES4Trade\Model\customers::get_by_customers_id($cID,[
        'customers_status','customers_email_address'
    ]);
    if($recreate_customer_status === null){
        die('<div style="margin-top:10px;" class="error ui-state-error">Invalid customer</div>');
    }
    $xtcPrice = new \xtcPrice(DEFAULT_CURRENCY, $recreate_customer_status->customers_status);
    $customers_status = \YES4Trade\Model\customers_status::get_by_customers_status_id($recreate_customer_status->customers_status);
}

yes_draw_pre_header();
$title = 'Order Copy '.$oID;
$hidden = [];
if(isset($_GET['products_price'])){
    $cs = \YES4Trade\Model\customers_status::get_by_customers_status_id(intval($recreate_customer_status->customers_status));
    $customer = \YES4Trade\Model\customers::get_by_customers_id($cID,[
        'customers_email_address'
    ]);
    $orders_data = $order->get_orders_entry_for_copy( $order->info['orders_status'] );
    $orders_data['customers_id'] = $cID;
    $orders_data['customers_status'] = $cs->customers_status_id;
    $orders_data['customers_status_name'] = $cs->customers_status_name;
    $orders_data['customers_status_image'] = $cs->customers_status_image;
    $orders_data['customers_status_discount'] = 0;
    $orders_data['customers_email_address'] = $customer->customers_email_address;
    $orders_data['comments'] = 'eBay netto copy of order '.$oID;
    $orders_data['marge'] = 0; // @todo

    yes_db_perform(TABLE_ORDERS,$orders_data);
    $new_oID = xtc_db_insert_id();
    \order::add_history_static(intval($new_oID),
        intval($order->info['orders_status']),
        false,
        $orders_data['comments']
    );

    // ALTE ORDER STORNIEREN
    $order->update_orders_status(ORDERS_STATUS_STORNIERT);
    $order->add_history(ORDERS_STATUS_STORNIERT,false,
        'ebay netto recreate - copies as order '.$new_oID
    );

    $op_sql_array = $order->get_orders_products_entries_for_copy();

    $subtotal_value = 0;
    foreach($op_sql_array as $opID => $tables){
        $orders_products = $tables['orders_products'];

        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(intval($orders_products['products_id']), 
            $order->delivery['country_id'], 
            $order->delivery['zone_id']
        );
        $tax_rate = 0;
        if(intval($customers_status->customers_status_add_tax_ot) == 1){
            $tax_rate = xtc_get_tax_rate($products_tax_class_id, 
                $order->delivery['country_id'],
                $order->delivery['zone_id'],
            );
        }
        $netto = floatval($_GET['products_price'][$opID]);
        if(intval($orders_products['allow_tax']) == 1){
            if(floatval($orders_products['products_tax']) > 0){
                $netto = xtc_oe_get_price_o_tax(
                    $netto,
                    floatval($orders_products['products_tax'])
                );
            }
        }
        if(intval($customers_status->customers_status_add_tax_ot) == 1){
            $copy_price = xtc_oe_get_price_i_tax($netto, $tax_rate);
            $allow_tax = 1;
            $ot_subtotal_class = 'ot_subtotal';
            $ot_subtotal_class_title = 'MODULE_ORDER_TOTAL_SUBTOTAL_TITLE';
            $ot_subtotal_sort_order = intval(constant('MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER'));
        }else{
            $copy_price = $netto;
            $allow_tax = 0;
            $ot_subtotal_class = 'ot_subtotal_no_tax';
            $ot_subtotal_class_title = 'MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_TITLE';
            $ot_subtotal_sort_order = intval(constant('MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_SORT_ORDER'));
        }

        unset($orders_products['orders_products_id']);
        $orders_products['orders_id'] = intval($new_oID);
        $orders_products['products_price'] = $copy_price;
        $orders_products['final_price'] = $copy_price*intval($orders_products['products_quantity']);
        $orders_products['products_tax'] = $tax_rate;
        $orders_products['allow_tax'] = $allow_tax;
        $orders_products['date_added'] = date('Y-m-d H:i:s');
        $orders_products['marge'] = 0;
        yes_db_perform(TABLE_ORDERS_PRODUCTS, $orders_products);
        $new_opID = xtc_db_insert_id();

        foreach($tables['orders_products_price_fixing'] as $oppf){
            unset($oppf['orders_products_price_fixing_id']);
            $oppf['orders_products_id'] = intval($new_opID);
            yes_db_perform('orders_products_price_fixing',$oppf);
        }

        // soweit ich weiss, gibt es bei ebay orders keine
        // eintraege in orders_products_properties, aber 
        // ich habs einfach mal drin gelassen.
        foreach($tables['orders_products_properties'] as $opp){
            unset($opp['orders_products_properties_id']);
            $opp['orders_products_id'] = intval($new_opID);
            yes_db_perform('orders_products_price_fixing',$opp);
        }
        $subtotal_value += $orders_products['final_price'];
    }
    $insert_sql_array = [
        'orders_id'=>intval($new_oID),
        'title'=>constant($ot_subtotal_class_title),
        'text'=>$xtcPrice->xtcFormat($subtotal_value,true),
        'value'=>floatval($subtotal_value),
        'class'=>$ot_subtotal_class,
        'sort_order'=>$ot_subtotal_sort_order,        
    ];
    yes_db_perform(TABLE_ORDERS_TOTAL, $insert_sql_array);
    $ot_total_value = floatval($subtotal_value);

    if(isset($_GET['ot_value']) and is_countable($_GET['ot_value'])){
        foreach($_GET['ot_value'] as $old_otid=>$ot_value){
            $ot_title = $_GET['ot_name'][$old_otid] ?? 'Kosten';
            $ot_value = floatval(str_replace(',','.',$ot_value));
            $ot_class = '';
            foreach($order->totals as $oot){
                if($oot['otid'] == $old_otid){
                    $ot_class = $oot['class'];
                }
            }
            $ot_tax_rate_percent = 0; // alles ausser ot_tax kriegt 0
            $insert_sql_array = [
                'orders_id'=>intval($new_oID),
                'title'=>urldecode($ot_title),
                'text'=>$xtcPrice->xtcFormat($ot_value,true),
                'value'=>floatval($ot_value),
                'class'=>$ot_class,
                'tax_rate_percent'=>$ot_tax_rate_percent,
                'sort_order'=>intval(constant('MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER'))
            ];
            yes_db_perform(TABLE_ORDERS_TOTAL, $insert_sql_array);
            $ot_total_value += floatval($ot_value);
        }
    }

    $insert_sql_array = [
        'orders_id'=>intval($new_oID),
        'title'=>constant('MODULE_ORDER_TOTAL_TOTAL_TITLE'),
        'text'=>$xtcPrice->xtcFormat($ot_total_value,true),
        'value'=>floatval($ot_total_value),
        'class'=>'ot_total',
        'sort_order'=>intval(constant('MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER'))
    ];
    yes_db_perform(TABLE_ORDERS_TOTAL, $insert_sql_array);

    // UMSCHREIBEN DER EBAY REFERENZEN
    yes_query("UPDATE ebay_orders SET orders_id=:new_oid WHERE orders_id=:old_oid",[
        'new_oid'=>intval($new_oID),
        'old_oid'=>intval($oID)
    ]);
    yes_query("UPDATE ebay_transactions SET orders_id=:new_oid WHERE orders_id=:old_oid",[
        'new_oid'=>intval($new_oID),
        'old_oid'=>intval($oID)
    ]);

    $new_order = new order($new_oID);
    // MARGE REKALKULIEREN
    $new_order->save_marge();

    // FIBU NUMMERN
    if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
        // wenn alter auftrag eine fibunummer hatte
        // kriegt auch der neue eine.
        if($order->get_fibunumber() > 0){
            $new_order->add_fibunumber();
        }
    }
    xtc_redirect(xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$new_oID));
}
foreach($_GET as $k=>$v){
    switch($k){
        case 'cID':
            break;
        default:
            $hidden[] = xtc_draw_hidden_field($k,$v);
            break;
    }
}
$smarty->assign([
    'HEADING_TITLE'=>$title,
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'FORM'=>xtc_draw_form('recreate_order',FILENAME_ORDERS,'','get')
        .implode('',$hidden),
    'SOURCE_ORDER_CUSTOMERS_STATUS'=>xtc_get_customers_status_name($order->info['status']),
    'SOURCE_ORDER_CUSTOMERS_STATUS_ID'=>$order->info['status'],
    'INPUT_CUSTOMERS_ID'=>xtc_draw_input_field('cID',($cID>0)?$cID:'','id="customers_id"'),
    'ADDITIONAL_TITLE'=>RECREATE_INTRO,
    'RECREATE_CUSTOMERS_ID'=>RECREATE_CUSTOMERS_ID,
    'PAGE_HEADING_MENU_BUTTONS'=>array(
        array('text'=>IMAGE_BACK,
            'link'=>xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array('action')).'action=edit'),
            'lbOn'=>false,
            'auth'=>true
        )
    ),
    'SOURCE_DELIVERY_ADDRESS'=>xtc_address_format($order->delivery['format_id'],$order->delivery,true,'','<br />'),
    'SOURCE_EMAIL_ADDRESS'=>$order->customer['email_address'],
    'SOURCE_ORDER_TOTALS'=>$order->totals,
    'DEFAULT_CURRENCY'=>$order->info['currency'],
    'REALLY_RECREATE_ORDER'=>sprintf(REALLY_RECREATE_ORDER,$oID,xtc_get_order_status_name($order->info['orders_status'])),
]);
yes_draw_header($title);
if($cID > 0){
    $recreate_customer_status = \YES4Trade\Model\customers::get_by_customers_id($cID,[
        'customers_status','customers_email_address'
    ]);
    if($recreate_customer_status === null){
        die('<div style="margin-top:10px;" class="error ui-state-error">Invalid customer</div>');
    }
    $table = new tableBlock();
    $table->table_parameters = 'class="yesListTable_minimal recreate_products" style="width: 100%;"';

    $contents = [[
        ['text'=>sprintf(RECREATE_ORDER_PRODUCT_ORIG,$oID),'th'=>true],
        ['text'=>sprintf(RECREATE_ORDER_PRODUCT_PRICE_ORIG,$oID),'th'=>true],
        ['text'=>sprintf(RECREATE_ORDER_PRODUCT_PRICE_TAX_ORIG,$oID),'th'=>true],
        ['text'=>RECREATE_ORDER_PRODUCT_PRICE_COPY,'th'=>true],
        ['text'=>RECREATE_ORDER_PRODUCT_PRICE_TAX_COPY,'th'=>true],
    ]];
    $subtotal = 0;
    foreach($order->products as $op){        
        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($op['id'], 
            $order->delivery['country_id'], 
            $order->delivery['zone_id']
        );
        $tax_rate = 0;
        if(intval($customers_status->customers_status_add_tax_ot) == 1){
            $tax_rate = xtc_get_tax_rate($products_tax_class_id, 
                $order->delivery['country_id'],
                $order->delivery['zone_id'],
            );
        }
        $netto = floatval($op['price']);
        if($op['allow_tax'] == 1){
            if(floatval($op['tax']) > 0){
                $netto = xtc_oe_get_price_o_tax($op['price'],$op['tax']);
            }
        }
        if(intval($customers_status->customers_status_add_tax_ot) == 1){
            $copy_price = xtc_oe_get_price_i_tax($netto, $tax_rate);
            $ot_subtotal_class = 'ot_subtotal';
            $ot_subtotal_class_title = 'MODULE_ORDER_TOTAL_SUBTOTAL_TITLE';
        }else{
            $copy_price = $netto;
            $ot_subtotal_class = 'ot_subtotal_no_tax';
            $ot_subtotal_class_title = 'MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_TITLE';
        }
        
        $subtotal += $copy_price*$op['qty'];
        $new_price = number_format(
            $copy_price,
            2,'.',''
        );
        $props = [];
        if(isset($op['properties']) and is_countable($op['properties'])){
            foreach($op['properties'] as $prp){
                $props[] = sprintf('%s: %s',
                    $prp['property_title'],
                    $prp['property_value']
                );
            }
            $props_str = '<div style="font-size: 0.8em;color: #666;">'.implode('<br />',$props).'</div>';
        }
        $contents[] = [
            ['text'=>sprintf('%d x %s (pID %d)%s',
                $op['qty'], $op['name'], $op['id'],$props_str
            )],
            ['text'=>$xtcPrice->xtcFormat($op['price'],true)],
            ['text'=>number_format($op['tax'],2,'.','').'%'],
            ['text'=>xtc_draw_input_field('products_price['.$op['opID'].']',$new_price,'step=".01"',false,'number'),
                'params'=>'data-quantity="'.$op['qty'].'" class="price"'
            ],
            ['text'=>((intval($customers_status->customers_status_add_tax_ot) == 1)?'+':'').number_format($tax_rate,2,'.','').'%'],
        ];
    }
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/'.$ot_subtotal_class.'.php');
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_total.php');
    $smarty->assign([
        'COPY_ORDER_TOTALS'=>[
            [
                'class'=>$ot_subtotal_class,
                'title'=>constant($ot_subtotal_class_title),
                'text'=>$xtcPrice->xtcFormat($subtotal,true),
                'value'=>$subtotal
            ],
            [
                'class'=>'ot_total',
                'title'=>constant('MODULE_ORDER_TOTAL_TOTAL_TITLE'),
                'text'=>$xtcPrice->xtcFormat($subtotal,true),
                'value'=>$subtotal
            ]
        ],
        'COPY_PRODUCTS_TABLE'=>$table->tableBlock_draw($contents),
        'COPY_ORDER_CUSTOMERS_STATUS_ID'=>$recreate_customer_status->customers_status,
        'COPY_DELIVERY_ADDRESS'=>xtc_address_format($order->delivery['format_id'],$order->delivery,true,'','<br />'),
        'FORM_ORDER'=>xtc_draw_form('recreate_order_form',FILENAME_ORDERS,'','GET')
            .implode('',$hidden).xtc_draw_hidden_field('cID',$cID),
        'COPY_EMAIL_ADDRESS'=>$recreate_customer_status->customers_email_address
    ]);
}
$smarty->display('orders.recreate.html');
include('includes/footer.php');
include('includes/application_bottom.php');
