<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
require('includes/application_top.php');
// include needed functions
require_once(DIR_FS_INC .'xtc_get_order_data.inc.php');
require_once(DIR_FS_INC .'xtc_get_attributes_model.inc.php');
require_once(DIR_FS_INC .'xtc_not_null.inc.php');
require_once(DIR_FS_INC .'xtc_format_price_order.inc.php');
require(DIR_FS_CATALOG.'inc/xtc_get_product_path.inc.php');
require(DIR_FS_CATALOG.'inc/xtc_get_parent_categories.inc.php');

function get_print_data($order_data_values,$dID,$currency,$allow_tax){
	$tax = xtc_display_tax_value($order_data_values['products_tax']).'%';
	$price_notax = format_price($order_data_values['final_price']/$order_data_values['products_quantity'], 1, $currency, $order_data_values['allow_tax'], $order_data_values['products_tax']);
	$item_price  = format_price($order_data_values['final_price']/$order_data_values['products_quantity'], 1, $currency, 0, 0);
	
	// auch LieferantenNr anzeigen
	$dist_products_name_query_raw = sprintf("SELECT distributor_products_number FROM products_distributors WHERE products_id=%s AND distributor_id=%s",$order_data_values['products_id'],$dID);
	$dist_products_name_query = xtc_db_query( $dist_products_name_query_raw);
	$dist_products_name_res = xtc_db_fetch_array($dist_products_name_query);

	if($allow_tax){
		$price = xtc_format_price_order($order_data_values['final_price'],1,$currency);
	}else{
		$price = xtc_format_price_order($order_data_values['final_price'],1,$currency);
	}
	
	$data = array(
		'PRODUCTS_ID' => $order_data_values['products_id'],
		'PRODUCTS_MODEL' => $order_data_values['products_model'],
		'DISTRIBUTOR_NUMBER'=>$dist_products_name_res['distributor_products_number'],
		'PRODUCTS_NAME' => xtc_db_prepare_input($order_data_values['products_name']),
		'PRODUCTS_PRICE' => $price,
		'PRODUCTS_PRICE_NOTAX' => $price_notax,
		'PRODUCTS_ITEM_PRICE' => $item_price,
		'PRODUCTS_TAX' => $tax,
		'PRODUCTS_QTY' => $order_data_values['products_quantity'],
		'PROPERTIES'=>$order_data_values['properties']
	);
	return $data;
}

$smarty = new yesSmarty;
$order_query_check = xtc_db_query("SELECT
	 distributor_id
	 FROM distributor_orders
	 WHERE distributor_orders_id='".(int)xtc_db_input($_GET['doID'])."'"
);
$order_check = xtc_db_fetch_array($order_query_check);
include(DIR_WS_CLASSES . 'distributor_order.php');
$order = new distributor_order((int)xtc_db_input($_GET['doID']));
$format_id = 5;
$smarty->assign(array(
    'ALLOW_TAX'=>$order->distributor['allow_tax'],
    'address_label_distributor'=>xtc_address_format($format_id, xtc_db_prepare_input($order->distributor), true, '', '<br />'),
    'address_label_delivery'=>xtc_address_format($format_id, xtc_db_prepare_input($order->delivery), true, '', '<br />')
));
// get products data
$order_query=xtc_db_query("SELECT
	products_id,
	distributor_orders_products_id,
	products_model,
	allow_tax,
	products_tax,
	products_name,
	final_price,
	products_quantity,
	stuecklistenartikel,
	stuecklisten_id,
	collie_qty
	 FROM distributor_orders_products 
	 WHERE distributor_orders_id='".(int)xtc_db_input($_GET['doID'])."' and stuecklisten_id=0 ORDER BY date_added DESC"
);
$order_data=array();
$order_stk_data=array();
while ($order_data_values = xtc_db_fetch_array($order_query)) {
	$collis = array();
	if($order_data_values['stuecklistenartikel'] == 1){
		$colli_query = xtc_db_query(sprintf(
			"SELECT products_id, distributor_orders_products_id, products_model, allow_tax, products_tax, products_name, final_price, products_quantity, stuecklistenartikel,stuecklisten_id,collie_qty
			 FROM distributor_orders_products WHERE stuecklisten_id=%s AND distributor_orders_id=%s",
			$order_data_values['products_id'],(int)xtc_db_input($_GET['doID'])
		));
		while($colli = xtc_db_fetch_array($colli_query)){
			$collis[] = get_print_data($colli,$order->distributor['ID'],$order->info['currency'],$order->distributor['allow_tax']);
		}
	}
	$properties = array();
	$query = xtc_db_query(sprintf(
		"SELECT property_title,property_value FROM distributor_orders_products_properties WHERE distributor_orders_products_id='%s'",
		$order_data_values['distributor_orders_products_id']
	));
	while($record = xtc_db_fetch_array($query)){
		$properties[] = $record;
	}
	$order_data_values['properties'] = $properties;
	$data = get_print_data($order_data_values,$order->distributor['ID'],$order->info['currency'],$order->distributor['allow_tax']);
	$data['collies'] = $collis;
	$order_data[] = $data;
}
$smarty->assign(array(
    'order_data' => $order_data,
    'order_stk_data' => $order_stk_data,
    'payment_terms'=>xtc_db_prepare_input($order->info['payment_terms']),
    'comments_visible'=>xtc_db_prepare_input($order->info['comments_visible'])
));    
if($order->info['estimated_date_receipt'] > 0){
    $smarty->assign('estimated_date_receipt',xtc_date_short($order->info['estimated_date_receipt']));
}
// get order_total data
$oder_total_query=xtc_db_query("SELECT
	  title,
	  text,
	  class,
	  value,
	  sort_order
	FROM distributor_orders_total
	WHERE orders_id='".$order->info['id']."'
	ORDER BY sort_order ASC"
);

$order_total=array();
while ($oder_total_values = xtc_db_fetch_array($oder_total_query)) {
	if($order->distributor['allow_tax'] == 0 and $oder_total_values['class'] == 'ot_tax')
		continue;
	$order_total[]=array(
		'TITLE' => $oder_total_values['title'],
		'CLASS'=> $oder_total_values['class'],
		'VALUE'=> $oder_total_values['value'],
		'TEXT' => $oder_total_values['text']
	);
	if ($oder_total_values['class']=='ot_total')
		$total=$oder_total_values['value'];
}
	
// assign language to template for caching
$smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
$smarty->assign('STORE_WRAP', nl2br(STORE_WRAP));
$smarty->assign('BANK', MODULE_PAYMENT_MONEYORDER_PAYTO);

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('logo_path',HTTP_SERVER.'templates/'.CURRENT_TEMPLATE.'/img/');
	
if($order->info['orders_status'] == ORDERS_STATUS_STORNIERT)
	$storno = ' <font color="red">STORNIERT</font> ';
else
	$storno = '';
$smarty->assign('oID',$_GET['doID'].$storno);
if (isset($order->info['payment_method']) and $order->info['payment_method']!='' && $order->info['payment_method']!='no_payment') {
	include(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/payment/'.$order->info['payment_method'].'.php');
	$payment_method=constant(strtoupper('MODULE_PAYMENT_'.$order->info['payment_method'].'_TEXT_TITLE'));
	$smarty->assign('PAYMENT_METHOD',$payment_method);
}
$smarty->assign('DATE',xtc_date_short($order->info['date_saved']));
$smarty->assign('order_total', $order_total);
$smarty->assign('csID',xtc_get_distributor_kundennummer($order->distributor['ID']));
$smarty->display('print_distributor_order.html');	
