<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'get_pid_image_src'){
		$listing_image = $_REQUEST['listing_image'];
		$img_base = $_REQUEST['base'];
		$text = $_REQUEST['text'];
		$im = @ImageCreateFromPNG ('images/'.$img_base); /* Versuch, Datei zu �ffnen */
		$listing_im = @ImageCreateFromGIF ('images/'.$listing_image); /* Versuch, Datei zu �ffnen */
		if($im){
		    //imagecopymerge($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $pct)
		    imagecopymerge($im, $listing_im,   1,      5,      0,      0,      10,    10,     75);
		    $black = imagecolorallocate($im, 0, 0, 0);
		    $green = imagecolorallocate($im, 0, 255, 0);
		    //#### get the width and the height of the base image
		    $width = imagesx($im);
		    $height = imagesy($im);

		    //#### Define font and text
		    $font = 'fonts/MonospaceTypewriter.ttf';
		    $fontSize = 9;
		    $angle = 0;

		    //#### calculate the left position of the text:
		    $dimensions = imagettfbbox($fontSize, $angle, $font, $text);
		    $textWidth = abs($dimensions[4] - $dimensions[0]);
		    $leftTextPos = 12;

		    //#### finally, write the string:
		    //imagestring($im, 5, $leftTextPos, $topTextPos, $text, $white);
		    imagettftext($im, $fontSize, $angle, $leftTextPos, $fontSize+5, $black, $font, $text);
		    imageAlphaBlending($im, true);
		    imageSaveAlpha($im, true);
		    Header('Content-type: image/png');
		    imagepng($im);
		    imagedestroy($im);
		}
		exit;
}
require('includes/application_top.php');
require_once(DIR_FS_INC.'xtc_generate_packingslip_barcode.inc.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'class.csv.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_FS_INC.'xtc_collis.inc.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');

if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
    require_once(DIR_WS_CLASSES.'yes_hitmeister.php');
}



$smarty = new yesSmarty;
if(is_file(DIR_WS_CLASSES.'storage.php')) require_once(DIR_WS_CLASSES.'storage.php');
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$smarty->assign(array(
	'PAGE_TITLE'=>PAGE_TITLE,
	'CLOSE_WINDOW'=>TEXT_CLOSE_WINDOW,
	'TEXT_INTRO_BESTANDSEINGABE'=>TEXT_INTRO_BESTANDSEINGABE,
	'TEXT_INTRO_BESTANDSEINGABE2'=>TEXT_INTRO_BESTANDSEINGABE2,
	'TEXT_INTRO_INVENTURMODUS'=>TEXT_INTRO_INVENTURMODUS,
	'TEXT_BESTANDSEINGABE'=>TEXT_BESTANDSEINGABE,
	'TEXT_MODUS_INVENTUR'=>TEXT_MODUS_INVENTUR,
	'TEXT_MODUS_NORMAL'=>TEXT_MODUS_NORMAL,
	'TEXT_INVENTURBESTAND'=>TEXT_INVENTURBESTAND,
	'TEXT_VALUE'=>TEXT_VALUE,
	'TEXT_COMMENTS'=>TEXT_COMMENTS,
	'IMAGE_SAVE'=>IMAGE_SAVE,
	'TEXT_PRODUCT_IS_SET'=>TEXT_PRODUCT_IS_SET,
	'TEXT_QTY_PHYSICAL'=>TEXT_QTY_PHYSICAL,
	'TEXT_QTY_AVAILABLE'=>TEXT_QTY_AVAILABLE,
	'TEXT_JE_SET'=>TEXT_JE_SET,
	'TEXT_CALCULATED_SETS'=>TEXT_CALCULATED_SETS,
	'TEXT_SQ_PHYSICAL'=>TEXT_SQ_PHYSICAL,
	'TEXT_SQ_AV1'=>TEXT_SQ_AV1,
	'TEXT_SQ_AV2'=>TEXT_SQ_AV2,
	'TEXT_SQ_ORDERS'=>TEXT_SQ_ORDERS,
	'TEXT_SQ_BEWEGUNGSDATEN'=>TEXT_SQ_BEWEGUNGSDATEN,
	'TEXT_SQ_PLANNED'=>TEXT_SQ_PLANNED,
	'TEXT_SQ_STATS'=>TEXT_SQ_STATS,
	'TEXT_SQ_PHYSICAL_MAINSTORAGE'=>TEXT_SQ_PHYSICAL_MAINSTORAGE,
	'TEXT_SQ_TOTAL'=>TEXT_SQ_TOTAL,
	'TEXT_SQ_PHYSICAL_BRANCHES'=>TEXT_SQ_PHYSICAL_BRANCHES,
	'TEXT_SQ_NOT_SHIPPED'=>TEXT_SQ_NOT_SHIPPED,
	'TEXT_SQ_ORDERS_TOTAL'=>TEXT_SQ_ORDERS_TOTAL,
	'TEXT_SQ_AT_EBAY'=>TEXT_SQ_AT_EBAY,
	'TEXT_SQ_AT_AMAZON'=>TEXT_SQ_AT_AMAZON,
	'TEXT_SQ_RECLAMATIONS'=>TEXT_SQ_RECLAMATIONS,
	'TEXT_SQ_BEWEGUNGSDATEN_TOTAL'=>TEXT_SQ_BEWEGUNGSDATEN_TOTAL,
	'TEXT_SQ_RESERVED'=>TEXT_SQ_RESERVED,
	'TEXT_SQ_DISTRIBUTOR_ORDERS'=>TEXT_SQ_DISTRIBUTOR_ORDERS,
	'TEXT_SQ_4_WEEKS'=>TEXT_SQ_4_WEEKS,
	'TEXT_SQ_3_MONTH'=>TEXT_SQ_3_MONTH,
	'TEXT_SQ_LB_FROM'=>TEXT_SQ_LB_FROM,
	'TEXT_SQ_LB_ESTIMATED'=>TEXT_SQ_LB_ESTIMATED,
	'TEXT_SQ_LB_NO_ESTIMATED'=>TEXT_SQ_LB_NO_ESTIMATED,
	'JS_ERROR_PLEASE_COMMENT'=>JS_ERROR_PLEASE_COMMENT,
	'JS_ERROR_INCORRECT_INPUT'=>JS_ERROR_INCORRECT_INPUT,
	'JS_ERROR_INCORRECT_STORAGENUMBER'=>JS_ERROR_INCORRECT_STORAGENUMBER,
	'JS_SQ_MESSAGE_QTY_PRODUCTS_MINUS'=>JS_SQ_MESSAGE_QTY_PRODUCTS_MINUS,
	'JS_SQ_MESSAGE_QTY_PRODUCTS_PLUS'=>JS_SQ_MESSAGE_QTY_PRODUCTS_PLUS,
	'JQUERY_SOURCE'=>yes_get_cdn_link('jquery', '1.9.1')
));
  
$admin_access = main::get_admin_access();


if(isset($_SESSION['bestandsinfo_message']) and is_array($_SESSION['bestandsinfo_message']) and sizeOf($_SESSION['bestandsinfo_message'])>0){
	$smarty->assign('message',implode('<br />',$_SESSION['bestandsinfo_message']));
	unset($_SESSION['bestandsinfo_message']);
}

// BESTANDSEINGABE BEI INVENTUR
if(!isset($_SESSION["quantity_inputmode"])) $_SESSION["quantity_inputmode"] = 'normal';
if(isset($_GET["input_mode"]) and xtc_not_null($_GET["input_mode"])){
	$_SESSION["quantity_inputmode"] = $_GET["input_mode"];
}
  
$ministats_allowed_stats_orders_status = array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET);
if(isset($_GET['action'])){
	switch ($_GET['action']) {
            case 'get_staffelpreise':
                $pID = (int)xtc_db_input($_GET['pID']);
                $cs = (int)xtc_db_input($_GET['cs']);
                $country_id = (int)xtc_db_input($_GET['country_id']);
                $product = new product($pID);
                $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                    $cs, $pID
                );
                $staffel = [];
                $xtPrice = new xtcPrice(DEFAULT_CURRENCY, $cs);
                $tc = yes_eu_oss_get_products_tax_class_id($pID, $country_id);
                // BUGF_CH_OSS
                $xtPrice->setCountryZone($country_id);
                
                foreach($group_prices_items as $GPI){
                    $record = $GPI->toArray();
                    $_stp = $xtPrice->xtcGetPrice($pID, false, $GPI->quantity);
                    $stp = $xtPrice->xtcFormat($_stp, true, $tc);
                    $record['personal_offer_formatted'] = $stp;
                    $staffel[] = $record;
                }
                die(json_encode(array(
                    'STAFFELPREISE'=>$staffel
                )));
                exit;
                break;
            case 'price_timings':
                include('products_price_timings.php');
                exit;
                break;
            case 'group_prices_view':
                require_once(DIR_FS_INC.'xtc_oe_get_price_i_tax.inc.php');
		$pID = (int)xtc_db_input($_GET['pID']);
                $product = new product($pID);
                $customers_statuses = xtc_get_customers_statuses();
                $group_prices = array();
                foreach($customers_statuses as $cs){
                    if($cs['id'] == 0){
                        continue;
                    }
                    $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                        $cs['id'],$pID
                    );
                    $prices = array();
                    foreach($group_prices_items as $GPI){
                        $prices[] = $GPI->toArray();
                    }
                    foreach($prices as $record){
                        $xtPrice = new xtcPrice(DEFAULT_CURRENCY, $cs['id']);
                        $record['personal_offer_brutto'] = $xtPrice->xtcFormat(
                            xtc_oe_get_price_i_tax($record['personal_offer'], 
                                $product->info['products_tax_class_id'], 
                                true
                            ), 
                            true
                        );
                        $group_prices[ $cs['text'] ][] = $record;
                    }
                }
                $smarty->assign(array(
                    'GROUP_PRICES'=>$group_prices
                ));
                $smarty->display('templates/products_group_prices.tpl');
                exit;
                break;
	    case 'get_barcode_src':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$mode = (isset($_REQUEST['mode']) and $_REQUEST['mode'] == 'ean') ? 'ean' : 'products_id';
		if(!defined('USE_BARCODE_PRODUCTS_ID') or USE_BARCODE_PRODUCTS_ID != 'True'){
		    $query = xtc_db_query(sprintf(
			    "SELECT products_ean FROM %s WHERE products_id='%s' AND products_ean != ''",
			    TABLE_PRODUCTS,$pID
		    ));
		    if(!xtc_db_num_rows($query)){
				die('pID doesnt exists or has no EAN');
		    }
		    $record = xtc_db_fetch_array($query);
			$pID = $record['products_ean'];
		}
		$barcode_file_name = 'PBC_'.$pID.'.png';
		$path_to_save_barcode = \main::get_exportdata_path().$barcode_file_name;
		if(is_file($path_to_save_barcode)){
			unlink($path_to_save_barcode);
		}
		$barcode_filename = xtc_generate_packingslip_barcode($pID, $path_to_save_barcode, false);
		$image = imagecreatefrompng($path_to_save_barcode);
		// Das Bild an den Browser ausgeben
		header('Content-Type: image/png');
		imagepng($image);
		exit;
		
		break;
	    case 'print_label':
            $gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$product = new product($pID);
            $allocs = \YES4Trade\Model\groups_products::get_by_products_id($pID);
			$data = array();
			foreach($allocs as $alloc){
                    foreach($gh->groups as $g){
                        if($g['groups_id'] == $alloc->groups_id){
                            $product->info['groups'][ $group['groups_title'] ] = 
                                    $product->get_group_allocations_data($group['id'], $_SESSION['languages_id']);
                        }
                    }
			}
			$xtPrice = new xtcPrice($_SESSION['currency'],$_SESSION['customers_status']['customers_status_id']);
			if(PRICE_IS_BRUTTO == 'true'){
				$product_price = $xtPrice->xtcGetPrice($pID,
				$format=true,
				1,
				$product->info['products_tax_class_id'],
				$product->info['products_price']
				);
				$product_price = str_replace('<font size="-1" color="#ff0000">','',$product_price);
				$product_price = str_replace('</font>','',$product_price);
				$product->info['price'] = $product_price;
			}else{
				$product->info['price'] = $xtPrice->xtcFormat($product->info['products_price'],true);
			}
			if(!defined('USE_BARCODE_PRODUCTS_ID') or USE_BARCODE_PRODUCTS_ID != 'True'){
				$code = $pID;
			}else{
				$code = ($product->info['products_ean'] != '') ? $product->info['products_ean']:$pID;
			}
			$barcode_file_name = 'PBC_'.$code.'.png';
			$path_to_save_barcode = \main::get_exportdata_path().$barcode_file_name;
			if(is_file($path_to_save_barcode)){
				unlink($path_to_save_barcode);
			}
			$barcode_filename = xtc_generate_packingslip_barcode($code, $path_to_save_barcode, false);
			$product->info['barcode_src'] = HTTPS_CATALOG_SERVER.'admin/barcode.php?action=get_barcode_src&code='.$code;
		
		$smarty->clear_all_assign();
		$smarty->assign($product->info);
		$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/product_label.html');
		exit;
		break;
	    case 'get_pid_image':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$product = new product($pID);
		$img_base = ($product->info['products_listing_status'] == 0) ? 'pid_red.png' : 'pid_green.png';
		$listing_image = ($product->info['products_status'] == 0) ? 'icon_status_red.gif' : 'icon_status_green.gif';
		$alt = ($product->info['products_status'] == 0) ? TEXT_PRODUCTS_IMG_STATUS_INACTIVE : TEXT_PRODUCTS_IMG_STATUS_ACTIVE;
		$alt .= ($product->info['products_listing_status'] == 0) ? TEXT_PRODUCTS_IMG_LISTING_STATUS_INACTIVE : TEXT_PRODUCTS_IMG_LISTING_STATUS_ACTIVE;
		printf('<img src="products.php?action=get_pid_image_src&text=%s&base=%s&listing_image=%s" border="0" alt="%s" title="%s" />',$pID,$img_base,$listing_image,$alt,$alt);
		break;
	    case 'save_pc':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$gID = (int)xtc_db_input($_REQUEST['groups_id']);
                $gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
                $allocateds = \YES4Trade\Model\groups_products_characteristics::get_by_products_id($pID);
		if(isset($_REQUEST['pc'])){
		    foreach($_REQUEST['pc'] as $pcID=>$pcsID){
			$pcID = (int)xtc_db_input($pcID);
			$pcsID = (int)xtc_db_input($pcsID);
                        foreach($gh->groups as $g){
                            if($g['groups_id'] != $gID){
                                continue;
                            }
                            foreach($g['characteristics'] as $gc){
                                if($gc['products_characteristic_id'] != $pcID){
                                    continue;
                                }
                                foreach($gc['sets'] as $gcset){
                                    foreach($allocateds as $alloc){
                                        if($alloc->products_characteristic_set_id == $gcset['products_characteristic_set_id']){
                                            \YES4Trade\Model\groups_products_characteristics::delete($alloc->products_to_characteristics_id);
                                        }
                                    }
                                }
                            }
                        }
			if($pcsID > 0){
                            $new_gpc = new \YES4Trade\Model\groups_products_characteristics([
				'products_id'=>$pID,
				'products_characteristic_set_id'=>$pcsID
                            ]);
                            $new_gpc->create();
			}
		    }
		}
		if(isset($_REQUEST['pctv'])){
                    $allocs = \YES4Trade\Model\groups_characteristic_text_values::get_by_products_id($pID);
		    foreach($allocs as $alloc){
		            \YES4Trade\Model\groups_characteristic_text_values::delete($alloc->products_characteristic_text_values_id);
		    }
		    foreach($_REQUEST['pctv'] as $pcID=>$data){
			$pcID = (int)xtc_db_input($pcID);
			$has_value = false;
			$languages = xtc_get_languages();
			foreach($languages as $lang){
			    if($data[ $lang['id'] ] != ''){
				$has_value = true;
                            }
			}
			if(!$has_value) {
                            continue;
                        }
			foreach($languages as $lang){
                            $new_gctv = new \YES4Trade\Model\groups_characteristic_text_values([
				'products_id'=>$pID,
				'products_characteristic_id'=>$pcID,
				'content'=> yes_decode_string(xtc_db_prepare_input($data[$lang['id']])),
				'language_id'=>(int)$lang['id']
                            ]);
                            $new_gctv->create();
			}
		    }
		}
		die(json_encode(array(
		    'MSG'=>''
		)));
		break;
	    case 'get_characteristics':
                $gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$gID = (int)xtc_db_input($_REQUEST['groups_id']);
                $allocs = \YES4Trade\Model\groups_products::get_by_products_id($pID);
                $products_set_allocations = \YES4Trade\Model\groups_products_characteristics::get_by_products_id($pID);
                $unique = [];
		foreach($allocs as $alloc){
                    unset($gc);
                    foreach($gh->groups as $g){
                        if($g['groups_id'] == $gID){
                            $group = $g;
                        }
                    }
                    
                    foreach($gh->groups as $g){
                        if($g['groups_id'] != $gID){
                            continue;
                        }
                        foreach($g['characteristics'] as $group_characteristic){
                            $default_value = 0;
                            switch($group_characteristic['no_sets']){
                                case 0:
                                    $values = array(array('id'=>'','text'=>TEXT_SELECT));
                                    foreach($group_characteristic['sets'] as $gcset){
                                        $values[] = array(
                                            'id' => $gcset['products_characteristic_set_id'],
                                            'text'=>$gcset['description']['title']
                                        );
                                        if((int)$default_value == 0){
                                            foreach($products_set_allocations as $psa){
                                                if($psa->products_characteristic_set_id == $gcset['products_characteristic_set_id']){
                                                    $default_value = $gcset['products_characteristic_set_id'];
                                                }
                                            }
                                        }
                                    }
                                    $input = xtc_draw_pull_down_menu('pc['.$group_characteristic['products_characteristic_id'].']',$values,$default_value);
                                    break;
                                case 1:
                                    $languages = xtc_get_languages();
                                    $input = array();
                                    foreach($languages as $lang){
                                        $text_value = \YES4Trade\Model\groups_characteristic_text_values::get_by_characteristic_id_and_products_id($group_characteristic['products_characteristic_id'], $pID, $lang['id']);
                                        if(!empty($text_value->content)){
                                            $default_value = yes_encode_string(xtc_db_prepare_input($text_value->content));
                                        }else{
                                            $default_value = '';
                                        }
                                        $input[ $lang['name'] ] = xtc_draw_input_field('pctv['.$group_characteristic['products_characteristic_id'].']['.$lang['id'].']',$default_value,'style="width:80%;"');
                                    }
                                    break;
                            }
                            if(!isset($unique[ $group_characteristic['products_characteristic_id'] ])){
                                $data[] = array(
                                    'title'=>$group_characteristic['description']['title'],
                                    'pcID'=>$group_characteristic['products_characteristic_id'],
                                    'input'=>$input,
                                    'visible'=>$group_characteristic['visible'],
                                    'ebay_visible'=>$group_characteristic['ebay_visible'],
                                );
                                $unique[ $group_characteristic['products_characteristic_id'] ] = true;
                            }
                        }
                    }
		}
                
		foreach($data as $k=>$v){
		    $data[$k]['title'] = yes_encode_string($v['title']);
		    if(!is_array($data[$k]['input'])){
			$data[$k]['input'] = yes_encode_string($v['input']);
                    }
		}
		header('Content-Type: text/html; charset='.CHARSET);
		echo json_encode(array(
		    'MSG'=>'',
		    'data'=>$data
		));
		exit;
		break;
	    case 'delete_groups_allocation':
                $gID = (int)xtc_db_input($_REQUEST['groups_id']);
		foreach($_REQUEST['pID'] as $rpID){
		    $pID = (int)xtc_db_input($rpID);
                    \YES4Trade\Model\groups_products::delete($gID, $pID);
		}
		die(json_encode(array(
		    'MSG'=>''
		)));
		exit;
		break;
	    case 'save_groups_allocation':
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$gID = (int)xtc_db_input($_REQUEST['groups_id']);
                $exists = \YES4Trade\Model\groups_products::allocation_exists($pID, $gID);
		if($exists){
		    header('Content-Type: text/html; charset='.CHARSET);
		    die(json_encode(array(
			'MSG'=>MSG_ERROR_SAVE_GROUPS_ALLOCATION_EXISTS
		    )));
		}
                $new = new \YES4Trade\Model\groups_products([
		    'groups_id'=>$gID,
		    'products_id'=>$pID
                ]);
                $new->create();
		header('Content-Type: text/html; charset='.CHARSET);
                $GH = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
                foreach($GH->groups as $g){
                    if($g['groups_id'] == $gID){
                        $title = yes_encode_string($g['groups_title']);
                    }
                }
		die(json_encode(array(
		    'MSG'=>'',
		    'TITLE'=>$title,
		)));
		break;
	    case 'groups_allocation':
                require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$GH = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
		$input_groups = array(array('id'=>'','text'=>TEXT_SELECT));
		foreach($GH->groups as $group){
		    $input_groups[] = array(
			'id'=>$group['groups_id'],
			'text'=>$group['groups_title']
		    );
		}
                $groups = xtc_get_product_groups($pID,true);
		$smarty->assign(array(
		    'INPUT_GROUPS'=>xtc_draw_pull_down_menu('groups_id',$input_groups),
		    'PRODUCTS_ID'=>$pID,
		    'GROUPS'=>$groups,
		    'add_to_group_text'=>TEXT_PRODUCT_GROUPS_ADD,
		    'add_to_group_submit'=>IMAGE_SAVE,
		    'text_delete_group'=>TEXT_PRODUCT_GROUPS_REMOVE,
		    'text_view_characteristics'=>TEXT_PRODUCT_GROUPS_EDIT_CHARACTERISTICS,
		    'image_save'=>TEXT_PRODUCT_GROUPS_SAVE_CHARACTERISTICS,
		    'text_characteristics'=>TEXT_PRODUCT_GROUPS_CHARACTERISTICS,
		    'text_product_groups'=>TEXT_PRODUCT_GROUPS_ALLOCATION,
		    'TEXT_PRODUCT_GROUPS_INVISIBLE'=>TEXT_PRODUCT_GROUPS_INVISIBLE,
		    'TEXT_PRODUCT_GROUPS_VISIBLE'=>TEXT_PRODUCT_GROUPS_VISIBLE,
		    'TEXT_PRODUCT_GROUPS_EBAY_INVISIBLE'=>TEXT_PRODUCT_GROUPS_EBAY_INVISIBLE,
		    'TEXT_PRODUCT_GROUPS_EBAY_VISIBLE'=>TEXT_PRODUCT_GROUPS_EBAY_VISIBLE,
		    'TEXT_GROUPS_INVISIBLE'=>TEXT_GROUPS_INVISIBLE,
		    'TEXT_GROUPS_VISIBLE'=>TEXT_GROUPS_VISIBLE,
		    'TEXT_GROUPS_EBAY_INVISIBLE'=>TEXT_GROUPS_EBAY_INVISIBLE,
		    'TEXT_GROUPS_EBAY_VISIBLE'=>TEXT_GROUPS_EBAY_VISIBLE
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('products_groups.html');
		exit;
		break;
	    case 'history_bestand':
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
		$history_query_raw = "select *,DATE_FORMAT(date_saved,'%d.%m.%y') as datum from history_bestand where products_id='".$pID."' AND source='direct' order by date_saved desc";
		$historys = array();
		$history_split = new splitPageResults( $_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $history_query_raw, $history_query_numrows);
		$history_query = xtc_db_query($history_query_raw);
		if(!xtc_db_num_rows($history_query)){
		    die('Keine weitere Bestandseingabe-Historie gespeichert.');
		}
		while($history = xtc_db_fetch_array($history_query) ){
		    $history['editor'] = xtc_get_editor_name($history['editor_id']);
		    printf('<li style="list-style-type: none;color: #999;font-family: monospace;font-size: 11px;">%s durch %s %s Stk.</li>',
			    $history['datum'],$history['editor'],$history['quantity_change']
		    );
		}
		break;
	    case 'stats_price':
			$basics = new basics;
			$stats = array();
			$items = array();
			$where = '';
			if(isset($_REQUEST['from'])){
				$where = sprintf("AND o.date_purchased>'%s' ",xtc_db_input($_REQUEST['from']));
			}
			if(isset($_REQUEST['to'])){
				$where = sprintf("AND o.date_purchased<'%s' ",xtc_db_input($_REQUEST['to']));
			}
			$query = xtc_db_query(
				"SELECT products_price,products_id,products_tax FROM `orders_products`  LEFT JOIN orders o USING(orders_id) WHERE o.orders_status !=7 $where"
			);
			$tax = array();
			while($record = xtc_db_fetch_array($query)){
				if($record['products_tax']>0){
					if(!isset($tax[$record['products_tax']]))
						$tax[$record['products_tax']] = ( (100+ $record['products_tax']) / 100);
					$record['products_price'] = $record['products_price'] / $tax[$record['products_tax']];
				}
				if(!isset($items[ $record['products_id'] ])){
					$items[ $record['products_id'] ] = array(
						'counter'=>0,
						'price'=>0
					);
				}
				$items[ $record['products_id'] ]['counter'] += 1;
				$items[ $record['products_id'] ]['price'] += $record['products_price'];
			}
			foreach($items as $pID => $item){
				$stats[$pID]['avg'] = $item['price']/$item['counter'];
			}
			
			
			$items = array();
			$query = xtc_db_query(
				"SELECT products_price,products_id,products_tax,products_quantity FROM `orders_products`  LEFT JOIN orders o USING(orders_id) WHERE o.orders_status !=7 $where"
			);
			$tax = array();
			$db_res = array();
			while($record = xtc_db_fetch_array($query)){
				$db_res[] = $record;
			}
			foreach($db_res as $record){
				if($record['products_tax']>0){
					if(!isset($tax[$record['products_tax']]))
						$tax[$record['products_tax']] = ( (100+ $record['products_tax']) / 100);
					$record['products_price'] = $record['products_price'] / $tax[$record['products_tax']];
				}
				if(!isset($items[ $record['products_id'] ]['min'])){
					$items[ $record['products_id'] ]['min'] = $record['products_price'];
				}
				if($items[ $record['products_id'] ]['min'] > $record['products_price']){
					$items[ $record['products_id'] ]['min'] = $record['products_price'];
				}
				if(!isset($items[ $record['products_id'] ]['max'])){
					$items[ $record['products_id'] ]['max'] = $record['products_price'];
				}
				if($items[ $record['products_id'] ]['max'] < $record['products_price']){
					$items[ $record['products_id'] ]['max'] = $record['products_price'];
				}
				if(!isset($items[ $record['products_id'] ]['qty'])){
					$items[ $record['products_id'] ]['qty'] = 0;
				}
				$items[ $record['products_id'] ]['qty'] += $record['products_quantity'];
			}
			foreach($items as $pID => $item){
				$stats[$pID]['min'] = $item['min'];
				$stats[$pID]['max'] = $item['max'];
				$stats[$pID]['qty'] = $item['qty'];
			}
			$buffer = implode(';',array('pID','Durchschnitt','MIN Preis','MAX Preis','Verkauft'))."\r\n";
			foreach($stats as $pID=>$s){
				$buffer .= sprintf("%s\r\n",implode(';',array($pID,$s['avg'],$s['min'],$s['max'],$s['qty']) ) );
			}
			// create File
			
			$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
			$filename = sprintf('products_price_stats_%s.csv',$crypt_file);
			$filepath = \main::get_exportdata_path();
			$basics->create_file($filepath.$filename,$buffer);
			$basics->zip_file($filepath,$filename,$filename.'.zip',true);

			$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
			unlink($filepath.$filename.'.zip');
			// send File to Browser
			$file = 'products_price_stats_'.date('Y-m-d_H_i_s').'.zip';
			header('Content-Type: application/octet-stream');
			header('Content-Transfer-Encoding: binary');
			header('Content-disposition: attachment; filename=' . $file);
			echo $file_contents;
			exit;
			break;
		case 'allocate_untransferred_process':
                        if(!isset($_REQUEST['target_spID'])){
                            if(isset($_REQUEST['return_url']) and $_REQUEST['return_url'] != ''){
                                die(json_encode(array(
                                    'MSG'=>'Invalid data'
                                )));
                            }
                            $_SESSION['bestandsinfo_message'] = array(
                                    'Invalid data'
                            );
                        }
			$target_spID = (int)xtc_db_input($_REQUEST['target_spID']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$SQ = new products_quantity($pID);
			$stp = new storage_product($target_spID);
			$untransferred = $SQ->get_untransferred();
			$qty = (int)xtc_db_input($_REQUEST['quantity']);
			if($qty <= 0 or $qty > $SQ->get_untransferred()){
				$_SESSION['bestandsinfo_message'] = array(
					sprintf(MSG_ERROR_QUANTITY_NOT_ALLOWED,$SQ->get_untransferred())
				);
			}else{
				if($stp->add_quantity($qty)){
					$_SESSION['bestandsinfo_message'] = array(
						sprintf(MSG_SUCCESS_ALLOCATE_UNTRANSFERRED,$qty)
					);
				}
			}
                        if(isset($_REQUEST['return_url']) and $_REQUEST['return_url'] != ''){
                            die(json_encode(array(
                                'MSG'=>$_SESSION['bestandsinfo_message']
                            )));
                        }
			xtc_redirect(xtc_href_link('products.php',xtc_get_all_get_params(array('action')).'action=bestand'));
			exit;
			break;
		case 'allocate_untransferred':
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$SQ = new products_quantity($pID);
                        $SP = array();
			$untransferred = $SQ->get_untransferred();
			$storage_places = array();
			$query = xtc_db_query(sprintf(
				"SELECT id,storage_id,quantity,storage_places_id FROM storage_products WHERE products_id='%s' ORDER BY priority",
				$pID
			));
			while($row = xtc_db_fetch_array($query)){
			    $storage_places[] = $row;
			}
			foreach($storage_places as $row){
				if($row['storage_places_id'] > 0){
				    $row['storage_place'] = yes_get_storage_place_title($row['storage_places_id']);
				}
				$storage = yes_get_storage_info($row['storage_id']);
				$stammlager = '';
				if($storage['default_storage'] == 'y'){
					$stammlager = ' Stammlager';
				}
				$SP[] = array('id'=>$row['id'],
					'text'=>$storage['name'].' / '.$row['storage_place'].$stammlager
				);
			}
			header('Content-Type: text/html; charset='.CHARSET);
                        $hidden = '';
                        if(!strstr($_SERVER['HTTP_REFERER'],basename(__FILE__))){
                            $hidden = xtc_draw_hidden_field('return_url',urlencode($_SERVER['HTTP_REFERER']));
                        }
			$smarty->assign(array(
                            'FORM'=>xtc_draw_form('unallocated','products.php',xtc_get_all_get_params(array('action')).'action=allocate_untransferred_process','post','onsubmit="return check_unallocated();"'),
                            'TEXT_INTRO'=>sprintf(TEXT_ALLOCATE_TO_STORAGE_PLACE_INTRO,$untransferred),
                            'TEXT_ALLOCATE_TO_STORAGE_PLACE'=>TEXT_ALLOCATE_TO_STORAGE_PLACE,
                            'INPUT_TARGET_SPID'=>xtc_draw_pull_down_menu('target_spID',$SP),
                            'TEXT_QUANTITY'=>TEXT_QUANTITY,
                            'INPUT_QUANTITY'=>xtc_draw_input_field('quantity',$SQ->get_untransferred(),'size="8" maxlength="8"'),
                            'IMAGE_CONFIRM'=>IMAGE_CONFIRM,
                            'INPUT_HIDDEN'=>$hidden
                        ));
                        $smarty->display('products_storage_transfer_untransferred.tpl');
			exit;
			break;
		case 'save_storage_place_transfer':
			require_once(DIR_WS_CLASSES.'storage.php');
			$spID = (int)xtc_db_input($_REQUEST['source_spID']);
			$sp = new storage_product($spID);
			if($sp->getProducts_id() < 1){
				die(json_encode(array(
					'ERROR'=>MSG_ERROR_STORAGE_PLACE_NOT_FOUND
				)));
			}
			$SQ = new products_quantity($sp->getProducts_id());
			$untransferred = $SQ->get_untransferred();
			$target_spID = (int)xtc_db_input($_REQUEST['target_spID']);
			$source_storage_qty = $sp->getQuantity();
			$spt = new storage_products_transfer($spID,$target_spID);
			if(!$spt->transfer( (int)xtc_db_input($_REQUEST['quantity']),$source_storage_qty)){
				die(json_encode(array(
					'ERROR'=>$untransferred.':'.$source_storage_qty.':'.sprintf(JS_ERROR_SP_TRANSFER_ERROR,$untransferred+$source_storage_qty)
				)));
			}
			$_SESSION['bestandsinfo_message'] = array(
				sprintf(MSG_SUCCESS_QUANTITY_TRANSFERRED,$_REQUEST['quantity'])
			);
			die(json_encode(array(
				'ERROR'=>''
			)));
			break;
		case 'sp_transfer':
			$SQ = new products_quantity((int)xtc_db_input($_REQUEST['pID']));
			$query = xtc_db_query(sprintf(
				"SELECT id,storage_id,quantity,storage_places_id FROM storage_products WHERE products_id='%s' ORDER BY priority",
				(int)xtc_db_input($_REQUEST['pID']),(int)xtc_db_input($_REQUEST['spID'])
			));
			$transfer_from = array();
			$transfer_to = array();
			while($row = xtc_db_fetch_array($query)){
			    if($row['storage_places_id'] > 0){
				$row['storage_place'] = yes_get_storage_place_title($row['storage_places_id']);
			    }
				$storage = yes_get_storage_info($row['storage_id']);
				if($row['id'] == $_REQUEST['spID']){
					$transfer_from = $row;
				}else{
					$transfer_to[] = $row;
				}
			}
                        $success_function = (isset($_GET['success_function'])) ? $_GET['success_function'] : '';
			$scs_link = (isset($_REQUEST['json'])) ? '' : xtc_href_link('products.php',  xtc_get_all_get_params(array('action')).'action=bestand');
			$smarty->assign(array(
				'SOURCE'=>$transfer_from,
				'TARGETS'=>$transfer_to,
				'TARGETS_SIZE'=>sizeOf($transfer_to),
				'TEXT_NO_TARGETS_AVAILABLE'=>TEXT_NO_TARGETS_AVAILABLE,
				'TEXT_SP_TRANSFER_FROM'=>sprintf(TEXT_SP_TRANSFER_FROM,$transfer_from['storage_place']),
				'TEXT_SP_AVAILABLE'=>TEXT_SP_AVAILABLE,
				'TEXT_SP_TRANSFER_QTY'=>TEXT_SP_TRANSFER_QTY,
				'TEXT_SP_TRANSFER_TO'=>TEXT_SP_TRANSFER_TO,
				'JS_ERROR_SP_TRANSFER_ERROR'=>JS_ERROR_SP_TRANSFER_ERROR,
				'UNTRANSFERRED'=>$stammlager['untransferred'],
				'TEXT_UNTRANSFERRED_ITEMS'=>sprintf(TEXT_UNTRANSFERRED_ITEMS,$stammlager['untransferred']),
				'SUCCESS_LINK'=>$scs_link,
                            'SUCCESS_FUNCTION'=>$success_function
			));
                        header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('products_storage_transfer.html');
			exit;
			break;
		case 'history':
			if($admin_access['f_products_history'] == '1'){
			    $mode = (isset($_REQUEST['mode']) and in_array($_REQUEST['mode'],array('','bestand','storage_transfer','branch'))) ? $_REQUEST['mode'] : '';
			    $modes = array(
				array('id'=>'','text'=>TEXT_HISTORY_BESTAND_MODE_HISTORY),
				array('id'=>'bestand','text'=>TEXT_HISTORY_BESTAND_MODE_BESTAND),
				array('id'=>'storage_transfer','text'=>TEXT_HISTORY_BESTAND_MODE_STORAGE_TRANSFER),
			    );
                            if(defined('YES_BRANCHES_COUNT') and YES_BRANCHES_COUNT > 0){
                                    $modes[] = array(
                                    'id'=>'branch','text'=>TEXT_HISTORY_BESTAND_MODE_BRANCH
                                );
                            }
			    $history_array = array();
			    $pID = (int)xtc_db_input($_REQUEST['pID']);
                            $do_ph_sql =false;
			    switch($mode){
				case 'branch':
                                    $products_history_query = xtc_db_query(sprintf(
                                            "SELECT btp.products_quantity, btp.quantity_transfer,bt.branches_id, bt.target_branches_id, bt.date_created, btsh.branches_transfer_status_id,btsh.comments, btsh.date_added, btsh.editor_id "
                                            . "FROM branches_transfer_status_history btsh " 
                                            . "LEFT JOIN branches_transfer bt USING(branches_transfer_id) "
                                            . "LEFT JOIN branches_transfer_products btp USING(branches_transfer_id) "
                                            . "WHERE products_id='%s' ORDER BY btsh.date_added ",
                                            $pID
                                    ));
                                    $hist = array();
                                    while($record = xtc_db_fetch_array($products_history_query)){
                                           $hist[] = $record;
                                    }
        /**
         * @todo:
         * AUS DEN ERGEBNISSEN DAS history_array ERSTELLEN
         */
                                    $do_ph_sql = false;
				    break;
				case 'storage_transfer':
                                    $products_history_query = xtc_db_query(sprintf(
                                            "SELECT DATE_FORMAT(spt.date_added,'%%d.%%m.%%Y - %%H:%%i:%%s') as datum, sp.storage_id,spt.* FROM storage_products sp LEFT JOIN storage_products_transfer spt ON spt.source_storage_products_id=sp.id OR spt.target_storage_products_id=sp.id WHERE sp.products_id='%s' ORDER BY date_added DESC",
                                            $pID
                                    ));
                                    $hist = array();
                                    while($record = xtc_db_fetch_array($products_history_query)){
                                        $hist[] = $record;
                                    }
                                    foreach($hist as $record){
                                        switch($record['source_storage_products_id']){
                                            case 0:
                                                $src = TEXT_STAMMLAGER;
                                                break;
                                            default:
                                                $sp_query = xtc_db_query(sprintf(
                                                        "SELECT storage_id,storage_places_id FROM storage_products WHERE id='%s'",
                                                        $record['source_storage_products_id']
                                                ));
                                                $sp_record = xtc_db_fetch_array($sp_query);
                                                $src = xtc_get_storage_name($sp_record['storage_id']);
                                                if($sp_record['storage_places_id'] > 0){
                                                    $src .= ' LP '.yes_get_storage_place_title($sp_record['storage_places_id']);
                                                }
                                        }
                                        switch($record['target_storage_products_id']){
                                            case 0:
                                                $trgt = TEXT_STAMMLAGER;
                                                break;
                                            case -1:
                                                $trgt = $record['reason_subclass'];
                                                break;
                                            case -2:
                                                $trgt = sprintf('%s (%s %s)',
                                                        $record['reason_subclass'],
                                                        $record['reason_class'],
                                                        $record['reason_id']
                                                );
                                                break;
                                            default:
                                                $sp_query = xtc_db_query(sprintf(
                                                        "SELECT storage_id,storage_places_id FROM storage_products WHERE id='%s'",
                                                        $record['target_storage_products_id']
                                                ));
                                                $sp_record = xtc_db_fetch_array($sp_query);
                                                $trgt = xtc_get_storage_name($sp_record['storage_id']);
                                                if($sp_record['storage_places_id'] > 0){
                                                    $trgt .= ' LP '.yes_get_storage_place_title($sp_record['storage_places_id']);
                                                }
                                        }
                                        $text = sprintf('%s Stk von &raquo;%s %s&laquo; auf &raquo;%s&laquo;',
                                                $record['quantity'],
                                                TEXT_STORAGE, 
                                                $src,
                                                $trgt
                                        );
                                        $history_array[] = array(
                                            'datum'=>$record['datum'],
                                            'hist'=>$text,
                                            'editor_id'=>$record['editor'],
                                        );
                                    }
				    break;
				case 'bestand':
				    $table = 'history_bestand';
				    $comments_field = 'title';
                                    $date_from_field = 'date_saved';
				    $index_field = 'id';
                                    $editor_field = 'editor_id';
                                    $do_ph_sql =true;
				    break;
				default:
				    $table = 'products_history';
				    $comments_field = 'comments';
                                    $date_from_field = 'date_saved';
				    $index_field = 'products_history_id';
                                    $editor_field = 'editor_id';
                                    $do_ph_sql =true;
				    break;
			    }
                            if($do_ph_sql){
                                $products_history_query = xtc_db_query(sprintf(
                                        "SELECT DATE_FORMAT(%s,'%%d.%%m.%%Y - %%H:%%i:%%s') as datum,%s,%s as hist FROM %s WHERE products_id='%s' ORDER BY %s DESC, %s DESC",
                                        $date_from_field,$editor_field,$comments_field,
                                        $table,$pID,$index_field,$date_from_field
                                ));
                                while($products_history = xtc_db_fetch_array($products_history_query)){
                                         $history_array[] = $products_history;
                                }
                            }
			    $smarty->assign(array(
				'TEXT_HISTORY_BESTAND_HEADING'=>sprintf(TEXT_HISTORY_BESTAND_HEADING,xtc_get_products_name($pID),$pID),
				'PRODUCTS_ID'=>$pID,
				'INPUT_MODES'=>xtc_draw_pull_down_menu('history_mode',$modes,$mode),
				'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
				'TEXT_HISTORY_BESTAND_EMPTY'=>TEXT_HISTORY_BESTAND_EMPTY,
				'BASELINK'=>xtc_href_link(basename(__FILE__),'pID='.$pID.'&action=history')
			    ));
			    $smarty->assign('items',$history_array);
			}
			header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('products_history.html');
			exit;
			break;
		case 'distributor_admin':
			if(!isset($_REQUEST['pID'])){
				die('Missing Parameters.');
			}
			$product = new product( xtc_db_input($_REQUEST['pID']) );
			$smarty->assign(array(
			    'PRODUCTINFO'=>$product->info,
			    'JS_ERROR_NO_DISTRIBUTOR_PRODUCTS_NUMBER'=>JS_ERROR_NO_DISTRIBUTOR_PRODUCTS_NUMBER
			));
			$distributors = $product->get_distributors($prices = true);
			foreach($distributors as $dID=>$dist_val){
			    foreach($dist_val as $dist_k=>$dval){
				if(is_array($dval)) continue;
				if(strpos($dval,'"') !== false){
				    $distributors[$dID][$dist_k] = htmlentities($dval,ENT_QUOTES,strtoupper(CHARSET));
				}
			    }
			}
			
                        $shippingtimes = xtc_get_shipping_status();
			/**
			 * WIR FUEGEN ZU JEDEM EK PREIS "SHIPPINGTIME_INPUT" ALS
			 * PULLDOWN HINZU
			 */
			for($i=0;$i<sizeOf($distributors);$i++){
                            for($j=0;$j<sizeOf($distributors[$i]['prices']);$j++){
                                $distributors[$i]['prices'][$j]['SHIPPINGTIME_INPUT'] = xtc_draw_pull_down_menu(
                                    'shipping_status_id',$shippingtimes,$distributors[$i]['prices'][$j]['shipping_status_id'],'id="shippingtime"'
                                );
                            }
			}
			$smarty->assign('DISTRIBUTORS',$distributors);

			$query = yes_db_query("SELECT id,name FROM distributors WHERE account_type='Lieferant' ORDER BY name",true);
			$distributors_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
			if(yes_db_num_rows($query)){
				foreach($query as $distributor){
					$distributors_array[] = array('id'=>$distributor['id'],'text'=>$distributor['name']);
				}
			}
			$smarty->assign('INPUT_DISTRIBUTORS',xtc_draw_pull_down_menu(
				'new_distributor_id',$distributors_array,'','id="new_distributor_id"'
			));
			header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('distributor_admin.html');
			exit;
			break;
		case 'storage_admin':
			if(!isset($_REQUEST['pID'])){
			    die('Missing params');
			}
			$product = new product( xtc_db_input($_REQUEST['pID']) );
			$smarty->assign(array(
			    'PRODUCTINFO'=>$product->info,
			    'TEXT_STORAGE_PLACES_AVAILABLE'=>TEXT_STORAGE_PLACES_AVAILABLE,
			    'TEXT_NO_STORAGE_PLACES_AVAILABLE'=>TEXT_NO_STORAGE_PLACES_AVAILABLE,
			    'TEXT_SELECT'=>TEXT_SELECT
			));
			$get_available_places = true;
			$strgs = $product->get_storages($get_available_places);
			foreach($strgs as $strgk=>$strg){
			    foreach($strg['places'] as $plck=>$plc){
				$strgs[$strgk]['places'][$plck]['storage_place'] = htmlentities(yes_encode_string(stripcslashes($plc['storage_place'])));
			    }
			}
			$smarty->assign('STORAGES',$strgs);
			$query = yes_db_query("SELECT id,name FROM storages ORDER BY name",true);
			$storages_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
			if(yes_db_num_rows($query)){
				foreach($query as $storage){
					$storages_array[] = array('id'=>$storage['id'],'text'=>$storage['name']);
				}
			}
			$smarty->assign('INPUT_STORAGES',xtc_draw_pull_down_menu(
				'new_storage_id',$storages_array,'','id="new_storage_id" onchange="get_new_storage_number(this)"'
			));
			header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('storages_admin.html');
			exit;
			break;
		case 'ajax_view':
			if(!isset($_REQUEST['pID'])){
				die('Missing parameter for products view');
			}
			$product = new product( (int)xtc_db_input($_REQUEST['pID']) );
			$product->info['packagings_info'] = $product->get_packaging_details();
			if(sizeOf($product->info['packagings_info'])){
			    $product->info['packagings_info']['weight'] = number_format($product->info['packagings_info']['weight'],4,',','.');
			    $product->info['packagings_info']['weight_brutto'] = number_format($product->info['packagings_info']['weight_brutto'],4,',','.');
			}
			if(!sizeOf($product->info)){
				die('Daten konnten nicht ermittelt werden.');
			}
			$SQ = new products_quantity($product->info['products_id']);
			$collies = $product->collies;
			if(sizeOf($collies)>0){
			    $product->info['collies'] = true;
			    $qty_available = xtc_get_product_collie_qty($product->info['products_id']);
			    $product->info['weight_brutto'] = number_format(xtc_get_ext_products_weight($product->info['products_id']),4,',','.');
			}else{
				$qty_available = $SQ->get_products_total_qty();
			}
			$product->info['products_weight'] = number_format($product->info['products_weight'],4,',','.');
			$product->info['qty_available'] = $qty_available;
			$smarty->assign('FORM_END','</form>');
			$product->info['products_tax_class'] = xtc_get_tax_class_title($product->info['products_tax_class_id']);
			$product->info['category'] = xtc_get_categories_name($product->info['categories_id'],$_SESSION['languages_id']);
			$product->info['qty_total'] = $SQ->get_gesamtbestand_qty();
			$product->info['qty_available'] = $SQ->get_available1_qty();
			$product->info['qty_available2'] = $SQ->get_available2_qty();
			$product->info['products_link'] = $product->get_edit_link();
			
			// EK/VSE
			$query = xtc_db_query(sprintf(
				"SELECT distributor_id,distributor_products_number,mindestbestellmenge FROM products_distributors WHERE products_id='%s' AND is_default=1",
				$product->info['products_id']
			));
			if(xtc_db_num_rows($query)){
				$record = xtc_db_fetch_array($query);
				$dID = $record['distributor_id'];
				$dnumber = $record['distributor_products_number'];
				$dname = xtc_get_distributor_name($dID);
				$mindestbestellmenge = $record['mindestbestellmenge'];
				$query = xtc_db_query(sprintf(
					"SELECT vpe,vpe_width,vpe_height,vpe_depth,vse,price FROM distributor_product_prices WHERE products_id='%s' AND distributor_id='%s' AND is_default=1",
					$product->info['products_id'],$dID
				));
				$record = xtc_db_fetch_array($query);
				$ek_array = array(
					'distributor_id'=>$dID,
					'price'=>number_format($record['price'],2,',','.'),
					'distributor_name'=>$dname,
					'distributor_number'=>$dnumber,
					'mindestbestellmenge'=>$mindestbestellmenge,
					'vpe'=>$record['vpe'],
					'vse'=>$record['vse'],
					'vpe_width'=>$record['vpe_width'],
					'vpe_height'=>$record['vpe_height'],
					'vpe_depth'=>$record['vpe_depth']
				);
				$smarty->assign('ek_data',$ek_array);
			}
			
			
			$dorders = array();
			$query = xtc_db_query(sprintf(
				"SELECT distributor_orders_id,products_quantity-qty_rueckbuch AS anz,date_created,estimated_date_receipt,orders_id FROM distributor_orders_products dop LEFT JOIN distributor_orders do USING(distributor_orders_id) WHERE products_id='%s' AND orders_status=%s  ORDER BY estimated_date_receipt",
				$product->info['products_id'],DISTRIBUTOR_ORDERS_STATUS_BESTELLT
			));
			while($record = xtc_db_fetch_array($query)){
				$dorders[] = $record;
			}
			if(sizeOf($dorders)){
				$smarty->assign('DISTRIBUTOR_ORDERS',$dorders);
			}
			
			// BOF LAGERPLAETZE
			$storages = array();
			$query = xtc_db_query(sprintf(
				"SELECT storage_id, storage_places_id,quantity FROM storage_products WHERE products_id='%s' ORDER BY quantity",
				$product->info['products_id']
			));
			while($record = xtc_db_fetch_array($query)){
				$storage_info = yes_get_storage_info($record['storage_id']);
				$record['name'] = $storage_info['name'];
				$storages[] = $record;
			}
			if(sizeOf($storages)){
			    foreach($storages as $stk=>$strg){
				if($strg['storage_places_id'] > 0){
				    $storages[$stk]['storage_place'] = yes_get_storage_place_title($strg['storage_places_id']);
				}
			    }
			    $smarty->assign('STORAGES',$storages);
			}
			// EOF LAGERPLAETZE
			
			// BOF filialen
			$branches_array = array();
			$branches_query = xtc_db_query("SELECT branches_id,products_quantity FROM branches_products WHERE products_id='".$product->info['products_id']."'");
			while($branches = xtc_db_fetch_array($branches_query)){
				$branches_array[] = array('branch'=>xtc_get_branch_title($branches['branches_id']),'qty'=>$branches['products_quantity'] );
			}
			if(sizeOf($branches_array)>0)
				$smarty->assign('BRANCHES',$branches_array);
			// EOF FILIALEN
			
			// BOF MINISTATS
			$ministats_years = array();
			$ministats_allowed_stats_orders_status = array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET);
			$query = xtc_db_query(sprintf(
				"SELECT DATE_FORMAT(date_purchased,'%%Y') as last FROM %s o LEFT JOIN %s op USING(orders_id) WHERE op.products_id='%s' AND o.orders_status IN(%s) ORDER BY date_purchased LIMIT 1",
				TABLE_ORDERS,
				TABLE_ORDERS_PRODUCTS,
				$product->info['products_id'],
				implode(',',$ministats_allowed_stats_orders_status)
			));
			$record = xtc_db_fetch_array($query);
			$steps = date('Y')-$record['last'];
			for($i=0;$i<=$steps;$i++){
			    $ministats_years[] = date('Y') - $steps + $i;
			}
			// EOF MINISTATS
			$man = $product->get_manufacturers_data();
			$product->info['manufacturer'] = $man['manufacturers_name'];

			$unc = '';
			$puc = \YES4Trade\Model\product_un_classification::get_by_products_id(intval($product->info['products_id']));
			if($puc !== null){
				$unc = str_replace('"','',$puc->get_un_classification_title());
			}

			$smarty->assign(array(
			    'INFO'=>$product->info,
			    'TEXT_VPE_SIZES'=>TEXT_VPE_SIZES,
			    'TEXT_DEFAULT_EK'=>TEXT_DEFAULT_EK,
			    'ministats_min'=>min($ministats_years),
			    'ministats_max'=>max($ministats_years),
			    'ministats_values'=>$ministats_years,
			    'TEXT_POPUP_QUANTITY'=>TEXT_POPUP_QUANTITY,
			    'EXT_POPUP_WIDTH'=>EXT_POPUP_WIDTH,
			    'EXT_POPUP_HEIGHT'=>EXT_POPUP_HEIGHT,
			    'TEXT_STORAGE_PLACES'=>TEXT_STORAGE_PLACES,
			    'TEXT_STORAGE_PLACE'=>TEXT_STORAGE_PLACE,
			    'TEXT_STORAGE'=>TEXT_STORAGE,
			    'TEXT_NUMBER_OF_STORAGE_PLACE_QTY'=>TEXT_NUMBER_OF_STORAGE_PLACE_QTY,
			    'TEXT_TOGGLE_STORAGE_PLACES'=>TEXT_TOGGLE_STORAGE_PLACES,
			    'TEXT_COLLIES_WEIGHT'=>TEXT_COLLIES_WEIGHT,
				'UNTRANSFERRED_STORAGE_PRODUCTS'=>$SQ->get_untransferred(),
				'EXTERNAL_STOCK'=>$SQ->get_external_stock(),
				'EXTERNAL_STOCK_DETAILS'=>$SQ->get_external_stock(true),

				'UN_CLASSIFICATIONS'=>$unc
			));
			$html=$smarty->fetch('ajax_product_info.html');
			echo $html;
			exit;
			break;
		case 'lager_save':
			if(isset($_GET['pID'])){
			    $pID = (int)xtc_db_input($_GET['pID']);
				$SQ = new products_quantity($pID,'direct');
				$sID = $SQ->get_default_storage_id();
			}

			if($_SESSION["quantity_inputmode"] == 'normal'){
				if( isset($_POST['quantity']) and $_POST['quantity']!='' ){
					$new_qty = (int)xtc_db_input($_POST['quantity']);
					$comment = $_POST['comments'];
					$SQ->addition_qty( $new_qty, $comment,$update_storage_quantity=true,'Bestandseingabe');
					xtc_redirect(xtc_href_link('products.php',xtc_get_all_get_params(array('action')).'action=bestand'));
				}
			}else{
				if($_GET['csv_mode'] == 1){
					$CSV = new CSVfile($_FILES['ifile']['tmp_name']);
					$CSV->delimiter = "\t";
					$CSV->open('r');
					while($row = $CSV->readRow()){
						$pID = (int)$row[0];
						$inv_qty = (int)$row[1];
						$collis = xtc_get_product_collies($pID);
						if($pID <= 0 or $inv_qty < 0 or sizeOf($collies)>0){
							continue;
						}
						$SQ = new products_quantity($pID);
						$sID = $SQ->get_default_storage_id();
						$qty = $SQ->get_products_total_qty();
						$new_qty = $inv_qty;
						$comment = '[CSV INVENTUR: '.$inv_qty.' Stk] '.xtc_db_input($_POST['comments']);
						$SQ->inventur_qty( $new_qty, $comment,$update_storage_quantity=true);
						xtc_db_query(sprintf(
							"UPDATE storage_products SET quantity=0 WHERE products_id='%s'",
							$SQ->get_products_id()
						));

					}

					$CSV->close();
					xtc_redirect(xtc_href_link('products.php',xtc_get_all_get_params(array('action')).'action=bestand'));
				}else{
					if( is_array($_POST) and $_POST['quantity'] != '' ){
						$qty = $SQ->get_products_total_qty();
						$new_qty = (int) xtc_db_input($_POST['quantity']);
						$comment = '[Eingabe: '.$_POST['quantity'].' Stk] '.xtc_db_input($_POST['comments']);
						$SQ->inventur_qty( $new_qty, $comment,$update_storage_quantity=true);
						
						xtc_db_query(sprintf(
							"UPDATE storage_products SET quantity=0 WHERE products_id='%s'",
							$SQ->get_products_id()
						));
						
						xtc_redirect(xtc_href_link('products.php',xtc_get_all_get_params(array('action')).'action=bestand'));
					}
				}
			}
			exit;
			break;
                case 'view_storage_transfers':
                    $pID = (int)xtc_db_input($_GET['pID']);
                ///    $sID = (isset($_REQUEST['sID'])) ? (int)xtc_db_input($_REQUEST['sID']):0;
                    $SQ = new products_quantity($pID);
                    $SP = array();
                    $stammlager_included = false; // wozu weiss ich nicht
                    $storage_products = array();
                    $query = xtc_db_query(sprintf(
                            "SELECT id,storage_id,quantity,storage_places_id FROM storage_products WHERE products_id=%s ORDER BY priority",
                            $pID
                    ));
                    while($row = xtc_db_fetch_array($query)){
                        $storage_products[] = $row;
                    }
                    // VERLINKUNGEN ENTFERNEN - 07/2019 - TICKET 3023
                    $all_functions = strstr($_SERVER['HTTP_REFERER'],'categories.php');
                    foreach($storage_products as $k=>$row){
                            if($row['storage_places_id'] > 0){
                                $row['storage_place'] = yes_get_storage_place_title($row['storage_places_id']);
                            }
                            $storage = new storage($row['storage_id']);
                            $storage_number = $storage->getStorage_number_by_products_id($pID);
// NOCHMAL UEBERDENKEN				$qty = ($storage->getDefault_storage() == 'y') ? $SQ->get_available1_qty() : $row['quantity'];
                            $qty = $row['quantity'];
                            if($storage->getDefault_storage() == 'y')
                                    $stammlager_included = true;
                            
                            $from_link = (!strstr($_SERVER['HTTP_REFERER'],'products.php')) ? urlencode($_SERVER['HTTP_REFERER']) : urlencode('products.php?'.xtc_get_all_get_params(array('action')).'action=bestand');
                            $json_return = ($all_functions) ? '' : '&json=1';
                            // wenn all_functions dann auch lagerplatzname und lagernummer aendern
                            if($storage_number != -1){
                                    $SP[] = array('id'=>$row['id'],
                                            'link'=>xtc_href_link('products.php',xtc_get_all_get_params(array('action','spID')).'action=sp_transfer&spID='.$row['id'].$json_return),
                                            'storage_name'=>$storage->getName(),
                                            'storage_number'=>$storage_number->getNummer(),
                                            'storage_edit_link'=>xtc_href_link('storage.php',xtc_get_all_get_params(array('action','id','from')).'action=quickedit&id='.$row['storage_id'].'&from='.$from_link ),
                                            'storage_number_edit_link'=>xtc_href_link('storage_numbers.php','action=quickedit&id='.$storage_number->getId().'&from='.$from_link),
                                            'place'=>$row['storage_place'],
                                            'place_edit_link'=>xtc_href_link('storage.php','action=quickedit_place&id='.$row['id'].'&from='.$from_link),
                                            'quantity'=>$qty,
                                            'stammlager'=>$storage->getDefault_storage(),
                                    );
                                    if(!isset($storage_qty[ $storage->getId() ])) $storage_qty[ $storage->getId() ] = array(
                                        'storage_name'=>$storage->getName(),
                                        'quantity'=>0
                                    );
                                    $storage_qty[ $storage->getId() ]['quantity'] += $qty;
                            }
                    }
                    $untransferred = $SQ->get_untransferred();
                    $smarty->assign(array(
                        'storage_qty'=>$storage_qty,
                        'SP'=>$SP,
                        'TEXT_SP_TRANSFER_INTRO'=>TEXT_SP_TRANSFER_INTRO,
                        'TEXT_UNTRANSFERRED_ITEMS'=>sprintf(TEXT_UNTRANSFERRED_ITEMS,$untransferred),
                        'UNTRANSFERRED'=>$untransferred,
                        'TEXT_ALLOCATE_UNTRANSFERRED'=>TEXT_ALLOCATE_UNTRANSFERRED,
                        'ALLOCATED_UNTRANSFERRED_LINK'=>xtc_href_link('products.php',xtc_get_all_get_params(array('action')).'action=allocate_untransferred'),
                        'TEXT_LINK_SP_TRANSFER'=>TEXT_LINK_SP_TRANSFER,
                        'ALL_FUNCTIONS'=>$all_functions
                    ));
                    $html=$smarty->fetch('bestandsinfo_storagetransfers.tpl');
                    echo $html;
                    exit;
                    break;
		case 'bestand':
		    $SP = array();
		    $storage_qty = array();
			$SQ = new products_quantity((int)xtc_db_input($_GET['pID']));
			$stammlager_included = false; // wozu weiss ich nicht
			$storage_products = array();
			$query = xtc_db_query(sprintf(
				"SELECT id,storage_id,quantity,storage_places_id FROM storage_products WHERE products_id=%s ORDER BY priority",
				(int)xtc_db_input($_REQUEST['pID'])
			));
			while($row = xtc_db_fetch_array($query)){
			    $storage_products[] = $row;
			}
			foreach($storage_products as $k=>$row){
				$storage = new storage($row['storage_id']);
				$storage_number = $storage->getStorage_number_by_products_id((int)xtc_db_input($_REQUEST['pID']));
// NOCHMAL UEBERDENKEN				$qty = ($storage->getDefault_storage() == 'y') ? $SQ->get_available1_qty() : $row['quantity'];
				$qty = $row['quantity'];
				if($storage->getDefault_storage() == 'y')
					$stammlager_included = true;
				if($storage_number != -1){
					if(!isset($storage_qty[ $storage->getId() ])) $storage_qty[ $storage->getId() ] = array(
					    'storage_name'=>$storage->getName(),
					    'quantity'=>0
					);
					$storage_qty[ $storage->getId() ]['quantity'] += $qty;
				}
			}
			$pqty = $SQ->get_products_total_qty();
			$products_query = xtc_db_query(sprintf(
				"SELECT products_ean, products_model, products_image FROM %s WHERE products_id='%s'",
				TABLE_PRODUCTS,$SQ->get_products_id($products_query)
			));
			$products_data = xtc_db_fetch_array($products_query);
			$img = ($products_data['products_image'] != '' and is_file(DIR_FS_CATALOG_THUMBNAIL_IMAGES.$products_data['products_image'])) ? HTTP_SERVER.'images/product_images/thumbnail_images/'.$products_data['products_image'] : '';
			$smarty->assign(array(
			    'jquery_ui_css_link'=>yes_get_cdn_link('jquery-ui-css','1.10.3','start'),
			    'jquery_ui_js_link'=>yes_get_cdn_link('jquery-ui','1.10.3'),
			    'PRODUCTS_EAN'=>$products_data['products_ean'],
			    'PRODUCTS_MODEL'=>$products_data['products_model'],
			    'PRODUCTS_IMAGE'=>$img,
			    'PRODUCTS_NAME'=>xtc_get_products_name($SQ->get_products_id()),
			    'PID'=>(int)xtc_db_input($_GET['pID']),
			    'TEXT_STAMMLAGER'=>TEXT_STAMMLAGER,
			    'CSV_IMPORT_LINK_TEXT'=>CSV_IMPORT_LINK_TEXT,
			    'STANDARD_IMPORT_LINK_TEXT'=>STANDARD_IMPORT_LINK_TEXT,
			    'INPUT_FILE_TEXT'=>INPUT_FILE_TEXT,
			    'CSV_IMPORT_LINK'=>xtc_href_link('products.php',xtc_get_all_get_params(array('csv_mode')).'csv_mode=1'),
			    'STANDARD_IMPORT_LINK'=>xtc_href_link('products.php',xtc_get_all_get_params(array('csv_mode'))),
			    'CSV_IMPORT_MODE'=>((isset($_GET['csv_mode']))?$_GET['csv_mode']:''),
			    'SHOW_AUCTIONS_LINK'=>xtc_href_link('products.php',xtc_get_all_get_params(array('show_auctions')).'show_auctions=1'),
			    'HIDE_AUCTIONS_LINK'=>xtc_href_link('products.php',xtc_get_all_get_params(array('show_auctions'))),
			    'TEXT_RUNNING_AUCTIONS'=>TEXT_RUNNING_AUCTIONS,
			    'TEXT_CHANGE_AUCTION_QTY'=>TEXT_CHANGE_AUCTION_QTY,
			    'URLDECODED_PAGE'=>urlencode(xtc_href_link('products.php',xtc_get_all_get_params())),
			    'STORAGE_QTY'=>$storage_qty,
                            'BASELINK_TRANSFER'=>xtc_href_link('products.php',xtc_get_all_get_params(array('action')).'action=view_storage_transfers'),
                            'EXTERNAL_STOCK'=>$SQ->get_external_stock(),
                            'EXTERNAL_STOCK_DETAILS'=>$SQ->get_external_stock(true)
			));

			if(isset($_GET['edit']) and $_GET['edit'] == '1' and ($_SESSION['customers_status']['customers_status_id'] == '0') and ($admin_access['f_products_quantity'] == '1') ){
				if($_SESSION["quantity_inputmode"] == 'normal'){
					$smarty->assign('INPUT_QTY',xtc_draw_input_field('quantity','0','size="5" id="qty"').xtc_draw_hidden_field('origqty',$pqty).xtc_draw_hidden_field('nummer',$SQ->get_products_id()));
					$smarty->assign('INPUT_ADDITION','<input type="checkbox" name="addition" value="1" onClick="document.forms[\'lager\'].qty.value=\'0\';" CHECKED>');
					$smarty->assign('INPUT_COMMENT',xtc_draw_textarea_field('comments','virtual',30,4,$_POST['comments'],'id="comments"'));
					$smarty->assign('FORM','<form name="lager" action="products.php?'.xtc_get_all_get_params(array('action')).'action=lager_save" onsubmit="return check_int();" method="post">');
					$smarty->assign('INPUT_SUBMIT','<a href="#" onclick="check_int();">'.xtc_image_button('button_save.gif',IMAGE_SAVE).'</a>');
				}else{
					$smarty->assign('INPUT_QTY',xtc_draw_input_field('quantity','0','size="5" id="qty"').xtc_draw_hidden_field('nummer',$SQ->get_products_id() ));
					if($_GET['csv_mode']){
						$smarty->assign('FORM',xtc_draw_form("lager","products.php",xtc_get_all_get_params(array('action')).'action=lager_save',"post",'enctype="multipart/form-data"'));
						$comments = DEFAULT_COMMENT_TEXT_CSV;
					}else{
						$smarty->assign('FORM',xtc_draw_form("lager","products.php",xtc_get_all_get_params(array('action')).'action=lager_save',"post"));
						$comments = DEFAULT_COMMENT_TEXT_NORMAL;
					}
					$smarty->assign('INPUT_COMMENT',xtc_draw_textarea_field('comments','virtual',30,4,$comments,'id="comments"' ));
				}
				if($_SESSION["quantity_inputmode"] == 'normal'){
					$smarty->assign('LINK_INPUT_MODE_INVENTUR',sprintf(
						'<a href="%s"><u>%s</u></a>',
						xtc_href_link('products.php',xtc_get_all_get_params(array('input_mode')).'input_mode=inventur'),
						TEXT_MODUS_INVENTUR
					));
					$smarty->assign('LINK_INPUT_MODE_NORMAL',sprintf(
						'<b>%s</b>',
						TEXT_MODUS_NORMAL
					));
				}else{
					$smarty->assign('LINK_INPUT_MODE_INVENTUR',sprintf(
						'<b>%s</b>',
						TEXT_MODUS_INVENTUR
					));
					$smarty->assign('LINK_INPUT_MODE_NORMAL',sprintf(
						'<a href="%s"><u>%s</u></a>',
						xtc_href_link('products.php',xtc_get_all_get_params(array('input_mode')).'input_mode=normal'),
						TEXT_MODUS_NORMAL
					));
				}
				$smarty->assign('INPUTMODE',$_SESSION["quantity_inputmode"]);
				$smarty->assign('SELFLINK',xtc_href_link('products.php',xtc_get_all_get_params(array('input_mode'))));
			}
			$CA = new colliarray((int)$_GET['pID']);
			if(is_countable($CA->get_collies()) && sizeOf($CA->get_collies())>0){
				$collie_array = array();
				$collieset_qty = 10000000000;
				$colliephysical_qty = 10000000000;
				foreach($CA->get_collies() as $k=>$collie){
					$coll = array();
					$coll['pID'] = $collie->get_products_id();
					$coll['name'] = xtc_get_products_name( $collie->get_products_id() );
					$coll['qty'] = $collie->get_set_quantity()*$collie->get_pack_quantity();
					$coll['pack'] = $collie->get_pack_quantity();
					//$coll['available'] = $collie->get_available_quantity();
					$coll['physical'] = $collie->get_set_quantity();
					$coll['available'] = $collie->get_quantity();
					$collie_array[] = $coll;
					if($collie->get_set_quantity() < $collieset_qty)
						$collieset_qty = $collie->get_set_quantity();
					if($collie->get_quantity() < $colliephysical_qty)
						$colliephysical_qty = $collie->get_quantity();
				}
				$smarty->assign('COLLIES','1');
				$smarty->assign('collies',$collie_array);
				$smarty->assign('COLLIE_PHYSICAL_QTY',$collieset_qty);
				$smarty->assign('COLLIE_QTY',$colliephysical_qty);
			}
			$smarty->assign('QTY_STAMMLAGER',$SQ->get_stammlager_qty());

			// BOF filialen
			$branches_array = array();
			$branches_query = xtc_db_query("SELECT branches_id,products_quantity FROM branches_products WHERE products_id='".(int)xtc_db_input($_GET['pID'])."'");
			while($branches = xtc_db_fetch_array($branches_query)){
				$branches_array[] = array('branch'=>xtc_get_branch_title($branches['branches_id']),'qty'=>$branches['products_quantity'] );
			}
			if(sizeOf($branches_array)>0)
				$smarty->assign('BRANCHES',$branches_array);
			// EOF FILIALEN

			$smarty->assign(array(
                            'QTY_GESAMTBESTAND'=>$SQ->get_gesamtbestand_qty(),
                            'QTY_AVAILABLE1'=>$SQ->get_available1_qty(),
                            'QTY_AVAILABLE2'=>$SQ->get_available2_qty(),
                        ));
                        
                        if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
			    $smarty->assign(array(
                                'QTY_HITMEISTER'=>$SQ->get_hitmeister_quantity(),
                                'HITMEISTER_ID_ITEM'=>yes_hitmeister::get_id_item_from_products_id((int)xtc_db_input($_GET['pID']))
                            ));
                        }
                        
			// BEWEGUNGSDATEN
			$smarty->assign('QTY_BEWEGUNGSDATEN_IN_AUCTION',$SQ->get_auction_qty());
			// BOF EBAY AUKTIONENANZAHL AUCH FUER SETARTIKEL - TICKET 1608
			if(is_countable($CA->get_collies()) && sizeOf($CA->get_collies())>0){
				$qty_set_at_ebay = \YES4Trade\Model\ebay_auctions::calc_running_auctions_quantity_for_products_id(intval($_GET['pID']));
			    $smarty->assign('QTY_SET_AT_EBAY',$qty_set_at_ebay);
			    
			}
			// EOF EBAY AUKTIONENANZAHL AUCH FUER SETARTIKEL - TICKET 1608
			$smarty->assign('QTY_BEWEGUNGSDATEN_BLOCK_RECLAMATIONS',$SQ->get_block_reclamations_qty());
			if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
				$smarty->assign('QTY_BEWEGUNGSDATEN_AT_AMAZON',$SQ->get_amazon_qty());
				$smarty->assign('QTY_BEWEGUNGSDATEN', ( $SQ->get_auction_qty() + $SQ->get_block_reclamations_qty() + $SQ->get_amazon_qty()  + $SQ->get_hitmeister_quantity() ) );
			}else{
				$smarty->assign('QTY_BEWEGUNGSDATEN', ( $SQ->get_auction_qty() + $SQ->get_block_reclamations_qty()  + $SQ->get_hitmeister_quantity() ) );
			}

			// AUFTRAEGE
			$smarty->assign('QTY_AUFTRAEGE_NOT_SHIPPED',$SQ->get_not_shipped_qty());
			$smarty->assign('QTY_AUFTRAEGE',$SQ->get_not_shipped_qty());

			//BOF LAGER
			$storages = array();
			if(in_array('Hermes',$VERSENDER)){
				$hermes_id_query = xtc_db_query("SELECT nummer FROM storage_numbers WHERE products_id='".(int)$_GET['pID']."' and storage_id='".HERMES_LAGER_ID."'");
				$hermes_id = xtc_db_fetch_array($hermes_id_query);
				if( $hermes_id['nummer'] != ''){
					$storage = array();
					$storage['name'] = 'Hermes';
					$storage['qty'] = $SQ->get_hermes_qty();
					$storages[] = $storage;
				}
			}
			if(sizeOf($storages)>0)
				$smarty->assign( 'lager',$storages);

			// EOF LAGER

			// BOF STATS
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_products_stats_abverkaeufe'] == '1')) {
                            $days_num = (int)xtc_db_input($_GET['days']);
                            $mode = ($days_num == 28) ? 'daily' : 'weekly';
                            $mode = ($days_num >= 84) ? 'monthly' : $mode;
                            $from = yes_strftime('%Y-%m-%d %H:%I:%S',time() - (60*60*24*$days_num));
                            if($_GET['stats'] == '1'){
                                $d = new DateTime('-'.$days_num.' Days');
                                $stat_query = xtc_db_query(sprintf(
                                    "select substring(o.date_purchased,1,10) as d,SUM(op.products_quantity) as verkauft from orders o, orders_products op where o.date_purchased > '%s' and op.products_id='%d' and op.orders_id=o.orders_id and o.orders_status != '%d' group by d",
                                    $d->format('Y-m-d 00:00:00'),
                                    (int)xtc_db_input($_GET['pID']),
                                    ORDERS_STATUS_STORNIERT
                                ));
                                $stat_data = array();
                                while($stat = xtc_db_fetch_array($stat_query)){
                                    $d = new DateTime($stat['d']);
                                    $stat_data[$d->format('d.m.y')] = $stat['verkauft'];
                                }
                                $days = array();
                                switch($mode){
                                    case 'daily':
                                        for($i=0;$i<$days_num;$i++){
                                            $d = new DateTime('-'.$i.'Days');
                                            $day = $d->format('d.m.y');
                                            $dayname = $d->format('a');
                                            $days[$i] = array(
                                                'day'=>$dayname.' - '.$day,
                                                'qty'=>((isset($stat_data[$day]))?$stat_data[$day]:0)
                                            );

                                                //$day = yes_strftime('%d.%m.%y',strtotime(date('Y-m-d'))-60*60*24*$i);
                                                //$dayname = yes_strftime('%a',strtotime(date('Y-m-d'))-60*60*24*$i);
                                                //$days[$i] = array('day'=>$dayname.' - '.$day,'qty'=>((isset($stat_data[$day]))?$stat_data[$day]:0));
                                        }
                                        break;
                                    case 'weekly':
                                        $week_from = date('d.m.y');
                                        for($i=0;$i<$days_num;$i++){
                                            $d = new DateTime('-'.$i.' Days');
                                            $day = $d->format('d.m.y');
                                            $dayOfWeek = $d->format('u');
                                                //$day = yes_strftime('%d.%m.%y',time()-60*60*24*$i);
                                                //$dayOfWeek = yes_strftime('%u',time()-60*60*24*$i);

                                            if( $dayOfWeek == 7 ){
                                                $week_from = $day;
                                                $counter = 0;
                                            }

                                            $counter += (($stat_data[$day])?$stat_data[$day]:0);

                                            if( $dayOfWeek == 1 ){
                                                $week_string = $week_from.' - '.$day;
                                                $days[$week_string] = array(
                                                    'day'=>$week_string,
                                                    'qty'=>$counter
                                                );
                                            }
                                        }
                                        break;
                                    case 'monthly':
                                        $week_from = date('d.m.y');
                                        $last_month = '';
                                        for($i=0;$i<$days_num;$i++){
                                            $d = new DateTime('-'.$i.' Days');
                                            $day = $d->format('d.m.y');
                                            $dayOfWeek = $d->format('u');
                                            $month = $d->format('b');
                                                //$day = yes_strftime('%d.%m.%y',time()-60*60*24*$i);
                                                //$dayOfWeek = yes_strftime('%u',time()-60*60*24*$i);
                                                //$month = yes_strftime('%b',time()-60*60*24*$i);
                                            if($last_month != $month){
                                                $last_month = $month;
                                                $counter = 0;
                                            }
                                            $counter += (($stat_data[$day])?$stat_data[$day]:0);
                                            $days[$month] = array(
                                                'day'=>$month,
                                                'qty'=>$counter
                                            );
                                        }
                                        break;
                                }
                                $src = (isset($_REQUEST['source'])) ? xtc_db_input($_REQUEST['source']) : 'ebay';
                                if($src == 'unknown') {
                                    $src = '';
                                }
                                $d = new DateTime('-'.$days_num.' Days');
                                $stat_query = xtc_db_query(sprintf(
                                    "SELECT substring(o.date_purchased,1,10) AS d,SUM(op.products_quantity) AS eingestellt FROM orders_products op LEFT JOIN orders o USING(orders_id) WHERE op.products_id='%s' and o.date_purchased >= '%s' AND o.orders_status != '%s' and o.source = '%s' GROUP BY d",
                                    (int)xtc_db_input($_GET['pID']),
                                    $d->format('Y-m-d 00:00:00'),
                                    ORDERS_STATUS_STORNIERT,$src
                                ));
                                $stat_data = array();
                                while($stat = xtc_db_fetch_array($stat_query)){
                                    $d = new DateTime($stat['d']);
                                    $stat_data[$d->format('d.m.y')] = $stat['eingestellt'];
                                }
                                $days2 = array();
                                switch($mode){
                                    case 'daily':
                                        for($i=0;$i<$days_num;$i++){
                                            $d = new DateTime('-'.$i.' Days');
                                            $day = $d->format('d.m.y');
                                            $dayname = $d->format('a');
                                            $days2[$i] = array(
                                                'day'=>$dayname.' - '.$day,
                                                'qty'=>(($stat_data[$day])?$stat_data[$day]:0)
                                            );
                                            /*
                                                $day = yes_strftime('%d.%m.%y',strtotime(date('Y-m-d'))-60*60*24*$i);
                                                $dayname = yes_strftime('%a',strtotime(date('Y-m-d'))-60*60*24*$i);
                                                $days2[$i] = array('day'=>$dayname.' - '.$day,'qty'=>(($stat_data[$day])?$stat_data[$day]:0));
                                             * 
                                             */
                                        }
                                        break;
                                    case 'weekly':
                                        $week_from = date('d.m.y');
                                        $counter = 0;
                                        for($i=0;$i<$days_num;$i++){
                                            $d = new DateTime('-'.$i.' Days');
                                            $day = $d->format('d.m.y');
                                            $dayOfWeek = $d->format('u');
                                            /*
                                                $day = yes_strftime('%d.%m.%y',time()-60*60*24*$i);
                                                $dayOfWeek = yes_strftime('%u',time()-60*60*24*$i);
                                            */
                                            if( $dayOfWeek == 7 ){
                                                $week_from = $day;
                                                $counter = 0;
                                            }

                                            $counter += (($stat_data[$day])?$stat_data[$day]:0);

                                            if( $dayOfWeek == 1 ){
                                                $week_string = $week_from.' - '.$day;
                                                $days2[$week_string] = array('day'=>$week_string,'qty'=>$counter);
                                            }
                                        }
                                        break;
                                    case 'monthly':
                                        $week_from = date('d.m.y');
                                        $last_month = '';
                                        $counter = 0;
                                        for($i=0;$i<$days_num;$i++){
                                            $d = new DateTime('-'.$i.' Days');
                                            $day = $d->format('d.m.y');
                                            $dayOfWeek = $d->format('u');
                                            $month = $d->format('b');
                                                //$day = yes_strftime('%d.%m.%y',time()-60*60*24*$i);
                                                //$dayOfWeek = yes_strftime('%u',time()-60*60*24*$i);
                                                //$month = yes_strftime('%b',time()-60*60*24*$i);
                                            if($last_month != $month){
                                                $last_month = $month;
                                                $counter = 0;
                                            }
                                            $counter += (($stat_data[$day])?$stat_data[$day]:0);
                                            $days[$month] = array('day'=>$month,'qty'=>$counter);
                                        }
                                        break;
                                }
                                $days = array_reverse($days);
                                $days2 = array_reverse($days2);
                                if(is_file('includes/bar_bestand_stats_'.xtc_db_input($_REQUEST['source']).'.php' ) ){
                                    require('includes/bar_bestand_stats_'.xtc_db_input($_REQUEST['source']).'.php');
                                }else{
                                    die($_REQUEST['source'].' kann nicht dargestellt werden.');
                                }
                            }
                            $d = new DateTime('-28 Days');
                            $from = $d->format('Y-m-d H:i:s');
                            //$from = yes_strftime('%Y-%m-%d %H:%I:%S',time() - (60*60*24*28));
                            $smarty->assign('stats_view_link',xtc_href_link('products.php',xtc_get_all_get_params(array('stats','days','src')).'stats=1&days=28'));
                            $_pid = (int)xtc_db_input($_GET['pID']);
                            $_col = xtc_get_product_in_collies($_pid);
                            $search_result['4 Wochen'] = yes_get_products_sells($_pid, 28, $_col, array(ORDERS_STATUS_STORNIERT),true );
                            $search_result['3 Monate'] = yes_get_products_sells($_pid, 28*3, $_col, array(ORDERS_STATUS_STORNIERT),true );
                            $search_result['6 Monate'] = yes_get_products_sells($_pid, 28*6, $_col, array(ORDERS_STATUS_STORNIERT),true );
                            $search_result['12 Monate'] = yes_get_products_sells($_pid, 365, $_col, array(ORDERS_STATUS_STORNIERT),true );
                            $smarty->assign('sells',$search_result);
                            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_products_stats_abverkaeufe'] == '1')) {
                                    $smarty->assign('shop_stats_base_link',xtc_href_link('products.php',xtc_get_all_get_params(array('stats','days','src')).'stats=1'));
                            }
                            $smarty->assign('POPUP_WIDTH',EXT_POPUP_WIDTH);
                            $smarty->assign('POPUP_HEIGHT',EXT_POPUP_HEIGHT);
			}
			// EOF STATS

			// BOF LIEFERANTEN
			$distributor_orders_query = xtc_db_query("SELECT do.*,dop.products_quantity,dop.qty_rueckbuch,dop.stuecklisten_id,dop.collie_qty FROM distributor_orders_products dop, distributor_orders do WHERE dop.products_id='".(int)xtc_db_input($_GET['pID'])."' AND dop.distributor_orders_id=do.distributor_orders_id AND do.orders_status=2 ORDER BY estimated_date_receipt");
			$distributor_order = array();
			while($distributor_orders = xtc_db_fetch_array($distributor_orders_query)){
				// collie
				if($distributor_orders['stuecklisten_id'] > 0){
					$st_collie_qty = $distributor_orders['collie_qty'];
					$st_query = xtc_db_query("SELECT dop.products_quantity,dop.qty_rueckbuch FROM distributor_orders_products dop WHERE dop.products_id='".$distributor_orders['stuecklisten_id']."' AND dop.distributor_orders_id='".$distributor_orders['distributor_orders_id']."'");
					while($st = xtc_db_fetch_array($st_query)){
						$distributor_order[] = array('created'=>$distributor_orders['date_created'],'doID'=>$distributor_orders['distributor_orders_id'],'estimated'=>$distributor_orders['estimated_date_receipt'],'qty'=>(($st['products_quantity']-$st['qty_rueckbuch'])*$st_collie_qty));
					}
				}else{
					$distributor_order[] = array('created'=>$distributor_orders['date_created'],'doID'=>$distributor_orders['distributor_orders_id'],'estimated'=>$distributor_orders['estimated_date_receipt'],'qty'=>($distributor_orders['products_quantity']-$distributor_orders['qty_rueckbuch']));
				}
			}
			if(sizeOf($distributor_order)>0){
                            $smarty->assign('DISTRIBUTOR_ORDERS',$distributor_order);
                        }



			// EOF LIEFERANTEN


			$history_query_raw = "select *,DATE_FORMAT(date_saved,'%d.%m.%y') as datum from history_bestand where products_id='".(int)xtc_db_input($_GET['pID'])."' order by date_saved desc";
			$historys = array();
			$history_split = new splitPageResults( $_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $history_query_raw, $history_query_numrows);
			$history_query = xtc_db_query($history_query_raw);
			$last_manual_change = array();
			$manual_change = array();
			while($history = xtc_db_fetch_array($history_query) ){
			    $history['editor'] = xtc_get_editor_name($history['editor_id']);
			    if($history['source'] == 'direct' and !sizeOf($last_manual_change)){
				$last_manual_change = $history;
			    }
			    if($history['source'] == 'direct'){
				$manual_change[] = $history;
			    }
                            if($history['quantity_change'] < 0){
                                    $history['bgcolor']='red';
                            }else{
                                    $history['bgcolor']='green';
                            }
                            $historys[] = $history;
			}
			$smarty->assign('last_manual_change',$last_manual_change);
			$smarty->assign('manual_change',$manual_change);
			$smarty->assign('historys',$historys);

			$smarty->assign('split_text',$history_split->display_count($history_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], 'Angezeigt werden %s bis %s von insgesamt %s Datens&auml;tzen',xtc_get_all_get_params(array('page'))));
			$smarty->assign('split_navi',$history_split->display_links($history_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page'))));

			$smarty->assign('SEPARATOR',xtc_draw_separator('pixel_black.gif'));
			
			if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
			    $amazon = yes_get_products_amazon_values((int)xtc_db_input($_GET['pID']));
			    $smarty->assign(array(
				'AMAZON_ASIN'=>$amazon['asin'],
				'AMAZON_SKU'=>$amazon['sku']
			    ));
			}
			
			if(isset($_REQUEST['show_auctions']) and $_REQUEST['show_auctions'] == 1){
			    $product = new product((int)xtc_db_input($_GET['pID']));
			    $auctions = $product->get_running_auctions_list();
                            $table = new tableBlock();
                            $params = 'class="yesListTable_minimal"';
                            $table->table_parameters = $params;
                            $blacklist = ['id']; // zb ['irgendein_spaltenname']
                            $contents = [
                                [['text'=>'eBay ID', 'params'=>'','align'=>'left','form'=>'','th'=>true],
                                ['text'=>'Seller', 'params'=>'','align'=>'left','form'=>'','th'=>true],
                                ['text'=>'Titel', 'params'=>'','align'=>'left','form'=>'','th'=>true],
                                ['text'=>'Type', 'params'=>'','align'=>'left','form'=>'','th'=>true],
                                ['text'=>'Menge', 'params'=>'','align'=>'right','form'=>'','th'=>true],
                                ['text'=>'Verkauft', 'params'=>'','align'=>'right','form'=>'','th'=>true],
                                ['text'=>'Variante', 'params'=>'','align'=>'left','form'=>'','th'=>true]],
                            ];
                            foreach($auctions as $auction){
                                $ebay_base_link = (defined('EBAY_TESTMODE') and EBAY_TESTMODE == '1') ? 'https://www.sandbox.ebay.com/itm/':'https://www.ebay.com/itm/';
                                $qty_info = sprintf('<span class="revise_linkcontainer" id="%s" title="%s">',
                                    $auction['id'],TEXT_CHANGE_AUCTION_QTY
                                );
                                if($auction['variation'] == 1){
                                    $qty_info .= '<div class="ui-state-default ui-widget ui-corner-all" style="padding:2px; margin-left: 3px;margin-right: 5px;display: inline-block;">Set</div>';
                                }
                                $qty_info .= '<span class="qty">'.$auction['quantity'].'</span>';
                                $variation_info = ($auction['variation'] == 1)?YES:NO;
                                if($auction['variation'] == 1){
                                    if(strpos($auction['sku'],'-STFLPRS_')>-1){
                                        $parts = explode('-STFLPRS_',$auction['sku']);
                                        $variation_info .= '<div style="color: #777;">Staffelpr. Anz.: '.$parts[1].'</div>';
                                    }
                                }
                                $contents[] = [
                                    ['text'=>sprintf('<a href="%s" target="_blank" title="Auktion bei eBay anzeigen.">%s</a>',
                                            $ebay_base_link.$auction['ebay_id'],
                                            $auction['ebay_id']
                                        ), 'params'=>'','align'=>'left'],
                                    ['text'=>$auction['user'], 'params'=>'','align'=>'left'],
                                    ['text'=>$auction['title'], 'params'=>'','align'=>'left'],
                                    ['text'=>$auction['type'], 'params'=>'','align'=>'left'],
                                    ['text'=>$qty_info, 'params'=>'','align'=>'right'],
                                    ['text'=>$auction['quantity_sold'], 'params'=>'','align'=>'right'],
                                    ['text'=>$variation_info, 'params'=>'','align'=>'left'],
                                ];
                            }
                            $smarty->assign('RUNNING_LIST',$table->tableBlock_draw($contents));
			}
			if($messageStack->size > 0){
			    $smarty->assign('MESSAGES',$messageStack->output(true));
			}

			$html=$smarty->fetch('bestandsinfo.html');
			echo $html;
			exit;
			break;
    } // end switch
}
