<?php
require_once(DIR_WS_CLASSES.'class.ebay.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
$GH = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
$EBAYAPI = new ebayAPI();
if(!isset($_SESSION['products_queue'])){
    $_SESSION['products_queue'] = array();
}
if(isset($_GET['clear_queue'])){
    $_SESSION['products_queue'] = array();
    $messageStack->add_session(MSG_PRODUCTS_QUEUE_CLEARED,'success');
    xtc_redirect(xtc_href_link('products.php',xtc_get_all_get_params(array(
        'clear_queue'
    ))));
}
$xtPrice = new xtcPrice(DEFAULT_CURRENCY, 1);
if(isset($_GET['groups_id'])){
    $gID = (int)xtc_db_input($_GET['groups_id']);
    foreach($GH->groups as $group){
        if($gID == $group['groups_id']){
            $g = $group;
        }
    }
    $title = $g['groups_title'];
    if(strtolower(CHARSET) == 'utf-8'){
        if(mb_detect_encoding($title) != CHARSET){
            $title = utf8_encode($title);
        }
    }
    
    $allocations = \YES4Trade\Model\groups_products::get_by_groups_id($g['groups_id']);
    $added = 0;
    foreach($allocations as $alloc){
        $pID = $alloc->products_id;
        if(isset($_SESSION['products_queue'][$pID])){
            continue;
        }
        $P = new product($pID);
        if($P->info['products_status'] != 1){
            continue;
        }
        if($P->has_special_price()){
            continue;
        }
        $_SESSION['products_queue'][$pID] = array(
            'image'=>$P->info['products_image'],
            'price'=>$xtPrice->xtcGetPrice($pID, false, 1, $P->info['products_tax_class_id'])
        );
        $added++;
    }
    $messageStack->add_session(sprintf(
            MSG_PRODUCTS_QUEUE_ADDED, $added
    ),'success');
    xtc_redirect(xtc_href_link('products.php',xtc_get_all_get_params(array(
        'groups_id'
    ))));
}
if(isset($_GET['cart_id'])){
    $cartID = (int)xtc_db_input($_GET['cart_id']);
    $es = new ebay_sammler($cartID);
    $dist_products = array();
    $query = xtc_db_query(sprintf(
            "SELECT DISTINCT(products_id) as pID FROM ebay_products WHERE products_id>0 AND ebay_sammler_id='%s'",
            $cartID
    ));
    while($record = xtc_db_fetch_array($query)){
        $dist_products[] = $record['pID'];
    }
    $query = xtc_db_query(sprintf(
            "SELECT DISTINCT(ev.products_id) as pID FROM ebay_variations ev LEFT JOIN ebay_variations_sets evs USING(ebay_variations_sets_id) LEFT JOIN ebay_products ep ON evs.ebay_products_id=ep.id WHERE ev.products_id>0 AND ep.ebay_sammler_id='%s'",
            $cartID
    ));
    while($record = xtc_db_fetch_array($query)){
        if(!in_array($record['pID'],$dist_products)){
            $dist_products[] = $record['pID'];
        }
    }
    $added = 0;
    foreach($dist_products as $pID){
        if(isset($_SESSION['products_queue'][$pID])){
            continue;
        }
        $P = new product($pID);
        if($P->info['products_status'] != 1){
            continue;
        }
        if($P->has_special_price()){
            continue;
        }
        $_SESSION['products_queue'][$pID] = array(
            'image'=>$P->info['products_image'],
            'price'=>$xtPrice->xtcGetPrice($pID, false, 1, $P->info['products_tax_class_id'])
        );
        $added++;
    }
    $messageStack->add_session(sprintf(
            MSG_PRODUCTS_QUEUE_ADDED, $added
    ),'success');
    xtc_redirect(xtc_href_link('products.php',xtc_get_all_get_params(array(
        'cart_id'
    ))));
}
if(isset($_GET['categories_id'])){
    $categories_id = (int)xtc_db_input($_GET['categories_id']);
    $dist_products = array();
    $products = array();
    main::get_products_in_category($categories_id, $products);
    foreach($products as $pID){
        if(!in_array($pID,$dist_products)){
            $dist_products[] = $pID;
        }
    }
    $added = 0;
    foreach($dist_products as $pID){
        if(isset($_SESSION['products_queue'][$pID])){
            continue;
        }
        $P = new product($pID);
        if($P->info['products_status'] != 1){
            continue;
        }
        if($P->has_special_price()){
            continue;
        }
        $_SESSION['products_queue'][$pID] = array(
            'image'=>$P->info['products_image'],
            'price'=>$xtPrice->xtcGetPrice($pID, false, 1, $P->info['products_tax_class_id'])
        );
        $added++;
    }
    $messageStack->add_session(sprintf(
            MSG_PRODUCTS_QUEUE_ADDED, $added
    ),'success');
    xtc_redirect(xtc_href_link('products.php',xtc_get_all_get_params(array(
        'categories_id'
    ))));
}

yes_draw_pre_header();
yes_draw_header('Thachs Timings');
$INPUT_PRODUCT_GROUPS_VALUES = array(array('id'=>'','text'=>TEXT_SELECT));
foreach($GH->groups as $group){
    $INPUT_PRODUCT_GROUPS_VALUES[] = array(
        'id'=>$group['groups_id'],
        'text'=>$group['groups_title']
    );
}
$INPUT_EBAY_CARTS_VALUES = $EBAYAPI->getSammlerValues();
$QUEUE = array();
foreach($_SESSION['products_queue'] as $pID=>$p){
    $img = 'images/basicons/hanging15.png';
    if(is_file(DIR_FS_CATALOG_THUMBNAIL_IMAGES.$p['image'])){
        $img = '../images/product_images/thumbnail_images/'.$p['image'];
    }
    $spec = '';
    if(isset($_GET['special_value'])){
        $spc = str_replace(',','.',$_GET['special_value']);
        if(!strstr($spc,'%')){
            $spec = $spc;
        }else{
            $spec = $p['price']-(($p['price'] * (float)str_replace('%','',$spc)) / 100);
        }
        $spec = '<br /><span class="special_price">'.number_format($spec,2,',','.').' '.DEFAULT_CURRENCY.'</span>';
    }
    $add = true;
    if(isset($_GET['revise_auctions']) and (int)$_GET['revise_auctions'] == 1){
        $P = new product($pID,$_SESSION['languages_id']);
        $au = $P->get_running_auctions_list();
        foreach($au as $auk=>$auv){
            if($auv['variation'] == 1)
                $au[$auk]['label'] = sprintf(TEXT_REVISE_VARIATION_ITEM,$pID, $auv['ebay_id']);
        }
        if(!sizeOf($au)){
            $add = false;
        }
    }
    if($add){
        $QUEUE[] = array(
            'products_id'=>$pID,
            'img'=>$img,
            'price'=>number_format($p['price'],2,',','.').' '.DEFAULT_CURRENCY,
            'spec_price'=>$spec,
            'auctions'=>$au
        );
    }
}
$end_date_default = (isset($_GET['end_date'])) ? $_GET['end_date'] : date('Y-m-d',(time()+(60*60*24*7)) );
$start_date_default = (isset($_GET['start_date'])) ? $_GET['start_date'] : date('Y-m-d');

$buttons = array(
    array('text'=>TEXT_HEADER_MENU_SPECIALS,
	'link'=>xtc_href_link(FILENAME_SPECIALS),
	'auth'=>true,
	'lbOn'=>false
    )
);

$cat_select = \YES4Trade\Model\category::get_categories_tree_select([
    'return_function'=>sprintf('$(\'input[name="categories_id"]\').val(id);'),
    'ALL_ITEMS_SELECTABLE'=>'true'
], new \yesSmarty());

$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE_PRICE_TIMINGS,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TEXT_SPECIAL_START'=>TEXT_SPECIAL_START,
    'TEXT_SPECIAL_END'=>TEXT_SPECIAL_END,
    'BASEURL'=>xtc_href_link('products.php',xtc_get_all_get_params(array(
        'groups_id','start_date','end_date','special_value','cart_id',
        'categories_id','sell_to_v1null','revise_auctions'
    ))),
    'INTRO_FILTER'=>INTRO_FILTER,
    'TEXT_PRODUCT_GROUPS_ALLOCATION'=>TEXT_PRODUCT_GROUPS_ALLOCATION,
    'INPUT_PRODUCT_GROUPS'=>xtc_draw_pull_down_menu('groups_id', $INPUT_PRODUCT_GROUPS_VALUES),
    'TEXT_EBAY_SAMMLER'=>TEXT_EBAY_SAMMLER,
    'INPUT_EBAY_CARTS'=>xtc_draw_pull_down_menu('cart_id', $INPUT_EBAY_CARTS_VALUES),
    'TEXT_CATEGORY'=>TEXT_CATEGORY,
    'IMAGE_SAVE'=>IMAGE_SAVE,
    'IMAGE_SEARCH'=>IMAGE_SEARCH,
    'TEXT_QUEUE'=>sprintf(TEXT_PRODUCTS_QUEUE,sizeOf($_SESSION['products_queue'])),
    'QUEUE_SIZE'=>sizeOf($_SESSION['products_queue']),
    'LINK_CLEAR_QUEUE'=>xtc_href_link('products.php',xtc_get_all_get_params().'clear_queue=1'),
    'TEXT_CLEAR_PRODUCTS_QUEUE'=>TEXT_CLEAR_PRODUCTS_QUEUE,
    'START_DATE_DEFAULT'=>$start_date_default,
    'END_DATE_DEFAULT'=>$end_date_default,
    'TEXT_SPECIAL'=>TEXT_SPECIAL,
    'INPUT_SPECIAL'=>xtc_draw_input_field('special_value',@$_GET['special_value'],'size="10" maxlength="10"'),
    'INTRO_SPECIAL_INPUT'=>INTRO_SPECIAL_INPUT,
    'QUEUE'=>$QUEUE,
    'PREVIEW_SPECIALS'=>PREVIEW_SPECIALS,
    'FORM_PREVIEW'=>xtc_draw_form('preview_specials','products.php','','GET'),
    'SAVE_SPECIALS'=>SAVE_SPECIALS,
    'PREVIEW_MODE'=>(isset($_GET['special_value'])) ? true : false,
    'RESET_SPECIALS'=>RESET_SPECIALS,
    'INPUT_SELL_TO_V1NULL'=>xtc_draw_checkbox_field('sell_to_v1null','1',(isset($_GET['sell_to_v1null']) and $_GET['sell_to_v1null'] == 1)),
    'INPUT_EBAY_PRICE_REVISE'=>xtc_draw_checkbox_field('ebay_price_revise','1',(isset($_GET['ebay_price_revise']) and $_GET['ebay_price_revise'] == 1)),
    'TEXT_EBAY_PRICE_REVISE'=>TABLE_HEADING_EBAY_PRICE_REVISE,
    'SELL_TO_V1NULL'=>SELL_TO_V1NULL,
    'LINK_SPECIALS_ADD_MULTIPLE'=>xtc_href_link('specials.php','action=add_multiple'),
    'REVISE_MODE'=>(isset($_GET['revise_auctions']) and $_GET['revise_auctions'] == 1 ) ? true : false,
    'TEXT_PRICE_TIMINGS_NO_END_DATE'=>TEXT_PRICE_TIMINGS_NO_END_DATE,
    'TEXT_PRICE_TIMINGS_INVALID_SPECIALS_PRICE'=>TEXT_PRICE_TIMINGS_INVALID_SPECIALS_PRICE,
    'INPUT_CATEGORIES'=>$cat_select
        . '<br />Category ID'
        . xtc_draw_input_field('categories_id','','size="8"',false,'number')
));
$smarty->display('products_price_timings.html');
include('includes/application_bottom.php');