<?php
include('includes/application_top.php');
include ('includes/classes/'.FILENAME_IMAGEMANIPULATOR);
require(DIR_WS_CLASSES.'class.ebay.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require(DIR_FS_INC.'xtc_get_parent_categories.inc.php');
require(DIR_FS_INC.'xtc_get_product_path.inc.php');
require(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require(DIR_FS_INC.'xtc_get_category_path.inc.php');
require(DIR_FS_INC.'xtc_get_site_country_id.inc.php');
require(DIR_FS_INC.'xtc_is_language_installed.inc.php');
$EBAYAPI = new ebayAPI;
$basics = new basics;

if(isset($_REQUEST['action'])){
    switch($_REQUEST['action']){
        case 'save_category':
            main::delete_configuration_key('QUICK_PRODUCT_ADD_CATEGORY');
            main::add_configuration([
                'configuration_key'=>'QUICK_PRODUCT_ADD_CATEGORY', 
                'configuration_value'=>xtc_db_input($_REQUEST['category_id']),
                'configuration_group_id'=>'102'
            ]);
            xtc_redirect('quick_product_add.php');
            exit;
            break;
        case 'get_ebayshop_allocations':
            $id = xtc_db_input($_REQUEST['id']);
            $query = xtc_db_query(sprintf(
                    "SELECT id,titel FROM ebay_sammler WHERE shopcat='%s'",
                    $id
            ));
            $array = array();
            while($record = xtc_db_fetch_array($query)){
                $array[] = array('id'=>$record['id'],'text'=>$record['titel'].' (ID: '.$record['id'].')');
            }
            header('Content-Type: text/html; charset='.CHARSET);
            if(sizeOf($array)){
                echo xtc_draw_pull_down_menu('sammler',$array,'','id="sammler"');
                $toggle = 'show';
            }else{
                echo '<span class="error">'.ERROR_NO_CARTS_ALLOCATED.'</span>';
                $toggle = 'hide';
            }
            printf('<script type="text/javascript">$().ready(function(){ $(\'.start\').'.$toggle.'() });</script>');
            exit;
            break;
        case 'get_ebayshop_categories':
            $cats = xtc_get_ebayshop_categorys();
            foreach($cats as $k=>$cat){
                if($cat['text'] == ''){
                    $cats[$k]['text'] = TEXT_SELECT;
                }
            }
            header('Content-Type: text/html; charset='.CHARSET);
            echo xtc_draw_pull_down_menu('ebayshop',$cats,'','class="textInput" onchange="get_ebayshop_carts(this)"');
            exit;
            break;
        case 'process':
            $error = false;
            $languages = xtc_get_languages();
            foreach($languages as $lang){
                if(!isset($_REQUEST['products_name'][$lang['id']])){
                    $error = true;
                }
            }
            if(!isset($_REQUEST['price'])){
                $error = true;
            }
            if(!isset($_REQUEST['sammler'])){
                $error = true;
            }
            if($error){
                xtc_redirect(xtc_href_link('quick_product_add.php','error=1'));
            }
            $tax_class_id = 1;
            $tax_rate = xtc_get_tax_rate($tax_class_id);
            
            $created_pid = array();
            $tax_rates_array = [];
            $tax_rates_query = xtc_db_fetch_array(sprintf(
                "SELECT tax_rates_id FROM %s WHERE tax_class_id='%d'", 
                TABLE_TAX_RATES, $tax_class_id
            ));
            while($tr = xtc_db_fetch_array($tax_rates_query)){
                $tax_rates_array[] = $tr['tax_rates_id'];
            }
            foreach($_REQUEST['price'] as $k=>$price){
                $price_netto = xtc_oe_get_price_o_tax(str_replace(',','.',xtc_db_input($price)), $tax_rate);
                $products_status = 0;
            
                $insert_sql_array = array(
                    'products_quantity'=>(int)xtc_db_input($_REQUEST['quantity'][$k]),
                    'products_price'=>$price_netto,
                    'products_date_added'=>'now()',
                    'products_status'=>$products_status,
                );
                xtc_db_perform('products',$insert_sql_array);
                $products_id = xtc_db_insert_id();
                
                // EU-OSS 2021/07
                foreach($tax_rates_array as $trID){
                    $insert_sql_array = [
                        'products_id'=>$products_id,
                        'tax_rates_id'=>$trID,
                        'date_added'=>'now()'
                    ];
                    xtc_db_perform('products_tax_rates_allocation',$insert_sql_array);
                }
                
                
                $created_pid[] = $products_id;
            
                foreach($languages as $lang){
                    $insert_sql_array = array(
                        'products_id'=>$products_id,
                        'language_id'=>$lang['id'],
                        'products_name'=>$_REQUEST['products_name'][$lang['id']][$k]
                    );
                    xtc_db_perform('products_description',$insert_sql_array);
                }
                $insert_sql_array = array(
                    'products_id'=>$products_id,
                    'categories_id'=>QUICK_PRODUCT_ADD_CATEGORY
                );
                xtc_db_perform('products_to_categories',$insert_sql_array);
            }
            
            // products_images, products_description, products_to_categories
            
            // BOF IMAGES
            $files = explode(";",$_REQUEST['fileorder']);
            
            $noshop_params = (isset($_REQUEST['filenoshop'])) ? explode(";",$_REQUEST['filenoshop']) : array();
            $noebay_params = (isset($_REQUEST['filenoebay'])) ? explode(";",$_REQUEST['filenoebay']) : array();
            $noebay = array();
            $ebay_bild = '';
            if(sizeOf($files)){
                $max_upload_size = $basics->get_upload_max_filesize();
                $default_ebay_bild = (isset($_REQUEST['gallery'])) ? $_REQUEST['gallery'] : $files[0];
                foreach($files as $image_number => $file){
                    if($file == ''){
                        continue;
                    }
                    $ext = current(array_reverse(explode('.',$file)));
                    $tmp_name = 'server/php/files/'.$file;
                    $needed = $basics->getMemoryRequiredToEdit($tmp_name);
                    if($needed > $basics->return_bytes(ini_get('memory_limit'))){
                        $str = FILE_UPLOAD_ERROR_GD_MEMORY_LIMIT1.'<br />'.sprintf(FILE_UPLOAD_ERROR_GD_MEMORY_LIMIT2,
                            ini_get('memory_limit'),
                            $basics->formatBytes($needed));
                        $messageStack->add_session($str,'error');
                        unlink($tmp_name);
                        continue;
                    }
                    
                    foreach($created_pid as $cc=>$products_id){
                        rename($tmp_name,DIR_FS_CATALOG.'images/product_images/original_images/'.$products_id.'_'.$image_number.'.'.$ext);
                        $products_image_name = $products_id.'_'.$image_number.'.'.$ext;
                        $tmp_name = DIR_FS_CATALOG.'images/product_images/original_images/'.$products_image_name;
                        $noshop = in_array($file, $noshop_params);
                        qpa_save_images($products_id,$products_image_name,$image_number,$noshop);
                        if($default_ebay_bild == $file){
                            $ebay_bild = $products_image_name;
                        }
                        if(in_array($file,$noebay_params)){
                            $noebay[] = $products_image_name;
                        }
                    }
                    unlink('server/php/files/'.$file);
                }
            } // EOF IMAGES
            foreach($created_pid as $cc=>$products_id){

                $insert_sql_array = array(
                    'products_id'=>$products_id,
                    'editor_id'=>$_SESSION['customer_id'],
                    'date_saved'=>'now()',
                    'comments'=>TEXT_HISTORY_CART_PRODUCT_SAVED
                );
                xtc_db_perform('products_history',$insert_sql_array);


                $cart = (isset($_REQUEST['sammler'])) ? (int)xtc_db_input($_REQUEST['sammler']) : 0;
                switch($cart){
                        case 0:
                                $cID = xtc_get_site_country_id(EBAY_SITE);
                                break;
                        default:
                                $sammler_sity_query = xtc_db_query("SELECT site FROM ebay_sammler WHERE id='".$cart."'");
                                $sammler_site = xtc_db_fetch_array($sammler_sity_query);
                                if($sammler_site['site'] != ''){
                                        $cID = xtc_get_site_country_id($sammler_site['site']);
                                }else{
                                        $cID = xtc_get_site_country_id(EBAY_SITE);
                                }
                                break;
                }


                $lID = xtc_is_language_installed($cID);
                if(!$lID){
                        $lID = '2';
                }
                $status = 2;
                $auctionStartPrice = xtc_db_input($_REQUEST['price'][$cc]);
                $buyItNowPrice = '0';
                $es = new ebay_sammler($cart);
                $sql_array = $es->get_new_ebay_product_sql_array();

                $item_shippingcosts = array();
                if($es->copy['template'] == 1)
                        $sql_array['ebay_template'] = $es->template;

                if($es->copy['payments'] == 1)
                        $payments = $EBAYAPI->get_payments('ebay_sammler_payments','ebay_sammler_id',$cart);

                if($es->copy['itemspecifics'] == 1)
                        $EBAYAPI->get_itemspecifics('sammler',$cart,$item_specifics);
                else
                        $item_specifics = array();

                $itemspecifics_recommendations = array();
                if($es->copy['itemspecifics_recommendations'] == 1)
                        $itemspecifics_recommendations = $EBAYAPI->get_itemspecifics_recommendations ($cart, 'sammler');

                if($es->copy['shippingmethods'] == 1)
                        $EBAYAPI->get_shippingcosts_value('sammler',$item_shippingcosts,$cart);
                else
                        $item_shippingcosts = array();

                if($es->copy['characteristics'] == 1)
                        $characteristics = $EBAYAPI->get_characteristics($source = 'ebay_sammler_characteristics',$index = 'ebay_sammler_id',$source_id = $cart );
                else
                        $characteristics = array();
                $sql_array['products_id'] = $products_id;

                // NEUES HANDLING - KATEGORIE AUS SAMMLER
                if($es->copy['category'] == 1)
                        $sql_array['ebay_kategorie'] = $es->getCategory();
                if($es->copy['category2'] == 1)
                        $sql_array['ebay_kategorie2'] = $es->getCategory2();


                $sql_array['ebay_preis'] = $auctionStartPrice;
                $sql_array['ebay_sofortkauf_preis'] = $buyItNowPrice;
                $sql_array['ebay_bild'] = $ebay_bild;
                $sql_array['ebay_titel'] = $_REQUEST['products_name'][$lID][$cc];
                $sql_array['ebay_beschreibung'] = '';
                $sql_array['ebay_sammler_id'] = $cart;
                $sql_array['STATUS'] = $status;
                $sql_array['ebay_angebotsformat'] = 'FixedPriceItem';
                $sql_array['ebay_menge'] = (int)xtc_db_input($_REQUEST['quantity'][$cc]);
                xtc_db_perform('ebay_products',$sql_array);
                $epID = xtc_db_insert_id();

                if(is_array($payments) and sizeOf($payments)>0){
                    foreach($payments as $k=>$v){
                            xtc_db_query("INSERT INTO ebay_products_payments SET ebay_products_id='".$epID."',payment='".$v."'");
                    }
                }
                // itemspecifics kopieren
                if(is_array($item_specifics) and sizeOf($item_specifics)>0){
                        foreach($item_specifics as $k=>$v){
                                $insert_sql_array = array(
                                        'is_name'=>$v['name'],
                                        'is_value'=>$v['value'],
                                        'ebay_products_id'=>$epID
                                );
                                xtc_db_perform('ebay_products_itemspecifics',$insert_sql_array);
                        }
                }
                if(is_array($itemspecifics_recommendations) and sizeOf($itemspecifics_recommendations)){
                        foreach($itemspecifics_recommendations as $k=>$v){
                                $insert_sql_array = array(
                                        'is_name'=>$v['name'],
                                        'is_value'=>$v['value'],
                                        'ebay_products_id'=>$epID
                                );
                                xtc_db_perform('ebay_products_itemspecifics_recommendations',$insert_sql_array);
                        }
                }

                if(sizeOf($item_shippingcosts)>0)
                        $EBAYAPI->save_ebayshipping_values($item_shippingcosts,'ebay_products',$epID);

                // CHARACTERISTICS KOPIEREN
                $EBAYAPI->copy_characteristics($characteristics,$target = 'ebay_products_characteristics',$index = 'ebay_products_id', $epID);

                if(sizeOf($noebay)){
                    foreach($noebay as $pic){
                        $insert_sql_array = array(
                            'pic'=>$pic,
                            'ebay_products_id'=>$epID
                        );
                        xtc_db_perform('ebay_template_excludes',$insert_sql_array);
                    }
                }

                if(EBAY_PRODUCTS_HISTORY == 1){
                        $EBAYAPI->save_history($epID,TEXT_HISTORY_CART_PRODUCT_SAVED,$_SESSION['customer_id']);
                }
            } // eof foreach created_pid
            $pid_str = implode('-',$created_pid);
            xtc_redirect(xtc_href_link('quick_product_add.php','err_msg_num='.(int)xtc_db_input($_REQUEST['err_msg_num']).'&products_id='.$pid_str));
            exit;
            break;
    }
}

$smarty = new yesSmarty;

if( (!defined('QUICK_PRODUCT_ADD_CATEGORY') or QUICK_PRODUCT_ADD_CATEGORY < 1) or (isset($_REQUEST['action']) and $_REQUEST['action'] == 'set_shopcategory') ){
    $value = (defined('QUICK_PRODUCT_ADD_CATEGORY')) ? QUICK_PRODUCT_ADD_CATEGORY : '';
    $cat_select = \YES4Trade\Model\category::get_categories_tree_select([
        'return_function'=>sprintf('$(\'input[name="category_id"]\').val(id);'),
        'ALL_ITEMS_SELECTABLE'=>'false'
    ], new \yesSmarty());

    $smarty->assign(array(
        'QUICK_PRODUCT_ADD_CATEGORY_EDIT'=>1,
        'INPUT_CID'=> $cat_select
        . '<br />Category ID'
        . xtc_draw_input_field('category_id',$value,'size="8"',false,'number'),
	'link'=>'',
        'IMAGE_SEARCH'=>IMAGE_SEARCH,
        'IMAGE_SAVE'=>IMAGE_SAVE
    ));
    
}
$languages = xtc_get_languages();
$inputs = array();
foreach($languages as $lang){
    $inputs[] = array(
        'INPUT_NAME'=>xtc_draw_input_field('products_name['.$lang['id'].'][]','','title="'.INPUT_NAME_DEFAULT.' '.$lang['name'].'" class="textInput defaultText" id="products_name_'.$lang['id'].'"  maxlength="80" size="80"'),
        'INPUT_TITLE'=>TEXT_INPUT_NAME.' '.$lang['name'],
        'INPUT_TITLE_INTRO'=>TEXT_INPUT_NAME_INTRO
    );
}
if(isset($_REQUEST['products_id'])){
    $errmsgnum = (int)xtc_db_input($_REQUEST['err_msg_num']);
    if(strstr($_REQUEST['products_id'], '-')){
        $pa = explode('-',$_REQUEST['products_id']);
    }else{
        $pa = array($_REQUEST['products_id']);
    }
    foreach($messageStack->errors as $nr=>$err){
        if($nr >= $_REQUEST['err_msg_num']){
            $error_strings[] = $err['text'];
            $errmsgnum--;
        }
    }
    $link_pID = '';
    foreach($pa as $pID){
        $cPath = xtc_get_product_path((int)xtc_db_input($pID));
        $link_pID .= sprintf('<a target="_blank" style="color:#009900;text-decoration:underline;" href="%s">%s</a>&nbsp;',
            xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&pID=' . $pID . '&action=new_product'),
            $pID
        );
    }
}else{
    $errmsgnum = sizeOf($messageStack->errors);
}

$addcat = (defined('QUICK_PRODUCT_ADD_CATEGORY'))?QUICK_PRODUCT_ADD_CATEGORY:0;
$smarty->assign(array(
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'TEXT_INPUT_PRICE'=>TEXT_INPUT_PRICE,
    'TEXT_INPUT_PRICE_INTRO'=>TEXT_INPUT_PRICE_INTRO,
    'TEXT_INPUT_NAME'=>TEXT_INPUT_NAME,
    'TEXT_INPUT_QUANTITY'=>TEXT_INPUT_QUANTITY,
    'TEXT_INPUT_QUANTITY_INTRO'=>TEXT_INPUT_QUANTITY_INTRO,
    'TEXT_INPUT_EBAYSHOP'=>TEXT_INPUT_EBAYSHOP,
    'TEXT_INPUT_EBAYSHOP_INTRO'=>TEXT_INPUT_EBAYSHOP_INTRO,
    'TEXT_INPUT_CART'=>TEXT_INPUT_CART,
    'TEXT_INPUT_CART_INTRO'=>TEXT_INPUT_CART_INTRO,
    'TEXT_FIRST_SELECT_EBAYSHOP'=>TEXT_FIRST_SELECT_EBAYSHOP,
    'BUTTON_START'=>BUTTON_START,
    'BUTTON_ADD'=>BUTTON_ADD,
    'BUTTON_CANCEL'=>BUTTON_CANCEL,
    'HEADING_TITLE'=>HEADING_TITLE,
    'INTRO_QUICK_PRODUCT_ADD_CATEGORY_EDIT'=>INTRO_QUICK_PRODUCT_ADD_CATEGORY_EDIT,
    'QUICK_PRODUCT_ADD_CATEGORY'=>'Schnellerfassung Zielkategorie',
    'QUICK_PRODUCT_ADD_CATEGORY_PATH'=> xtc_output_generated_category_path($addcat),
    'TEXT_QUICK_PRODUCT_EDIT_CATEGORY_LINK'=>TEXT_QUICK_PRODUCT_EDIT_CATEGORY_LINK,
    'TEXT_SHOPCATEGORY'=>TEXT_SHOPCATEGORY,
    'JS_ERROR_FILL_OUT_ALL_FIELDS'=>JS_ERROR_FILL_OUT_ALL_FIELDS,
    'INPUTS'=>$inputs,
    'ERROR'=>((isset($_REQUEST['error']))?1:0),
    'SUCCESS'=>((isset($_REQUEST['products_id']))? sprintf(TEXT_PRODUCT_ADDED,$link_pID): ''),
    'TEXT_NO_EBAY_IMAGE'=>TEXT_NO_EBAY_IMAGE,
    'TEXT_NO_SHOP_IMAGE'=>TEXT_NO_SHOP_IMAGE,
    'TEXT_EBAY_GALLERY'=>TEXT_EBAY_GALLERY,
    'ERRORS'=>$error_strings,
    'ERROR_MESSAGE_NUM_INPUT'=>xtc_draw_hidden_field('err_msg_num',$errmsgnum),
    'CDN_UI_CSS'=>yes_get_cdn_link('jquery-ui-css'),
    'CDN_JQUERY_JS'=>yes_get_cdn_link('jquery'),
));
yes_draw_pre_header();
echo $smarty->display('quick_product_add.html');


//include(DIR_WS_INCLUDES.'footer.php');
include(DIR_WS_INCLUDES.'application_bottom.php');

