<?php
require_once('includes/application_top.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'order.php');
require_once(DIR_FS_INC . 'xtc_serials.inc.php');
require_once(DIR_FS_INC . 'xtc_retoure_copy_product.inc.php');
if(defined('YES_BRANCHES_COUNT') and YES_BRANCHES_COUNT > 0){
    if(!isset($_SESSION['allocated_branches_id'])){
	    $messageStack->add_session(MSG_ERROR_NO_BRANCH_SELECTED,'error');
	    xtc_redirect(xtc_href_link('start.php'));
    }
    $branch_query = xtc_db_query(sprintf("SELECT * FROM branches WHERE branches_id='%s'",$_SESSION['allocated_branches_id']));
    $branch = xtc_db_fetch_array($branch_query);
    $STAMMLAGER = ($branch['stammlager'] == 1) ? true : false;
}else{
    $STAMMLAGER = true;
}
function check_full_set($colli_qty=array(),$submt_qty = array()){
	$complete = 0;
	$rest = $submt_qty[0] % $colli_qty[0];
	if($rest == 0){
		$teiler = $submt_qty[0]/$colli_qty[0];
		//echo 'teiler '.$teiler."\r\n";
		foreach($colli_qty as $nr => $cqty){
			$mod = $submt_qty[ $nr ] % $cqty;
			//echo "\tmod $mod\n";
			if( $mod == 0 ){
				$soll = $colli_qty[ $nr ] * $teiler;
				if($soll == $submt_qty[$nr]){
					//echo 'Colli qty DB='.$cqty.' / submitted: '.$submt_qty[ $nr ]."\r\n";
					$complete++;
				}
			}
		}
	}
	if(sizeOf($submt_qty) == $complete){
		return true;
	}else{
		return false;
	}
}

$basics = new basics;
$admin_access = main::get_admin_access();

$RETOURE_CAT = \YES4Trade\Model\categories_description::get_retoure_categories_id();
if($RETOURE_CAT < 1){
    $messageStack->add_session(MSG_ERROR_NO_RETOURE_CAT,'error');
    xtc_redirect(xtc_href_link('start.php'));
}

$valid_order_statuses = array(ORDERS_STATUS_BEZAHLT,ORDERS_STATUS_VERSENDET,ORDERS_STATUS_ABGESCHLOSSEN);
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$oID = (int)xtc_db_input($_GET['oID']);
if(xtc_not_null($oID)){
	$check_order_query = xtc_db_query(sprintf("SELECT orders_id FROM orders WHERE orders_id='%s' and orders_status IN(%s)",
		$oID,
		implode(',',$valid_order_statuses)
	));
	if(xtc_db_num_rows($check_order_query)){
		$order = new order($oID);
	}else{
		$smarty->assign('ORDERS_STATUS_ERROR',TEXT_ORDERS_STATUS_ERROR);
	}
}


if(xtc_not_null($_GET['action'])){
	switch($_GET['action']){
		case 'create_reclamation':
                    if( isset($_REQUEST['verrechnung']) and $_REQUEST['verrechnung'] == 'rueckerstattung' ){
                        $rueckerstattung_betrag = (float)xtc_db_input(str_replace(',','.',$_REQUEST['rueckerstattung_betrag']));
                        if($rueckerstattung_betrag === 0){
                            $messageStack->add_session(MSG_ERROR_RUECKERSTATTUNG_BETRAG,'error');
                            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
                        }
                    }
                            
                    $qty_defekt_array = (isset($_POST['qty_defekt'])) ? $_POST['qty_defekt'] : array();
                    $collie_qty_defekt_array = (isset($_POST['collie_qty_defekt'])) ? $_POST['collie_qty_defekt'] : array();
                    $submit_qty_array = (isset($_POST['submit_qty']))?$_POST['submit_qty']:array();
                    $submit_collie_qty_array = (isset($_POST['submit_collie_qty']))?$_POST['submit_collie_qty']:array();
                    $comments_defekt_array = (isset($_POST['comments_defekt']))?$_POST['comments_defekt']:array();
                    if(sizeOf($submit_qty_array)>0){
                        foreach($submit_qty_array as $opID => $qty){
                            if( $qty_defekt_array[$opID] > 0 and (!$comments_defekt_array[$opID] or $comments_defekt_array[$opID] == '') ){
                                die('WRONG PARAMETER COUNT2');
                            }
                        }
                    }
                    if(sizeOf($submit_collie_qty_array)>0){
                        foreach($submit_collie_qty_array as $opID => $collie){
                            foreach($collie as $cpID => $qty){
                                if( $collie_qty_defekt_array[$opID][$cpID] > 0 and (!$comments_defekt_array[$opID][$cpID] or $comments_defekt_array[$opID][$cpID] == '') ){
                                    die('WRONG PARAMETER COUNT2.1');
                                }
                            }
                        }
                    }

                    // reklamationskunden/metadaten speichern
                    $oID = (int)xtc_db_input($_GET['oID']);
                    $order = new order($oID);
                    $status = 3;
                    $sql_array = array('orders_id' => $oID,
                        'customers_id' => $order->customer['ID'],
                        'ebay_id' => $order->info['ebay_id'],
                        'customers_cid' => $order->customer['csID'],
                        'customers_vat_id' => xtc_db_input($order->customer['vat_id']),
                        'customers_status' => $order->info['status'],
                        'customers_status_name' => xtc_db_input($order->info['status_name']),
                        'customers_status_image' => xtc_db_input($order->info['status_image']),
                        'customers_status_discount' => xtc_db_input($order->info['status_discount']),
                        'customers_name' => $order->customer['name'],
                        'customers_company' => $order->customer['company'],
                        'customers_street_address' => $order->customer['street_address'],
                        'customers_suburb' => $order->customer['suburb'],
                        'customers_city' => $order->customer['city'],
                        'customers_postcode' => $order->customer['postcode'],
                        'customers_country' => $order->customer['country'],
                        'customers_email_address' => xtc_db_input($order->customer['email_address']),
                        'customers_address_format_id' => $order->customer['format_id'],
                        'delivery_name' => $order->delivery['name'],
                        'delivery_company' => $order->delivery['company'],
                        'delivery_street_address' => $order->delivery['street_address'],
                        'delivery_suburb' => $order->delivery['suburb'],
                        'delivery_city' => $order->delivery['city'],
                        'delivery_postcode' => $order->delivery['postcode'],
                        'delivery_country' => $order->delivery['country'],
                        'delivery_address_format_id' => $order->delivery['format_id'],
                        'billing_name' => $order->billing['name'],
                        'billing_company' => $order->billing['company'],
                        'billing_street_address' => $order->billing['street_address'],
                        'billing_suburb' => $order->billing['suburb'],
                        'billing_city' => $order->billing['city'],
                        'billing_postcode' => $order->billing['postcode'],
                        'billing_country' => $order->billing['country'],
                        'billing_address_format_id' => $order->billing['format_id'],
                        'payment_method' => $order->info['payment_method'],
                        'last_modified' => "now()",
                        'date_created' => "now()",
                        'reclamations_status' => $status,
                        'reclamations_type' => RECLAMATIONS_STATUS_WARENRUECKNAHME,
                        'currency' => xtc_db_input($order->info['currency']),
                        'currency_value' => xtc_db_input($order->info['currency']),
                        'language' => xtc_db_input($order->info['language'])
                    );
                    $reclamations_query = xtc_db_perform('reclamations',$sql_array);
                    $reclamations_id = xtc_db_insert_id($reclamations_query);

                    // zu reklamierende Produkte speichern
                    // COLLIES
                    if(isset($_SESSION['allocated_branches_id'])){
                        $branch_title = xtc_get_branch_title($_SESSION['allocated_branches_id']);
                        if($STAMMLAGER){
                            $branch_title = TEXT_MAIN_STORAGE.' ('.$branch_title.')';
                        }
                    }else{
                        $branch_title = TEXT_MAIN_STORAGE;
                    }
                    if(is_array($submit_collie_qty_array) and sizeOf($submit_collie_qty_array)>0){
                        foreach( $submit_collie_qty_array as $opID=>$collies ){
                            foreach($order->products as $op){
                                if($op['opID'] == $opID){
                                    $pID = $op['id'];
                                }
                            }
                            foreach($collies as $cpID => $cqty){
                                $cpID = (int)xtc_db_input($cpID);
                                $cqty = (int)xtc_db_input($cqty);
                                if($cqty>0){
                                    // brauchen das products model des collis
                                    $products_data_query = xtc_db_query(sprintf(
                                        "SELECT products_tax_class_id,products_model,products_price
                                                FROM products WHERE products_id='%s'",
                                        $cpID
                                    ));
                                    $products_data = xtc_db_fetch_array($products_data_query);
                                    $pname = xtc_get_products_name($cpID);

                                    // REKLAMATIONS COLLI PRODUKT SPEICHERN
                                    $sql_array = array('reclamations_id'=>$reclamations_id,
                                        'products_id'=>$cpID,
                                        'products_model'=>$products_data['products_model'],
                                        'products_name'=>$pname,
                                        'products_price'=>'0.00',
                                        'products_discount_made'=>0,
                                        'final_price'=>'0.00',
                                        'products_tax'=>'0.00',
                                        'products_quantity'=>$cqty,
                                        'allow_tax'=>0
                                    );
                                    xtc_db_perform('reclamations_products',$sql_array);
                                    $rpID = xtc_db_insert_id();


                                    // orders_status_history updaten
                                    $comments = sprintf(HISTORY_ORDER_COLLI_SAVED_IN_RECLAMATION,$cpID,$pID,$reclamations_id,$cqty);
                                    $order->add_history($order->info['orders_status'], 0, $comments);

                                    $comments = sprintf(HISTORY_RECLAMATION_COLLI_SAVED,$cpID,$pID,$cqty,$branch_title);
                                    $new = new \YES4Trade\Model\reclamations_status_history([
                                        'reclamations_id'=>(int)$reclamations_id,
                                        'reclamations_status_id'=>(int)$status,
                                        'editor_id'=>(int)$_SESSION['customer_id'],
                                        'customer_notified'=>0,
                                        'date_added'=>date('Y-m-d H:i:s'),
                                        'comments'=>$comments
                                    ]);
                                    $new->create();

                                    // BESTANDSBUCHUNG ZUR USERFILIALE
                                    $product_qty_defect = (int)xtc_db_input($collie_qty_defekt_array[$opID][$cpID]);
                                    $product_qty_submitted = (int)xtc_db_input($submit_collie_qty_array[$opID][$cpID]);
                                    $qty_to_add = $product_qty_submitted - $product_qty_defect;
                                    if($STAMMLAGER){
                                        $SQ = new products_quantity($cpID);
                                        $new_qty = $qty_to_add;
                                        $qty_total = $SQ->get_products_total_qty();
                                        $comments = sprintf(HISTORY_MAINSTORAGE_PRODUCTS_TRANSFER,$reclamations_id);
                                        $SQ->update_qty( $new_qty, 
                                            $SQ->get_default_storage_id(),
                                            $qty_total,
                                            $comments
                                        );
                                    }else{
                                        $branches_products_query = xtc_db_query(
                                            sprintf("SELECT branches_products_id,products_quantity FROM branches_products WHERE branches_id='%s' and products_id='%s'",
                                            $_SESSION['allocated_branches_id'],
                                            $cpID
                                        ));

                                        if(xtc_db_num_rows($branches_products_query)){
                                            // PRODUKT IN FILIALE GESPEICHERT
                                            $branches_products = xtc_db_fetch_array($branches_products_query);
                                            $bpID = $branches_products['branches_products_id'];
                                            xtc_db_query(sprintf(
                                                "UPDATE branches_products
                                                SET products_quantity=products_quantity+%s WHERE
                                                branches_products_id='%s'",
                                                $qty_to_add,
                                                $bpID
                                            ));
                                        }else{
                                            // PRODUKT NICHT IN FILIALE GESPEICHERT - HINZUFUEGEN
                                            $insert_sql_array = array(
                                                'branches_id'=>$_SESSION['allocated_branches_id'],
                                                'products_id'=>$cpID,
                                                'products_quantity'=>$qty_to_add
                                            );
                                            xtc_db_perform('branches_products',$insert_sql_array);
                                            $bpID = xtc_db_insert_id();

                                            $comments = sprintf(HISTORY_BRANCH_PRODUCT_ADDED,xtc_get_products_name($cpID),$cpID,$reclamations_id);
                                            $insert_sql_array = array(
                                                'branches_id'=>$_SESSION['allocated_branches_id'],
                                                'date_created'=>'now()',
                                                'comments'=>$comments,
                                                'editor_id'=>$_SESSION['customer_id']
                                            );
                                            xtc_db_perform('branches_history',$insert_sql_array);
                                        }
                                    } // END IF STAMMLAGER
                                    $comments = sprintf(HISTORY_PRODUCT,$reclamations_id,$qty_to_add,$branch_title);
                                    $insert_sql_array = array(
                                        'products_id'=>$cpID,
                                        'editor_id'=>$_SESSION['customer_id'],
                                        'date_saved'=>'now()',
                                        'comments'=>$comments
                                    );
                                    xtc_db_perform('products_history',$insert_sql_array);

                                    if($product_qty_defect > 0){
                                        // NEUES RETOURE PRODUKT MIT ANZAHL (DEFEKT) ANLEGEN
                                        $categories_id = $RETOURE_CAT;
                                        $cat_ids = array('0'=>$categories_id);
                                        $comments = sprintf(HISTORY_GENERATE_RETOURE_PRODUCT,$cpID,$reclamations_id,$branch_title);
                                        xtc_retoure_copy_product($cpID,$cat_ids,$product_qty_defect,$comments,xtc_db_input($comments_defekt_array[$opID][$cpID]));
                                        $new_product_query = xtc_db_query("SELECT products_id FROM products ORDER BY products_id DESC LIMIT 1");
                                        $new_product = xtc_db_fetch_array($new_product_query);
                                        $new_products_id = $new_product['products_id'];

                                        if(!$STAMMLAGER){
                                            // NUN IM STAMMLAGER PRODUKT NULLEN
                                            $SQ = new products_quantity($new_products_id);
                                            $new_qty = $product_qty_defect;
                                            $qty_total = $SQ->get_products_total_qty();
                                            $comments = sprintf(HISTORY_RETOURE_PRODUCTS_TRANSFER,$reclamations_id);
                                            $SQ->update_qty( -$new_qty, $SQ->get_default_storage_id(),$qty_total,$comments,
                                               'reklamation',$reclamations_id,'Defekt'
                                            );


                                            // RETOURE PRODUKT IN FILIALE SPEICHERN
                                            $insert_sql_array = array(
                                                'branches_id'=>$_SESSION['allocated_branches_id'],
                                                'products_id'=>$new_products_id,
                                                'products_quantity'=>$product_qty_defect
                                            );
                                            xtc_db_perform('branches_products',$insert_sql_array);
                                            $bpID = xtc_db_insert_id();
                                        }

                                        // FILIALKOMMENTAR
                                        if(isset($_SESSION['allocated_branches_id'])){
                                            $comments = sprintf(HISTORY_BRANCH_RETOURE_PRODUCT_ADDED,xtc_get_products_name($new_products_id),$new_products_id,$reclamations_id);
                                            $insert_sql_array = array(
                                                'branches_id'=>$_SESSION['allocated_branches_id'],
                                                'date_created'=>'now()',
                                                'comments'=>$comments,
                                                'editor_id'=>$_SESSION['customer_id']
                                            );
                                            xtc_db_perform('branches_history',$insert_sql_array);
                                        }

                                        // KOMMENTAR IN REKLA
                                        $comments = sprintf(HISTORY_RECLAMATION_COLLIE_RETOUREPRODUCT_SAVED,
                                            xtc_get_products_name($cpID),
                                            $cpID,
                                            $product_qty_defect,
                                            $new_products_id,
                                            $branch_title
                                        );
                                        $new = new \YES4Trade\Model\reclamations_status_history([
                                            'reclamations_id'=>(int)$reclamations_id,
                                            'reclamations_status_id'=>(int)$status,
                                            'editor_id'=>(int)$_SESSION['customer_id'],
                                            'customer_notified'=>0,
                                            'date_added'=>date('Y-m-d H:i:s'),
                                            'comments'=>$comments
                                        ]);
                                        $new->create();
                                    } // end if defects
                                } // end if cqty > 0
                            } // end foreach submitted collies
                        } // end main foreach collies
                    } // end if collies

                    // MAIN PRODUCTS
                    if(is_array($submit_qty_array) and sizeOf($submit_qty_array)>0){
                        foreach( $submit_qty_array as $opID=>$qty ){
                            foreach($order->products as $op){
                                if($op['opID'] == $opID){
                                    $pID = $op['id'];
                                }
                            }
                            $qty = (int)xtc_db_input($qty);
                            if($qty>0){
                                // brauchen das products model des collis
                                $products_data_query = xtc_db_query(sprintf(
                                        "SELECT products_tax_class_id,products_model,products_price
                                                FROM products WHERE products_id='%s'",
                                        $pID
                                ));
                                $products_data = xtc_db_fetch_array($products_data_query);
                                $pname = xtc_get_products_name($pID);

                                // REKLAMATIONS COLLI PRODUKT SPEICHERN
                                $sql_array = array('reclamations_id'=>$reclamations_id,
                                    'products_id'=>$pID,
                                    'products_model'=>$products_data['products_model'],
                                    'products_name'=>$pname,
                                    'products_price'=>'0.00',
                                    'products_discount_made'=>0,
                                    'final_price'=>'0.00',
                                    'products_tax'=>'0.00',
                                    'products_quantity'=>$qty,
                                    'allow_tax'=>0);
                                xtc_db_perform('reclamations_products',$sql_array);
                                $rpID = xtc_db_insert_id();


                                // orders_status_history updaten
                                $comments = sprintf(HISTORY_ORDER_PRODUCT_SAVED_IN_RECLAMATION,xtc_get_products_name($pID),$pID,$reclamations_id,$qty);
                                $order->add_history($order->info['orders_status'], 0, $comments);

                                $comments = sprintf(HISTORY_RECLAMATION_PRODUCT_SAVED,xtc_get_products_name($pID),$pID,$qty,$branch_title);
				$new = new \YES4Trade\Model\reclamations_status_history([
                                    'reclamations_id'=>(int)$reclamations_id,
                                    'reclamations_status_id'=>(int)$status,
                                    'editor_id'=>(int)$_SESSION['customer_id'],
                                    'customer_notified'=>0,
                                    'date_added'=>date('Y-m-d H:i:s'),
                                    'comments'=>$comments
                                ]);
                                $new->create();

                                // BESTANDSBUCHUNG ZUR USERFILIALE
                                $product_qty_defect = (int)$qty_defekt_array[$opID];
                                $product_qty_submitted = (int)$submit_qty_array[$opID];
                                $qty_to_add = $product_qty_submitted - $product_qty_defect;

                                $comments = sprintf(HISTORY_PRODUCT,$reclamations_id,$qty_to_add,$branch_title);
                                $insert_sql_array = array(
                                    'products_id'=>$pID,
                                    'editor_id'=>$_SESSION['customer_id'],
                                    'date_saved'=>'now()',
                                    'comments'=>$comments
                                );
                                xtc_db_perform('products_history',$insert_sql_array);

                                if($STAMMLAGER){
                                    $SQ = new products_quantity($pID);
                                    $new_qty = $qty_to_add;
                                    $qty_total = $SQ->get_products_total_qty();
                                    $comments = sprintf(HISTORY_MAINSTORAGE_PRODUCTS_TRANSFER,$reclamations_id);
                                    $SQ->update_qty( $new_qty, $SQ->get_default_storage_id(),$qty_total,$comments);
                                }else{
                                    $branches_products_query = xtc_db_query(sprintf(
                                        "SELECT branches_products_id,products_quantity FROM branches_products WHERE branches_id='%s' and products_id='%s'",
                                        $_SESSION['allocated_branches_id'],
                                        $pID
                                    ));

                                    if(xtc_db_num_rows($branches_products_query)){
                                        // PRODUKT IN FILIALE GESPEICHERT
                                        $branches_products = xtc_db_fetch_array($branches_products_query);
                                        $bpID = $branches_products['branches_products_id'];
                                        xtc_db_query(sprintf(
                                            "UPDATE branches_products
                                                    SET products_quantity=products_quantity+%s WHERE
                                                    branches_products_id='%s'",
                                            $qty_to_add,
                                            $bpID
                                        ));
                                    }else{
                                        // PRODUKT NICHT IN FILIALE GESPEICHERT - HINZUFUEGEN
                                        $insert_sql_array = array(
                                            'branches_id'=>$_SESSION['allocated_branches_id'],
                                            'products_id'=>$pID,
                                            'products_quantity'=>$qty_to_add
                                        );
                                        xtc_db_perform('branches_products',$insert_sql_array);
                                        $bpID = xtc_db_insert_id();

                                        $comments = sprintf(HISTORY_BRANCH_PRODUCT_ADDED,xtc_get_products_name($cpID),$pID,$reclamations_id);
                                        $insert_sql_array = array(
                                            'branches_id'=>$_SESSION['allocated_branches_id'],
                                            'date_created'=>'now()',
                                            'comments'=>$comments,
                                            'editor_id'=>$_SESSION['customer_id']
                                        );
                                        xtc_db_perform('branches_history',$insert_sql_array);
                                    }
                                } // END IF !STAMMLAGER



                                if($product_qty_defect > 0){
                                    // NEUES RETOURE PRODUKT MIT ANZAHL (DEFEKT) ANLEGEN
                                    $categories_id = $RETOURE_CAT;
                                    $cat_ids = array('0'=>$categories_id);
                                    $comments = sprintf(HISTORY_GENERATE_RETOURE_PRODUCT,$pID,$reclamations_id,$branch_title);
                                    xtc_retoure_copy_product($pID,$cat_ids,$product_qty_defect,$comments,xtc_db_input($comments_defekt_array[$opID]));
                                    $new_product_query = xtc_db_query("SELECT products_id FROM products ORDER BY products_id DESC LIMIT 1");
                                    $new_product = xtc_db_fetch_array($new_product_query);
                                    $new_products_id = $new_product['products_id'];

                                    if(!$STAMMLAGER){
                                        // NUN IM STAMMLAGER PRODUKT NULLEN
                                        $SQ = new products_quantity($new_products_id);
                                        $new_qty = $product_qty_defect;
                                        $qty_total = $SQ->get_products_total_qty();
                                        $comments = sprintf(HISTORY_RETOURE_PRODUCTS_TRANSFER,$reclamations_id);
                                        $SQ->update_qty( -$new_qty, $SQ->get_default_storage_id(),$qty_total,$comments,
                                            'reklamation',$reclamations_id,'Defekt'
                                        );

                                        // RETOURE PRODUKT IN FILIALE SPEICHERN
                                        $insert_sql_array = array(
                                            'branches_id'=>$_SESSION['allocated_branches_id'],
                                            'products_id'=>$new_products_id,
                                            'products_quantity'=>$product_qty_defect
                                        );
                                        xtc_db_perform('branches_products',$insert_sql_array);
                                        $bpID = xtc_db_insert_id();
                                    }

                                    // FILIALKOMMENTAR
                                    if(isset($_SESSION['allocated_branches_id'])){
                                        $comments = sprintf(HISTORY_BRANCH_RETOURE_PRODUCT_ADDED,xtc_get_products_name($new_products_id),$new_products_id,$reclamations_id);
                                        $insert_sql_array = array(
                                            'branches_id'=>$_SESSION['allocated_branches_id'],
                                            'date_created'=>'now()',
                                            'comments'=>$comments,
                                            'editor_id'=>$_SESSION['customer_id']
                                        );
                                        xtc_db_perform('branches_history',$insert_sql_array);
                                    }

                                    // KOMMENTAR IN REKLA
                                    $comments = sprintf(HISTORY_RECLAMATION_RETOUREPRODUCT_SAVED,
                                        xtc_get_products_name($pID),
                                        $pID,
                                        $product_qty_defect,
                                        $new_products_id,
                                        $branch_title
                                    );
                                    $new = new \YES4Trade\Model\reclamations_status_history([
                                        'reclamations_id'=>(int)$reclamations_id,
                                        'reclamations_status_id'=>(int)$status,
                                        'editor_id'=>(int)$_SESSION['customer_id'],
                                        'customer_notified'=>0,
                                        'date_added'=>date('Y-m-d H:i:s'),
                                        'comments'=>$comments
                                    ]);
                                    $new->create();
                                } // end if defects
                            } // end if cqty > 0
                        } // end foreach
                    } // end if main products array
                    
                    $umtausch = false;
                    $rueckerstattung = false;
                    if( isset($_REQUEST['verrechnung']) and $_REQUEST['verrechnung'] == 'umtausch' ){
			    $new_orders_products = array();
			    if( (is_array($submit_qty_array) and sizeOf($submit_qty_array)>0)  or (isset($_REQUEST['submit_collie_qty']) and sizeOf($_REQUEST['submit_collie_qty'])) ){
				$ot_subtotal = 0;
				foreach( $submit_qty_array as $opID=>$qty ){
				    $op_array_key = 0;
				    foreach($order->products as $opnr=>$op){
					if($op['opID'] == $opID){
					    $pID = $op['id'];
					    $op_array_key = $opnr;
					}
				    }
				    $qty = (int)xtc_db_input($qty);
				    if($qty>0){
					$ot_subtotal += $qty*$order->products[ $op_array_key ]['price'];
				    }
				}
				if(isset($_REQUEST['submit_collie_qty'])){
				    foreach($_REQUEST['submit_collie_qty'] as $opID=>$_submcollies){
					// das brauchen wir nur fuer den ersten Artikel
					// lediglich berechnen wieviel sets uebergeben wurden
					foreach($_submcollies as $_cpID=>$_cqty){
					    $op_array_key = 0;
					    foreach($order->products as $opnr=>$op){
						if($op['opID'] == $opID){
						    $setpID = $op['id'];
						    $op_array_key = $opnr;
						}
					    }
					    $collies = xtc_get_product_collies($setpID);
					    foreach($collies as $_col){
						if($_col['collie_products_id'] != $_cpID){
						    continue;
						}
						$set_qty = $_cqty / $_col['quantity'];
						if($set_qty > 0){
						    $ot_subtotal += $set_qty*$order->products[ $op_array_key ]['price'];
						}
					    }
					    break;
					}
				    }
				}
				if($ot_subtotal > 0){
				    $insert_sql_array = array(
					'customers_id'=>$order->customer['ID'],
					'ebay_id'=>$order->info['ebay_id'],
					'customers_cid'=>$order->customer['csID'],
					'customers_vat_id'=>$order->customer['vat_id'],
					'customers_status'=>$order->info['status'],
					'customers_status_name'=>$order->info['status_name'],
					'customers_status_image'=>$order->info['status_image'],
					'customers_status_discount'=>$order->info['status_discount'],
					'customers_name'=>$order->customer['name'],
					'customers_company'=>$order->customer['company'],
					'customers_street_address'=>$order->customer['street_address'],
					'customers_suburb'=>$order->customer['suburb'],
					'customers_city'=>$order->customer['city'],
					'customers_postcode'=>$order->customer['postcode'],
					'customers_state'=>$order->customer['state'],
					'customers_country'=>$order->customer['country'],
					'customers_telephone'=>$order->customer['telephone'],
					'customers_mobile'=>$order->customer['mobile'],
					'customers_email_address'=>$order->customer['email_address'],
					'customers_address_format_id'=>$order->customer['format_id'],
					'delivery_name'=>$order->delivery['name'],
					'delivery_company'=>$order->delivery['company'],
					'delivery_street_address'=>$order->delivery['street_address'],
					'delivery_suburb'=>$order->delivery['suburb'],
					'delivery_city'=>$order->delivery['city'],
					'delivery_postcode'=>$order->delivery['postcode'],
					'delivery_state'=>$order->delivery['state'],
					'delivery_country'=>$order->delivery['country'],
					'delivery_address_format_id'=>$order->delivery['format_id'],
					'billing_name'=>$order->billing['name'],
					'billing_company'=>$order->billing['company'],
					'billing_street_address'=>$order->billing['street_address'],
					'billing_suburb'=>$order->billing['suburb'],
					'billing_city'=>$order->billing['city'],
					'billing_postcode'=>$order->billing['postcode'],
					'billing_state'=>$order->billing['state'],
					'billing_country'=>$order->billing['country'],
					'billing_address_format_id'=>$order->billing['format_id'],
					'payment_method'=>$order->info['payment_method_db'],
					'cc_type'=>'',
					'cc_owner'=>'',
					'cc_number'=>'',
					'cc_expires'=>'',
					'cc_start'=>'',
					'cc_issue'=>'',
					'cc_cvv'=>'',
					'comments'=>'',
					'last_modified'=>'now()',
					'date_purchased'=>'now()',
					'date_payment'=>'now()',
					'orders_status'=>1,
					'currency'=>$order->info['currency'],
					'currency_value'=>$order->info['currency_value'],
					'account_type'=>$order->info['account_type'],
					'payment_class'=>$order->info['payment_method'],
					'shipping_method'=>'',
					'shipping_class'=>'',
					'customers_ip'=>'',
					'language'=>$order->info['language'],
					'source'=>'counter',
					'source_editor_id'=>$_SESSION['customer_id']
				    );
				    xtc_db_perform(TABLE_ORDERS,$insert_sql_array);
				    $new_orders_id = xtc_db_insert_id();
                                    
                                    // BOF - fuer jeden Artikel eine Kopie 
                                    // erzeugen. Nicht mehr einen einzelnen
                                    // Reklamationsartikel mit Negativ Auftrags-
                                    // wert
                                    
                                    foreach( $submit_qty_array as $opID=>$qty ){
                                        $op_array_key = 0;
                                        foreach($order->products as $opnr=>$op){
                                            if($op['opID'] == $opID){
                                                $insert_sql_array = array(
                                                    'orders_id'=>$new_orders_id,
                                                    'products_id'=>ORDERS_CREDIT_PRODUCTS_ID,
                                                    'products_name'=>'[reklamiert] pID '.$op['id'].' '.$op['name'],
                                                    'products_price'=> -$op['price'],
                                                    'final_price'=>-($op['price']*$qty),
                                                    'products_quantity'=>$qty,
                                                    'date_added'=>'now()',
                                                    'allow_tax'=>$op['allow_tax'],
                                                    'products_tax'=>$op['tax']
                                                );
                                                xtc_db_perform('orders_products',$insert_sql_array);
                                            }
                                        }
                                    }
                                    
				    foreach($order->totals as $_ot){
                                        $insert_sql_array = array(
                                            'orders_id'=>$new_orders_id,
                                            'title'=>$_ot['title'],
                                            'text'=>number_format($_ot['value'],2,',','.').' '.$order->info['currency'],
                                            'value'=>$_ot['value'],
                                            'class'=>$_ot['class'],
                                            'sort_order'=>$_ot['sort_order']
                                        );
                                        xtc_db_perform('orders_total',$insert_sql_array);
				    }
				    $new_order = new order($new_orders_id);
				    $new_order->add_history(1, false,'Umtausch Reklamation #'.$reclamations_id);
				    $new_order->recalc();
				    $umtausch = true;
				}
			    }
			}
			if( isset($_REQUEST['verrechnung']) and $_REQUEST['verrechnung'] == 'rueckerstattung' ){
			    if( (is_array($submit_qty_array) and sizeOf($submit_qty_array)>0)  or (isset($_REQUEST['submit_collie_qty']) and sizeOf($_REQUEST['submit_collie_qty'])) ){
				    $insert_sql_array = array(
					'orders_id'=>$oID,
					'reclamations_id'=>$reclamations_id,
					'customers_id'=>$order->customer['ID'],
					'betrag'=>$rueckerstattung_betrag,
					'paymode'=>'Bar',
					'date_created'=>'now()',
					'comments'=>TEXT_COMMENTS_RUECKERSTATTUNG_WARENWERT,
					'editor_id'=>$_SESSION['customer_id'],
					'status'=>1,
					'type'=>3
				    );
				    xtc_db_perform('rueckerstattungen',$insert_sql_array);
				    $rueckerstattungen_id = xtc_db_insert_id();
				    $rueckerstattung = true;
			    }
                        }
			$messageStack->add_session(sprintf(MSG_HISTORY_RECLAMATION_ADDED,$reclamations_id),'success');
			if($umtausch){
			    xtc_redirect(xtc_href_link('orders.php','action=edit&oID='.$new_orders_id));
                        }elseif($rueckerstattung){
			    xtc_redirect(xtc_href_link('rueckerstattungen.php','action=edit&rID='.$rueckerstattungen_id));
			}else{
			    xtc_redirect(xtc_href_link('reclamations.php','action=edit&rID='.$reclamations_id));
			}
			break;
		case 'check':
			$selected_products = $_POST['qty'];
			$selected_collie_products = $_POST['collie_qty'];
			if( (!xtc_not_null($selected_products) and !is_array($selected_products)) and (!xtc_not_null($selected_collie_products) and !is_array($selected_collie_products))){
				$messageStack->add_session(MSG_ERROR_PLEASE_SELECT_PRODUCTS,'error');
				xtc_redirect(xtc_href_link('quick_reclamation.php',xtc_get_all_get_params(array('action')).'action=select_products'));
			}else{
				$products_array = array();
				if(sizeOf($selected_products)>0){
					foreach($selected_products as $opID=>$qty){
						if($qty > 0){
							$products_array[$opID]['qty'] += $qty;
						}
					}
				}
				if(is_countable($selected_collie_products) and sizeOf($selected_collie_products)>0){
					foreach($selected_collie_products as $opID=>$collies){
						if(sizeOf($collies > 0)){
							foreach($collies as $cpID=>$collie_qty){
								if($collie_qty > 0){
									$products_array[$opID]['collies'][$cpID]['qty'] += $collie_qty;
								}
							}
						}
					}
				}
				if(is_countable($products_array) and sizeOf($products_array)==0){
					$messageStack->add_session(MSG_ERROR_PLEASE_SELECT_PRODUCTS,'error');
					xtc_redirect(xtc_href_link('quick_reclamation.php',xtc_get_all_get_params(array('action')).'action=select_products'));
				}
			}
			foreach($order->products as $product){
                            if($products_array[$product['opID']]){
                                $collies = xtc_get_product_collies($product['id']);
                                // SERIENNUMMERN CHECK
                                if(!sizeOf($collies)>0){
                                    // TESTEN OB NICHT PER POST-PARAMS AN DER MENGE VERAENDERT WURDE
                                    if($products_array[$product['opID']]['qty'] > $product['qty']){
                                            die('FEHLERHAFTE PARAMETER!');
                                    }
                                }
                            }
			}
                        $create_reclamation = true;
			break;
		case 'select_products':
			$action = 'check';
			break;
	}
}else{
	$action = 'check';
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
$smarty->assign('HEADING_TITLE',HEADING_TITLE);
$smarty->assign('FORM_END','</form>');
if($order && !$create_reclamation){
	$smarty->assign('ORDERS_ID',$oID);
	$smarty->assign('ACTION_PARAMETER',$_GET['action']);
	foreach($order->products as $k=>$prod){
		$qty_array = array();
		for($i=0;$i<=$prod['qty'];$i++){
			$qty_array[] = array('id'=>$i,'text'=>$i);
		}
		if(xtc_not_null($_GET['action']) and $_GET['action'] == 'select_products'){
			$order->products[$k]['input_qty'] = xtc_draw_pull_down_menu('qty['.$prod['opID'].']',$qty_array,0,'class="ui-button ui-corner-all ui-state-default"');
		}else if($_GET['action'] == 'check'){
			$order->products[$k]['input_qty'] = xtc_draw_hidden_field('qty['.$prod['opID'].']',(int)$products_array[$prod['opID']]['qty']);
			$order->products[$k]['selected_qty'] = (int)$products_array[$prod['opID']]['qty'];
		}else if(!$_GET['action']){
			$order->products[$k]['input_qty'] = $prod['qty'];
		}else{
			$order->products[$k]['input_qty'] = xtc_draw_hidden_field('qty['.$prod['opID'].']',$prod['qty']);
		}

		$collies = xtc_get_product_collies($prod['id']);
		$order->products[$k]['collies'] = $collies;
		$order->products[$k]['collies_rowspan'] = (sizeOf($collies)+1);
		if(sizeOf($collies)>0){
			foreach($collies as $kc=>$collie){
				$collie_qty_array = array();
				$collie_qty = $collie['quantity']*$prod['qty'];
				for($i=0;$i<=$collie_qty;$i++){
					$collie_qty_array[] = array('id'=>$i,'text'=>$i);
				}
				if(xtc_not_null($_GET['action']) and $_GET['action'] == 'select_products'){
					$order->products[$k]['collies'][$kc]['input_qty'] = xtc_draw_pull_down_menu('collie_qty['.$prod['opID'].']['.$collie['collie_products_id'].']',$collie_qty_array,0,'class="ui-button ui-corner-all ui-state-default"');
				}else if($_GET['action'] == 'check'){
					$order->products[$k]['collies'][$kc]['input_qty'] = xtc_draw_hidden_field('collie_qty['.$prod['opID'].']['.$collie['collie_products_id'].']',$products_array[$prod['opID']]['collies'][$collie['collie_products_id']]['qty']);
					$order->products[$k]['collies'][$kc]['selected_qty'] = $products_array[$prod['opID']]['collies'][$collie['collie_products_id']]['qty'];
				}else{
					$order->products[$k]['collies'][$kc]['input_qty'] = xtc_draw_hidden_field('collie_qty['.$prod['opID'].']['.$collie['collie_products_id'].']',$collie_qty).$collie_qty;
				}
			}
		}
	}
	
	$smarty->assign(array(
	    'info'=>$order->info
	));
	$smarty->assign('products',$order->products);
	$smarty->assign('totals',$order->totals);
	$smarty->assign('TEXT_CUSTOMER_DATA',TEXT_CUSTOMER_DATA);
	$smarty->assign('CUSTOMER_ADDRESS',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br />'));
	$smarty->assign('TEXT_DELIVERY_DATA',TEXT_DELIVERY_DATA);
	$smarty->assign('DELIVERY_ADDRESS',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br />'));
	$smarty->assign('TEXT_BILLING_DATA',TEXT_BILLING_DATA);
	$smarty->assign('BILLING_ADDRESS',xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br />'));
	$smarty->assign('FORM',xtc_draw_form('quickreclamation','quick_reclamation.php',xtc_get_all_get_params(array('action')).'action='.$action));
	if(!xtc_not_null($_GET['action']) and $_GET['action'] != 'select_products'){
		$smarty->assign('BUTTON_SELECT_PRODUCTS',yes_draw_href_button(
				BUTTON_SELECT_PRODUCTS,
				xtc_href_link('quick_reclamation.php',
					xtc_get_all_get_params(array('action')).'action=select_products'
				)
		));
	}else if($_GET['action'] == 'select_products'){
		$smarty->assign('BUTTON_NEXT',yes_draw_href_button(
				IMAGE_SAVE,
				'',
				'',
				'submit'
		));
	}else if($_GET['action'] == 'check'){
		$smarty->assign('BUTTON_NEXT',yes_draw_href_button(
				IMAGE_SAVE,
				'',
				'',
				'submit'
		));
	}
}else if($create_reclamation){
	$smarty->assign('ORDERS_ID',$oID);
	$smarty->assign('ACTION_PARAMETER','create_reclamation');
	$smarty->assign('info',$order->info);
	foreach($products_array as $opID=>$product){
	    foreach($order->products as $op){
		if($op['opID'] == $opID){
		    $pID = $op['id'];
		}
	    }
	    $products_array[$opID]['name'] = xtc_get_products_name($pID);
	    if(!$product['collies']){
                $qty_defekt_array = array();
                for($i=0;$i<=$product['qty'];$i++){
                    $qty_defekt_array[] = array('id'=>$i,'text'=>$i);
                }
                $products_array[$opID]['input_qty'] = xtc_draw_pull_down_menu('qty_defekt['.$opID.']',$qty_defekt_array,0,'title="'.TEXT_SET_DEFECT.'"').xtc_draw_hidden_field('submit_qty['.$opID.']',$product['qty']);
                $products_array[$opID]['comments_defekt'] = xtc_draw_textarea_field('comments_defekt['.$opID.']','virtual',40,3,'');
	    }else{
                $collies_array = array();
                foreach($product['collies'] as $cpID => $collie){
                    $qty_defekt_array = array();
                    for($i=0;$i<=$collie['qty'];$i++){
                        $qty_defekt_array[] = array('id'=>$i,'text'=>$i);
                    }
                    $collies_array[] = array(
                        'collie_products_id'=> $cpID,
                        'name' => xtc_get_products_name($cpID),
                        'input_qty' => xtc_draw_pull_down_menu('collie_qty_defekt['.$opID.']['.$cpID.']',$qty_defekt_array,0,'title="'.TEXT_SET_DEFECT.'"').xtc_draw_hidden_field('submit_collie_qty['.$opID.']['.$cpID.']',$collie['qty']),
                        'submitted_qty'=>$collie['qty'],
                        'comments_defekt' => xtc_draw_textarea_field('comments_defekt['.$opID.']['.$cpID.']','virtual',40,3,''),
                    );
                }
                $products_array[$opID]['collies'] = $collies_array;
                $products_array[$opID]['collies_rowspan'] = sizeOf($product['collies'])+1;
            }
	}

	$full_sets = true;
	foreach($products_array as $_product){
	    if(!isset( $_product['collies'])){
		continue;
	    }
	    $colli_qty = array();
	    $submt_qty = array();
	    $_collies = xtc_get_product_collies($pID);
	    foreach($_collies as $_col){
		$colli_qty[] = $_col['quantity'];
		foreach($_product['collies'] as $_colli){
		    if($_col['collie_products_id'] == $_colli['collie_products_id']){
			$submt_qty[] = $_colli['submitted_qty'];
		    }
		}
	    }
	    if(!check_full_set($colli_qty,$submt_qty)){
		$full_sets = false;
	    }
	}
	if($full_sets){
            $warenwert = 0;
            foreach($products_array as $opID=>$submitted){
                foreach($order->products as $op){
                    if($op['opID'] == $opID){
                        $warenwert += $op['price'] * $submitted['qty'];
                    }
                }
            }
            $rueckerstattung_betrag = (isset($_REQUEST['rueckerstattung_betrag'])) ? (float)xtc_db_input(str_replace(',','.',$_REQUEST['rueckerstattung_betrag'])) : $warenwert;
            $rueckerstattung_betrag_formatted = number_format($rueckerstattung_betrag,2,',','');
	    $smarty->assign(array(
                'UMTAUSCH'=>(isset($_REQUEST['verrechnung']) and  $_REQUEST['verrechnung'] == 'umtausch')?1:0,
                'UMTAUSCH_VALID'=>1,
                'RUECKERSTATTUNG'=>(isset($_REQUEST['verrechnung']) and  $_REQUEST['verrechnung'] == 'rueckerstattung')?1:0,
                'INPUT_RUECKERSTATTUNG_WARENWERT'=>xtc_draw_input_field('rueckerstattung_betrag',$rueckerstattung_betrag_formatted,'size="10" maxlength="10"',false,'text',false)
            ));
	}else{
	    $smarty->assign('UMTAUSCH_ERROR',TEXT_UMTAUSCH_ERROR);
	}
	$smarty->assign(array(
	    'products'=>$products_array,
            'TEXT_NO_VERRECHNUNG'=>TEXT_NO_VERRECHNUNG,
	    'TEXT_UMTAUSCH'=>TEXT_UMTAUSCH,
            'TEXT_RUECKERSTATTUNG_WARENWERT'=>TEXT_RUECKERSTATTUNG_WARENWERT,
            'TEXT_RUECKERSTATTUNG_WARENWERT_VALUE'=>TEXT_RUECKERSTATTUNG_WARENWERT_VALUE,
	    'TEXT_UMTAUSCH_ERROR_DEFECT'=>TEXT_UMTAUSCH_ERROR_DEFECT,
	    'MSG_ERROR_NO_ORDERS_CREDIT_PRODUCTS_ID'=>MSG_ERROR_NO_ORDERS_CREDIT_PRODUCTS_ID,
	    'ORDERS_CREDIT_PRODUCTS_ID'=>ORDERS_CREDIT_PRODUCTS_ID,
	));
	$smarty->assign('TEXT_CUSTOMER_DATA',TEXT_CUSTOMER_DATA);
	$smarty->assign('CUSTOMER_ADDRESS',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br />'));
	$smarty->assign('TEXT_DELIVERY_DATA',TEXT_DELIVERY_DATA);
	$smarty->assign('DELIVERY_ADDRESS',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br />'));
	$smarty->assign('TEXT_BILLING_DATA',TEXT_BILLING_DATA);
	$smarty->assign('BILLING_ADDRESS',xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br />'));
	$smarty->assign('FORM',xtc_draw_form('quickreclamation','quick_reclamation.php',xtc_get_all_get_params(array('action')).'action=create_reclamation','post','onsubmit="return check_defekt();"'));
	$smarty->assign('BUTTON_NEXT',yes_draw_href_button(
				IMAGE_SAVE,
				'',
				'',
				'submit'
	));
}
$smarty->assign('SEARCH_FORM',xtc_draw_form('search_orders_id','quick_reclamation.php','','GET'));
$smarty->assign('INPUT_ORDERS_ID',xtc_draw_input_field('oID',$_GET['orders_id'],'size="6" maxlength="8"'));

$smarty->display('quick_reclamation.html');
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
