<?php
/* --------------------------------------------------------------
   $Id: stats_products_purchased.php,v 1.64 2020/04/30 10:28:33 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(stats_products_purchased.php,v 1.27 2002/11/18); www.oscommerce.com 
   (c) 2003	 nextcommerce (stats_products_purchased.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
$sources = array(
    'ebay','amazon','shop','counter','admin'
);
if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
    $sources[] = 'hitmeist';
}

require_once(DIR_WS_CLASSES . 'currencies.php');
require_once(DIR_WS_CLASSES . 'class.basics.php');
require(DIR_FS_INC . 'xtc_get_categories.inc.php');
require(DIR_FS_INC . 'xtc_get_manufacturers.inc.php');
require(DIR_FS_INC . 'yes_multisort.inc.php');
$currencies = new currencies();
$action = $_GET['action'] ?? null;

$endDateValue = $_REQUEST['endDate'] ?? date('Y-m-d');
$endDateAsTime = (new DateTime($endDateValue.' 23:59:59'))->getTimestamp();

$startDateValue = $_REQUEST['startDate'] ?? (new DateTime('first day of this month'))->format('Y-m-d');
$startDateAsTime = (new DateTime($startDateValue))->getTimestamp();

$dID = filter_var($_REQUEST['distributor_id'] ?? null, FILTER_VALIDATE_INT);
$pID = $_REQUEST['products_id'] ?? null;

$manID = filter_var($_REQUEST['manufacturers_id'] ?? null, FILTER_VALIDATE_INT);
$csID = $_REQUEST['customers_status_id'] ?? '';
if(!empty($csID)){
    $csID = intval($csID);
}
$master_id = filter_var($_REQUEST['master_id'] ?? null, FILTER_VALIDATE_INT);
$catID = filter_var($_REQUEST['categories_id'] ?? null, FILTER_VALIDATE_INT);
$groups_id = filter_var($_REQUEST['group'] ?? null, FILTER_VALIDATE_INT);

$products_name_search = '';
$products_name_search_submitted = $_GET['products_name_search'] ?? null;
if($products_name_search_submitted == '1' and $pID !== null){
    $products_name_search = $pID;
    $pID = null;
}
$source = xtc_db_input($_REQUEST['source'] ?? '');
$csv_export = $_REQUEST['csv_export'] ?? null;
$order_by = 'pqty DESC';
$order_by_sql = $order_by;
if(isset($_REQUEST['order_by'])){
    $order_by = xtc_db_input($_REQUEST['order_by']);
    if(!stristr($_REQUEST['order_by'],'price')){
	$order_by_sql = $order_by;
    }
}
$sort_parts = explode(' ',$order_by);

$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$distributor_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
$distributor_query = xtc_db_query(
        "SELECT id,name,ort FROM distributors ORDER BY name"
);
while($distributor = xtc_db_fetch_array($distributor_query)){
    $name = ($distributor['ort'] != '') ? xtc_db_prepare_input($distributor['name'].', '.$distributor['ort']) : xtc_db_prepare_input($distributor['name']);
    $distributor_array[] = array(
        'id'=>$distributor['id'],
        'text'=>$name
    );
}
$manufacturers = xtc_get_manufacturers();
$manufacturers_array = array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),$manufacturers);

$customers_statuses = xtc_get_customers_statuses();
$customers_statuses = array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),$customers_statuses);

$source_values = array(array(
    'id'=>'','text'=>TEXT_SELECT
));
foreach($sources as $s){
    $s_text = $s;
    switch($s){
	case 'counter':
	    $s_text = TEXT_ORDERS_SOURCE_COUNTER;
	    break;
	case 'admin':
	    $s_text = TEXT_ORDERS_SOURCE_ADMIN;
	    break;
	case 'hitmeist':
	    $s_text = 'Kaufland';
	    break;
    }
    $source_values[] = array(
	'id'=>$s,'text'=>$s_text
    );
}

$input_pid_value = ($products_name_search != '') ? $products_name_search : $pID;
$input_pid_size = ($products_name_search != '') ? 32 : 12;

$smarty->assign(array(
    'SORT_BASE_URL'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('order_by'))),
    'SUBMITTED_ORDER_BY'=>strtolower($sort_parts[0]),
    'SUBMITTED_ORDER_DIRECTION'=>strtolower($sort_parts[1]),
    'FORM_END'=>'</form>',
    'HEADING_TITLE'=>HEADING_TITLE,
    'TEXT_REPORT_STARTDATE'=>TEXT_REPORT_STARTDATE,
    'TEXT_REPORT_ENDDATE'=>TEXT_REPORT_ENDDATE,
    'FORMATTED_STARTDATE'=>$startDateValue,
    'FORMATTED_ENDDATE'=>$endDateValue,
    'TEXT_PRODUCTS_GROUP'=>TEXT_PRODUCTS_GROUP,
    'TEXT_NO_PRODUCTS_GROUPS'=>TEXT_NO_PRODUCTS_GROUPS,
    'TEXT_CATEGORY'=>TEXT_CATEGORY,
    'IMAGE_UPDATE'=>IMAGE_UPDATE,
    'TEXT_ONLY_VERSENDET'=>TEXT_ONLY_VERSENDET,
    'TEXT_ONLY_BEZAHLT'=>TEXT_ONLY_BEZAHLT,
    'INPUT_ONLY_BEZAHLT'=>xtc_draw_checkbox_field('only_bezahlt','1', ((isset($_REQUEST['only_bezahlt']) and $_REQUEST['only_bezahlt'] == 1) ? true : false ) ),
    'INPUT_ONLY_VERSENDET'=>xtc_draw_checkbox_field('only_versendet','1', ((isset($_REQUEST['only_versendet']) and $_REQUEST['only_versendet'] == 1) ? true : false ) ),
    'TABLE_HEADING_NUMBER'=>TABLE_HEADING_NUMBER,
    'TABLE_HEADING_PRODUCTS'=>TABLE_HEADING_PRODUCTS,
    'TABLE_HEADING_PRODUCTS_MODEL'=>TABLE_HEADING_PRODUCTS_MODEL,
    'TABLE_HEADING_PURCHASED'=>TABLE_HEADING_PURCHASED,
    'TABLE_HEADING_TOTAL'=>TABLE_HEADING_TOTAL,
    'TEXT_NO_SEARCH_RESULTS'=>TEXT_NO_SEARCH_RESULTS,
    'TEXT_TOTAL'=>TEXT_TOTAL,
    'TEXT_TOTAL_TAX'=>TEXT_TOTAL_TAX,
    'INPUT_DISTRIBUTOR'=>xtc_draw_pull_down_menu('distributor_id',$distributor_array,$dID),
    'TEXT_DISTRIBUTOR'=>TEXT_DISTRIBUTOR,
    'INPUT_PID'=>xtc_draw_input_field('products_id',$input_pid_value,'size="'.$input_pid_size.'"' ),
    'INPUT_SOURCE'=>xtc_draw_pull_down_menu('source',$source_values,$source),
    'TEXT_ORDERS_SOURCE'=>TEXT_ORDERS_SOURCE,
    'TEXT_ORDERS_SOURCE_ADMIN'=>TEXT_ORDERS_SOURCE_ADMIN,
    'TEXT_ORDERS_SOURCE_COUNTER'=>TEXT_ORDERS_SOURCE_COUNTER,
    'TEXT_CSV_EXPORT'=>TEXT_CSV_EXPORT,
    'INPUT_MANUFACTURER'=>xtc_draw_pull_down_menu('manufacturers_id',$manufacturers_array,$manID),
    'INPUT_CUSTOMERS_STATUS'=>xtc_draw_pull_down_menu('customers_status_id',$customers_statuses,$csID),
    'TEXT_FILTER_STATS'=>TEXT_FILTER_STATS,
    'TEXT_SEARCH_PRODUCTS_NAME'=>TEXT_SEARCH_PRODUCTS_NAME,
    'INPUT_PRODUCTS_NAME_SEARCH'=> xtc_draw_checkbox_field('products_name_search',1, ($products_name_search != ''),false,'title="'.TEXT_SEARCH_PRODUCTS_NAME.'"')
));
if($source != ''){
    $smarty->assign('TEXT_SOURCE_SELECTED',sprintf(TEXT_SOURCE_SELECTED,$source));
}


function _get_product_stat_detail($product,$rows,$master_check=true){
    global $source;
    $pID = key($product);
    global $all_tax,$all_total_netto,$startDateAsTime ,$endDateAsTime;
    
    $only = '';
    if( (isset($_GET['only_bezahlt']) and xtc_not_null($_GET['only_bezahlt'])) || (isset($_GET['only_versendet']) and xtc_not_null($_GET['only_versendet'])) ){
	    $only = ' and ';
	    if( xtc_not_null($_GET['only_bezahlt']) && xtc_not_null($_GET['only_versendet']) )
		    $only .= ' (';
	    $only .= ( xtc_not_null($_GET['only_bezahlt']) ) ? 'o.orders_status = '.ORDERS_STATUS_BEZAHLT : '';
	    if( xtc_not_null($_GET['only_bezahlt']) && xtc_not_null($_GET['only_versendet']) )
		    $only .= ' or ';
	    $only .= ( xtc_not_null($_GET['only_versendet']) ) ? ' (o.orders_status = '.ORDERS_STATUS_VERSENDET.' or o.orders_status = '.ORDERS_STATUS_ABGESCHLOSSEN .') ' : '';
	    if( xtc_not_null($_GET['only_bezahlt']) && xtc_not_null($_GET['only_versendet']) )
		    $only .= ') ';
    }
    
    
    $product_query = xtc_db_query(sprintf(
        "SELECT pd.*,p.products_model FROM products p LEFT JOIN products_description pd USING(products_id) WHERE p.products_id='%d' && language_id='%d'",
        $pID, $_SESSION['languages_id']
    ));
    $products_detail = xtc_db_fetch_array($product_query);
    if (strlen($rows) < 2) {
            $rows = '0' . $rows;
    }
    $source_sql = '';
    if($source != ''){
	$source_sql .= sprintf(" AND o.source='%s' ",$source);
    }
    $total_query = xtc_db_query(sprintf(
            "SELECT o.source,final_price,products_tax FROM orders_products op LEFT JOIN orders o USING(orders_id) WHERE op.products_id=%s and o.orders_status != %s and UNIX_TIMESTAMP(o.date_purchased)>%s and UNIX_TIMESTAMP(o.date_purchased)<%s %s %s",
            $pID,ORDERS_STATUS_STORNIERT,$startDateAsTime ,$endDateAsTime,$source_sql,$only
    ));
    $total = 0;
    $sources = array();
    while($total_record = xtc_db_fetch_array($total_query)){
        if(!isset($sources[ $total_record['source']])) $sources[ $total_record['source']] = 0;
        if($total_record['products_tax'] == 0){
            $total += $total_record['final_price'];
            $sources[ $total_record['source']] += $total_record['final_price'];
        }else{
            $tax_divisor = (100+$total_record['products_tax'])/100;
            $netto = $total_record['final_price'] / $tax_divisor;
            $total += $netto;
            $all_tax += $total_record['final_price']-$netto;
            $sources[ $total_record['source']] += $netto;
        }
    }
    $all_total_netto += $total;
    $total_sort = $total;
    $total = number_format($total,2,',','.');
    $slaves_array = array();
    $master_array = array();
    $master_id = $pID;
    if($master_check){
        $slaves_query = xtc_db_query(sprintf(
            "SELECT products_id FROM products WHERE products_master='%d'",
            $pID
        ));
        while($slaves = xtc_db_fetch_array($slaves_query)){
            $slaves_array[] = $slaves;
        }
        $master_query = xtc_db_query(sprintf(
            "SELECT products_master FROM products WHERE products_id='%d' AND products_master > 0",
            $pID
        ));
	if(xtc_db_num_rows($master_query)){
	    $master = xtc_db_fetch_array($master_query);
	    $master_id = $master['products_master'];
	}
    }
    return array(
        'PRODUCTS_ID'=>$pID,
        'LINK'=>xtc_href_link('products.php','action=ajax_view&pID='.$pID),
        'NAME'=>$products_detail['products_name'],
        'PRODUCTS_MODEL'=>$products_detail['products_model'],
        'QTY'=>$product[$pID]['pqty'],
        'CQTY'=>$product[$pID]['cqty'],
        'TOTAL'=>$total,
        'TOTAL_SORT'=>$total_sort,
        'TOTAL_AMAZON'=>$sources['amazon'],
        'TOTAL_EBAY'=>$sources['ebay'],
        'TOTAL_SHOP'=>$sources['shop'],
        'TOTAL_COUNTER'=>$sources['counter'],
        'TOTAL_ADMIN'=>$sources['admin'],
        'SLAVES'=>$slaves_array,
        'MASTER'=>$master_id,
        'SOURCES'=>$sources,
        'SLAVES_LINK'=>xtc_href_link('stats_products_purchased.php',xtc_get_all_get_params(array('action','master_id')).'action=show_slaves&master_id='.$master_id)
    );
}

$query_base = "select op.products_id,SUM(op.products_quantity) as pqty from orders_products op, orders o";

if($action == 'show_slaves'){
    $slaves_query = xtc_db_query(sprintf(
        "SELECT products_id FROM products WHERE products_master='%s'",
        $master_id
    ));
    while($slaves = xtc_db_fetch_array($slaves_query)){
        $slaves_array[] = $slaves['products_id'];
    }
    $query_raw = sprintf("%s WHERE op.orders_id=o.orders_id AND op.products_id IN(%s) group by op.products_id order by %s",
        $query_base,implode(',',$slaves_array).', '.$master_id,$order_by_sql
    );
    $stats_query = xtc_db_query($query_raw);
    $collie_query_raw = substr($query_raw,0,strpos($query_raw,'group by'));
    $collie_query_raw2 = substr($query_raw,strpos($query_raw,'group by'),strlen($query_raw));
    $stats_items = array();
    $products_data = array();
    while($stats = xtc_db_fetch_array($stats_query)){
        $cqty = 0;
        $in_collies = xtc_get_product_in_collies($stats['products_id']);
        if(sizeOf($in_collies)){
            foreach($in_collies as $ic){
                $collie_qty = $ic['quantity'];
                $cquery_raw = $collie_query_raw." AND op.products_id=".$ic['products_id'].' '.$collie_query_raw2;
                $cquery = xtc_db_query($cquery_raw);
                $c = xtc_db_fetch_array($cquery);
                $cqty += $c['pqty']*$collie_qty;

            }
        }
        $products_data[] = array( 
            $stats['products_id'] => array('pqty'=>$stats['pqty'],'cqty'=>$cqty)
        );
    }
    $all_total_netto = 0;
    $all_tax = 0;
    if(sizeOf($products_data)){
	$rows = 0;
	foreach ($products_data as $k=>$product) {
            $rows++;
            $stats_items[] = _get_product_stat_detail($product,$rows,true);
	} // end foreach
	
	$multisort = (strtolower($sort_parts[1]) == 'asc') ? SORT_ASC: SORT_DESC;
        if(strstr($order_by,'price_amazon')){
	    $stats_items = yes_multisort($stats_items,'TOTAL_AMAZON',$multisort);
        }elseif(strstr($order_by,'price_ebay')){
	    $stats_items = yes_multisort($stats_items,'TOTAL_EBAY',$multisort);
        }elseif(strstr($order_by,'price_counter')){
	    $stats_items = yes_multisort($stats_items,'TOTAL_COUNTER',$multisort);
        }elseif(strstr($order_by,'price_shop')){
	    $stats_items = yes_multisort($stats_items,'TOTAL_SHOP',$multisort);
        }elseif(strstr($order_by,'price_admin')){
	    $stats_items = yes_multisort($stats_items,'TOTAL_ADMIN',$multisort);
        }elseif(strstr($order_by,'price')){
	    $stats_items = yes_multisort($stats_items,'TOTAL_SORT',$multisort);
	}
	
	$smarty->assign('ITEMS',$stats_items);
	$smarty->assign('TOTAL',number_format($all_total_netto,2,',','.'));
	$smarty->assign('TOTAL_TAX',number_format($all_tax,2,',','.'));
    }
    $smarty->assign('POPUP',true);
    header('Content-Type: text/html; charset='.CHARSET);
    $smarty->display('stats_products_purchased.html');
    exit;
}

$only = '';
if( (isset($_GET['only_bezahlt']) and xtc_not_null($_GET['only_bezahlt'])) || (isset($_GET['only_versendet']) and xtc_not_null($_GET['only_versendet'])) ){
	if( xtc_not_null($_GET['only_bezahlt']) && xtc_not_null($_GET['only_versendet']) )
		$only = ' (';
	$only .= ( xtc_not_null($_GET['only_bezahlt']) ) ? 'o.orders_status = '.ORDERS_STATUS_BEZAHLT : '';
	if( xtc_not_null($_GET['only_bezahlt']) && xtc_not_null($_GET['only_versendet']) )
		$only .= ' or ';
	$only .= ( xtc_not_null($_GET['only_versendet']) ) ? ' (o.orders_status = '.ORDERS_STATUS_VERSENDET.' or o.orders_status = '.ORDERS_STATUS_ABGESCHLOSSEN .') ' : '';
	if( xtc_not_null($_GET['only_bezahlt']) && xtc_not_null($_GET['only_versendet']) )
		$only .= ') ';
	if( xtc_not_null($_GET['only_bezahlt']) || xtc_not_null($_GET['only_versendet']) )
		$only .= ' and ';
}


$categories_where = '';
if($catID>0){
    $categories = array($catID);
    yes_get_subcategories($categories,$catID);
    $categories_where = sprintf(
        ' and p2c.products_id=op.products_id and p2c.categories_id IN (%s)',
        implode(',',$categories)
    );
}

if($dID > 0){
    $query_base .= ", products_distributors prd";
}
if($manID > 0){
    $query_base .= ", products p";
}
if($groups_id < 1){
    if($categories_where != ''){
        $query_raw = $query_base.", products_to_categories p2c where $only op.orders_id=o.orders_id && UNIX_TIMESTAMP(o.date_purchased) > $startDateAsTime && UNIX_TIMESTAMP(o.date_purchased) < $endDateAsTime and o.orders_status NOT IN (".ORDERS_STATUS_STORNIERT.",".ORDERS_STATUS_OFFER.")";
    }else{
        $query_raw = $query_base." where $only op.orders_id=o.orders_id && UNIX_TIMESTAMP(o.date_purchased) > $startDateAsTime && UNIX_TIMESTAMP(o.date_purchased) < $endDateAsTime and o.orders_status NOT IN (".ORDERS_STATUS_STORNIERT.",".ORDERS_STATUS_OFFER.")";
    }
}else{
    if($categories_where != ''){
        $query_raw = $query_base.", products_to_categories p2c, groups_allocations ga where $only op.orders_id=o.orders_id && UNIX_TIMESTAMP(o.date_purchased) > $startDateAsTime && UNIX_TIMESTAMP(o.date_purchased) < $endDateAsTime and o.orders_status NOT IN (".ORDERS_STATUS_STORNIERT.",".ORDERS_STATUS_OFFER.")  and ga.products_id=op.products_id and ga.groups_id='".$groups_id."'";
    }else{
        $query_raw = $query_base.", groups_allocations ga where $only op.orders_id=o.orders_id && UNIX_TIMESTAMP(o.date_purchased) > $startDateAsTime && UNIX_TIMESTAMP(o.date_purchased) < $endDateAsTime and o.orders_status NOT IN (".ORDERS_STATUS_STORNIERT.",".ORDERS_STATUS_OFFER.")  and ga.products_id=op.products_id and ga.groups_id='".$groups_id."'";
    }
}
if($dID > 0){
    $query_raw .= sprintf(" AND op.products_id=prd.products_id AND prd.distributor_id='%d'",$dID);
}

if($manID > 0){
    $query_raw .= sprintf(" AND p.manufacturers_id='%d' AND op.products_id=p.products_id ",$manID);
}

if($pID > 0){
    $query_raw .= sprintf(" AND op.products_id='%d'",$pID);
}

if(!empty($products_name_search)){
    $query_raw .= sprintf(" AND op.products_name LIKE('%%%s%%') ",$products_name_search);
}

if(!empty($source)){
    $query_raw .= sprintf(" AND o.source='%s'",$source);
}

if($csID > 0){
    $query_raw .= sprintf(" AND o.customers_status='%d'",$csID);
}

$query_raw .= $categories_where." group by op.products_id order by ".$order_by_sql;
$stats_query = xtc_db_query($query_raw);

$collie_query_raw = substr($query_raw,0,strpos($query_raw,'group by'));
$collie_query_raw2 = substr($query_raw,strpos($query_raw,'group by'),strlen($query_raw));
$products_data = array();
while($stats = xtc_db_fetch_array($stats_query)){
    $cqty = 0;
    $in_collies = xtc_get_product_in_collies($stats['products_id']);
    if(sizeOf($in_collies)){
	foreach($in_collies as $ic){
	    $collie_qty = $ic['quantity'];
	    $cquery_raw = $collie_query_raw." AND op.products_id=".$ic['products_id'].' '.$collie_query_raw2;
	    $cquery = xtc_db_query($cquery_raw);
	    $c = xtc_db_fetch_array($cquery);
	    $cqty += $c['pqty']*$collie_qty;
	    
	}
    }
    $products_data[] = array( 
	$stats['products_id'] => array('pqty'=>$stats['pqty'],'cqty'=>$cqty)
    );
}
$stats_items = array();
$all_total_netto = 0;
$all_tax = 0;
$sources_total = array();
if(sizeOf($products_data)){
    $rows = 0;
    foreach ($products_data as $k=>$product) {
        $rows++;
        $current = _get_product_stat_detail($product,$rows,true);
        if(isset($current['SOURCES']) and sizeOf($current['SOURCES'])){
            foreach($current['SOURCES'] as $src_title => $src_value ){
                switch($src_title){
                    case 'counter':
                        $src_title = TEXT_ORDERS_SOURCE_COUNTER;
                        break;
                    case 'admin':
                        $src_title = TEXT_ORDERS_SOURCE_ADMIN;
                        break;
                }
                $sources_total[ $src_title ] += $src_value;
            }
        }
        $stats_items[] = $current;
    } // end foreach

    $multisort = (strtolower($sort_parts[1]) == 'asc') ? SORT_ASC : SORT_DESC;
    if(strstr($order_by,'price_amazon')){
        $stats_items = yes_multisort($stats_items,'TOTAL_AMAZON',$multisort);
    }elseif(strstr($order_by,'price_ebay')){
        $stats_items = yes_multisort($stats_items,'TOTAL_EBAY',$multisort);
    }elseif(strstr($order_by,'price_counter')){
        $stats_items = yes_multisort($stats_items,'TOTAL_COUNTER',$multisort);
    }elseif(strstr($order_by,'price_shop')){
        $stats_items = yes_multisort($stats_items,'TOTAL_SHOP',$multisort);
    }elseif(strstr($order_by,'price_admin')){
        $stats_items = yes_multisort($stats_items,'TOTAL_ADMIN',$multisort);
    }elseif(strstr($order_by,'price')){
        $stats_items = yes_multisort($stats_items,'TOTAL_SORT',$multisort);
    }
    $smarty->assign('ITEMS',$stats_items);
    $smarty->assign('TOTAL',number_format($all_total_netto,2,',','.'));
    $smarty->assign('TOTAL_TAX',number_format($all_tax,2,',','.'));
    $smarty->assign('SOURCES_TOTAL',$sources_total);
}
if($csv_export == 1){
    $csv_items = array(array(TABLE_HEADING_NUMBER,
        TABLE_HEADING_PRODUCTS,
        TABLE_HEADING_PRODUCTS_MODEL,
        TABLE_HEADING_PURCHASED,
        TABLE_HEADING_TOTAL,
        'eBay',
        'Amazon',
        'Shop',
        TEXT_ORDERS_SOURCE_ADMIN,
        TEXT_ORDERS_SOURCE_COUNTER
    ));
    foreach($stats_items as $si){
	$csv_items[] = array(
	    $si['PRODUCTS_ID'],
	    $si['NAME'],
	    $si['PRODUCTS_MODEL'],
	    $si['QTY'].(($si['CQTY'] > 0)?' (+'.$si['CQTY'].')':''),
	    $si['TOTAL'],
	    number_format($si['SOURCES']['ebay'],2,',',''),
	    number_format($si['SOURCES']['amazon'],2,',',''),
	    number_format($si['SOURCES']['shop'],2,',',''),
	    number_format($si['SOURCES']['admin'],2,',',''),
	    number_format($si['SOURCES']['counter'],2,',','')
	);
    }
    $csv_string = '';
    foreach($csv_items as $csv){
	$csv_string .= implode("\t",$csv)."\r\n";
    }
    $basics = new basics();
    $filename = "stats_products_purchased_".date("Y-m-d-His",time()).".csv";
    $basics->create_file(\main::get_exportdata_path().$filename, $csv_string);
    $basics->download_file(\main::get_exportdata_path().$filename);
    unlink(\main::get_exportdata_path().$filename);
    exit;
}  

$groups_query = xtc_db_query("SELECT g.groups_title,g.groups_id,COUNT(ga.products_id) as anz FROM groups_allocations ga,`groups` g WHERE g.groups_id=ga.groups_id GROUP BY ga.groups_id ORDER BY g.groups_title");
$group_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
while( $groups = xtc_db_fetch_array($groups_query) ){
    $group_array[] = array(
        'id'=>$groups['groups_id'],
        'text'=>$groups['groups_title'].' ('.$groups['anz'].')'
    );
}
if(sizeOf($group_array) > 1){
    $smarty->assign('INPUT_PRODUCTS_GROUPS', 
        xtc_draw_pull_down_menu('group',$group_array,$groups_id,'id="group"')
    );
}

$cat_array1 = array(0=>array('id'=>'','text'=>TEXT_SELECT));
$cat_array2 = xtc_get_categories();
$cat_array = xtc_array_merge($cat_array1,$cat_array2);
$smarty->assign('INPUT_CATEGORIES',xtc_draw_pull_down_menu('categories_id', $cat_array,$catID,'id="categories_id"'));

if($pID > 0){
    $date_range_sql = sprintf(
        "UNIX_TIMESTAMP(o.date_purchased) > %s AND UNIX_TIMESTAMP(o.date_purchased) < %s",
        $startDateAsTime,$endDateAsTime
    );
    $query = xtc_db_query(sprintf(
        "select SUM(op.products_quantity) as pqty from orders_products op LEFT JOIN orders o USING(orders_id) "
        . "where op.products_id='%d' and %s AND o.orders_status NOT IN(%d,%d) group by op.products_id order by pqty DESC",
        $pID, $date_range_sql, 
        ORDERS_STATUS_STORNIERT,ORDERS_STATUS_OFFER,
    ));
    $row = xtc_db_fetch_array($query);
    $ebay_storno_query = xtc_db_query(sprintf(
        "SELECT sum(op.products_quantity) as eqty from orders_products op left join orders o USING(orders_id) "
        . "where o.orders_status IN(%d, %d) and %s and op.products_id='%d'",
        ORDERS_STATUS_STORNIERT,ORDERS_STATUS_OFFER,
        $date_range_sql,$pID
    ));
    $ebay_storno_row = xtc_db_fetch_array($ebay_storno_query);
	
    $ebay_query = xtc_db_query(sprintf(
        "SELECT sum(op.products_quantity) as eqty from orders_products op left join orders o USING(orders_id) "
        . "where %s and op.products_id='%d' AND o.orders_status NOT IN(%d,%d)",
        $date_range_sql, $pID, 
        ORDERS_STATUS_OFFER,ORDERS_STATUS_STORNIERT
    ));
    $ebay_row = xtc_db_fetch_array($ebay_query);
    $img = '';
    $images = yes_get_products_images($pID);
    if(is_countable($images) and sizeOf($images)){
        $file = DIR_FS_CATALOG.'images/product_images/thumbnail_images/'.$images[0]['id'];
        if(is_file($file) and is_readable($file)){
            $img = sprintf('<img src="%s" border="0" alt="pID %d" title="pID %d" style="display: block;max-width: 120px;"/>',
                HTTPS_CATALOG_SERVER.'images/product_images/thumbnail_images/'.$images[0]['id'],
                $pID, $pID
            );
        }
    }
    $smarty->assign(array(
        'NAME'=> xtc_get_products_name($pID),
        'IMAGE'=> $img,
        'PQTY'=>(int)$row['pqty'],
        'EQTY'=>(int)$ebay_row['eqty'],
        'PID_MODE'=>1,
        'PRODUCTS_ID'=>$pID,
        'TEXT_PRODUCT'=>TEXT_PRODUCT,
        'TEXT_SELLS'=>TEXT_SELLS,
        'TEXT_EBAY_SELLS'=>TEXT_EBAY_SELLS,
        'TEXT_EBAY_SELLS_STORNO'=>sprintf(TEXT_EBAY_SELLS_STORNO,(int)$ebay_storno_row['eqty']),
        'TEXT_QUANTITY_INFO'=>TEXT_QUANTITY_INFO,
        'PLINK'=>xtc_href_link('products.php','action=bestand&pID='.$pID)
    ));
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = array();
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->display('stats_products_purchased.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
