{config_load file=$language_path section="general"}
<script>
    {literal}
        $(function(){
            $('a.set_captured').each(function(){
               $(this).on('click',function(){
                   var koid = $(this).attr('id');
                  $.ajax({
                     url:'shipping.php?action=klarna_set_captured&klarna_order_id='+koid,
                     dataType: 'json',
                     success: function(json){
                         $('#klarna-shippings #klarna_shipping_'+koid).remove();
                         if(!$('#klarna-shippings .klarna_shipping').length){
                             $('#modal_window').dialog('destroy');
                         }
                     },
                     error: function(err){
                         alert('Set capture error');
                     }
                  });
               });
            });
            if(!$('input[name^="shippings_id\["]').length){
                $('input.klarna_capture_submit').hide();
            }
            $('form[name="klarna_fulfillment"]').on('submit',function(){
               $('#klarna-shippings .klarna_shipping').each(function(){
                  var koID = $(this).attr('id').replace('klarna_shipping_','');
                  var ko_ref = $('input[name="klarna_order_reference['+koID+']"]').val();
                  var sID = $('input[name="shippings_id['+koID+']"]').val();
                  var ocv = $('input[name="open_capture_value['+koID+']"]').val();
                  var get_set = 'klarna_order_id='+koID+'&captured_value='+ocv;
                  $.ajax({
                     url: $('form[name="klarna_fulfillment"]').attr('action'),
                     dataType: 'json',
                     data: get_set,
                     success: function(json){
                         if(json.MSG != ''){
                            alert(json.MSG);
                         }else{
                            $('#klarna_shipping_'+koID).remove();
                            if(!$('input[name^="shippings_id\["]').length){
                                $('#modal_window').dialog('destroy');
                            }
                         }
                     },
                     error: function(err){
                         alert('Error sent fulfillment Order #'+ko_ref);
                     }
                  });
               });
               return false;
            });
        });
    {/literal}
</script>
<style type="text/css">
{literal}
#klarna-shippings  #products  #klarna-tracking-numbers  #label{
    width: 200px;
    display: inline-block;
}
#klarna-shippings{
    display: block;
}
#klarna-shippings .klarna_shipping{
    padding: 4px;
}

#klarna-shippings .klarna_shipping #title{
    font-size: 130%;
    color: #555;
}
#captures li{
    list-style-type: none;
    font-style: italic;
}
           
{/literal}
</style>
<p><b>{$KLARNA_FULFILLMENT_TITLE}</b></p>
<div id="klarna-shippings" class="ui-widget">
{$FORM}
{foreach from=$INPUT_ITEMS item=sh}
    <div class="klarna_shipping ui-widget-content main" id="klarna_shipping_{$sh.klarna_orders_id}">
    {if $sh.klarna_order_status == 'CAPTURED'}
        <i>{$sh.KLARNA_FULFILLMENT_ORDER_IS_CAPTURED}</i>
        <p><a class="set_captured" id="{$sh.klarna_orders_id}" href="javascript:;">{$KLARNA_FULFILLMENT_SET_YES_CAPTURE}</a></p>
    {else}
        <input type="hidden" name="shippings_id[{$sh.klarna_orders_id}]" value="{$sh.shippings_id}" />
        <input type="hidden" name="open_capture_value[{$sh.klarna_orders_id}]" value="{$sh.open_capture_value_raw}" />
        <input type="hidden" name="klarna_order_reference[{$sh.klarna_orders_id}]" value="{$sh.klarna_reference}" />
        <div id="title">Klarna Order <span title="{$sh.klarna_orders_id}">#{$sh.klarna_reference}</span> / {#order#} {$sh.orders_id} via {$sh.versender}</div>
        <div id="capture-open"><b>{$KLARNA_FULFILLMENT_OPEN_CAPTURE_AMOUNT}: {$sh.open_capture_value}</b></div>
        <div id="products">
        {foreach from=$sh.products item=p}
            {foreach from=$sh.klarna_order_items item=koi}
                {if $koi.reference == $p.products_id}
            {$p.quantity} x pID {$p.products_id} &laquo;{$koi.name|truncate:50:"...":true}&raquo;<br />
                {/if}
            {/foreach}
        {/foreach}
        </div>
        {if $sh.captures.0}
        <div id="captures">
            <br />{$KLARNA_FULFILLMENT_CAPTURE_HISTORY}:
        {foreach from=$sh.captures item=capture}
            {assign var=amt value=$capture.captured_amount/100}
            <li>{$amt|string_format:"%.2f"} {$sh.currency}  {$capture.captured_at|date_format:"%d.%m.%Y"}</li>
        {/foreach}
        </div>
        <br />
        {/if}
    {/if}
    </div>
{/foreach}
<input type="submit" value="{#save#}" class="ui-button ui-corner-all ui-state-default klarna_capture_submit" />
</form>
</div>
