<?php
/**
 * TWG Flash uploader 2.6
 * 
 * Copyright (c) 2004-2007 TinyWebGallery
 * written by Michael Dempfle
 * 
 *   This file is the main configuration file of the flash.
 * 
 *   Please read the documentation found in this file!
 * 
 * There are 2 interesting settings you should look at first:
 *   - $login  - you can implement your own autentification by setting this flag! 
 *               If you use "auth" a login screen appears.
 *   - $folder - The folder where your uploads will be saved!
 * 
 *   Have fun using TWG Flash Uploader
 */
define('_VALID_TWG', '42');
if (isset($_GET['TFUSESSID'])) { // this is a workaround if you set php_flag session.use_trans_sid=off + a workaround for some servers that don't handle sessions correctly if you open 2 instances of TFU
  session_id($_GET['TFUSESSID']);
}
session_start();

$install_path = ""; // Please read the howto 8 of the TFU FAQ what you have to do with this parameter! You need a / at the end if you set it!

include $install_path . "tfu_helper.php";

/*
    CONFIGURATION
*/
$login = "auth"; // The login flag - has to set by yourself below "true" is logged in, "auth" shows the login form, "reauth" should be set if the authentification has failed. "false" if the flash should be disabled.  
$folder = "../../templates/"; // this is the root upload folder. 

$maxfilesize = 300; // The max files size limit of the server in KB. You can specify your own limit here e.g. 512
$resize_show = "false"; // Show the resize box! Valid is "true" and "false" (Strings!) - the function is_gd_version_min_20 checks if the minimum requirements for resizing images are there! 
$resize_data = "100000,1280,1024,800"; // The data for the resize dropdown
$resize_label = "Original,1280,1024,800"; // The labels for the resize dropdown
$resize_default = "0";                 // The preselected entry in the dropdown (1st = 0)
$allowed_file_extensions = "jpg,gif,jpeg,png,js,html,htm,txt,css";  // Allowed file extensions! jpg,jpeg,gif,png are allowed by default. "all" allowes all types - this list is the supported files in the browse dropdown! Please note: The filter of the file chooser dialog is limited - I have found out that if you have more than 30 extensions + $split_extension == FALSE (= no support for splitted files) not all files are listed in the dropdown if "supported files " is used. If $split_extension == 'part' (= support for splitted files) the number is limited to 10. This does not mean that TFU would not process them correctlty! If you specify more TFU automatically uses "All Files" - Then all files are listed and not supported extensions are checked by the flash after pressing "Open"
$forbidden_file_extensions = "php,php4,php5,php3";    // Forbidden file extensions! - only usefull if you use "all" and you want to skip some exensions!

// Enhanced features - this are only defaults! if TFU detects that this is not possible this functions are disabled!
$hide_remote_view = "";                 // If you want to disable the remote view add "&hide_remote_view=true" as value!
$show_preview = is_gd_version_min_20(); // Show the small preview. Valid is "true" and "false" (Strings!) - the function is_gd_version_min_20 checks if the minimum requirements for resizing images are there! 
$show_big_preview = "true";             // Show the big preview - clicking on the preview image shows a bigger preview 
$show_delete = "true";                  // Shows the delete button
$enable_folder_browsing = "true";       // Without browsing creation and deletion is disabled by default!
$enable_folder_creation = "false";       // Show the menu item to create folders
$enable_folder_deletion = "false";       // Show the menu item to delete folders - this works recursive!
$enable_folder_rename = "true";         // Show the menu item to rename folders
$enable_file_rename = "true";          // Show the menu item to rename files - default is false because this is a securiy issue!
$keep_file_extension = "true";          // You can disalow to change the file extension! - only available in the unlimited version! 
$language_dropdown="de,en,es,it,cn,da,fr,nl,no,pl,sk,pt";       // New 2.6 - You can enable a dropdown for the language selection. If you leave this empty no selector is shown (you can still change the language with the url parameter). Otherwise you specify the flags here. They are displayed in the given order! The default language is still given by the url parameter! 

// some optional things - can be removed as well - the defaults are entered below!
$login_text = "&login_text=YES Upload Zugangsdaten"; // "&login_text=Please login";  // Login Text
$relogin_text = ""; // "&relogin_text=Wrong Username/Password. Please retry"; // Retry login text
$upload_file = "&upload_file=tfu_upload.php"; // Upload php file - this is relative to he flash
$readdir_file = "&readdir_file=".$install_path."tfu_readDir.php"; // readDir php file - this dir is relative to the caller html file
$file_file = "&file_file=".$install_path."tfu_file.php";    // file php file - creates the preview images, downloads images, deletes and rename files - this dir is relative to the caller html file
$sort_files_by_date = false;               // sort files that last uploaded files are shown on top
$warning_setting = "&warning_setting=once"; // the warning is shown if remote files do already exist - can be set to all,once,none
$direct_download="";                       // "&direct_download=true" - If the downloads are corrupt from your server you can enable the direct download. Then the flash tries to get the files directly and not over a php script. The disadvantage is that the url has to be urlencoded - and not all filenames are possible then - do only use this if the download does not work with the default setting. 
$split_extension="FALSE";                  // This is the extension when you upload splitted files - tfu can merge them after upload. A splited file has to ge like: file.extension.part1, file.extension.part2 ... - the file extension cannot be empty - if emptpy the default is part! to disable splited uploads use "FALSE";
$show_size="&show_size=true"; 
$hide_directory_in_title="false";          // You can disable the display of the upload dir in the title bar if you set this to "true"

// the text of the email is stored in the tfu_upload.php if you like to change it :) 
$upload_notification_email = ""; // you can get an email everytime a fileupload was initiated! The mail is sent at the first file of an upload queue! "" = no emails - php mail has to be configured properly!
$upload_notification_email_from = ""; // the sender of the notification email!
$upload_notification_email_subject ="A file was uploaded by the TWG Flash Uploader"; // Subject of the email - you should set a nicer one after the login or in tfu_upload.php
$upload_notification_email_text ="A file was uploaded by the TWG Flash Uploader";    // Text of the email - you should set a nicer one after the login or in tfu_upload.php

/**
 * Extra settings for the unlimied version
 */
$titel = "&titel=YES Templates verwalten";      // This is the title of the flash - can not be set in the freeware version!
$remote_label = "&remote_label=Server";    // This is a optional setting - you can change the display string above the file list if you want to use a different header - can only be changed in the unlimited version! - if you want to have a ? you have to urlencode the & !
$preview_label = "";                       // "&preview_label=Preview" This is a optional setting - you can change the display string of the header if you don't use the preview but maybe this function to determine the selection in the remote file list - can only be changed in the unlimited version!  - if you want to have a ? you have to urlencode the & !
$upload_finished_js_url = "&upload_finished_js_url=status.php";              // "&upload_finished_js_url=status.???" - You can specify a url that is called by the flash in the js function uploadFinished(param) This makes it possible e.g. to show a kind of result in a iframe below the flash. - only available in the unlimited version! Check the tfu.htm for examples of the Javascript function.
$preview_select_js_url = "&preview_select_js_url=edit.php";                // "&preview_select_js_url=preview.???" - You can specify a url that is called by the flash in the js function previewSelect(param) This makes it possible e.g. to show a kind of result in a iframe below the flash. this is only executed if show_preview=true - only available in the unlimited version! Check the tfu.htm for examples of the Javascript function.
$delete_js_url = "&delete_js_url=status.php";   // "&delete_js_url=preview.???" - You can specify an url that is called by the flash in the js function deleteFile(param) This makes it possible e.g. to show a kind of result in a iframe below the flash is someone deletes a file. - only available in the unlimited version!
$js_change_folder = "&js_change_folder=status.php";
$show_full_url_for_selected_file = "";     // "&show_full_url_for_selected_file=true" - if you use this parameter the link to the selected file is shown - can be used for direct links - only available in the unlimited version!  
$directory_file_limit = "&directory_file_limit=250"; // you can specify a maximum number of files someone is allowed to have in a folder to limit the upload someone can make! - only available in the unlimited version!  
$queue_file_limit = "&queue_file_limit=20"; // you can specify a maximum number of files someone can upload at once! - only available in the unlimited version!  
$queue_file_limit_size = "&queue_file_limit_size=100000"; // you can specify the limit of the upload queue in MB! - only available in the unlimited version!  
$hide_help_button="true";                  // since TFU 2.5 it is possible to turn off the ? (no extra flash like before is needed anymore!) - it is triggered now by the license file! personal licenses, source code licenses and licenses that contain a TWG_NO_ABOUT in the domain (=license for €20) enable that this switch is read - possible settings are "true" and "false" 
$enable_file_download = "button1";            // You can enable the download of a single file! valid entries "true", false", "button", "button1" - "button" show the dl button insted the menu button if all other elements of the menu are set to false - "button1" shows the download button instead of the delete button and the delete function is moved to the menu if enabled! - only available in the unlimited version!
$enable_folder_move="false";                // New 2.6 - Show the menu item to move folders 
$enable_file_copymove="true";              // New 2.6 - Show the menu item to move and copy files

/*
     AUTHENTIFICATION

This part is interesting if you want to use the login!
*/
if (isset($_POST['twg_user'])){ // twg_user and twg_pass are always sent by the flash!
	$user = $_POST['twg_user'];
	$pass = $_POST['twg_pass'];

/*
  TFU has a very simply user managment included - 
  add users/folders/paths at .htusers.php.
  The password is not encrypted - please add this to enhance security!
*/
  if (($login == "auth" || $login == "reauth") && $user != "") {
    include ($install_path . ".htusers.php");
    foreach ($GLOBALS["users"] as $userarray){
    	if ($user == $userarray[0] && $pass == $userarray[1]){
				$login = "true";
				$folder = $userarray[2]; 
				if ($userarray[3] != "") {
				  $show_delete = $userarray[3];  
				}
				if ($userarray[4] != "") {
				  $enable_folder_browsing = $userarray[4];    
				  $enable_folder_creation = $userarray[4]; 
				  $enable_folder_deletion = $userarray[4];   
				  $enable_folder_rename = $userarray[4];
				}
				break;
			} else {
				$login = "reauth";
			}
	  }
	}
	
	if ($login == "true"){
		$_SESSION["TFU_LOGIN"] = "true";
	}
	
	// this setting are needed in the other php files too!
	$_SESSION["TFU_ROOT_DIR"] = $_SESSION["TFU_DIR"] = $folder;
	$_SESSION["TFU_BROWSE_FOLDER"]      = $enable_folder_browsing;
	$_SESSION["TFU_CREATE_FOLDER"]      = $enable_folder_creation;
	$_SESSION["TFU_DELETE_FOLDER"]      = $enable_folder_deletion;
	$_SESSION["TFU_SORT_FILES_BY_DATE"] = $sort_files_by_date; 
	$_SESSION["TFU_NOT_EMAIL"]          = $upload_notification_email;
	$_SESSION["TFU_NOT_EMAIL_FROM"]     = $upload_notification_email_from;
	$_SESSION["TFU_NOT_EMAIL_SUBJECT"]  = $upload_notification_email_subject;
	$_SESSION["TFU_NOT_EMAIL_TEXT"]     = $upload_notification_email_text;
	$_SESSION["TFU_SPLIT_EXTENSION"]    = $split_extension;
	$_SESSION["TFU_USER"]               = $user;
	$_SESSION["TFU_HIDE_DIRECTORY_IN_TITLE"] = $hide_directory_in_title;
	
	// sending and checking the registration infos - check is done in the flash therefore
	// we have to send all the registration infos to the flash!
	$license_file = $install_path . "twg.lic.php";
	if (file_exists($license_file)){
		include $license_file;
		$reg_infos = "&d=" . $d . "&s=" . $s . "&m=" . $m . "&l=" . $l;
	}else{
		$reg_infos = ""; // means freeware version!
	}
	// the sessionid is mandatory because upload in flash and Firefox would create a new session otherwise - sessionhandled login would fail then!
	echo "&session_id=" . session_id() . "&login=" . $login . "&maxfilesize=" . $maxfilesize . "&dir=" . $folder;
	echo "&resize_show=" . $resize_show . "&resize_data=" . $resize_data . "&resize_label=" . $resize_label . "&resize_default=" . $resize_default;
	echo "&allowed_file_extensions=" . $allowed_file_extensions . "&forbidden_file_extensions=" . $forbidden_file_extensions;
	echo "&show_delete=" . $show_delete . "&enable_folder_browsing=" . $enable_folder_browsing . "&enable_folder_creation=" . $enable_folder_creation . "&enable_folder_deletion=" . $enable_folder_deletion . "&enable_file_download=" . $enable_file_download;
	echo "&show_preview=" . $show_preview . "&show_big_preview=" . $show_big_preview . "&enable_file_rename=" . $enable_file_rename . "&enable_folder_rename=" . $enable_folder_rename . "&keep_file_extension=" . $keep_file_extension;
	echo "&enable_folder_copy=" . $enable_folder_move . "&enable_file_copy=" . $enable_file_copymove . "&language_dropdown=" . $language_dropdown;
	// optional settings!
	echo $login_text . $relogin_text . $upload_file . $readdir_file . $titel . $file_file . $warning_setting . $hide_remote_view . $directory_file_limit;
	echo $remote_label . $preview_label . $reg_infos . $show_full_url_for_selected_file . $upload_finished_js_url . $preview_select_js_url . $delete_js_url . $js_change_folder;
	echo $queue_file_limit . $queue_file_limit_size. "&split_extension=" . $split_extension . "&hide_help_button=" . $hide_help_button . $direct_download . $show_size;
}else{
	echo "Server name : " . $_SERVER['SERVER_NAME'] . "<br>";
	echo "PHP upload limit (in KB): " . getMaximumUploadSize(). "<br>"; 
	echo "PHP memory limit (in KB): " . return_kbytes(ini_get('memory_limit')) . "<br>&nbsp;<br>"; 	
	echo " Direct calls are not allowed.";
}

?>
