<?php
include('includes/application_top.php');
require_once(DIR_WS_CLASSES.'customer.php');
$action = $_GET['action']??'';
switch($action){
  case 'wishlist_delete_product':
    $wID = intval($_GET['wID']??0);
    $pID = intval($_GET['pID']??0);
    if($wID < 1){
      $messageStack->add_session('Invalid wishlist entry','error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','wID','pID'])));
    }
    if($pID < 1){
      $messageStack->add_session('Invalid wishlist product entry','error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','wID','pID'])));
    }
    $wishlist = \YES4Trade\Model\wishlist_customers::get_by_id($wID);
    if($wishlist === null){
      $messageStack->add_session('Invalid wishlist entry','error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','wID','pID'])));
    }
    if(!\product::exists($pID)){
      $messageStack->add_session('Unknown wishlist product entry','error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','wID','pID'])));
    }
    $existing_items = \YES4Trade\Model\wishlist_products::get_by_wishlist_customers_id($wishlist->id);
    foreach($existing_items as $ea){
      if(intval($ea->products_id) === $pID){
        \YES4Trade\Model\wishlist_products::delete($ea->id);
        $customer = new \customer($wishlist->customers_id);
        $customer->add_memo('Wishlist item deleted','Deleted by admin',$_SESSION['customer_id']);
        $messageStack->add_session(MSG_SUCCESS_WISHLIST_ITEM_DELETE,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','wID','pID'])));
      }
    }
    $messageStack->add_session('Unknown wishlist product entry','error');
    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','wID','pID'])));
    break;
  case 'insert_wp':
    $wID = intval($_POST['wID']??0);
    $pID = intval($_POST['pID']??0);
    if($wID < 1){
      $messageStack->add_session('Invalid wishlist entry','error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    }
    if($pID < 1){
      $messageStack->add_session('Invalid wishlist product entry','error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    }
    $wishlist = \YES4Trade\Model\wishlist_customers::get_by_id($wID);
    if($wishlist === null){
      $messageStack->add_session('Invalid wishlist entry','error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    }
    if(!\product::exists($pID)){
      $messageStack->add_session('Unknown wishlist product entry','error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    }
    $existing_items = \YES4Trade\Model\wishlist_products::get_by_wishlist_customers_id($wishlist->id);
    foreach($existing_items as $ea){
      if(intval($ea->products_id) === $pID){
        $messageStack->add_session(sprintf(MSG_ERROR_WISHLIST_PRODUCTS_ALLOCATION_EXISTS,$pID),'error');
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
      }
    }
    $new = new \YES4Trade\Model\wishlist_products([
      'products_id'=>$pID,
      'wishlist_customers_id'=>intval($wishlist->id),
      'quantity'=>0,
      'create_date'=>date('Y-m-d H:i:s'),
      'memo'=>'Item added by Admin: '.xtc_get_editor_name($_SESSION['customer_id']),
    ]);
    $new->create();
    $messageStack->add_session(MSG_SUCCESS_WISHLIST_PRODUCT_ADDED,'success');
    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    break;
  case 'delete':
    $wcID = intval($_GET['wID']??0);
    if($wcID < 1){
      die('Invalid wishlist ID');
    }
    $wc = \YES4Trade\Model\wishlist_customers::get_by_id($wcID,['customers_id']);
    $customer = new \customer(intval($wc->customers_id));
    $customer->add_memo('Wishlist deleted','Wishlist entry deleted',$_SESSION['customer_id']);
    \YES4Trade\Model\wishlist_customers::delete($wcID);
    $messageStack->add_session(MSG_SUCCESS_WISHLIST_DELETED,'success');
    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    break;
  case 'insert':
    $cID = intval($_POST['customers_id']??0);
    if($cID < 1){
      $messageStack->add_session(MSG_ERROR_INVALID_CUSTOMERS_ID,'error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    }
    $customer = \YES4Trade\Model\customers::get_by_customers_id($cID,['customers_id']);
    if($customer === null){
      $messageStack->add_session(MSG_ERROR_INVALID_CUSTOMERS_ID,'error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    }
    $exists = \YES4Trade\Model\wishlist_customers::get_by_customers_id($cID);
    if($exists !== null){
      $messageStack->add_session(sprintf(MSG_ERROR_CUSTOMERS_ID_ALLOCATION_EXISTS,$cID),'error');
      xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    }
    $new = new \YES4Trade\Model\wishlist_customers([
      'customers_id'=>$cID,
      'create_date'=>date('Y-m-d H:i:s'),
      'memo'=>'created by Admin: '.xtc_get_editor_name($_SESSION['customer_id'])
    ]);
    $new->create();
    $messageStack->add_session(MSG_SUCCESS_WISHLIST_CUSTOMER_ADDED,'success');
    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
    break;
}
$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" id="wishlist_customers"';
$contents = [[[
    'text'=>TEXT_CUSTOMER,
    'th'=>true
],[
    'text'=>WISHLIST_PRODUCTS,
    'th'=>true
],[
    'text'=>'Memo',
    'th'=>true
],[
    'text'=>'Action',
    'th'=>true
]]];
$wishlists = \YES4Trade\Model\wishlist_customers::get_all();
foreach($wishlists as $wl){
  $customer = \YES4Trade\Model\customers::get_by_customers_id(intval($wl->customers_id),['customers_firstname','customers_lastname']);
  $products = \YES4Trade\Model\wishlist_products::get_by_wishlist_customers_id($wl->id);
  $products_array = [];
  foreach($products as $p){
    $memo = '';
    if(!empty($p->memo)){
      $memo_str = $p->memo;
      if(strlen($memo_str)>50){
        $memo_str = sprintf('<span title="%s">%s...</span>',
          str_replace('"','-',$memo_str),
          substr($memo_str,0,50)
        );
      }
      $memo .= '<div class="wishlist_product_memo">Memo: <code>'.$memo_str.'</code></div>';
    }
    $products_array[] = sprintf('<div>%s<a title="%s" href="javascript:wishlist_delete_product(\'%s\');">%dx %s</a>%s</div><div>Ordered: %s</div><div>Date: %s</div>',
      sprintf('<a class="yes_dynamic_tooltip" href="javascript:;" rel="products.php?action=ajax_view&pID=%d" title="Info pID %d">%s</a>',
        $p->products_id,$p->products_id,
        yes_draw_href_button($p->products_id,'javascript:','width:80px;')
      ),
      IMAGE_DELETE,
      xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','pID','wID']).'action=wishlist_delete_product&pID='.$p->products_id.'&wID='.$wl->id),
      $p->quantity,
      substr(xtc_get_products_name($p->products_id),0,100),
      $memo,
      //($p->wishstatus==0)?'❎':'✅',
      $p->ordered,
      yes_date_short($p->create_date->format('Y-m-d H:i:s'))
    );
  }
$smarty = new \yesSmarty;
  $prd = sprintf('<div class="wishlist_products">%s</div>',implode("\n",$products_array));
  $contents[] = [
    ['text'=>sprintf('<a title="CRM %d" href="%s" class="ui-button ui-corner-all ui-state-default" target="_blank">CRM</a>'.$customer->customers_firstname.' '.$customer->customers_lastname,
        $wl->customers_id,
        smarty_function_yes_system_link(['type'=>'crm','id'=>$wl->customers_id],$smarty)
      )
    ],
    ['text'=>$prd],
    ['text'=>$wl->memo],
    ['text'=>
      yes_draw_href_button(WISHLIST_ADD_PRODUCT,'javascript:wishlist_product_add('.$wl->id.')','')
      .'<br />'
      .yes_draw_href_button(IMAGE_DELETE,'javascript:really_delete_wc(\''.xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','wID']).'action=delete&wID='.$wl->id).'\')','','button','ui-button ui-corner-all ui-state-error')
    ],
  ]; 
}

$smarty->assign([
  'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
  'HEADING_TITLE'=>'Wishlist',
  'SUBMIT'=>yes_draw_href_button(IMAGE_SAVE,'','','submit'),
  'FORM'=>xtc_draw_form('insert_wc','wishlist.php',xtc_get_all_get_params(['action']).'action=insert','POST'),
  'TABLE'=>$table->tableBlock_draw($contents),
  'FORM_ADD_WP'=>xtc_draw_form('insert_wp','wishlist.php',xtc_get_all_get_params(['action']).'action=insert_wp','POST'),
  'WISHLIST_ADD_PRODUCT'=>WISHLIST_ADD_PRODUCT,
  'REALLY_DELETE_WISHLIST_PRODUCT'=>REALLY_DELETE_WISHLIST_PRODUCT
]);

yes_draw_pre_header();
yes_draw_header('Wishlist');
$smarty->display('wishlist.html');
include(DIR_WS_INCLUDES.'footer.php');
include(DIR_WS_INCLUDES.'application_bottom.php');
