<?php
if(!defined('YES_PAYMODULE_CRON_EXPORT_CONFIG') or YES_PAYMODULE_CRON_EXPORT_CONFIG != 'True'){
    die('Bezahlmodul - muss vom YES Team freigeschaltet werden');
}
require_once(DIR_WS_CLASSES.'yes_export_module.php');
require_once(DIR_WS_CLASSES.'yes_cron_export.php');
require_once(DIR_WS_CLASSES.'class.yes_lister.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'includes'.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'export'.DIRECTORY_SEPARATOR.'yes2.php');

function xtc_date_yce($date){
    if($date == '0000-00-00 00:00:00'){
        return '&nbsp;';
    }
    return xtc_date_short($date);
}
function out($msg, $die = false){
    if($die){
        echo '<hr noshade="noshade">';
    }
    printf("<p>%s</p>",$msg);
    if($die){
        exit;
    }
}

function yce_get_ini_file_string($ini_file){
    $error = yes2::check_ini_sort(sprintf('yes2_%s.ini',$ini_file));
    $addon = '';
    if($error === true){
        $addon .= sprintf('<img src="images/basicons/broken45.png" title="%s" align="left" width="15" height="15" style="margin-right: 8px;"/>',
                YCE_ERROR_IN_INI_FILE_BROKEN_SORT
        );
    }
    return $ini_file.$addon;
}
$export_interval_in_hours_values = yes_cron_export::getExport_interval_in_hours_values();

function yes_get_export_interval_in_hours($hours){
    global $export_interval_in_hours_values;
    foreach($export_interval_in_hours_values as $intv){
        if($intv['id'] != $hours){
            continue;
        }
        return $intv['text'];
    }
    return 'unknown';
}

$name = 'Marios Test';
$ini = 'nur1';
$use_heading_row = 1;
$export_filename = 'mariostest.csv';
$export_linked_products = false;
$module = new yes2;
$cat = '';
$allCat = true;
$yce_action = (isset($_GET['yce_action'])) ? $_GET['yce_action'] : '';
$BASICS = new basics;
switch($yce_action){
    case 'delete':
        $yceID = (isset($_GET['yceID'])) ? (int)xtc_db_input($_GET['yceID']) : 0;
        if($yceID < 1){
            die('Illegal Transaction delete');
        }
        $yce = new yes_cron_export($yceID);
        $yce->delete();
        $messageStack->add_session(sprintf(
                MSG_SUCCESS_YCE_DELETED,
                $yce->getName()
        ),'success');
        xtc_redirect(xtc_href_link('module_export.php',xtc_get_all_get_params(array('yce_action','yceID'))));
    case 'save':
        $json_array = array(
            'MSG'=>array(),
            'ERR'=>array()
        );
        $yceID = (isset($_GET['yceID'])) ? (int)xtc_db_input($_GET['yceID']) : 0;
        if(!isset($_POST['export_filename']) or $_POST['export_filename'] == ''){
            $json_array['ERR'][] = MSG_ERROR_YCE_NO_EXPORT_FILENAME;
        }else{
            if($yceID < 1 and yes_cron_export::export_filename_exists($_POST['export_filename'])){
                $json_array['ERR'][] = sprintf(MSG_ERROR_YCE_EXPORT_FILENAME_EXISTS, $_POST['export_filename']);
            }
        }
        if($yceID < 1 && (!isset($_POST['ini_file']) or $_POST['ini_file'] == '')){
            $json_array['ERR'][] = MSG_ERROR_YCE_NO_INI_FILE;
        }
        if($yceID < 1){
            if(yes2::check_ini_sort($_POST['ini_file'])){
                $json_array['ERR'][] = YCE_ERROR_IN_INI_FILE_BROKEN_SORT;
            }
        }
        if(!isset($_POST['name']) or $_POST['name'] == ''){
            $json_array['ERR'][] = MSG_ERROR_YCE_NO_NAME;
        }
        if($yceID > 0){
            $yce = new yes_cron_export($yceID);
            if($yce->getName() != $_POST['name']){
                if(yes_cron_export::name_exists($_POST['name'])){
                    $json_array['ERR'][] = sprintf(
                            MSG_ERROR_YCE_NAME_EXISTS,
                            $_POST['name']
                    );
                }
            }
            if(!sizeOf($json_array['ERR'])){
                $yce->update($_POST);
            }
        }else{
            if(yes_cron_export::ini_exists($_POST['ini_file'])){
                $json_array['ERR'][] = sprintf(
                        MSG_ERROR_YCE_INI_FILE_EXISTS,
                        $_POST['ini_file']
                );
            }
            if(yes_cron_export::name_exists($_POST['name'])){
                $json_array['ERR'][] = sprintf(
                        MSG_ERROR_YCE_NAME_EXISTS,
                        $_POST['name']
                );
            }
            if(!sizeOf($json_array['ERR'])){
                yes_cron_export::create_from_post($_POST);
            }
        }
        if(sizeOf($json_array['ERR'])){
            die(json_encode($json_array));
        }
        $json_array['MSG'][] = MSG_SUCCESS_YCE_SAVED;
        die(json_encode($json_array));
        break;
}




//yes_debug(yes_cron_export::get_inis());
/*
if(!yes_cron_export::name_exists($name)){
    if( !$yceID = yes_cron_export::add($name, $ini, $use_heading_row, $export_filename, $export_linked_products, $cat, $allCat) ){
        out('Cant add yes_cron_export with Name "'.$name.'"',true);
    }
    out('yes_cron_export with Name "'.$name.'" added as #'.$yceID);
}else{
    $yceID = yes_cron_export::get_yes_cron_export_id_by_name($name);
    out('yes_cron_export with Name "'.$name.'" exists as #'.$yceID);
}
$yce = new yes_cron_export($yceID);

$sort_order = 1;
$name = 'Mein Eigener Header';
$added_row = $yce->add_heading_rows_row($sort_order, $name);
if(!$added_row){
    out('yes_cron_export_heading_row with Name "'.$name.'" and sort_order "'.$sort_order.'" exists');
}else{
    out('yes_cron_export_heading_row with Name "'.$name.'" and sort_order "'.$sort_order.'" added as #'.$added_row);
}
 * 
 */
yes_draw_pre_header();
yes_draw_header(TITLE);
$ini = (isset($_GET['ini'])) ? $_GET['ini'] : '';
if($ini != ''){
    $ini_clean = str_replace(array('yes2_','.ini'),'',$ini);
    $yceID = yes_cron_export::get_yes_cron_export_id_by_ini_file($ini_clean);
    
    if(!$yceID){
        $mode = 'add';
        $name = 'EXPORTKONFIG '.basename($ini);
        $export_filename = strtoupper(basename($ini));
        $use_heading_row = true;
        $export_linked_products = false;
        $categories_id = '';
        $allCat = true;
        $distributors_id = 0;
        $export_interval_in_hours = $export_interval_in_hours_values[0]['id'];
    }else{
        $yce = new yes_cron_export($yceID);
        $mode = 'edit';
        $name = $yce->getName();
        $export_filename = $yce->getExport_filename();
        $use_heading_row = $yce->getUse_heading_row();
        $export_linked_products = $yce->getExport_linked_products();
        $categories_id = $yce->getCat();
        $allCat = $yce->getAllCat();
        $distributors_id = $yce->getDistributors_id();
        $export_interval_in_hours = $yce->getExport_interval_in_hours();
    }
    /* WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN */
    $distributor_input_array = array(
            0=>array('id'=>'','text'=>'Alle')
    );
    $distributors_query = xtc_db_query("SELECT id,name FROM distributors ORDER BY name");
    while($distributors = xtc_db_fetch_array($distributors_query)){
            $distributor_input_array[] = array(
                    'id'=>$distributors['id'],
                    'text'=>$distributors['name']
            );
    }
    $smarty->assign(array(
        'MODE'=>$mode,
        'ID'=>$yceID, 
        'INI'=>$ini,
        'INPUT_NAME'=>xtc_draw_input_field('name',$name,'size="32" maxlength="64"'),
        'INPUT_INI_FILE'=>xtc_draw_hidden_field('ini_file',$ini).$ini,
        'INPUT_EXPORT_FILENAME'=>xtc_draw_input_field('export_filename',$export_filename,'size="32" maxlength="64"'),
        'INPUT_USE_HEADING_ROW'=>xtc_draw_checkbox_field('use_heading_row',$use_heading_row),
        'INPUT_EXPORT_LINKED_PRODUCTS'=>xtc_draw_checkbox_field('export_linked_products',$export_linked_products),
        'CAT'=>explode(',',$yce->getCat()),
        'INPUT_ALLCAT'=>xtc_draw_checkbox_field('allCat','1',$allCat,false,'onClick="allCatFunc();"'),
        'INPUT_DISTRIBUTORS_ID'=>xtc_draw_pull_down_menu('distributors_id', $distributor_input_array, $distributors_id),
        'INPUT_EXPORT_INTERVAL_IN_HOURS',xtc_draw_pull_down_menu('export_interval_in_hours',$export_interval_in_hours_values,$export_interval_in_hours),
        'CS_STRING'=>$module->getCategoriesString()
    ));
}
$buttons = array(
    array('text'=>IMAGE_BACK,
	'link'=>xtc_href_link('module_export.php'),
	'lbOn'=>false,
	'auth'=>true,
    ),
    array('text'=>YCE_CREATE_NEW_ENTRY,
	'link'=>'javascript:;',
        'id'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=cron_export_config&box_action=add'),
        'add_css_class'=>'add_new',
	'lbOn'=>false,
	'auth'=>true,
    )
);
$smarty->assign(array(
    'HEADING_TITLE' => BUTTON_CRON_EXPORT_CONFIG,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'BASELINK'=>xtc_href_link('module_export.php',xtc_get_all_get_params(array('ini'))),
    'INI'=>$ini,
    'YES_CRON_EXPORT_INTRO'=>YCE_INTRO
));
?>
<link rel="stylesheet" type="text/css" href="includes/javascript/spiffyCal/spiffyCal_v2_1.css">
<script type="text/javascript" src="includes/javascript/spiffyCal/spiffyCal_v2_1.js"></script>
<!-- header //-->
<?php 



$order_by = (isset($_GET['order_by'])) ? $_GET['order_by'] : 'yes_cron_exports_id DESC';
$query_raw = "select * from yes_cron_exports order by ".$order_by;

$split = new splitPageResults($_GET['page'], $view_limit = MAX_DISPLAY_SEARCH_RESULTS, $query_raw, $query_numrows);
$select_field_array = array(
		0=>array(
			'field'=>'yes_cron_exports_id',
			'heading'=>'ID',
			'format'=>'string',
			'get_param'=>'yceID',
			'sortable'=>1,
			'index'=>true,
			'column'=>0
		),
		1=>array(
			'field'=>'name',
			'heading'=>'Name',
			'format'=>'string',
			'get_param'=>'name',
			'sortable'=>1,
			'column'=>1
		),
		2=>array(
			'field'=>'ini_file',
			'heading'=>YCE_INI_FILE,
			'format'=>'string',
			'get_param'=>'ini_file',
			'sortable'=>1,
			'column'=>2,
                    'function'=>'yce_get_ini_file_string'
		),
		3=>array(
			'field'=>'date_added',
			'heading'=>YCE_DATE_ADDED,
			'format'=>'string',
			'get_param'=>'date_added',
			'sortable'=>1,
			'column'=>3,
                    'function'=>'xtc_date_yce',
		),
		4=>array(
			'field'=>'last_export',
			'heading'=>YCE_LAST_EXPORT,
			'format'=>'string',
			'get_param'=>'last_export',
                    'function'=>'xtc_date_yce',
			'sortable'=>1,
			'column'=>4
		),
		5=>array(
			'field'=>'export_filename',
			'heading'=>YCE_EXPORT_FILENAME,
			'format'=>'string',
			'get_param'=>'export_filename',
			'sortable'=>1,
			'column'=>5
		),
		6=>array(
			'field'=>'export_interval_in_hours',
			'heading'=>YCE_EXPORT_INTERVAL_IN_HOURS,
			'format'=>'string',
                    'function'=>'yes_get_export_interval_in_hours',
			'get_param'=>'export_interval_in_hours',
			'sortable'=>1,
			'column'=>6
		),
);
$listing_smarty = $smarty;
$YL = new yes_lister($query_raw,'yes_cron_exports','module_export.php',$select_field_array,$where_array = array(),$ajax_box = 1,$ajax_get_param_key = 'yceID',$ajax_link = 'module_export.php?action=yce_box');
$YL->setSmarty($listing_smarty);
$yceInfo = $YL->active_row;
$smarty->assign('LISTING',$YL->display($split,$query_numrows,$view_limit));
$smarty->assign('start_row_input',$YL->start_row_input);
$smarty->assign('SPLIT',$YL->split_string);
$smarty->assign('UPDATE_FORM', xtc_draw_form('change_yce','module_export.php',xtc_get_all_get_params(array('action')).'action=cron_export_config','POST') );

$box_html = '';
$heading = array();
$contents = array();
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch ($action) {
    	case 'delete':
	      $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_DELETE_ORDER . '</b>');
	      $contents = array('form' => xtc_draw_form('orders', FILENAME_ORDERS, xtc_get_all_get_params(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=deleteconfirm'));
	      $contents[] = array('text' => TEXT_INFO_DELETE_INTRO . '<br><br><b>' . $cInfo->customers_firstname . ' ' . $cInfo->customers_lastname . '</b>');
	      $contents[] = array('text' => '<br>' . xtc_draw_checkbox_field('restock') . ' ' . TEXT_INFO_RESTOCK_PRODUCT_QUANTITY);
	      $contents[] = array('align' => 'center', 'text' => '<br>' . xtc_image_submit('button_delete.gif', IMAGE_DELETE) . ' <a href="' . xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array('oID', 'action')) . 'oID=' . $oInfo->orders_id) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
	      break;
	default:
		$box_html .= '<div id="orderdetails" style="z-index:0;width:100%;margin: 0;padding: 0;" class="ui-widget-content"></div>';
		break;
}

if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    $box_html .= '            <td width="25%" valign="top">' . "\n";

    $box = new box;
    $box_html .= $box->infoBox($heading, $contents);
    $box_html .= '            </td>' . "\n";
}
$smarty->assign('BOX',$box_html);
$smarty->display('cron_export_configuration.tpl');
