<?php
/* -----------------------------------------------------------------------------------------
   $Id: advanced_search_result.php,v 1.52 2020/07/28 11:06:17 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(advanced_search_result.php,v 1.68 2003/05/14); www.oscommerce.com 
   (c) 2003	 nextcommerce (advanced_search_result.php,v 1.17 2003/08/21); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');
  // create smarty elements
$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );
// include needed functions
require_once(DIR_FS_INC . 'xtc_parse_search_string.inc.php');
require_once(DIR_FS_INC . 'xtc_get_subcategories.inc.php');
require_once(DIR_FS_INC . 'xtc_parse_search_string.inc.php');
require_once(DIR_FS_INC . 'xtc_checkdate.inc.php');
require_once(DIR_FS_INC . 'xtc_get_currencies_values.inc.php');
require_once(DIR_FS_INC . 'yes_get_products_sort_direction.inc.php');

$error = 0; // reset error flag to false
$errorno = 0;

if ( (isset($_GET['keywords']) && empty($_GET['keywords'])) &&
	(isset($_GET['dfrom']) && (empty($_GET['dfrom']) || ($_GET['dfrom'] == DOB_FORMAT_STRING))) &&
	(isset($_GET['dto']) && (empty($_GET['dto']) || ($_GET['dto'] == DOB_FORMAT_STRING))) &&
	(isset($_GET['pfrom']) && empty($_GET['pfrom'])) &&
	(isset($_GET['pto']) && empty($_GET['pto'])) ) {
	$errorno += 1;
	$error = 1;
}

$dfrom_to_check = ((!isset($_GET['dfrom']) or $_GET['dfrom'] == DOB_FORMAT_STRING) ? '' : $_GET['dfrom']);
$dto_to_check = ((!isset($_GET['dto']) or $_GET['dto'] == DOB_FORMAT_STRING) ? '' : $_GET['dto']);
if (strlen($dfrom_to_check) > 0) {
	if (!xtc_checkdate($dfrom_to_check, DOB_FORMAT_STRING, $dfrom_array)) {
		$errorno += 10;
		$error = 1;
	}
}  

if (strlen($dto_to_check) > 0) {
	if (!xtc_checkdate($dto_to_check, DOB_FORMAT_STRING, $dto_array)) {
		$errorno += 100;
		$error = 1;
	}
}  

if (strlen($dfrom_to_check) > 0 && !(($errorno & 10) == 10) && strlen($dto_to_check) > 0 && !(($errorno & 100) == 100)) {
	if (mktime(0, 0, 0, $dfrom_array[1], $dfrom_array[2], $dfrom_array[0]) > mktime(0, 0, 0, $dto_array[1], $dto_array[2], $dto_array[0])) {
		$errorno += 1000;
		$error = 1;
	}
}

if (isset($_GET['pfrom']) and strlen($_GET['pfrom']) > 0) {
	$pfrom_to_check = $_GET['pfrom'];
	if (!settype($pfrom_to_check, "double")) {
		$errorno += 10000;
		$error = 1;
	}
}

if (isset($_GET['pto']) and strlen($_GET['pto']) > 0) {
	$pto_to_check = $_GET['pto'];
	if (!settype($pto_to_check, "double")) {
		$errorno += 100000;
		$error = 1;
	}
}

if ( (isset($_GET['pfrom']) and strlen($_GET['pfrom']) > 0) && !(($errorno & 10000) == 10000) && strlen($_GET['pto']) > 0 && !(($errorno & 100000) == 100000)) {
	if ($pfrom_to_check > $pto_to_check) {
		$errorno += 1000000;
		$error = 1;
	}
}

if (isset($_GET['keywords']) and strlen($_GET['keywords']) > 0) {
	if (!xtc_parse_search_string(stripslashes($_GET['keywords']), $search_keywords)) {
		$errorno += 10000000;
		$error = 1;
	}
}
if(!defined('SEARCHWORD_MIN_LENGTH')){
    define('SEARCHWORD_MIN_LENGTH',5);
}

if (strlen($_GET['keywords']) < SEARCHWORD_MIN_LENGTH) {
    $errorno += 10000000;
    $error = 1;
}
  
if ($error == 1) {
    xtc_redirect(xtc_href_link(FILENAME_ADVANCED_SEARCH, 'errorno=' . $errorno . '&' . xtc_get_all_get_params(array('x', 'y'))));
}
if(!defined('DISABLE_ADVANCED_SEARCH') or DISABLE_ADVANCED_SEARCH !== True){
    $breadcrumb->add(NAVBAR_TITLE1_ADVANCED_SEARCH, xtc_href_link(FILENAME_ADVANCED_SEARCH));
}
$keywords = (isset($_GET['keywords'])) ? xtc_db_input($_GET['keywords']) : '';
$search_in_description = (isset($_GET['search_in_description'])) ? xtc_db_input($_GET['search_in_description']) : '';
$categories_id = (isset( $_GET['categories_id'] )) ? xtc_db_input($_GET['categories_id']) : '';
$inc_subcat = (isset($_GET['inc_subcat'])) ? xtc_db_input($_GET['inc_subcat']) : '';
$manufacturers_id = (isset($_GET['manufacturers_id'])) ? (int)xtc_db_input($_GET['manufacturers_id']) : '';
$pfrom = (isset($_GET['pfrom'])) ? xtc_db_input($_GET['pfrom']) : '';
$pto = (isset($_GET['pto'])) ? xtc_db_input($_GET['pto']) : '';
$dfrom = (isset($_GET['dfrom'])) ? xtc_db_input($_GET['dfrom']) : '';
$dto = (isset($_GET['dto'])) ? xtc_db_input($_GET['dto']) : '';
$breadcrumb->add(NAVBAR_TITLE2_ADVANCED_SEARCH, xtc_href_link(FILENAME_ADVANCED_SEARCH_RESULT,
    'keywords=' . $keywords . 
    '&search_in_description=' . $search_in_description . 
    '&categories_id=' . $categories_id . 
    '&inc_subcat=' . $inc_subcat . 
    '&manufacturers_id=' . $manufacturers_id . 
    '&pfrom=' . $pfrom . 
    '&pto=' . $pto . 
    '&dfrom=' . $dfrom . 
    '&dto=' . $dto
));
	
	
if((isset($_GET['autocomplete']) and $_GET['autocomplete'] == 1) or (isset($_REQUEST['ajaxscrolldown']) and $_REQUEST['ajaxscrolldown'] == '1')){
}else{
        require(DIR_WS_INCLUDES . 'header.php');
}
$groups_sql_from = '';
$groups_sql_where_sets = array();
$groups_sql_where_nosets = array();
$groups_sql_where_sets_string = '';
$groups_sql_where_nosets_string = '';
$in_groups_sql_from = '';
$in_groups_sql_where = '';
$parameters = [
    'language_id'=>(int)$_SESSION['languages_id']
];
if(isset($_GET['groups_id']) and (int)$_GET['groups_id'] > 0){
    $groups_id = (int)$_GET['groups_id'];
                
    $in_groups_sql_from = '';
    $in_groups_sql_where = '';

    $sets = $_GET['set'];
    $nosets = $_GET['noset'];
    if(is_array($sets) and sizeOf($sets)>0){
        // WORKAROUNG OR VERKNUEPFUNG uop = use or parameter
        if(isset($_REQUEST['uop']) and $_REQUEST['uop'] == 1){
            $parameters['sets'] = implode(',', array_filter($sets, fn($value) => $value !== ''));
            $set_sql = 'p.products_id IN (SELECT products_id FROM products_to_characteristics WHERE products_characteristic_set_id IN(:sets)) ';
        }
        foreach($sets as $k=>$set_id){
            $set_id = (int)$set_id;
            if($set_id > 0){
                $setIDSQLKey = 'set_id_'.$k;
                $parameters[$setIDSQLKey] = $set_id;
                $groups_sql_where_sets[] = sprintf(
                    " p.products_id IN (SELECT products_id FROM products_to_characteristics WHERE products_characteristic_set_id=:%s ) ",
                    $setIDSQLKey
                );
            }
        }
        
        
    }
    if(is_array($nosets) and sizeOf($nosets)>0){
        foreach($nosets as $k=>$noset_id){
            $noset_id = (int)$noset_id;
            if($noset_id > 0){
                $nosetSQLKey = 'noset_id_'.$k;
                $parameters[$nosetSQLKey] = $noset_id;
                $parameters['keywords'] = '%'.$_GET['keywords'].'%';
                $groups_sql_where_nosets[] = sprintf(
                    " p.products_id IN (SELECT products_id FROM products_characteristic_text_values WHERE products_characteristic_id=:%s AND content LIKE :keywords and language_id=pd.language_id) ",
                    $nosetSQLKey
                );
            }
        }
    }
}
if(sizeOf($groups_sql_where_sets)>0){
    // WORKAROUNG OR VERKNUEPFUNG uop = use or parameter
    if(isset($_REQUEST['uop']) and $_REQUEST['uop'] == 1){
        $groups_sql_where_sets_string = $set_sql;
    }else{
        $groups_sql_where_sets_string = implode('AND',$groups_sql_where_sets);
    }
}
if(sizeOf($groups_sql_where_nosets)>0 and xtc_not_null($_GET['keywords'])){
    $groups_sql_where_nosets_string = implode('OR',$groups_sql_where_nosets);
}

// SETS ODER/UND NOSETS GESETZT
$characteristics_from_sql = '';
if(xtc_not_null($groups_sql_where_sets_string) or xtc_not_null($groups_sql_where_nosets_string)){
    $characteristics_where_sql = "";
    $characteristics_from_sql = "";
    // SETS UND NOSETS GESETZT
    if(xtc_not_null($groups_sql_where_sets_string) and xtc_not_null($groups_sql_where_nosets_string)){
        $characteristics_where_sql .= sprintf(" %s AND (%s) ",$groups_sql_where_sets_string,$groups_sql_where_nosets_string);
    }else if(xtc_not_null($groups_sql_where_sets_string)){
        // NUR SETS GESETZT
        $characteristics_where_sql .= sprintf(" %s ",$groups_sql_where_sets_string);
    }else if(xtc_not_null($groups_sql_where_nosets_string)){
        // NUR SETS GESETZT
        $characteristics_where_sql .= sprintf(" (%s) ",$groups_sql_where_nosets_string);
    }
}

//fsk18 lock
$fsk_lock='';
if ($_SESSION['customers_status']['customers_fsk18_display']=='0') {
    $fsk_lock=' and p.products_fsk18!=1';
}
	
$select_str = "select
        p.products_model,
        pd.products_name,
        p.products_quantity,
        p.products_shippingtime,
        p.products_fsk18,
        p.products_image,
        p.products_weight,
        pd.products_short_description,
        pd.products_description,
        pd.products_extra_text,
        p2c.products_id,
        pd.products_name,
        p.products_price,
        p.products_master_status,
        p.products_ean,
        p.products_date_available ";
	
$select_str .= ', m.manufacturers_name,m.manufacturers_id ';

if ( (defined('DISPLAY_PRICE_WITH_TAX') and DISPLAY_PRICE_WITH_TAX == 'true') && ( (isset($_GET['pfrom']) && xtc_not_null($_GET['pfrom'])) || (isset($_GET['pto']) && xtc_not_null($_GET['pto']))) ) {
    $select_str .= ", SUM(tr.tax_rate) as tax_rate ";
}
if(isset($_REQUEST['search_mode']) and $_REQUEST['search_mode'] == 'author'){
    $from_str = "from " . TABLE_PRODUCTS . " p left join " . TABLE_MANUFACTURERS . " m using(manufacturers_id), " . TABLE_CATEGORIES . " c, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c LEFT JOIN specials s USING(products_id), " . TABLE_PRODUCTS_DESCRIPTION . " pd, products_characteristic_text_values pctv ";
}else{
    $from_str = "from " . TABLE_PRODUCTS . " p left join " . TABLE_MANUFACTURERS . " m using(manufacturers_id), " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c LEFT JOIN specials s USING(products_id), " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_CATEGORIES . " c ";
}
if(xtc_not_null($in_groups_sql_from)){
    $from_str .= $in_groups_sql_from;
}
        
if(!isset($group_check)) {
    $group_check = '';
}
if (GROUP_CHECK=='true') {
    $group_check = "and p.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
}

$where_str = " where p.products_status = '1' ".$fsk_lock." and
    pd.products_id=p.products_id 
    and pd.language_id =:language_id
    and p.products_id = p2c.products_id
    ".$group_check."
    and p2c.categories_id = c.categories_id ";
	
if(isset($_REQUEST['search_mode']) and $_REQUEST['search_mode'] == 'author'){
    $where_str .= " and pctv.products_id=p.products_id and pctv.language_id=:language_id and pctv.products_characteristic_id in(1,2,3,4) ";
}

if (isset($_GET['categories_id']) && xtc_not_null($_GET['categories_id'])) {
    $parameters['categories_id'] = (int)$_GET['categories_id'];
    if (isset($_GET['inc_subcat']) and $_GET['inc_subcat'] == '1') {
        $subcategories_array = array();
        xtc_get_subcategories($subcategories_array, (int)$_GET['categories_id']);
        $where_str .= " and p2c.products_id = p.products_id and p2c.products_id = pd.products_id and (p2c.categories_id = :categories_id";
        for ($i=0, $n=sizeof($subcategories_array); $i<$n; $i++ ) {
            $subcatSQLKey = 'subcatid_'.$i;
            $parameters[$subcatSQLKey] = $subcategories_array[$i];
            $where_str .= " or p2c.categories_id = :" . $subcatSQLKey;
        }
        $where_str .= ")";
    } else {
        $where_str .= " and p2c.products_id = p.products_id and p2c.products_id = pd.products_id and pd.language_id =:language_id and p2c.categories_id = :categories_id";
    }
}

if (isset($_GET['manufacturers_id']) && xtc_not_null($_GET['manufacturers_id'])) {
    $parameters['manufacturers_id'] = (int)$_GET['manufacturers_id'];
    $where_str .= " and m.manufacturers_id = :manufacturers_id";
}

if (isset($_GET['keywords']) && xtc_not_null($_GET['keywords'])) {
    if (xtc_parse_search_string(stripslashes($_GET['keywords']), $search_keywords)) {
        foreach($search_keywords as $ski=>$sk){
            $search_keywords[ $ski ] = xtc_db_input($sk);
        }
	if(isset($_GET['search_mode']) and $_GET['search_mode'] == 'ean'){
            $parameters['ean'] = current($search_keywords);
            $where_str .= " AND p.products_ean=:ean";
	}else if(isset($_GET['search_mode']) and $_GET['search_mode'] == 'author'){
            $parameters['keywords_author'] = '%'.$_GET['keywords'].'%';
            $where_str .= " AND pctv.content LIKE :keywords_author";
	}else{
            $where_words = array();
            for ($i=0, $n=sizeof($search_keywords); $i<$n; $i++ ) {
                switch ($search_keywords[$i]) {
                    case '(':
                    case ')':
                    case 'and':
                    case 'or':
                    case '+':
                            break;
                    default:
                            $where_words[] = $search_keywords[$i];
                            break;
                }
            }
            if(sizeOf($where_words)){
                $where_str .= " and (";
                $where_words_str = implode('|',$where_words);
                $operator = (strtolower(ADVANCED_SEARCH_DEFAULT_OPERATOR) == 'and' or strtolower(ADVANCED_SEARCH_DEFAULT_OPERATOR) == 'or') ? ADVANCED_SEARCH_DEFAULT_OPERATOR : 'or';
                $search_tags_sql = " or p.products_id IN (select products_id from tags t LEFT JOIN tags_products tp USING(tags_id) where ";
                $search_tags_sql_terms = [];
                foreach($where_words as $wk=>$ww){
                    if(!in_array($ww,['(',')','and','or','+'])){
                        $tagSQLKey = 'tagreg_'.$wk;
                        $parameters[$tagSQLKey] = "%$ww%";
                        $search_tags_sql_terms[] = sprintf(" t.tag LIKE :%s ",$tagSQLKey); 
                    }
                }
                $search_tags_sql .= implode($operator,$search_tags_sql_terms). " ) ";

                $meta_keywords_sql_str = '';
                if(defined('USE_PRODUCTS_META_KEYWORDS_IN_SHOPSEARCH') and USE_PRODUCTS_META_KEYWORDS_IN_SHOPSEARCH == 'True'){
                    $parameters['where_words_str'] = "%$where_words_str%";
                    $meta_keywords_sql_str = " pd.products_meta_keywords LIKE :where_words_str or ";
                }

                $where_str .= "(".$meta_keywords_sql_str;
                $where_ww = [];
                foreach($where_words as $wk=>$ww){
                    if(!in_array($ww,['(',')','and','or','+'])){
                        $pnSQLKey = 'pnreg_'.$wk;
                        $parameters[$pnSQLKey] = '%'.$ww.'%';
                        $where_ww[] = "pd.products_name LIKE :".$pnSQLKey;
                    }
                }
                $where_str .= "(".implode(" ".$operator." ", $where_ww).") or ";
                $where_ww = [];
                foreach($where_words as $wk=>$ww){
                    if(!in_array($ww,['(',')','and','or','+'])){
                        $etSQLKey = 'etreg_'.$wk;
                        $parameters[$etSQLKey] = '%'.$ww.'%';
                        // keine parameter setzen, sind weiter oben schon
                        $where_ww[] = "pd.ebay_title LIKE :".$etSQLKey;
                    }
                }
                $where_str .= "(".implode(" ".$operator." ", $where_ww).") or";
                $where_ww = [];
                foreach($where_words as $wk=>$ww){
                    if(!in_array($ww,['(',')','and','or','+'])){
                        $pmSQLKey = 'pmreg_'.$wk;
                        $parameters[$pmSQLKey] = '%'.$ww.'%';
                        $where_ww[] = "p.products_model LIKE :".$pmSQLKey;
                    }
                }
                $where_str .= "(".implode(" ".$operator." ", $where_ww).") or";
                $where_ww = [];
                foreach($where_words as $wk=>$ww){
                    if(!in_array($ww,['(',')','and','or','+'])){
                        $peSQLKey = 'pereg_'.$wk;
                        $parameters[$peSQLKey] = '%'.$ww.'%';
                        $where_ww[] = "p.products_ean LIKE :".$peSQLKey;
                    }
                }
                $where_str .= "(".implode(" ".$operator." ", $where_ww).") or";
                $where_ww = [];
                foreach($where_words as $wk=>$ww){
                    if(!in_array($ww,['(',')','and','or','+'])){
                        $mnSQLKey = 'mnreg_'.$wk;
                        $parameters[$mnSQLKey] = '%'.$ww.'%';
                        $where_ww[] = "m.manufacturers_name LIKE :".$mnSQLKey;
                    }
                }
                $where_str .= "(".implode(" ".$operator." ", $where_ww).") or";
                $where_ww = [];
                foreach($where_words as $wk=>$ww){
                    if(!in_array($ww,['(',')','and','or','+'])){
                        $mpnSQLKey = 'mpnreg_'.$wk;
                        $parameters[$mpnSQLKey] = '%'.$ww.'%';
                        $where_ww[] = "p.mpn LIKE :".$mpnSQLKey;
                    }
                }
                $where_str .= "(".implode(" ".$operator." ", $where_ww).")".$search_tags_sql;

                if(isset($characteristics_where_sql) and xtc_not_null($characteristics_where_sql)){
                    $where_str .= ' OR '.$characteristics_where_sql.$characteristics_from_sql;
                }
                $where_str .= " ))";
            }
	}
    }
}else{
    // EMPTY KEYWORD
    if(isset($characteristics_where_sql) and xtc_not_null($characteristics_where_sql)){
        $where_str .= ' AND '.$characteristics_where_sql.$characteristics_from_sql;
    }
}

if (isset($_GET['dfrom']) && xtc_not_null($_GET['dfrom']) && ($_GET['dfrom'] != DOB_FORMAT_STRING)) {
    $parameters['dfrom'] = xtc_date_raw($dfrom_to_check);
    $where_str .= " and p.products_date_added >= :dfrom";
}

if (isset($_GET['dto']) && xtc_not_null($_GET['dto']) && ($_GET['dto'] != DOB_FORMAT_STRING)) {
    $parameters['dto'] = xtc_date_raw($dto_to_check);
    $where_str .= " and p.products_date_added <= :dto";
}
$rate=xtc_get_currencies_values($_SESSION['currency']);
$rate=$rate['value'];

if(xtc_not_null($in_groups_sql_where)){
    $where_str .= $in_groups_sql_where;
}

if(defined('ADVANCED_SHOP_SEARCH_ONLY_MASTER') and ADVANCED_SHOP_SEARCH_ONLY_MASTER == 'True'){
    $where_str .= ' and p.products_master = 0';
}
if(!isset($order_str)){
    $order_str = '';
}

$sorting = yes_get_product_sort_direction();
$listing_sql = $select_str . $from_str . $where_str . $order_str;
if ((($pfrom != '') && (is_numeric($pfrom))) || (($pto != '') && (is_numeric($pto)))) {
    if ($pfrom == '') {
        $pfrom = 0;
    }
    if ($pto == '') {
        $pto = 100000000;
    }
    $prices = array();
    $result = yes_query($listing_sql, $parameters);
    foreach($result as $row){
        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($row['products_id'], yes_get_store_country_id());
        $prices[$row['products_id']] = $xtPrice->xtcGetPrice($row['products_id'], false, 1, $products_tax_class_id, $row['products_price'], 1);
    }
    asort($prices);
    $prices_query = '';
    foreach ($prices as $products_id => $price) {
        if ((float)$price >= (int)$pfrom && (float)$price <= (int)$pto) {
            $prices_query.= $products_id . ',';
        }
    }
    if (strlen($prices_query) > 0) {
        $prices_query = substr($prices_query, 0, -1);
    }
    if ($prices_query != '') {
        $where_str .= " and p.products_id in (" . $prices_query . ") ";
    }
    $select_str = "select distinct
            p.products_id,
            p.products_price,
            p.products_model,
            p.products_quantity,
            p.products_shippingtime,
            p.products_fsk18,
            p.products_image,
            p.products_weight,
            pd.products_short_description,
            pd.products_description,
            pd.products_extra_text,
            m.manufacturers_id,
            p2c.products_id,
            pd.products_name,
            p.products_price ";
    $listing_sql = $select_str.$from_str.$where_str.$group_str;
}
require(DIR_WS_MODULES . FILENAME_PRODUCT_LISTING);

$smarty->assign('language', $_SESSION['language']);

$smarty->caching = 0;
if(!isset($_REQUEST['ajaxscrolldown'])){
    if (!defined('RM')) {
        $smarty->load_filter('output', 'note');
    }
    $smarty->display(CURRENT_TEMPLATE . '/index.html');
}
include(DIR_WS_INCLUDES.'application_bottom.php');