<?php
use \Secuconnect\Client\Configuration;
use \Secuconnect\Client\Authentication\Authenticator;
use Secuconnect\Client\ObjectSerializer;
chdir('../');
include('includes/application_top.php');
include('includes/modules/payment/yes_secupay.php');
include('lang/german/modules/payment/yes_secupay.php');
require(DIR_WS_CLASSES.'order.php');

if(!function_exists('yes_write_notice')){
	require_once(DIR_FS_INC.'yes_write_notice.inc.php');
}
$notice_rec = main::get_notice_recipients('orders');

if(!defined('MODULE_PAYMENT_YES_SECUPAY_STATUS') or MODULE_PAYMENT_YES_SECUPAY_STATUS != 'True'){
    die(json_encode([
        'MSG'=>'Modul secupay nicht aktiv'
    ]));
}
$raw_payload = file_get_contents('php://input', true);
if(!empty($raw_payload)){
	try{
		$secupay = new \yes_secupay();

		$host = $secupay->mode == 'Live' ? $secupay::API_URL_LIVE : $secupay::API_URL_TEST;
		$auth_host = $secupay->mode == 'Live' ? $secupay::AUTH_URL_LIVE : $secupay::AUTH_URL_TEST;
		$payload = json_decode($raw_payload, true);
		$debug = false;
		Configuration::getDefaultConfiguration()
			->setDebug($debug)
			->setHost($host)
			->setAuthHost($auth_host);

		// === Authentifizierung ===
		Authenticator::authenticateByClientCredentials(
			constant('MODULE_PAYMENT_YES_SECUPAY_USERID'),
			constant('MODULE_PAYMENT_YES_SECUPAY_SECRET')
		);
		foreach($payload['data'] as $dat){
			$transinfo = $secupay->getAllocationFromPaymentTransactionId($dat['id']);
			if($transinfo['orders_id'] < 1){
				throw new Exception('Cant find YES order for secupay paymenttransactionid '.$dat['id']);
			}
			$order = new \order($transinfo['orders_id']);
			$payment_details = $secupay->getFullPaymentTransaction($dat['id']);
			$order->add_history($order->info['orders_status_id'],false,
				'[Secupay Webhook] Secupay Payment Status: '.$payment_details->getStatusText().' ('.$payment_details->getStatus().')'
			);
		}
	}catch(Exception $e){
		yes_mail_debug(print_r($raw_payload,true)."\n\n".$e->getMessage());
	}
}else{
	yes_mail_debug(print_r($_REQUEST,true));
    exit;
}
header("HTTP/1.1 200 OK");
