<?php
include('includes/application_top.php');
//ini_set('display_errors',true);
class SimpleXMLExtended extends SimpleXMLElement{    
  public function addCData($cdata_text){    
	if(strstr(HTTP_SERVER,'localhost'))
		$cdata_text = yes_encode_string($cdata_text);
	$node= dom_import_simplexml($this);    
	$no = $node->ownerDocument;    
	$node->appendChild($no->createCDATASection($cdata_text));    
  }    
}    

class cat2XML{
	function __construct(){
	}

	private function get_categories_from_db($group_check_customers_status = 0){
		$cats = array();
		$query = xtc_db_query(
			"SELECT * FROM categories WHERE categories_status=1 ORDER BY parent_id,sort_order"
		);
		while($record = xtc_db_fetch_array($query)){
			$cats[] = $record;
		}
		return $cats;
	}

	private function get_categories_description_from_db( $categories_id ){
		$return = array();
		$query = xtc_db_query(sprintf(
			"SELECT * FROM categories_description WHERE categories_id='%d' ORDER BY language_id,categories_name",
			intval($categories_id)
		));
		while($record = xtc_db_fetch_array($query)){
			$return[] = $record;
		}
		return $return;
	}

	public function create_xml_file($file){
            $charset = CHARSET;
		$xmlstr = "<?xml version='1.0' encoding='".$charset."' standalone='yes'?><CATEGORIES></CATEGORIES>";
		$CATEGORIES = new SimpleXMLExtended($xmlstr);
		foreach($this->get_categories_from_db() as $record){
			$CATEGORY = $CATEGORIES->addChild('CATEGORY');
			$CATEGORY->addAttribute('ID',$record['categories_id']);
			$CATEGORY->addAttribute('PARENT',$record['parent_id']);
			$CATEGORY->addAttribute('SORT_ORDER',$record['sort_order']);
			$CATEGORY->addChild('IMAGE',$record['categories_image']);
			$CATEGORY->addChild('ADDITIONAL_IMAGE',$record['categories_additional_image']);
			foreach($this->get_categories_description_from_db( $record['categories_id'] ) as $drecord){
				$DESCRIPTION = $CATEGORY->addChild('DESCRIPTION');
				$DESCRIPTION->addAttribute('LANG',$drecord['language_id']);
				$NAME = $DESCRIPTION->addChild('NAME');
				$NAME->addCData(xtc_db_prepare_input($drecord['categories_name']));
				$HEADING_TITLE = $DESCRIPTION->addChild('HEADING_TITLE');
				$HEADING_TITLE->addCData(xtc_db_prepare_input($drecord['categories_heading_title']));
			}
		}
		if(is_file($file))
			unlink($file);
		$CATEGORIES->asXML($file);
	}
}

$cat2xml = new cat2xml();
$cat2xml->create_xml_file( DIR_FS_CATALOG.'cat2xml.xml');
echo "generated cat2xml.xml\r\n\r\n";

