<?php
$c = file_get_contents("php://input");
include('includes/application_top.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');
require_once(DIR_FS_INC.'xtc_php_mail.inc.php');


if(empty($c)){
    yes_mail_debug(basename(__FILE__).': unauthorized call - no data received');
    die(json_encode(array(
        'MSG'=>sprintf("%s - no data received\n",HTTP_SERVER)
    )));
}

$content = json_decode($c);
if(!isset($content->AUTH) or empty($content->AUTH) or $content->AUTH != 'YES4TRADEEBAYNOTIFICATION'){
    die(json_encode(array(
        'MSG'=>sprintf("%s - unauthorized call - wrong authentification\n",HTTP_SERVER)
    )));
}
$lines = explode("\n",$content->EBAY_DELETED_USER);

$messages = array();
$u_array = [];
foreach($lines as $line){
	$parts = explode("\t",$line);
	$user = xtc_db_input(trim($parts[0]));
	if(empty($user)){
		continue;
	}
        $u_array[] = sprintf("'%s'",$user);
}

if(sizeOf($u_array)){
    $query = xtc_db_query(sprintf(
            "SELECT customers_id, customers_firstname, customers_lastname,customers_ebay_userid FROM customers WHERE customers_ebay_userid IN(%s)",
            implode(',',$u_array)
    ));
    while($record = xtc_db_fetch_array($query)){
        $messages[] = sprintf("[cID %d eBay Username %s] %s %s<br />",
            $record['customers_id'],
            $record['customers_ebay_userid'],
            $record['customers_firstname'], 
            $record['customers_lastname']
        );
    }
    if(sizeOf($messages)){
        $notice = "<b>eBay User Delete</b><p><i>Folgende eBay User haben Ihren Account deaktiviert und laut den AGB von eBay sollen die Daten des Users gel&ouml;scht (bzw anonymisiert) werden.</i></p>";
        $notice .= implode('<br />',$messages);
        yes_write_notice('eBay User Delete '.date('d.m.Y'), $notice, 0, main::get_notice_recipients('orders'));
        try{
            xtc_php_mail(EMAIL_SUPPORT_ADDRESS, EMAIL_SUPPORT_NAME, EMAIL_SUPPORT_ADDRESS, EMAIL_SUPPORT_NAME, '', EMAIL_SUPPORT_ADDRESS, EMAIL_SUPPORT_NAME, '', '', 
                'eBay User Delete '.date('d.m.Y'), 
                $notice, '');
        }catch(Exception $e){
            yes_mail_debug(basename(__FILE__.': Email to Shop-Admin dont sent. '.$e->getMessage()));
        }
    }
}
die(json_encode(array(
    'MSG'=>sprintf("%s - Es wurden %d deleted eBay User geprueft und %d Kandidaten gefunden\n",HTTP_SERVER,sizeOf($u_array),sizeOf($messages))
)));


