<?php
/*-----------------------------------------------------------------------
    Version: $Id: shopstat_functions.inc.php,v 1.37 2018/12/12 07:39:08 cvs Exp $
    xtC-SEO-Module by www.ShopStat.com (Hartmut König)
    http://www.shopstat.com
    info@shopstat.com
    © 2004 ShopStat.com
    All Rights Reserved.
------------------------------------------------------------------------*/
function shopstat_getSEO(   $page               = '',
                            $parameters         = '',
                            $connection         = 'NONSSL',
                            $add_session_id     = true,
                            $search_engine_safe = true,
                            $mode               = 'user',
			    $product_listing_mode = false)
{
        if($mode == 'admin')
            {
            require_once(DIR_FS_INC . 'xtc_parse_category_path.inc.php');
            require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
            require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
            require_once(DIR_FS_INC . 'xtc_check_agent.inc.php');
            }
        else{
            require_once(DIR_FS_INC . 'xtc_get_products_name.inc.php');
            require_once(DIR_FS_INC . 'xtc_get_manufacturers.inc.php');
            }

        global $languages_id;

        //-- XTC
        (!isset($languages_id)) ? $languages_id = $_SESSION['languages_id'] : false;

        $go     = true;
        //-- Nur bei der index.php und product_info.php
        if( $page != "index.php" &&
            $page != "product_info.php" &&
            $page != "specials.php" &&
            $page != "shop_content.php" &&
	    $page != "products_new.php")
            {
            $go = false;
            }
        //-- Unter diesen Bedingungen werden die URLs nicht umgewandelt
        //-- Sortieren
        elseif(preg_match("/sort=/",$parameters))
            {
            $go = false;
            }
        //-- Sortieren der Herstellerprodukte
        elseif(preg_match("/filter_id=/",$parameters))
            {
            $go = false;
            }
        //-- Andere Aktion
        elseif(preg_match("/action=/",$parameters))
            {
            $go = false;
            }

        preg_match("/(?:cPath)\=([^\&]*)/",$parameters,$caterg);
        preg_match("/[&|?]{0,1}(?:^products_id)\=([^\&]*)/",$parameters,$proderg);
        preg_match("/(?:coID)\=([^\&]*)/",$parameters,$coerg);
        preg_match("/(?:content)\=([^\&]*)/",$parameters,$conterg);
        //-- Manufacturer
        preg_match("/(?:manufacturers_id)\=([^\&]*)/",$parameters,$manuerg);
        //preg_match("/(?:filter_id)\=([^\&]*)/",$parameters,$filtererg);

        //-- Paging
        preg_match("/(?:page)\=([^\&]*)/",$parameters,$pagerg);

        //-- Language
        preg_match("/(?:language)\=([^\&]*)/",$parameters,$lang);
        $cPath      = @$caterg[1];

	$selected_cat_id = false; 
	if($proderg !== null and isset($proderg[1]) and strstr(@$proderg[1],'_')){
		$split = split('_',$proderg[1]);
	        $prodid     = $split[0];
		$selected_cat_id = $split[1]; 
	}else{
	        $prodid     = @$proderg[1];
	}

        $content    = @$conterg[1];
        $coid       = @$coerg[1];
        $maid       = @$manuerg[1];
        //$filterid   = $filtererg[1];
        $pager      = @$pagerg[1];
        $special    = ($page == 'specials.php') ? true : false;
	$new_products = ($page == 'products_new.php') ? true : false;
	$upcoming_products = false;
	if($new_products){
		if(strstr($parameters,'upcoming=1')){
			$new_products = false;
			$upcoming_products = true;
		}
	}

        if ($go && (   xtc_not_null($maid) ||
                xtc_not_null($cPath) ||
                xtc_not_null($prodid) ||
                $special || $new_products || $upcoming_products ||
                xtc_not_null($coid)
                )
        ){
            if ($connection == 'SSL'){
                if (ENABLE_SSL == true){
		    $link = HTTPS_SERVER . DIR_WS_CATALOG;
                }else{
                    $link = HTTP_SERVER . DIR_WS_CATALOG;
		}
            }else{
		if($mode == 'admin'){
			$link = HTTP_SERVER;
		}else{
			$link = HTTP_SERVER . DIR_WS_CATALOG;
		}
            }

            if(!$special && (xtc_not_null($cPath) || xtc_not_null($prodid)) ){
                $cPath_array        = xtc_parse_category_path($cPath);
                $cPath              = implode('_', $cPath_array);
                if(is_countable($cPath_array) and sizeOf($cPath_array)){
                    $current_category_id= $cPath_array[(sizeof($cPath_array)-1)];
                }else{
                    $current_category_id = false;
                }

                if(!$current_category_id && $prodid){
                    $current_category_id = xtc_get_product_path($prodid);
                }

                // -------------------------------------------------
                if(!$prodid){
                    $category['categories_name'] = shopstat_getRealPath($cPath);
                    $additional_params = '';
                    if(strpos($parameters,'set[')>0){
                    	$parts = explode('?',$parameters);
                    	foreach($parts as $part){
                    		$matches = explode('&',$part);
	                    	foreach($matches as $m){
	                    		if( strpos($m, 'set[')>-1){
	                    			$additional_params = '?'.$m;
	                    		}
	                    	}
	                }
                    }
                    $link .= shopstat_hrefCatlink($category['categories_name'],$cPath,$pager,$additional_params);
                }else{
		    // BUGFIX MARIO: Verlinkungen richtig zeigen
		    // +SECURITY BUGFIX MARIO
		    $selected_cat_id = (xtc_not_null(@$_GET['cPath'])) ? current(array_reverse(explode('_',htmlspecialchars($_GET['cPath'],ENT_QUOTES)))) : $selected_cat_id;
// MARIO                   $category['categories_name'] = shopstat_getRealPath(xtc_get_product_path($prodid,$selected_cat_id));
                   $category['categories_name'] = '';

		    // BUGFIX YES SYSTEM!
		    $pname = xtc_get_products_name($prodid,$languages_id);
            if(!empty($pname)){
                while( $pname[ strlen($pname) -1 ] == '-'){
                    $pname = substr($pname,0,(strlen($pname)-1));
                }
            }

		    $prodid = ($selected_cat_id) ? $prodid.'_'.$selected_cat_id : $prodid;
                    $link .= shopstat_hrefLink($category['categories_name'],
                                               $pname,
                                               $prodid
                                               );
                }
            }elseif(xtc_not_null($coid)){
//-- 05.03.2006
/*
                if(xtc_not_null($content))
                    {
                    //-- Trennen von Name und Erweiterung und ID einmontieren
                    if(preg_match("/\./",$content))
                        {
                        $content = substr($content,0,strrpos ($content, "."));
                        }
                    }
                else{
*/
                    $content = shopstat_getContentName($coid, $languages_id);

//                    }

                $link .= shopstat_hrefContlink($content, $coid);

            }elseif(xtc_not_null($maid) && !$special){
                $manufacturers = xtc_get_manufacturers();
                foreach($manufacturers as $manufacturer){
                    if($manufacturer['id'] == $maid){
                        $maname = $manufacturer['text'];
                        break;
                    }
                }
                $link .= shopstat_hrefManulink($maname, $maid, $pager);
	    }elseif($special){
		$_param = array(
		    'cPath'=>(!empty($cPath)) ? $cPath : false,
		    'maid'=>(!empty($maid) and $maid > 0) ? $maid : false,
		);
		$link .= shopstat_hrefSpeciallink($pager,$cPath,$maid);
            }elseif($upcoming_products){
                $link .= shopstat_hrefUpcomingProductslink($pager);
            }elseif($new_products){
                $link .= shopstat_hrefNewProductslink($pager);
            }

	    $separator  = '?';
    }

    //-- Concat the lang-var
    //-- Check parameters and given language, just concat
    //-- if the language is different
    if(sizeof($lang)>0){
        $lng = new language;
        if( $lng->catalog_languages[$lang[1]]['id'] != $languages_id &&
            (isset($link) && $link != ""))
            {
            $link .= $separator.$lang[0];
            }
    }
    if(isset($link))
        return($link);
}
/*
 * FUNCTION shopstat_getRealPath
 * Get the 'breadcrumb'-path
 */
function shopstat_getRealPath($cPath, $delimiter = '/')
{
    if(empty($cPath)) return;

    $path       = explode("_",$cPath);
    $categories = array();
    $language = (isset($_SESSION['languages_id'])) ? (int)xtc_db_input($_SESSION['languages_id']) : 2;
    foreach($path as $key => $value)
        {
        $categories[$key] = shopstat_getCategoriesName($value, $language);
        }

    $realpath = implode($delimiter,$categories);

    return($realpath);
}
function shopstat_getContentName($coid, $language = '')
{
    if(empty($coid)) return;
    if(empty($language)) $language = $_SESSION['languages_id'];
        $items = \YES4Trade\Model\content_manager::get_by_content_group_and_languages_id((int)$coid,(int)$language);
        if(!sizeOf($items)){
            return '';
        }
        $item = current($items);
	return $item->content_title;
}
/*
 * FUNCTION shopstat_getCategoriesName
 * Get the Category-Name from a give CID
 */
function shopstat_getCategoriesName($categories_id, $language = ''){
    global $InstanceCache;
    if(empty($categories_id)) {
        return;
    }
    if(empty($language)) {
        $language = intval($_SESSION['languages_id']??2);
    }

    $cache_key = 'c'.$categories_id.'-l'.$language;
    $cache_group = 'categories';
    $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
        $catd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($categories_id), $language,['categories_name']
        );
        $categories_data = [
            'categories_id'=>intval($categories_id),
            'categories_name'=>$catd->categories_name??''
        ];
        $CachedString->set($categories_data)->expiresAfter(YES_CACHE_LIFETIME_LONG); // cat
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $categories_data = $CachedString->get();
    }
    return $categories_data['categories_name'];
}
/*
 * FUNCTION shopstat_hrefLink
 */
function shopstat_hrefLink($cat_desc, $product_name, $product_id)
{
    $link = "";

    if(shopstat_hrefSmallmask($cat_desc)){
        $link .= shopstat_hrefSmallmask($cat_desc)."/";
    }
	// YES BUGFIX, KEINE DREIFACHEN AUSRUFEZEICHEN
	$pname = shopstat_hrefMask($product_name);
    if(!empty($pname)){
        while( $pname[ strlen($pname) -1 ] == '-'){
                $pname = substr($pname,0,(strlen($pname)-1));
        }
    }
	$link .= $pname."--".$product_id.".html";

    return($link);
}
/*
 * FUNCTION shopstat_hrefCatlink
 */
function shopstat_hrefCatlink($category_name, $category_id, $pager=false,$additional_params=false)
{
    $link = shopstat_hrefSmallmask($category_name)."---".$category_id;

    if($pager && $pager != 1)
        {
        $link .= "-".$pager.".html";
        }
    else{
        $link .= ".html";
        }
	if($additional_params !== null){
		$link .= $additional_params;
	}
    return($link);
}
/*
 * FUNCTION shopstat_hrefContlink
 */
function shopstat_hrefContlink($content_name, $content_id)
{
    $link = shopstat_hrefMask($content_name)."-_-".$content_id.".html";

    return($link);
}
/*
 * FUNCTION shopstat_hrefManulink
 */
function shopstat_hrefManulink($content_name, $content_id, $pager=false)
{
    $link = shopstat_hrefMask($content_name)."-.-".$content_id;

    if($pager && $pager != 1)
        {
        $link .= "-".$pager.".html";
        }
    else{
        $link .= ".html";
        }

    return($link);
}

function shopstat_hrefSpeciallink($pager=false,$cPath = false,$manufacturers_id = false)
{
    $link = "Angebote";

    if($pager && $pager != 1){
        $link .= "___".$pager;
    }else{
        $link .= "___1";
    }
    if($cPath && $cPath != ''){
	$link .= "_-_-".$cPath;
    }
    if($manufacturers_id && $manufacturers_id > 0){
	$link .= "-_-_".$manufacturers_id;
    }
    $link .= ".html";
    return($link);
}


function shopstat_hrefNewProductslink($pager=false)
{
	$link = "Neuheiten";
        if($pager && $pager != 1){
	        $link .= "___".$pager.".html";
	}else{
	        $link .= "___1.html";
        }
	return($link);
}

function shopstat_hrefUpcomingProductslink($pager=false)
{
	$link = "Zulauf";
        if($pager && $pager != 1){
	        $link .= "___".$pager.".html";
	}else{
	        $link .= "___1.html";
        }
	return($link);
}



/*
 * FUNCTION shopstat_hrefSmallmask
 */
function shopstat_hrefSmallmask($string)
{
    shopstat_getRegExps($search, $replace);

    //-- <br> neutralisieren
    if($string === null){
        return '';
    }
    $newstring  = preg_replace("/<br>/i","-",$string);

    //-- HTML entfernen
    $newstring  = strip_tags($newstring);

    //-- Schrägstriche entfernen
    $newstring  = preg_replace("/\s\/\s/","+",$newstring);

    //-- Definierte Zeichen entfernen
    $newstring  = preg_replace($search,$replace,$newstring);

    //-- Die nun noch (komisch aussehenden) doppelten Bindestriche entfernen
    $newstring  = preg_replace("/(-){2,}/","-",$newstring);

    return($newstring);
}
/*
 * FUNCTION shopstat_hrefMask
 */
function shopstat_hrefMask($string)
{
    shopstat_getRegExps($search, $replace);

    //-- <br> neutralisieren
    $newstring  = preg_replace("/<br>/i","-",$string);

    //-- HTML entfernen
    $newstring  = strip_tags($newstring);

    //-- Schrägstriche entfernen
    $newstring  = preg_replace("/\//","-",$newstring);

    //-- Definierte Zeichen entfernen
    $newstring  = preg_replace($search,$replace,$newstring);
//if($_REQUEST['test']){print $newstring."<br>";}

    //-- String URL-codieren
    $newstring  = urlencode($newstring);

    //-- Die nun noch (komisch aussehenden) doppelten Bindestriche entfernen
    $newstring  = preg_replace("/(-){2,}/","-",$newstring);
//if($_REQUEST['test']){print $newstring."<hr>";}
    return($newstring);
}
function shopstat_getRegExps(&$search, &$replace)
{
    $search     = array(
                        "'\s&\s'",          //--Kaufmännisches Und mit Blanks muss raus
						"'[\r\n\s]+'",	    // strip out white space
						"'&(quote|#34);'i",	// replace html entities
						"'&(amp|#38);'i",
						"'&(lt|#60);'i",
						"'&(gt|#62);'i",
						"'&(nbsp|#160);'i",
						"'&(iexcl|#161);'i",
						"'&(cent|#162);'i",
						"'&(pound|#163);'i",
						"'&(copy|#169);'i",
                        "'&'",              //--Kaufmännisches Und wird +
                        "'%'",              //--Prozent muss weg
                        "/[\[\({]/",        //--öffnende Klammern nach Bindestriche
                        "/[\)\]\}]/",       //--schliessende Klammern weg
                        "/ß/",              //--Umlaute etc.
                        "/ä/",              //--Umlaute etc.
                        "/ü/",              //--Umlaute etc.
                        "/ö/",              //--Umlaute etc.
                        "/Ä/",              //--Umlaute etc.
                        "/Ü/",              //--Umlaute etc.
                        "/Ö/",              //--Umlaute etc.
                        "/'|\"|Ž|`/",       //--Anführungszeichen weg.
                        "/[:,\.!?\*\°+]/",   //--Doppelpunkte, Komma, Punkt etc. weg.
                        );
    $replace    = array(
                        "-",
			"-",
			"\"",
			"-",
			"<",
			">",
			"",
			chr(161),
			chr(162),
			chr(163),
			chr(169),
			"-",
			"+",
			"-",
			"",
			"ss",
			"ae",
			"ue",
			"oe",
			"Ae",
			"Ue",
			"Oe",
			"",
			""
			);

}
