<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_collect_posts.inc.php,v 1.18 2015/02/09 07:20:23 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce coding standards; www.oscommerce.com

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/


function xtc_collect_posts() {
    global $coupon_no, $REMOTE_ADDR,$xtPrice,$cc_id;
    // BOF EASYCHECKOUT
    $pre_shoppingcart_mode = (isset($_REQUEST['pre_shoppingcart_mode']) and $_REQUEST['pre_shoppingcart_mode'] == 1) ? true : false;
    if(defined('USE_EASYCHECKOUT') and USE_EASYCHECKOUT == 'True' and !$pre_shoppingcart_mode){
        $target_url_filename = FILENAME_CHECKOUT_SHIPPING;
    }else{
        $target_url_filename = FILENAME_SHOPPING_CART;
    }
    // EOF EASYCHECKOUT
    if (!$REMOTE_ADDR) {
        $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
    }
    if (isset($_POST['gv_redeem_code'])){
        $coupon = \YES4Trade\Model\coupons::get_by_coupon_code(trim($_POST['gv_redeem_code']));

        if ($coupon === null or $coupon->coupon_active != 'Y' ) {
            xtc_redirect(xtc_href_link($target_url_filename, 'info_message=' . urlencode(ERROR_NO_INVALID_REDEEM_GV), 'SSL'));
        }
        $gv_result = $coupon->toArray();
        $redeems = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id(intval($gv_result['coupon_id']));
        if ( sizeOf($redeems) > 0 and $gv_result['coupon_type'] == 'G' ) {
            xtc_redirect(xtc_href_link($target_url_filename, 'info_message=' . urlencode(ERROR_NO_INVALID_REDEEM_GV), 'SSL'));
        }
		
        // GIFT CODE G START
        if ($gv_result['coupon_type'] == 'G') {

            $gv_amount = (float)$gv_result['coupon_amount'];
            $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id(intval($_SESSION['customer_id']));
            $customer_gv = false;
            $total_gv_amount = $gv_amount;
            if ($gvc !== null) {
                $total_gv_amount = (float)$gvc->amount + (float)$gv_amount;
                $customer_gv = true;
            }
            $upd = new \YES4Trade\Model\coupons([
                'coupon_active' => 'N',
                'coupon_id' => intval($gv_result['coupon_id'])
            ]);
            $upd->update();
            $new = new \YES4Trade\Model\coupon_redeem_track([
                'coupon_id'=>intval($gv_result['coupon_id']), 
                'customer_id'=>intval($_SESSION['customer_id']), 
                'redeem_date'=>date('Y-m-d H:i:s'), 
                'redeem_ip'=> $REMOTE_ADDR
            ]);
            $new->create();
            
            if ($customer_gv) {
                $upd = new \YES4Trade\Model\coupon_gv_customer([
                    'amount' => $total_gv_amount,
                    'customer_id' => intval($_SESSION['customer_id'])
                ]);
                $upd->update();
            } else {
                $new = new \YES4Trade\Model\coupon_gv_customer([
                    'customer_id'=>intval($_SESSION['customer_id']), 
                    'amount'=>$total_gv_amount
                ]);
                $new->create();
            }
            xtc_redirect(xtc_href_link($target_url_filename, 'info_message=' . urlencode(REDEEMED_AMOUNT. $xtPrice->xtcFormat($gv_amount,true)), 'SSL'));
        }
        // GIFT CODE G END
        $coupon_result = $gv_result;
        if ($coupon_result['coupon_type'] != 'G') {
            $startDate = new DateTime($coupon_result['coupon_start_date']);
            $now = new DateTime();
            if($startDate > $now){
                xtc_redirect(xtc_href_link($target_url_filename, 'info_message=' . urlencode(ERROR_INVALID_STARTDATE_COUPON), 'SSL'));
            }
            $endDate = new DateTime($coupon_result['coupon_expire_date']);
            if($endDate < $now){
                xtc_redirect(xtc_href_link($target_url_filename, 'info_message=' . urlencode(ERROR_INVALID_FINISDATE_COUPON), 'SSL'));
            }

            $coupon_count = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id(intval($coupon_result['coupon_id']));
            $coupon_count_customer = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id_and_customers_id(intval($coupon_result['coupon_id']), intval($_SESSION['customer_id']));

            if (sizeOf($coupon_count) >= $coupon_result['uses_per_coupon'] and $coupon_result['uses_per_coupon'] > 0) {
                xtc_redirect(xtc_href_link($target_url_filename, 'info_message=' . urlencode(sprintf(ERROR_INVALID_USES_COUPON,$coupon_result['uses_per_coupon']) ), 'SSL'));
            }

            if (sizeOf($coupon_count_customer) >= $coupon_result['uses_per_user'] and $coupon_result['uses_per_user'] > 0) {
                xtc_redirect(xtc_href_link($target_url_filename, 'info_message=' . urlencode(sprintf(ERROR_INVALID_USES_USER_COUPON,$coupon_result['uses_per_user']) ), 'SSL'));
            }
            if ($coupon_result['coupon_type']=='S') {
                $allowed_countries = array();
                if($coupon_result['free_shipping_countries'] != ''){
                        $allowed_countries = explode(',',$coupon_result['free_shipping_countries']);
                        foreach($allowed_countries as $ak=>$av){
                                $allowed_countries[$ak] = trim(strtoupper($av));
                        }
                }
                if(!isset($order)){
                    $item = \YES4Trade\Model\address_book::get_by_address_book_id((int)$_SESSION['sendto']);
                    $check_country = $item->entry_country_id;
                }else{
                    $check_country = $order->delivery['country']['iso_code_2'];
                }
                if(basename($_SERVER['SCRIPT_NAME']) == FILENAME_SHOPPING_CART){
                    $check_country = (isset($_SESSION['default_shipping_countries_id']) and $_SESSION['default_shipping_countries_id'] > 0) ? $_SESSION['default_shipping_countries_id'] : $check_country;
                }
                if( !sizeOf($allowed_countries) or in_array($check_country,$allowed_countries)){
                    if(!isset($order)){
                        $coupon_amount = $_SESSION['shipping']['cost'];
                    }else{
                        $coupon_amount = $order->info['shipping_cost'];
                    }
                }
            } else {
                $coupon_amount = $coupon_result['coupon_amount'] . ' ';
            }
            if ($coupon_result['coupon_type']=='P') {
                $coupon_amount = $coupon_result['coupon_amount'] . '% ';
            }
            if ($coupon_result['coupon_minimum_order']>0) {
                $coupon_amount .= 'on orders greater than ' . $coupon_result['coupon_minimum_order'];
            }
            $cc_id = $coupon_result['coupon_id']; //Fred ADDED, set the global and session variable
            $_SESSION['cc_id'] = $cc_id;
            xtc_redirect(xtc_href_link($target_url_filename, 'info_message=' . urlencode(REDEEMED_COUPON), 'SSL'));
        }
        // GIFT NOT G
    } // end if isset gv_redeem_code
    if ($_POST['submit_redeem_x'] and $gv_result['coupon_type'] == 'G') {
        xtc_redirect(xtc_href_link($target_url_filename, 'info_message=' . urlencode(ERROR_NO_REDEEM_CODE), 'SSL'));
    }
}
