<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_draw_pull_down_menu.inc.php,v 1.3 2018/11/28 07:44:03 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(html_output.php,v 1.52 2003/03/19); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_draw_pull_down_menu.inc.php,v 1.3 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
// Output a form pull down menu
  function xtc_draw_pull_down_menu($name, $values, $default = '', $parameters = '', $required = false) {
    $field = '<select name="' . xtc_parse_input_field_data($name, array('"' => '&quot;')) . '"';

    if (xtc_not_null($parameters)) $field .= ' ' . $parameters;

    $field .= '>';
    if (empty($default) && isset($GLOBALS[$name])) $default = $GLOBALS[$name];

    $sizeOf_values = (is_array($values) and sizeOf($values)) ? sizeOf($values) : 0;
    for ($i=0, $n=$sizeOf_values; $i<$n; $i++) {
	  if(!isset($values[$i]['id'])) $values[$i]['id'] = '';
      $field .= '<option value="' . xtc_parse_input_field_data($values[$i]['id'], array('"' => '&quot;')) . '"';
      if ($default == $values[$i]['id']) {
        $field .= ' SELECTED';
      }

      $field .= '>' . xtc_parse_input_field_data($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) . '</option>';
    }
   
    $field .= '</select>';

    // TEXT_REQUIRED = SHOP | TEXT_FIELD_REQUIRED = Admin
    $req_text = (defined('TEXT_FIELD_REQUIRED'))?constant('TEXT_FIELD_REQUIRED'):constant('TEXT_REQUIRED');
    if ($required == true) {
      $field .= sprintf('&nbsp;<span class="fieldRequired">%s</span>',$req_text);
    }

    return $field;
  }

 ?>
