<?php
function xtc_generate_packingslip_barcode($code,$savefile = '', $show = false){
	// Barcode-Objekt für Code128-Barcode erstellen
	$code = (string)$code;
	$barcode = new \Picqer\Barcode\BarcodeGeneratorPNG();
	$type = 'TypeCode39';
	switch($type){
		case 'TypeCode39':
			try{
				$barcodeImage = $barcode->getBarcode($code, \Picqer\Barcode\BarcodeGeneratorPNG::TYPE_CODE_39);
			}catch(Exception $e){
				throw new Exception('Barcode '.$code.' is not valid. '.$e->getMessage());
			}
			break;
		default:
			die('unbekannter barcode type');
			break;
	}

	$barcodeImg = imagecreatefromstring($barcodeImage);
	$originalWidth = imagesx($barcodeImg);
	$originalHeight = imagesy($barcodeImg);

	// Erstelle ein neues, größeres Bild, das Barcode und Text aufnehmen kann
	$newImageHeight = $originalHeight+20; // Neue Höhe für das Bild (Barcode oben + Text unten)
	$newImageWidth = $originalWidth; // Breite des neuen Bildes entspricht der Breite des Barcodes
	
	// Leeres Bild mit größerer Höhe erstellen
	$im = imagecreatetruecolor($newImageWidth, $newImageHeight);
	
	// Hintergrundfarbe für das neue Bild festlegen (weiß)
	$backgroundColor = imagecolorallocate($im, 255, 255, 255);
	imagefill($im, 0, 0, $backgroundColor);
	
	// Barcode-Bild in das neue Bild einfügen (oben)
	imagecopy($im, $barcodeImg, 0, 0, 0, 0, $originalWidth, $originalHeight);
	
	// Textfarbe für den Barcode-Text (schwarz)
	$textColor = imagecolorallocate($im, 0, 0, 0);
	
	// Schriftgröße (Standardgröße für imagefont)
	$font = 3; 
	
	// Der Text, der unter den Balken angezeigt werden soll
	$text = $code;
	$padding = 1; // Abstand zwischen Barcode und Text
	
	// Berechne die Textbreite, um den Text zu zentrieren
	$textWidth = imagefontwidth($font) * strlen($text);
	
	// Text horizontal zentrieren
	$x = ($newImageWidth - $textWidth) / 2;
	
	// Berechne die Y-Position für den Text (unterhalb des Barcodes)
	$y = $originalHeight + $padding; // 50px ist die Höhe des Barcodes, Padding ist der Abstand
	
	// Text ins Bild einfügen
	imagestring($im, $font, $x, $y, $text, $textColor);
	if($show){
		header('Content-Type: image/png');
		// Bild ausgeben
		imagepng($im);
		
		// Ressourcen freigeben
		imagedestroy($im);
		imagedestroy($barcodeImg); // Wichtig: Barcode-Bild-Ressource ebenfalls freigeben
		exit;
	}
	if($savefile == ''){
		imagedestroy($im);
		imagedestroy($barcodeImg); // Wichtig: Barcode-Bild-Ressource ebenfalls freigeben
		$ipath = (defined('DIR_WS_ADMIN')) ? HTTP_SERVER.DIR_WS_ADMIN : HTTP_SERVER.'admin/';
		return "<img  src='".$ipath."barcode.php?code=".$code."&type=".$type."'>";
	}else{
		$barcode_prefix_added = false;
		if(!strpos($savefile,'.png')){
			if(!strpos($savefile,'BARCODE_')){
				$savefile .= 'BARCODE_';
				$barcode_prefix_added = true;
			}
			$savefile .= $code.'.png';
		}
		if(!imagepng($im, $savefile)){
			die($savefile.' kann nicht gespeichert werden.');
		}
		imagedestroy($im);
		imagedestroy($barcodeImg); // Wichtig: Barcode-Bild-Ressource ebenfalls freigeben
		if($barcode_prefix_added){
			$savefile = str_replace('BARCODE_','',$savefile);
		}
		return basename($savefile);
	}
	exit;		
 }
