<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
  
  // bedingung: ORDERS_STATUS_BEZAHLT,ORDERS_STATUS_UPSELLING,1 oder 2
  //            REKLA TYP 3 / STATUS 1, 2
  // @returns (int)
function xtc_get_products_not_shipped( $pID, $submitted_orders_statuses=array() ) {
    if($pID < 1){
        return 0;
    }
    $varray = array(ORDERS_STATUS_BEZAHLT,ORDERS_STATUS_UPSELLING,1,2);
    if(defined('PAYPAL_ORDER_STATUS_SUCCESS_ID')){
	$varray[] = PAYPAL_ORDER_STATUS_SUCCESS_ID;
    }
    if(defined('PAYPAL_ORDER_STATUS_PENDING_ID')){
	$varray[] = PAYPAL_ORDER_STATUS_PENDING_ID;
    }
    $valid_orders_statuses = implode(',',$varray);
    
    if(defined('MODULE_PAYMENT_ICLEAR_STATUS_WAIT_ID')){
	    $valid_orders_statuses .= ','.MODULE_PAYMENT_ICLEAR_STATUS_WAIT_ID;
    }
    if(defined('RESERVE_STOCK_FOR_OFFERS') and RESERVE_STOCK_FOR_OFFERS == 'true')
	    $valid_orders_statuses .= ','.ORDERS_STATUS_OFFER;
    
    if(sizeOf($submitted_orders_statuses)){
	$valid_orders_statuses = implode(',',$submitted_orders_statuses);
    }
    
    $total = 0;
    $collie_query = yes_query(
        "SELECT products_id,quantity FROM products_collies WHERE collie_products_id=:products_id",
        ['products_id'=>$pID]
    );
    if(sizeOf($collie_query)>0){
        // DIESES PRODUKT IST INHALT MINDESTENS EINES SETS, WIR SCHAUEN ALSO AUCH NACH OB DAS SET IN
        // OFFENEN BESTELLUNGEN IST
        $_collies = [];
        foreach($collie_query as $collie){
            $_collies[] = $collie;
        }
        foreach($_collies as $collie){
            $qty_query = xtc_db_query("SELECT SUM(products_quantity-quantity_shipped) as anzahl FROM orders_products op,orders o WHERE op.products_id='".$collie['products_id']."' and o.orders_status IN (".$valid_orders_statuses.") and o.orders_id=op.orders_id");
            $qty = xtc_db_fetch_array($qty_query);
            $total += (int)$qty['anzahl']*$collie['quantity'];
            // BOF: 30.01.2014 - mario - Offene Rekla Typ 3 includen
            $reclamations_products_query = xtc_db_query(sprintf(
                "SELECT SUM(products_quantity) as anzahl FROM reclamations_products rp LEFT JOIN reclamations r USING(reclamations_id) WHERE rp.products_id='%d' AND r.reclamations_type='3' AND r.reclamations_status IN (1,2)",
                $collie['products_id']
            ));
            $reclamations_products = xtc_db_fetch_array($reclamations_products_query);
            $total += (int)$reclamations_products['anzahl']*$collie['quantity'];
            // EOF: 30.01.2014 - mario - Offene Rekla Typ 3 includen
        }
    }
    $qty = yes_query(
        "SELECT SUM(products_quantity-quantity_shipped) as anzahl FROM orders_products op,orders o WHERE op.products_id=:products_id and o.orders_status IN (".$valid_orders_statuses.") and o.orders_id=op.orders_id",
        ['products_id'=>(int)$pID],
        true
    );
    $total += (int)$qty['anzahl'];

    // BOF: 30.01.2014 - mario - Offene Rekla Typ 3 includen
    $reclamations_products = yes_query(
        "SELECT SUM(products_quantity) as anzahl FROM reclamations_products rp LEFT JOIN reclamations r USING(reclamations_id) WHERE rp.products_id=:products_id AND r.reclamations_type='3' AND r.reclamations_status IN (1,2)",
        ['products_id'=>(int)$pID],
        true
    );
    $total += (int)$reclamations_products['anzahl'];
    return $total;
}
