<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_set_specials_status.inc.php,v 1.9 2020/08/03 08:36:26 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(specials.php,v 1.5 2003/02/11); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_set_specials_status.inc.php,v 1.3 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
// Sets the status of a special product
if(!class_exists('specials_ebay_revise')){
    require_once(DIR_FS_CATALOG.'admin/includes/classes/specials_ebay_revise.php');
}
function xtc_set_specials_status($specials_id, $status) {
    $specials_data = yes_query(
        "SELECT * FROM specials WHERE specials_id=:specials_id",
        ['specials_id'=>(int)$specials_id],
        true
    );
    $update_sql_array = [
        'status' => $status, 
        'date_status_change' => 'now()'
    ];
    $update_res = yes_db_perform(TABLE_SPECIALS,$update_sql_array,'update',[
        'specials_id' => (int)$specials_id
    ]);
    
    // BOF - specials ebay revise
    if($specials_data['ebay_price_revise'] == 1){
            $ser_array = specials_ebay_revise::get_specials_ebay_revise_id_from_specials_id($specials_id);
            switch($status){
                case 0:
                    foreach($ser_array as $serID){
                        $ser = new specials_ebay_revise($serID);
                        // WENN NOCH GAR KEIN REVISE AUF DEN SONDERPREIS
                        // STATTGEFUNDEN HAT, EINFACH LOESCHEN
                        if($ser->getIs_revised() == 0 and $ser->getStatus() == 0){
                            $ser->delete();
                            continue;
                        }
                        // ser item wurde schon auf sonderpreis gesetzt, wir setzen 
                        // status auf 1 um ihn beim naechsten cronjob wieder auf alten
                        // preis zu setzen
                        $ser->update_status('1');
                    }
                    break;
                case 1:
                    if(sizeOf($ser_array)){
                        if(!function_exists('yes_write_notice'))
                            include(DIR_FS_INC.'yes_write_notice.inc.php');
                        $message = 'Beim Aktivieren des Sonderangebots wurde ermittelt, dass eine eBay Preis&auml;nderung stattfinden soll. F&uuml;r diese pID sind aber bereits Preis&auml;nderungen an eBay gesendet worden. Bitte pr&uuml;fen Sie den Vorgang und kontaktieren ggf. das YES Team';
                        yes_write_notice('Problem mit Sonderangebot eBay Preis pID '.$specials_data['products_id'],$message,0,$recipients_array);
                    }else{
                        if(!class_exists('xtcPrice')){
                            require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
                        }
                        $xtPrice = new xtcPrice(DEFAULT_CURRENCY, EBAY_CUSTOMERS_STATUS);
                        $tax_class_id = yes_eu_oss_get_products_tax_class_id(
                            $specials_data['products_id'], STORE_COUNTRY, 0
                        );
                        $new_price = $xtPrice->xtcGetPrice($specials_data['products_id'], false, 1, $tax_class_id);
                        specials_ebay_revise::create_from_specials_id($specials_id, $new_price);
                    }
                    break;
            }
        }
    return $update_res;
}
