<?php
/**
 * generates a pdf file with all order-data
 *
 * @param integer $orders_id
 * @param object $smarty
 * @param object $pdf_smarty
 * @param string $pdf_filename
 * @return string
 */
function yes_export_order_pdf($orders_id,$pdf_filename){
	global $smarty,$pdf_smarty,$xtPrice;

	$rueckerstattung_smarty = $pdf_smarty;
	$reclamation_smarty = $pdf_smarty;
	$retoure_smarty = $pdf_smarty;
	
	$history_smarty = $pdf_smarty;
	$payment_smarty = $pdf_smarty;
	
	
	$order = new order($orders_id);
	$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
	$order_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');
	
	if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
	    $pdf = new yes_pdf();
	    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
		$pdf->set_landscape();
	    }
	    $yes_pdf_content = $order_html;
	}else{
	    $pdf=new HTML2FPDF();
	    $pdf->AddPage();
	    $pdf->WriteHTML($order_html);
	}
	
	$history_array = array();

	$history_query = xtc_db_query("SELECT * FROM orders_status_history WHERE orders_id='".$order->info['id']."' order by date_added DESC");
	while($history = xtc_db_fetch_array($history_query)){
		$history['editor'] = xtc_get_editor_name($history['editor_id']);
		$history['status_name'] = xtc_get_orders_status_name($history['orders_status_id']);
		$history['comments'] = htmlentities($history['comments']);
		$history_array[] = xtc_db_prepare_input($history);
	}
	$history_smarty->assign('history_array',$history_array);
	$history_smarty->assign('history_item','Re-Nr: '.$order->info['id']);
	$history_html = $history_smarty->fetch(CURRENT_TEMPLATE . '/admin/pdf_order_export_history.html');

	if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
	    $yes_pdf_content .= $history_html;
	}else{
	    $pdf->AddPage();
	    $pdf->WriteHTML($history_html);
	}
	
	// PAYMENTS	
	$payment_query = xtc_db_query("SELECT ip.buchungstag,ip.betrag,po.created FROM incoming_payments ip, payment_orders po WHERE ip.id=po.payment_id and po.orders_id='".$order->info['id']."'");
	if(xtc_db_num_rows($payment_query) > 0){
		$payment_array = array();
		while($payment = xtc_db_fetch_array($payment_query)) {
			$payment_array[] = $payment;
		}
		$payment_smarty->assign('payment_array',$payment_array);
		$payment_smarty->assign('orders_id',$order->info['id']);
		$payment_html = $payment_smarty->fetch(CURRENT_TEMPLATE . '/admin/pdf_order_export_payments.html');
	}
	
	if(xtc_not_null($payment_html)){
	    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		$yes_pdf_content .= $payment_html;
	    }else{
		$pdf->AddPage();
		$pdf->WriteHTML($payment_html);
	    }
	}
	
	// RUECKERSTATTUNGEN
	if(is_array($order->rueckerstattungen) and sizeOf($order->rueckerstattungen)>0){
		foreach($order->rueckerstattungen as $k=>$v){
			$rueckerstattung = new rueckerstattung($v['id']);
			$rueckerstattung_html = xtc_get_rueckerstattung_html_for_pdf($rueckerstattung,$rueckerstattung_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_rueckerstattung.html');
			if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			    $yes_pdf_content .= $rueckerstattung_html;
			}else{
			    $pdf->AddPage();
			    $pdf->WriteHTML($rueckerstattung_html);
			}
	
			// HISTORIE RUECKERSTATTUNGEN
			$history_smarty = $smarty;
			$history_array = array();
			$history_query = xtc_db_query("SELECT * FROM rueckerstattungen_status_history WHERE rueckerstattungen_id='".$v['id']."' order by date_added DESC");
			while($history = xtc_db_fetch_array($history_query)){
				$history['editor'] = xtc_get_editor_name($history['editor_id']);
				$history['status_name'] = xtc_get_rueckerstattungen_status_name($history['rueckerstattungen_status_id']);
				$history['comments'] = htmlentities($history['comments']);
				$history_array[] = xtc_db_prepare_input($history);
			}
			$history_smarty->assign('history_array',$history_array);
			$history_smarty->assign('history_item','Rueckerstattung-Nr: '.$v['id']);
			$history_html = $history_smarty->fetch(CURRENT_TEMPLATE . '/admin/pdf_order_export_history.html');
	
			if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			    $yes_pdf_content .= $history_html;
			}else{
			    $pdf->AddPage();
			    $pdf->WriteHTML($history_html);
			}
		}
	}
	
	// REKLAMATIONEN
	$reclamations_query = xtc_db_query("SELECT reclamations_id FROM reclamations WHERE orders_id='".$order->info['id']."'");
	if(xtc_db_num_rows($reclamations_query)){
		while($row = xtc_db_fetch_array($reclamations_query)){
			$reclamation = new reclamation($row['reclamations_id']);
			$reclamation_html = xtc_get_reclamation_html_for_pdf($reclamation,$reclamation_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_reclamation.html');

			if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			    $yes_pdf_content .= $reclamation_html;
			}else{
			    $pdf->AddPage();
			    $pdf->WriteHTML($reclamation_html);
			}
	
			// HISTORIE REKLAMATION
			$history_smarty = $smarty;
			$history_array = array();
                        $hitems = \YES4Trade\Model\reclamations_status_history::get_by_reclamations_id((int)$row['reclamations_id']);
                        foreach($hitems as $hit){
                            $history = $hit->toArray();
                            $history['editor'] = xtc_get_editor_name($hit->editor_id);
                            $history['status_name'] = xtc_get_reclamations_status_name($hit->reclamations_status_id);
                            $history['comments'] = htmlentities($hit->comments);
                            $history_array[] = xtc_db_prepare_input($history);
			}
			$history_smarty->assign('history_array',$history_array);
			$history_smarty->assign('history_item','Reklamation-Nr: '.$row['reclamations_id']);
			$history_html = $history_smarty->fetch(CURRENT_TEMPLATE . '/admin/pdf_order_export_history.html');
			if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			    $yes_pdf_content .= $history_html;
			}else{
			    $pdf->AddPage();
			    $pdf->WriteHTML($history_html);
			}
		}
	}
	
	// RETOUREN
	$retouren_query = xtc_db_query("SELECT retoure_id FROM retouren WHERE orders_id='".$order->info['id']."'");
	if(xtc_db_num_rows($retouren_query)){
		while($row = xtc_db_fetch_array($retouren_query)){
			$retoure = new retoure($row['retoure_id']);
			$retoure_html = xtc_get_retoure_html_for_pdf($retoure,$retoure_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_retoure.html');
			if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			    $yes_pdf_content .= $retoure_html;
			}else{
			    $pdf->AddPage();
			    $pdf->WriteHTML($retoure_html);
			}
	
			// HISTORIE REKLAMATION
			$history_smarty = $smarty;
			$history_array = array();
                        $items = \YES4Trade\Model\retoure_status_history::get_by_retoure_id((int)$row['retoure_id']);
			foreach($items as $it){
                            $history = $it->toArray();
                            $history['editor'] = xtc_get_editor_name($history['editor_id']);
                            $history['status_name'] = xtc_get_retoure_status_name($history['retoure_status_id']);
                            $history['comments'] = htmlentities($history['comments']);
                            $history_array[] = xtc_db_prepare_input($history);
			}
			$history_smarty->assign('history_array',$history_array);
			$history_smarty->assign('history_item','Retoure-Nr: '.$row['retoure_id']);
			$history_html = $history_smarty->fetch(CURRENT_TEMPLATE . '/admin/pdf_order_export_history.html');
	
			if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			    $yes_pdf_content .= $history_html;
			}else{
			    $pdf->AddPage();
			    $pdf->WriteHTML($history_html);
			}
		}
	}
	
	//$pdf->Output($pdf_name,$dest='F'); //Read the FPDF.org manual to know the other options
	if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
	    $pdf->set_html($yes_pdf_content);
	    $pdf->save($pdf_filename);
	}else{
	    $pdf->Output($pdf_filename,$dest='F'); //Read the FPDF.org manual to know the other options
	}
	return $pdf_filename;
}
