<?php
function yes_get_subcategories($category_id,$status_check = true,$result = array()){
    global $InstanceCache;
    $cache_key = sprintf('categories.subcategories-%s',
        base64_encode('cat'.$category_id.'-status'.(($status_check === true) ? '1' : '0'))
    );
    $cache_group = 'categories';
    $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

    $CachedString = $InstanceCache->getItem($key); // cache group
    if (!$CachedString->isHit()) {
        $res = \YES4Trade\Model\category::get_by_parent_id($category_id,[
            'categories_id', 'categories_status'
        ]);
        $data = [];
        foreach($res as $cat_item){
            $data[] = $cat_item->toArray();
        }
        $CachedString->set($data)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $data = $CachedString->get();
    }
    if(is_countable($data) and sizeOf($data)){
        foreach($data as $record){
            if($status_check === true){
                if(intval($record['categories_status']) != 1){
                    continue;
                }
            }
            $result[] = $record['categories_id'];
            yes_get_subcategories($record['categories_id'],$status_check,$result);
        }
    }
    return $result;
}
