$(function(){
    if($('input[name="keywords"]').length){
        $('input[name="keywords"]').attr('id','suggestkw');
        var queryString = window.location.search;
        var urlParams = new URLSearchParams(queryString);
        var default_keywords = urlParams.get('keywords');
        if(!default_keywords){
            default_keywords = '';
        }
        $( '#suggestkw' ).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: "advanced_search_result.php",
                    dataType: "json",
                    data: {
                        keywords : request.term,
                        autocomplete : 1
                    },
                    success: function(data) {
                        response(data);
                    }
                });
            },
            minLength: 2,
            select: function( event, ui ) {
                $(this).val(ui.item.label);
                window.location.href = 'product_info.php?products_id='+ui.item.value+'&keywords='+encodeURIComponent(ui.item.label);
                return false;
//                alert(ui.item.value + " aka " + ui.item.label );
            },
            open: function(event, ui) {
                // HOVER EFFEKT AUSBLENDEN
                // $('.ui-autocomplete').off('menufocus hover mouseover mouseenter');
            }
        }).val(default_keywords);
    }else{
        console.log('no form with id=quickfind and includet input name=keywords');
    }
    $( '#suggestkw' ).data("ui-autocomplete")._renderItem = function (ul, item) {
        if(item.img != ''){
            return $( "<li></li>" )
                .data( "item.autocomplete", item )
                .append( "<table class=\"autocomplete_search_table\" width=\"100%\"><tr><td><img src=\""+item.img+"\" alt=\""+item.label+"\" style=\"max-width: 50px;max-height:50px;\"></td><td>" + item.label+ " </td><td align=\"right\" class=\"asprice\">"+item.price+"</td></tr></table>" )
                .appendTo( ul );
        
        }else{
            return $( "<li></li>" )
                .data( "item.autocomplete", item )
                .append( "<table class=\"autocomplete_search_table\" width=\"100%\"><tr><td>" + item.label+ " </td><td align=\"right\" class=\"asprice\">"+item.price+"</td></tr></table>" )
                .appendTo( ul );
        }
    };
});
