<?php
class products_email_notification{
    var $products_email_notifications_id;
    var $products_id;
    var $email_address;
    var $customers_id;
    var $notification_confirmed;
    var $date_confirmation;
    var $confirmation_code;
    var $email_template_filename_add;
    var $email_template_filename_remove;
    
    function __construct(){
	$this->setEmail_template_filename_add(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/products_email_notification_add');
	$this->setEmail_template_filename_remove(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/products_email_notification_remove');
    }
    
    public function getNotificationData($customers_id,$products_id){
	return array();
    }
    
    public function getProductsListByCustomerId($customer_id,$confirmation_status_check = false){
	$items = array();
	$status_check_sql = ($confirmation_status_check) ? " AND notification_confirmed = '1' " : '';
	$query = yes_query(sprintf(
		"SELECT * FROM products_email_notifications WHERE customers_id=:customers_id %s ORDER BY date_confirmation",
		$status_check_sql
	),['customers_id'=>(int)$customer_id]);
	foreach($query as $record){
	    $items[] = $record;
	}
	return $items;
    }
    
    public function collectData(){
		$action = $_REQUEST['action']??'';
	switch($action){
	    case 'pem_confirm':
		$code = substr(xtc_db_input($_REQUEST['code']),0,8);
		$email_address = xtc_db_input($_REQUEST['email']);
		$error = false;
		if(empty($code)){
		    $error = true;
		    $errorMsg = PEM_CODE_INVALID;
		}
		if(!$error && !xtc_validate_email($email_address)){
		    $error = true;
		    $errorMsg = PEM_ADD_ERROR_INVALID_EMAIL_ADDRESS;
		}
		if(!$error){
		    $pID_param = '';
		    $query = yes_query(
                        "SELECT products_email_notifications_id,products_id FROM products_email_notifications WHERE email_address=:email AND confirmation_code=:code AND notification_confirmed='0'",
                        ['email'=>$email_address,'code'=>$code]
                    );
		    if(!sizeOf($query)){
			$error = true;
			$errorMsg = PEM_CODE_INVALID;
		    }else{
			$record = current($query);
			$this->confirmEmailProductAllocation((int)$record['products_email_notifications_id']);
			$infoMsg = PEM_ADD_CONFIRMATION_SUCCESSFUL;
			$pID_param = '&products_id='.$record['products_id'];
		    }
		}
		if(isset($_REQUEST['json'])){
		    die(json_encode(array(
			'MSG'=>$errorMsg
		    )));
		}
		$msg = ($error) ? 'error_message='.urldecode($errorMsg): 'info_message='.urldecode($infoMsg);
		xtc_redirect(xtc_href_link(basename($_SERVER['SCRIPT_FILENAME'])).'?'.$msg.$pID_param);
	    case 'pem_remove_confirm':
		$code = substr(xtc_db_input($_REQUEST['code']),0,8);
		$email_address = xtc_db_input($_REQUEST['email']);
		$error = false;
		if(empty($code)){
		    $error = true;
		    $errorMsg = PEM_CODE_INVALID;
		}
		if(!$error && !xtc_validate_email($email_address)){
		    $error = true;
		    $errorMsg = PEM_ADD_ERROR_INVALID_EMAIL_ADDRESS;
		}
		if(!$error){
		    $pID_param = '';
		    $query = yes_query(
                        "SELECT products_email_notifications_id,products_id FROM products_email_notifications WHERE email_address=:email AND confirmation_code=:code AND delete_flag='1'",
                        ['email'=>$email_address,'code'=>$code]
		    );
		    if(!sizeOf($query)){
			$error = true;
			$errorMsg = PEM_CODE_INVALID;
		    }else{
			$record = current($query);
			$this->removeEmailProductAllocation((int)$record['products_email_notifications_id']);
			$infoMsg = PEM_REMOVE_SUCCESSFUL;
			$pID_param = '&products_id='.$record['products_id'];
		    }
		}
		// erst nach erfolgreichem abmelden 
		// unset($_SESSION['products_email_notification'][$pID][$email_address]);
		if(isset($_REQUEST['json'])){
		    die(json_encode(array(
			'MSG'=>$errorMsg
		    )));
		}
		$msg = ($error) ? 'error_message='.urldecode($errorMsg): 'info_message='.urldecode($infoMsg);
		xtc_redirect(xtc_href_link(basename($_SERVER['SCRIPT_FILENAME'])).'?'.$msg.$pID_param);
		break;
	    case 'pem_add':
		if(!is_file($this->getEmail_template_filename_add().'.html')){
		    die('products_email_notification Template '.$this->getEmail_template_filename_add().'.html nicht vorhanden');
		}
		if(!is_file($this->getEmail_template_filename_add().'.txt')){
		    die('products_email_notification Template '.$this->getEmail_template_filename_add().'.txt nicht vorhanden');
		}
		if(!is_file($this->getEmail_template_filename_remove().'.html')){
		    die('products_email_notification Template '.$this->getEmail_template_filename_remove().'.html nicht vorhanden');
		}
		if(!is_file($this->getEmail_template_filename_remove().'.txt')){
		    die('products_email_notification Template '.$this->getEmail_template_filename_remove().'.txt nicht vorhanden');
		}
		$error = false;

		if(defined('MODULE_OTHER_TURNSTILE_STATUS') and constant('MODULE_OTHER_TURNSTILE_STATUS') == 'True'){
			require_once(DIR_WS_MODULES.'other/turnstile.php');
			require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/turnstile.php');
			$turnstile = true;
			$turnstile_class = new \turnstile();
		}
		if(!$turnstile){
			$vvCode = xtc_db_input($_REQUEST['vv_code']);
			if(!isset($_SESSION['PEMvvcode']) or empty($_SESSION['PEMvvcode']) or $_SESSION['PEMvvcode'] != $vvCode){
		    	$error = true;
		    	$errorMsg = PEM_ADD_ERROR_WRONG_VVCODE;
			}
		}else{
			$error = true;
			$errorMsg = TEXT_CAPTCHA_FAILED;
			if($turnstile_class->verify()){
				$error = false;
			}
		}
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
		$email_address = xtc_db_input($_REQUEST['email_address']);
		if(!$error && $pID < 1){
		    $error = true;
		    $errorMsg = PEM_ADD_ERROR_NO_PRODUCTS_ID;
		}
		if(!$error && !$this->isProductValid($pID)){
		    $error = true;
		    $errorMsg = PEM_ADD_ERROR_INVALID_PRODUCTS_ID;
		}
		if(!$error && !xtc_validate_email($email_address)){
		    $error = true;
		    $errorMsg = PEM_ADD_ERROR_INVALID_EMAIL_ADDRESS;
		}
		if(!$error && $this->existsEmailProductAllocation($email_address,$pID)){
		    if(isset($_REQUEST['pn_mode']) and $_REQUEST['pn_mode']=='out'){
			$code = $this->removeEmailProductAllocationConfirm($email_address,$pID);
			$this->send_remove_confirmation_email($email_address,$code,$pID);
			$infoMsg = sprintf(PEM_REMOVE_SUCCESS_MSG,$email_address);
			if(isset($_REQUEST['json'])){
			    die(json_encode(array(
				'MSG'=>$errorMsg
			    )));
			}
			$msg = '?info_message='.urldecode($infoMsg);
			xtc_redirect(xtc_href_link(basename($_SERVER['SCRIPT_FILENAME']),xtc_get_all_get_params(array('action','error_message','info_message'))).$msg);
		    }else{
			$error = true;
			$errorMsg = PEM_ADD_ERROR_ALLOCATION_EXISTS;
		    }
		}
		$infoMsg = '';
		if(!$error){
		    $code = $this->addEmailProductAllocation($email_address,$pID);
		    $this->send_confirmation_email($email_address,$code,$pID);
		    $infoMsg = sprintf(PEM_ADD_SUCCESS_MSG,$email_address);
		}
		if(isset($_REQUEST['json'])){
		    die(json_encode(array(
			'MSG'=>$errorMsg
		    )));
		}
		if($error){
		    $msg = '?error_message='.urlencode($errorMsg);
		}else{
		    $msg = '?info_message='.urldecode($infoMsg);
		}
		xtc_redirect(xtc_href_link(basename($_SERVER['SCRIPT_FILENAME']),xtc_get_all_get_params(array('action','error_message','info_message'))).$msg);
		break;
	}
    }
    
    private function confirmEmailProductAllocation($id){
	$update_sql_array = array(
	    'delete_flag'=>0,
	    'confirmation_code'=> '',
	    'date_confirmation'=>'now()',
	    'notification_confirmed'=>1
	);
	yes_db_perform('products_email_notifications',$update_sql_array,'update',[
                'products_email_notifications_id'=>(int)$id
        ]);
    }
    
    private function send_confirmation_email($email_address,$code,$products_id){
	$smarty = new yesSmarty();
	$products_name = xtc_get_products_name($products_id);
	$smarty->assign(array(
	   'EMAIL_ADDRESS'=>$email_address,
	   'CONFIRMATION_LINK'=>xtc_href_link(basename($_SERVER['SCRIPT_FILENAME']),'action=pem_confirm&code='.$code.'&email='.$email_address),
	   'PRODUCTS_NAME'=>$products_name,
	    'language'=>$_SESSION['language'],
	    'STORE_NAME_ADDRESS'=>STORE_NAME_ADDRESS
	));
	$html_mail = $smarty->fetch(''.$this->getEmail_template_filename_add().'.html');
	$txt_mail = $smarty->fetch(''.$this->getEmail_template_filename_add().'.txt');
	$subject = PEM_EMAIL_CONFIRMATION_SUBJECT.': '.$products_name;
	// send mail to customer
	if(!strstr(HTTP_SERVER,'localhost')){
		xtc_php_mail(EMAIL_BILLING_ADDRESS,
		EMAIL_BILLING_NAME,
		$email_address,
		$email_address,
		'',
		EMAIL_BILLING_REPLY_ADDRESS,
		EMAIL_BILLING_REPLY_ADDRESS_NAME,
		'',
		'',
		$subject,
		$html_mail ,
		$txt_mail );
	}
    }
    
    private function send_remove_confirmation_email($email_address,$code,$products_id){
	$smarty = new yesSmarty();
	$products_name = xtc_get_products_name($products_id);
	$smarty->assign(array(
	   'EMAIL_ADDRESS'=>$email_address,
	   'CONFIRMATION_LINK'=>xtc_href_link(basename($_SERVER['SCRIPT_FILENAME']),'action=pem_remove_confirm&code='.$code.'&email='.$email_address),
	   'PRODUCTS_NAME'=>$products_name,
	    'language'=>$_SESSION['language'],
	    'STORE_NAME_ADDRESS'=>STORE_NAME_ADDRESS
	));
	$html_mail = $smarty->fetch(''.$this->getEmail_template_filename_remove().'.html');
	$txt_mail = $smarty->fetch(''.$this->getEmail_template_filename_remove().'.txt');
	$subject = PEM_EMAIL_REMOVE_CONFIRMATION_SUBJECT.': '.$products_name;
	// send mail to customer
	if(!strstr(HTTP_SERVER,'localhost')){
		xtc_php_mail(EMAIL_BILLING_ADDRESS,
		EMAIL_BILLING_NAME,
		$email_address,
		$email_address,
		'',
		EMAIL_BILLING_REPLY_ADDRESS,
		EMAIL_BILLING_REPLY_ADDRESS_NAME,
		'',
		'',
		$subject,
		$html_mail ,
		$txt_mail );
	}
    }
    
    private function removeEmailProductAllocationConfirm($email_address,$pID){
	$update_sql_array = array(
	    'delete_flag'=>1,
	    'confirmation_code'=>  xtc_random_charcode(8)
	);
	yes_db_perform('products_email_notifications',$update_sql_array,'update',[
            'products_id'=>(int)$pID,'email_address'=>$email_address
        ]);
	return $update_sql_array['confirmation_code'];
    }
    
    private function addEmailProductAllocation($email_address,$pID){
	$insert_sql_array = array(
	    'date_added'=>'now()',
	    'products_id'=>$pID,
	    'email_address'=>$email_address,
	    'customers_id'=>(isset($_SESSION['customer_id'])) ? $_SESSION['customer_id'] : 0,
	    'confirmation_code'=>  xtc_random_charcode(8)
	);
	yes_db_perform('products_email_notifications',$insert_sql_array);
	return $insert_sql_array['confirmation_code'];
    }
    
    public function existsEmailProductAllocation($email_address,$products_id){
	$query = yes_query(
		"SELECT products_email_notifications_id FROM products_email_notifications WHERE email_address=:email AND products_id=:products_id",
		['email'=>$email_address,'products_id'=>$products_id]
	);
	if(sizeOf($query)){
	    return true;
	}
	return false;
    }
    private function isProductValid($products_id){
	$query = yes_query(sprintf(
            "SELECT products_id FROM %s WHERE products_id=:products_id AND products_status='1'",
		TABLE_PRODUCTS
            ),['products_id'=>$products_id]
        );
	if(!sizeOf($query)){
	    return false;
	}
	$record = current($query);
	$SQ = new products_quantity($record['products_id']);
	$qty_total = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
	if($qty_total > 0){
	    return false;
	}
	return true;
    }
    
    private function removeEmailProductAllocation($id){
	yes_query(
            "DELETE FROM products_email_notifications WHERE products_email_notifications_id=:id",
            ['id'=>(int)$id]
	);
    }
    
    public function getProducts_email_notifications_id() {
	return $this->products_email_notifications_id;
    }

    public function setProducts_email_notifications_id($products_email_notifications_id) {
	$this->products_email_notifications_id = $products_email_notifications_id;
    }

    public function getProducts_id() {
	return $this->products_id;
    }

    public function setProducts_id($products_id) {
	$this->products_id = $products_id;
    }

    public function getEmail_address() {
	return $this->email_address;
    }

    public function setEmail_address($email_address) {
	$this->email_address = $email_address;
    }

    public function getCustomers_id() {
	return $this->customers_id;
    }

    public function setCustomers_id($customers_id) {
	$this->customers_id = $customers_id;
    }

    public function getNotification_confirmed() {
	return $this->notification_confirmed;
    }

    public function setNotification_confirmed($notification_confirmed) {
	$this->notification_confirmed = $notification_confirmed;
    }

    public function getDate_confirmation() {
	return $this->date_confirmation;
    }

    public function setDate_confirmation($date_confirmation) {
	$this->date_confirmation = $date_confirmation;
    }

    public function getConfirmation_code() {
	return $this->confirmation_code;
    }

    public function setConfirmation_code($confirmation_code) {
	$this->confirmation_code = $confirmation_code;
    }
    public function getEmail_template_filename_add() {
	return $this->email_template_filename_add;
    }

    public function setEmail_template_filename_add($email_template_filename_add) {
	$this->email_template_filename_add = $email_template_filename_add;
    }
    public function getEmail_template_filename_remove() {
	return $this->email_template_filename_remove;
    }

    public function setEmail_template_filename_remove($email_template_filename_remove) {
	$this->email_template_filename_remove = $email_template_filename_remove;
    }
}