<?php
/* -----------------------------------------------------------------------------------------
   $Id: default.php,v 1.45 2020/04/07 15:13:45 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(default.php,v 1.84 2003/05/07); www.oscommerce.com
   (c) 2003	 nextcommerce (default.php,v 1.11 2003/08/22); www.nextcommerce.org

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contributions:
   Enable_Disable_Categories 1.3        	Autor: Mikel Williams | mikel@ladykatcostumes.com
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
$default_smarty = new yesSmarty;
$default_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
$default_smarty->assign('session',session_id());
$main_content = '';
// include needed functions
require_once(DIR_FS_INC . 'xtc_customer_greeting.inc.php');
require_once(DIR_FS_INC . 'xtc_get_path.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_pull_down_menu.inc.php');
require_once(DIR_FS_INC . 'xtc_check_categories_status.inc.php');
require_once(DIR_FS_INC . 'yes_get_products_sort_direction.inc.php');

$parameters = [];
if (xtc_check_categories_status($current_category_id)>=1) {
    $error=CATEGORIE_NOT_FOUND;
    include(DIR_WS_MODULES . FILENAME_ERROR_HANDLER);
} else {
    if ($category_depth == 'nested') {
        if (GROUP_CHECK=='true') {
            $group_check="and c.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
        }
        
        $categories_query_raw = "select
            cd.categories_description,
            cd.categories_heading_title,
            cd.categories_name,
            c.categories_id,
            c.categories_template,
            c.link_id,
            c.categories_image,
            c.parent_id from " .
            TABLE_CATEGORIES . " c, " .
            TABLE_CATEGORIES_DESCRIPTION . " cd
            where c.categories_status = '1'
            and c.parent_id =:parent_id
            and c.categories_id = cd.categories_id
            ".$group_check."
            and cd.language_id =:language_id
            order by sort_order, cd.categories_name";
        
	    if (isset($cPath) and strstr($cPath,'_')) {
            // check to see if there are deeper categories within the current category
            $category_links = array_reverse($cPath_array);
            for($i = 0, $n = sizeof($category_links); $i < $n; $i++) {
                
                $cache_key = sprintf('shop.categories.nested.parentid%d-lang%d',
                    $category_links[$i],$_SESSION['languages_id']
                );
                $cache_key = md5(serialize($cache_key));
                $cache_group = 'categories';
                $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

                $CachedString = $InstanceCache->getItem($key); // cache group
                if (!$CachedString->isHit()) {
                    $categories_query = yes_query($categories_query_raw,[
                        'parent_id'=>$category_links[$i],
                        'language_id'=> (int)$_SESSION['languages_id']
                    ]);
                    $CachedString->set($categories_query)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
                    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
                }else{
                    $categories_query = $CachedString->get();
                }
                if (!sizeOf($categories_query)) {
                // do nothing, go through the loop
                } else {
                    break; // we've found the deepest category the customer is in
                }
            }
	    } else {
            $cache_key = sprintf('shop.categories.nested.parentid%d-lang%d',
		        $current_category_id,$_SESSION['languages_id']
            );
            $cache_key = md5(serialize($cache_key));
            $cache_group = 'categories';
            $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

            $CachedString = $InstanceCache->getItem($key); // cache group
            if (!$CachedString->isHit()) {
                $categories_query = yes_query($categories_query_raw,[
                    'parent_id'=>$current_category_id,
                    'language_id'=> (int)$_SESSION['languages_id']
                ]);
                $CachedString->set($categories_query)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $categories_query = $CachedString->get();
            }
    	}
    	$rows = 0;
        if(sizeOf($categories_query)){
            foreach($categories_query as $categories) {
                $rows++;
                if($categories['link_id']>0){
                    $cPath_new = xtc_get_path($categories['link_id']);
                }else{
                    $cPath_new = xtc_get_path($categories['categories_id']);
                }
                $width = (int)(100 / MAX_DISPLAY_CATEGORIES_PER_ROW) . '%';
                $image='';
                if ($categories['categories_image']!='') {
                    $image=DIR_WS_IMAGES.'categories/'.$categories['categories_image'];
	      	    }
                $categories_content[]=array(
                        'CATEGORIES_NAME' => $categories['categories_name'],
                        'CATEGORIES_HEADING_TITLE' => $categories['categories_heading_title'],
                        'CATEGORIES_IMAGE' => $image,
                        'CATEGORIES_ID'=>$categories['categories_id'],
                        'CATEGORIES_LINK' => xtc_href_link(FILENAME_DEFAULT, $cPath_new),
                        'CATEGORIES_DESCRIPTION' => $categories['categories_description']
                );
            }
	    }
	    $new_products_category_id = $current_category_id;
        include(DIR_WS_MODULES . FILENAME_NEW_PRODUCTS);
        include(DIR_WS_MODULES . 'products_in_category.php');
        if (GROUP_CHECK=='true') {
            $group_check="and c.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
        }
    	$category_query_raw = "select
            cd.categories_description,
            cd.categories_heading_title,
            cd.categories_name,
            c.categories_id,
            c.categories_template,
            c.categories_image from " .
            TABLE_CATEGORIES . " c, " .
            TABLE_CATEGORIES_DESCRIPTION . " cd
            where c.categories_id =:cat_id and cd.categories_id = c.categories_id
            ".$group_check."
            and cd.language_id =:language_id";
        
        $cache_key = sprintf('shop.categories.nested-cid%d-lang%d',
            $current_category_id,$_SESSION['languages_id']
        );
        $cache_group = 'categories';
        $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

        $CachedString = $InstanceCache->getItem($key); // cache group
        if (!$CachedString->isHit()) {
            $category = yes_query($category_query_raw,[
                'cat_id'=>$current_category_id,
                'language_id'=> (int)$_SESSION['languages_id']
            ],true);
            $CachedString->set($category)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $category = $CachedString->get();
        }
        $image='';
        if ($category['categories_image']!='') {
            $image=DIR_WS_IMAGES.'categories/'.$category['categories_image'];
        }
        
        $default_smarty->assign([
            'CATEGORIES_ID'=>$category['categories_id'],
            'CATEGORIES_NAME'=>$category['categories_name'],
            'CATEGORIES_IMAGE'=>$image,
            'CATEGORIES_HEADING_TITLE'=>xtc_db_prepare_input($category['categories_heading_title']),
            'CATEGORIES_DESCRIPTION'=>$category['categories_description'],
            'language' => $_SESSION['language'],
            'module_content'=>$categories_content
        ]);

    	// get default template
	    if ($category['categories_template']=='' or $category['categories_template']=='default') {
            $files=array();
            if ($dir= opendir(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/categorie_listing/')){
                while  (($file = readdir($dir)) !==false) {
                    if (is_file( DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/categorie_listing/'.$file) and ($file !="index.html")){
                        $files[]=array(
                            'id' => $file,
                            'text' => $file
			            );
                    }//if
		        } // while
		        closedir($dir);
            }
            $category['categories_template']=$files[0]['id'];
	    }
	    $default_smarty->caching = 0;
	    $main_content= $default_smarty->fetch(CURRENT_TEMPLATE.'/module/categorie_listing/'.$category['categories_template']);
	    $smarty->assign(array(
            'main_content'=>$main_content,
            'listing_mode'=>'categories'
        ));
        // END IF nested category
    } elseif ($category_depth == 'products' or isset($_GET['manufacturers_id'])) {
        /**
         * KATEGORIEANSICHT PRODUKTE
         */
        //fsk18 lock
        $fsk_lock='';
        if ($_SESSION['customers_status']['customers_fsk18_display']=='0') {
            $fsk_lock=' and p.products_fsk18!=1';
        }
        // show the products of a specified manufacturer

        // BOF - PRODUKTGRUPPEN FILTER
        $products_groups_filter_where = ''; // alt
        $products_groups_filter_from = ''; // chatgpt
        if(isset($_GET['set']) and sizeOf($_GET['set'])){
            $pg_arr = array();
            $pg_count = 1;
            foreach($_GET['set'] as $gcID=>$products_characteristic_set_id){
                // OPTIMIERT VON chatgpt
                $products_groups_filter_from .= sprintf(
                    " INNER JOIN products_to_characteristics c%d ON p.products_id = c%d.products_id AND c%d.products_characteristic_set_id = %d ",
                    $pg_count, $pg_count,$pg_count,intval($products_characteristic_set_id)
                );                    
                $pg_count++;

                /** ALT
                $sqlKeyName = 'set_id_'.$gcID;
                $pg_arr[] = " p.products_id IN( SELECT products_id FROM products_to_characteristics WHERE products_characteristic_set_id=:".$sqlKeyName." ) ";
                $parameters[$sqlKeyName]=(int)xtc_db_input($products_characteristic_set_id);
                */
            }
            /** ALT
            $products_groups_filter_where = sprintf(" AND %s ",
                implode(' AND ',$pg_arr)
            );*/
        }
        // EOF - PRODUKTGRUPPEN FILTER
                
	    if (isset($_GET['manufacturers_id'])) {
            $manufacturer_name = \YES4Trade\Model\manufacturer::get_manufacturers_name(
                intval($_GET['manufacturers_id'])
            );
            $default_smarty->assign('MANUFACTURERS_NAME',$manufacturer_name);
            if (isset($_GET['filter_id']) && xtc_not_null($_GET['filter_id'])) {
                $sorting = yes_get_product_sort_direction((int)xtc_db_input($_REQUEST['filter_id']));

                if (GROUP_CHECK=='true') {
                    $group_check="and p.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
                }

                // OPTIMIERT VON chatgpt
                $listing_sql_select = "select p.products_id,
                    p.products_model,
                    p.products_ean,
                    p.products_price,
                    p.products_discount_allowed,
                    p.products_quantity,
                    p.products_weight,
                    p.products_image,
                    p.products_date_available,
                    p.products_shippingtime,
                    p.products_fsk18,
                    p.products_vpe,
                    p.products_vpe_status,
                    p.products_vpe_value,
                    p.products_master,
                    p.products_master_status,
                    p.manufacturers_id,
                    pd.products_name,
                    pd.products_extra_text,
                    pd.products_short_description,
                    pd.products_description,
                    m.manufacturers_name,
                    s.specials_new_products_price";

                /** ALT
                $listing_sql_select = "select DISTINCT p.products_fsk18,
                    p.products_date_available,
                    p.products_shippingtime,
                    p.products_model,
                    pd.products_name,
                    pd.products_extra_text,
                    p.products_ean,

                    p.products_master,
                    p.products_master_status,

                    p.products_price,
                    m.manufacturers_name,
                    p.products_quantity,
                    p.products_image,
                    p.products_weight,
                    pd.products_short_description,
                    pd.products_description,
                    p.products_id,
                    p.manufacturers_id,
                    p.products_price,
                    p.products_discount_allowed,
                    p.products_vpe,p.products_vpe_status,p.products_vpe_value";
                */


                // OPTIMIERT VON chatgpt
                $listing_sql_from = sprintf(" from %s p"
                    ." INNER JOIN %s pd ON p.products_id = pd.products_id"
                    ." INNER JOIN %s m ON p.manufacturers_id = m.manufacturers_id"
                    ." INNER JOIN %s p2c ON p.products_id = p2c.products_id"
                    ." LEFT JOIN %s s ON p.products_id = s.products_id",
                        TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION,
                        TABLE_MANUFACTURERS, TABLE_PRODUCTS_TO_CATEGORIES,
                        TABLE_SPECIALS
                    ).$products_groups_filter_from;
                    
                /** ALT
                $listing_sql_from = " from " . TABLE_PRODUCTS . " p, " .
                    TABLE_PRODUCTS_DESCRIPTION . " pd, " .
                    TABLE_MANUFACTURERS . " m, " .
                    TABLE_PRODUCTS_TO_CATEGORIES . " p2c left join " .
                    TABLE_SPECIALS . " s on p2c.products_id = s.products_id ";
                */
                
                // OPTIMIERT VON chatgpt
                $listing_sql_where = " where p.products_status = 1"
                    ." AND p.products_listing_status = 1"
                    ." AND m.manufacturers_id = :manufacturers_id"
                    ." AND pd.language_id = :language_id"
                    ." AND p2c.categories_id = :filter_id"
                    .$group_check
                    .$fsk_lock
                    .$sorting;
                

                /** ALT
                $listing_sql_where = " where p.products_status = '1'
                    and p.products_listing_status = '1'		
                    and p.manufacturers_id = m.manufacturers_id
                    and m.manufacturers_id =:manufacturers_id
                    and p.products_id = p2c.products_id
                    and pd.products_id = p2c.products_id
                    ".$products_groups_filter_where."
                    ".$group_check."
                    ".$fsk_lock."
                    and pd.language_id =:language_id ".$fsk_lock."
                    and p2c.categories_id =:filter_id ".$sorting;
                */

                $listing_sql = sprintf('%s %s %s',
                    $listing_sql_select,$listing_sql_from,$listing_sql_where
                );
                
                $parameters['manufacturers_id'] = (int)$_GET['manufacturers_id'];
                $parameters['language_id'] = (int)$_SESSION['languages_id'];
                $parameters['filter_id'] =  (int)$_GET['filter_id'];
            } else { // end if filter_id
                // We show them all
                if (GROUP_CHECK=='true') {
                    $group_check="and p.group_ids like '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
                }
		        $listing_sql_select = "select p.products_fsk18,
                    p.manufacturers_id,
                    p.products_date_available,
                    p.products_discount_allowed,
                    p.products_ean,
                    p.products_id,
                    p.products_image,
                    p.products_master,
                    p.products_master_status,
                    p.products_model,
                    p.products_price,
                    p.products_quantity,
                    p.products_shippingtime,
                    p.products_vpe,
                    p.products_vpe_status,
                    p.products_vpe_value,
                    p.products_weight,
                    pd.products_name,
                    pd.products_extra_text,
                    pd.products_short_description,
                    pd.products_description,
                    m.manufacturers_name,
                    s.specials_new_products_price";
                    
                // OPTIMIERT VON chatgpt
                $listing_sql_from = sprintf(
                     " from %s p"
                    ." INNER JOIN %s pd ON p.products_id = pd.products_id"
                    ." INNER JOIN %s m ON p.manufacturers_id = m.manufacturers_id"
                    ." INNER JOIN %s p2c ON p.products_id = p2c.products_id"
                    ." LEFT JOIN %s s ON p.products_id = s.products_id",
                    TABLE_PRODUCTS, TABLE_PRODUCTS_DESCRIPTION,
                    TABLE_MANUFACTURERS,TABLE_PRODUCTS_TO_CATEGORIES,
                    TABLE_SPECIALS
                ).$products_groups_filter_from;
                /** ALT
                $listing_sql_from = " from " .
                    TABLE_PRODUCTS . " p, " .
                    TABLE_PRODUCTS_DESCRIPTION . " pd left join " .
                    TABLE_SPECIALS . " s on pd.products_id = s.products_id, " .
                    TABLE_MANUFACTURERS . " m, ".
                    TABLE_PRODUCTS_TO_CATEGORIES . " p2c";
                */

                // OPTIMIERT VON chatgpt
                $listing_sql_where = " where p.products_status = '1'"
                    ." AND p.products_listing_status = 1"
                    ." AND pd.language_id = :language_id"
                    ." AND m.manufacturers_id = :manufacturers_id"
                    .$group_check
                    .$fsk_lock
                    ." ORDER BY p.products_date_added DESC, p.products_id ASC";
                
                /** ALT
                $listing_sql_where = " where p.products_status = '1'
                    and p.products_listing_status = '1'
                    and pd.products_id = p.products_id
                    ".$products_groups_filter_where."
                    ".$group_check."
                    ".$fsk_lock."
                    and pd.language_id =:language_id
                    and p.manufacturers_id = m.manufacturers_id ".$fsk_lock."
                    and m.manufacturers_id =:manufacturers_id group by p.products_id ORDER BY p.products_date_added DESC, p.products_id ASC";
                */
                $listing_sql = sprintf('%s %s %s',
                    $listing_sql_select,$listing_sql_from,$listing_sql_where
                );
                $parameters['manufacturers_id'] = (int)$_GET['manufacturers_id'];
                $parameters['language_id'] = (int)$_SESSION['languages_id'];
            }// end if !filter_id
        // end if manufacturers_id
	    } else {
            // show the products in a given categorie
            if (isset($_GET['filter_id']) && xtc_not_null($_GET['filter_id'])) {
                $sorting = yes_get_product_sort_direction($current_category_id);
       		    // We are asked to show only specific catgeory
		        if (GROUP_CHECK=='true') {
                    $group_check="and p.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
		        }

                // OPTIMIERT VON chatgpt
                $listing_sql_select = "select 
                    p.products_fsk18,
                    p.products_date_available,
                    p.products_shippingtime,
                    p.products_model,
                    p.products_ean,
                    p.products_master,
                    p.products_master_status,
                    pd.products_name,
                    pd.products_extra_text,
                    p.products_id,
                    m.manufacturers_name,
                    p.products_quantity,
                    p.products_image,
                    p.products_weight,
                    pd.products_short_description,
                    pd.products_description,
                    p.manufacturers_id,
                    p.products_price,
                    p.products_discount_allowed,
                    p.products_vpe,
                    p.products_vpe_status,
                    p.products_vpe_value,
                    s.specials_new_products_price";

                /** ALT
       		    $listing_sql_select = "select p.products_fsk18,
                    p.products_date_available,
                    p.products_shippingtime,
                    p.products_model,
                    p.products_ean,
                    p.products_master,
                    p.products_master_status,
                    pd.products_name,
                    pd.products_extra_text,
                    p.products_id,
                    m.manufacturers_name,
                    p.products_quantity,
                    p.products_image,
                    p.products_weight,
                    pd.products_short_description,
                    pd.products_description,
                    p.manufacturers_id,
                    p.products_price,
                    p.products_discount_allowed,
                    p.products_vpe,p.products_vpe_status,p.products_vpe_value";
                */
                // OPTIMIERT VON chatgpt
                $listing_sql_from = sprintf(" from %s p"
                    ." INNER JOIN %s pd ON p.products_id = pd.products_id"
                    ." INNER JOIN %s m ON p.manufacturers_id = m.manufacturers_id"
                    ." INNER JOIN %s p2c ON p.products_id = p2c.products_id"
                    ." LEFT JOIN %s s ON p.products_id = s.products_id",
                    TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION,
                    TABLE_MANUFACTURERS, TABLE_PRODUCTS_TO_CATEGORIES,
                    TABLE_SPECIALS
                ).$products_groups_filter_from;

                /** ALT
                $listing_sql_from = " from " . TABLE_PRODUCTS . " p, " .
                    TABLE_PRODUCTS_DESCRIPTION . " pd, " .
                    TABLE_MANUFACTURERS . " m, " .
                    TABLE_PRODUCTS_TO_CATEGORIES . " p2c left join " .
                    TABLE_SPECIALS . " s USING(products_id)";
                */

                // OPTIMIERT VON chatgpt
                $listing_sql_where = " where p.products_status = 1"
                    ." AND p.products_listing_status = 1"
                    ." AND m.manufacturers_id = :filter_id"
                    ." AND pd.language_id = :language_id"
                    ." AND p2c.categories_id = :cat_id"
                    .$group_check
                    .$fsk_lock
                    .$sorting;
                /** ALT
                $listing_sql_where = " where p.products_status = '1'
                    and p.products_listing_status = '1'
                    and p.manufacturers_id = m.manufacturers_id
                    and m.manufacturers_id =:filter_id
                    and p.products_id = p2c.products_id
                    and pd.products_id = p2c.products_id
                    ".$products_groups_filter_where."
                    ".$group_check."
                    ".$fsk_lock."
                    and pd.language_id =:language_id ".$fsk_lock."
                    and p2c.categories_id =:cat_id group by p.products_id ".$sorting;
                */
      			// end if filter
                $listing_sql = sprintf('%s %s %s',
                    $listing_sql_select,$listing_sql_from,$listing_sql_where
                );
                $parameters['language_id'] = (int)$_SESSION['languages_id'];
                $parameters['cat_id'] =  $current_category_id;
                $parameters['filter_id'] = $_GET['filter_id'];
            // end if filter id
            } else {
		        $sorting = yes_get_product_sort_direction($current_category_id);
                // We show them all
                if (GROUP_CHECK=='true') {
                    $group_check = "and p.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
                }
                // OPTIMIERT VON chatgpt
                $listing_sql_select = "select p.products_fsk18,
                    p.products_date_available,
                    p.products_shippingtime,
                    p.products_model,
                    p.products_master,
                    p.products_master_status,
                    p.products_ean,
                    pd.products_name,
                    pd.products_extra_text,
                    p.products_quantity,
                    p.manufacturers_id,
                    p.products_image,
                    p.products_weight,
                    pd.products_short_description,
                    pd.products_description,
                    p.products_id,
                    p.products_price,
                    p.products_discount_allowed,
                    p.products_vpe,
                    p.products_vpe_status,
                    p.products_vpe_value";

                /** ALT
                $listing_sql_select = "select p.products_fsk18,
                    p.products_date_available,
                    p.products_shippingtime,
                    p.products_model,
                    p.products_master,
                    p.products_master_status,
                    p.products_ean,
                    pd.products_name,
                    pd.products_extra_text,
                    p.products_quantity,
                    p.manufacturers_id,
                    p.products_image,
                    p.products_weight,
                    pd.products_short_description,
                    pd.products_description,
                    p.products_id,
                    p.products_price,
                    p.products_discount_allowed,
                    p.products_vpe,p.products_vpe_status,p.products_vpe_value";
                */
                
                // OPTIMIERTER QUERY chatgpt
                $listing_sql_from = sprintf("from %s p INNER JOIN %s pd ON p.products_id=pd.products_id INNER JOIN %s p2c ON p.products_id=p2c.products_id",
                    TABLE_PRODUCTS,
                    TABLE_PRODUCTS_DESCRIPTION,
                    TABLE_PRODUCTS_TO_CATEGORIES,
                ).$products_groups_filter_from;

                // ALTER QUERY
                // $listing_sql_from = "from " . TABLE_PRODUCTS . " p left join " .
                //    TABLE_PRODUCTS_DESCRIPTION . " pd using(products_id), " .
                //    TABLE_PRODUCTS_TO_CATEGORIES . " p2c ";

                // OPTIMIERTER QUERY chatgpt
                $listing_sql_where = sprintf("where p.products_status = '1' and p.products_listing_status = '1' %s %s and pd.language_id =:language_id and p2c.categories_id =:cat_id %s",
                    $fsk_lock,
                    $group_check,
                    $sorting
                );


                // ALTER QUERY
                // $listing_sql_where = "where p.products_status = '1'
                //      and p.products_listing_status = '1' 
                //      and p2c.products_id=p.products_id " .
                //     $products_groups_filter_where.
                //     $group_check . " " .
                //     $fsk_lock . "
                //      and pd.language_id =:language_id ".
                //     $fsk_lock."
                //      and p2c.categories_id =:cat_id ".$sorting;

                $listing_sql = sprintf('%s %s %s',
                    $listing_sql_select,$listing_sql_from,$listing_sql_where
                );
                $parameters['language_id'] = (int)$_SESSION['languages_id'];
                $parameters['cat_id'] =  $current_category_id;
            }
        } // end if manufacturers_id
    		
	// optional Product List Filter
    	if (defined('PRODUCT_LIST_FILTER') and PRODUCT_LIST_FILTER > 0) {
            if (isset($_GET['manufacturers_id'])) {
                // OPTIMIERTER QUERY chatgpt
                $filterlist_sql = sprintf(
                     "select DISTINCT c.categories_id AS id, cd.categories_name AS name"
                    ." from %s p INNER JOIN %s p2c ON p.products_id = p2c.products_id"
                    ." INNER JOIN %s c ON p2c.categories_id = c.categories_id"
                    ." INNER JOIN %s cd ON c.categories_id = cd.categories_id"
                    ." where p.products_status = 1 AND cd.language_id = :language_id"
                    ." AND p.manufacturers_id = :manufacturers_id"
                    ." ORDER BY cd.categories_name",
                    TABLE_PRODUCTS,TABLE_PRODUCTS_TO_CATEGORIES,
                    TABLE_CATEGORIES,TABLE_CATEGORIES_DESCRIPTION,
                );
                // ALTER QUERY
                // $filterlist_sql = "select distinct c.categories_id as id, cd.categories_name as name from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c, " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where p.products_status = '1' and p.products_id = p2c.products_id and p2c.categories_id = c.categories_id and p2c.categories_id = cd.categories_id and cd.language_id =:language_id and p.manufacturers_id =:manufacturers_id order by cd.categories_name";
                $fl_parameters = [
                    'manufacturers_id'=>(int)$_GET['manufacturers_id'],
                    'language_id'=> (int)$_SESSION['languages_id']
                ];
            } else {
                // OPTIMIERTER QUERY chatgpt
                $filterlist_sql = sprintf("select DISTINCT m.manufacturers_id AS id, m.manufacturers_name AS name"
                    ." from %s p INNER JOIN %s p2c ON p.products_id = p2c.products_id"
                    ." INNER JOIN %s m ON p.manufacturers_id = m.manufacturers_id"
                    ." where p.products_status = 1 AND p2c.categories_id = :cat_id"
                    ." order by m.manufacturers_name",
                    TABLE_PRODUCTS,TABLE_PRODUCTS_TO_CATEGORIES,
                    TABLE_MANUFACTURERS
                );
                // ALTER QUERY
                // $filterlist_sql = "select distinct m.manufacturers_id as id, m.manufacturers_name as name from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c, " . TABLE_MANUFACTURERS . " m where p.products_status = '1' and p.manufacturers_id = m.manufacturers_id and p.products_id = p2c.products_id and p2c.categories_id =:cat_id order by m.manufacturers_name";
                $fl_parameters = [
                    'cat_id'=>(int)$current_category_id,
                ];
            }
            
            // wir basteln einen eindeutigen key aus den SQL Parametern
            $key_parts = [];
            foreach($fl_parameters as $flk=>$flv){
                $key_parts[] = sprintf('%s-%s',$flk, $flv);
            }
            $key = 'shop_filterlist_'.implode('_',$key_parts);
            
            $CachedString = $InstanceCache->getItem($key);
            if (!$CachedString->isHit()) {
                $filterlist_query = yes_query($filterlist_sql,$fl_parameters);
                $CachedString->set($filterlist_query)->expiresAfter(YES_CACHE_LIFETIME_LONG)->addTag('shop');//shop_filterlist_*
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $filterlist_query = $CachedString->get();
            }
            if (sizeOf($filterlist_query)) {
                $manufacturer_dropdown= xtc_draw_form('filter', FILENAME_DEFAULT, 'GET') .'&nbsp;';
                if (isset($_GET['manufacturers_id'])) {
                    $manufacturer_dropdown.= xtc_draw_hidden_field('manufacturers_id', (int)xtc_db_input($_GET['manufacturers_id']));
                    $options = array(array('text' => TEXT_ALL_CATEGORIES));
                } else {
                    $manufacturer_dropdown.= xtc_draw_hidden_field('cPath', $cPath);
                    $options = array(array('text' => TEXT_ALL_MANUFACTURERS));
                }
                $manufacturer_dropdown.= xtc_draw_hidden_field('sort', ((isset($_GET['sort']))?(int)xtc_db_input($_GET['sort']):''));
                $manufacturer_dropdown.= xtc_draw_hidden_field(xtc_session_name(), xtc_session_id());
                foreach($filterlist_query as $filterlist) {
                    $options[] = array('id' => $filterlist['id'], 'text' => $filterlist['name']);
		        }
                $manufacturer_dropdown.= xtc_draw_pull_down_menu('filter_id', $options, ((isset($_GET['filter_id']))?(int)xtc_db_input($_GET['filter_id']):''), 'onchange="this.form.submit()"');
                $manufacturer_dropdown.= '</form>' . "\n";
            }
	    } // EOF PRODUCT_LIST_FILTER

        // Get the right image for the top-right
        $image = DIR_WS_IMAGES . 'table_background_list.gif';
        if (isset($_GET['manufacturers_id'])) {
            $key = 'shop_manufacturers_image_'.intval($_GET['manufacturers_id']??0);
            $CachedString = $InstanceCache->getItem($key);
            if (!$CachedString->isHit()) {
                $manu = \YES4Trade\Model\manufacturer::get_by_manufacturers_id((int)$_GET['manufacturers_id'],[
                    'manufacturers_image'
                ]);
                if($manu !== null){
                    $image_manu = $manu->toArray();
                }else{
                    $image_manu = [];
                }
                $CachedString->set($image_manu)->expiresAfter(YES_CACHE_LIFETIME_LONG)->addTag('shop');//shop_manufacturers_image_*
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $image_manu = $CachedString->get();
            }
            $image = $image_manu['manufacturers_image']??'';
	    } elseif ($current_category_id) {
            $cache_key = 'shop_categories_image_'.$current_category_id;
            $cache_group = 'categories';
            $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

            $CachedString = $InstanceCache->getItem($key); // cache group
            if (!$CachedString->isHit()) {
                $cat = \YES4Trade\Model\category::get_by_categories_id((int)$current_category_id,[
                    'categories_image'
                ]);
                if($cat !== null){
                    $image_cat = $cat->toArray();
                }else{
                    $image_cat = [];
                }
                $CachedString->set($image_cat)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $image_cat = $CachedString->get();
            }
            $image = $image_cat['categories_image']??'';
	    }
	    include(DIR_WS_MODULES . FILENAME_PRODUCT_LISTING);
        $smarty->assign('listing_mode','products');
    } else { // default page oder matrix
        $group_check = '';
        if (GROUP_CHECK == 'true') {
                $group_check = "and group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
        }
        $items = \YES4Trade\Model\content_manager::get_by_content_group_and_languages_id(5, (int)$_SESSION['languages_id']);
        if(sizeOf($items)){
            $first = current($items);
            $shop_content_data = $first->toArray();
        }
        $default_smarty->assign('title', $shop_content_data['content_heading']);
        include (DIR_WS_INCLUDES.FILENAME_CENTER_MODULES);
	if (isset($shop_content_data['content_file']) and !empty($shop_content_data['content_file'])) {
            ob_start();
            if (strpos($shop_content_data['content_file'], '.txt')){
                echo '<pre>';
            }
            include (DIR_FS_CATALOG.'media/content/'.$shop_content_data['content_file']);
            if (strpos($shop_content_data['content_file'], '.txt')){
                echo '</pre>';
            }
            $shop_content_data['content_text'] = ob_get_contents();
            ob_end_clean();
	}
	
        $default_smarty->assign('text', str_replace('{$greeting}', xtc_customer_greeting(), $shop_content_data['content_text']));
        $default_smarty->assign('language', $_SESSION['language']);
	
        // set cache ID
        if (USE_CACHE == 'false') {
            $default_smarty->caching = 0;
            $main_content = $default_smarty->fetch(CURRENT_TEMPLATE.'/module/main_content.html');
        } else {
            $default_smarty->caching = 1;
            $default_smarty->cache_lifetime = CACHE_LIFETIME;
            $default_smarty->cache_modified_check = CACHE_CHECK;
            $cache_id = yes_get_store_country_id().$_SESSION['language'].$_SESSION['currency'].$_SESSION['customer_id'];
            $main_content = $default_smarty->fetch(CURRENT_TEMPLATE.'/module/main_content.html', $cache_id);
	}
        $smarty->assign('listing_mode','default');
        if(!isset($_REQUEST['ajaxscrolldown'])){
            $smarty->assign('main_content', $main_content);
        }else{
            echo $main_content;
        }
    }
}
