<?php
/* -----------------------------------------------------------------------------------------
   $Id: ot_discount.php,v 1.5 2012/09/12 07:40:42 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(ot_subtotal.php,v 1.7 2003/02/13); www.oscommerce.com
   (c) 2003	 nextcommerce (ot_discount.php,v 1.11 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

  class ot_discount {
    var $title, $output, $code, $description, $enabled, $sort_order, $Price;

    function __construct($price) {
        $this->code = 'ot_discount';
        $this->title = MODULE_ORDER_TOTAL_DISCOUNT_TITLE;
        $this->description = MODULE_ORDER_TOTAL_DISCOUNT_DESCRIPTION;
        $this->enabled = ((defined('MODULE_ORDER_TOTAL_DISCOUNT_STATUS') and MODULE_ORDER_TOTAL_DISCOUNT_STATUS == 'true') ? true : false);
        $this->sort_order = (defined('MODULE_ORDER_TOTAL_DISCOUNT_SORT_ORDER'))?MODULE_ORDER_TOTAL_DISCOUNT_SORT_ORDER:0;
        $this->Price=$price;
        $this->output = array();
    }

    function process() {
      global $order, $currencies;
      $this->title = $_SESSION['customers_status']['customers_status_ot_discount'] . ' % ' . SUB_TITLE_OT_DISCOUNT;
      if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == '1' && $_SESSION['customers_status']['customers_status_ot_discount']!='0.00') {
        $discount_price = $this->Price->xtcFormat($order->info['subtotal'], false) / 100 * $_SESSION['customers_status']['customers_status_ot_discount']*-1;
        $this->output[] = array('title' => $this->title . ':',
                                'text' => '<font color="ff0000">'.$this->Price->xtcFormat($discount_price,true).'</font>',
                                'value' => $discount_price);
      }
    }
	
	function process_tax_rates($order){
		$tax_array = array();
		foreach($order->products as $product){
			if(!isset($tax_array[ 'TAX'.$product['tax'] ])){
				$tax_array[ 'TAX'.$product['tax'] ] = array();
				$tax_array[ 'TAX'.$product['tax'] ]['tax_rate'] = $product['tax'];
				$tax_array[ 'TAX'.$product['tax'] ]['tax_class_id'] = $product['tax_class_id'];
				$tax_array[ 'TAX'.$product['tax'] ]['tax_total'] = 0;
				$tax_array[ 'TAX'.$product['tax'] ]['percentage'] = 0;
			}
			$tax_array[ 'TAX'.$product['tax'] ]['tax_total'] += $product['final_price'];
		}
		foreach($tax_array as $tax_rate => $tax_data){
                    $tax_array[$tax_rate]['percentage'] = $tax_array[$tax_rate]['tax_total'] / ($order->info['subtotal']/100);
                    $discount_value_brutto = $_SESSION['customers_status']['customers_status_ot_discount'] / 100 * $tax_array[$tax_rate]['percentage'];
                    $discount_value_tax = $discount_value_brutto-($discount_value_brutto / ((100+$tax_array[$tax_rate]['tax_rate'])/100));
                    $order->info['tax'] -= $discount_value_tax;
                    
                    // EU-OSS 2021/07
                    $tax_country_id = $order->delivery['country']['id'];
                    $tax_zone_id = $order->delivery['zone_id'];
                    
                    $discount_tax_description = xtc_get_tax_description($tax_array[$tax_rate]['tax_class_id'], $tax_country_id, $tax_zone_id);
                    $order->info['tax_groups'][TAX_ADD_TAX . $discount_tax_description] -= $discount_value_tax;
                    //$order->info['total'] -= $discount_value_tax;
		}
		
	}
	
    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_DISCOUNT_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }

      return $this->_check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_DISCOUNT_STATUS', 'MODULE_ORDER_TOTAL_DISCOUNT_SORT_ORDER');
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_DISCOUNT_STATUS', 'true','6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_DISCOUNT_SORT_ORDER', '2', '7', '2', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
}