<?php
class cashier {

    var $code, $title, $description, $enabled, $sort_order;


    function __construct() {
        $this->code = 'cashier';
        $this->title = MODULE_OTHER_CASHIER_TITLE;
        $this->description = MODULE_OTHER_CASHIER_DESCRIPTION;
        $this->enabled = ((defined('MODULE_OTHER_CASHIER_STATUS') and MODULE_OTHER_CASHIER_STATUS == 'True') ? true : false);
        $this->sort_order = (defined('MODULE_OTHER_CASHIER_SORT_ORDER'))?MODULE_OTHER_CASHIER_SORT_ORDER:0;
    }


    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_OTHER_CASHIER_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_CASHIER_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_CASHIER_SORT_ORDER', '0',  '6', '1', now())");
		xtc_db_query("CREATE TABLE IF NOT EXISTS `module_cashier_cashiers` (`module_cashier_cashiers_id` INT NOT NULL AUTO_INCREMENT ,`customers_id` INT NOT NULL,`date_created` DATETIME NOT NULL ,`date_changed` DATETIME NOT NULL ,PRIMARY KEY ( `module_cashier_cashiers_id` )) ENGINE = MYISAM;");
		xtc_db_query("CREATE TABLE IF NOT EXISTS `module_cashier_sellers` (`module_cashier_sellers_id` INT NOT NULL AUTO_INCREMENT ,`seller_alias` VARCHAR( 32 ) NOT NULL ,`date_created` DATETIME NOT NULL ,`date_changed` DATETIME NOT NULL ,PRIMARY KEY ( `module_cashier_sellers_id` )) ENGINE = MYISAM;");
		xtc_db_query("CREATE TABLE IF NOT EXISTS `module_cashier_orders` (`module_cashier_orders_id` INT NOT NULL AUTO_INCREMENT ,`module_cashier_seller_id` INT NOT NULL,`module_cashier_cashiers_id` INT NOT NULL,`date_created` DATETIME NOT NULL ,`orders_id` INT(11) NOT NULL, PRIMARY KEY ( `module_cashier_orders_id` )) ENGINE = MYISAM;");

		$admin_access_scheme_exists = false;
		$query = xtc_db_query("SHOW COLUMNS FROM admin_access");
		while($result = xtc_db_fetch_array($query)){
			if($result['Field'] == 'cashier'){
				$admin_access_scheme_exists = true;
			}
		}
		if(!$admin_access_scheme_exists){
			xtc_db_query("ALTER TABLE `admin_access` ADD `cashier` INT NOT NULL");
			xtc_db_query("UPDATE `admin_access` SET cashier='1' WHERE customers_id='1'");
		}
   }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_OTHER_CASHIER_STATUS', 'MODULE_OTHER_CASHIER_SORT_ORDER');
    }
}

