<?php
class google_recaptcha_v2 {

    var $code, $title, $description, $enabled, $sort_order;


    function __construct() {
      $this->code = 'google_recaptcha_v2';
      $this->title = MODULE_OTHER_GOOGLE_RECAPTCHA_V2_TITLE;
      $this->description = MODULE_OTHER_GOOGLE_RECAPTCHA_V2_DESC;
      $this->enabled = ((defined('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS') and MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS == 'True') ? true : false);
      $this->sort_order = (defined('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SORT_ORDER')) ? MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SORT_ORDER : 0;
    }


    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SORT_ORDER', '0',  '6', '1', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SITE_KEY', '',  '6', '5', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SECRET_KEY', '',  '6', '7', now())");
        
   }
   
   function process(){
	return $str;
   }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array(
		  'MODULE_OTHER_GOOGLE_RECAPTCHA_V2_STATUS', 
		  'MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SORT_ORDER',
		  'MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SITE_KEY',
                  'MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SECRET_KEY'
	  );
    }	
    
    public function validate(string $response){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,"https://www.google.com/recaptcha/api/siteverify");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,
            sprintf("secret=%s&response=%s",
                MODULE_OTHER_GOOGLE_RECAPTCHA_V2_SECRET_KEY,
                $response
            )
        );
        // Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $server_output = curl_exec($ch);
        $res = json_decode($server_output);
        curl_close ($ch);
        return $res->success;
    }
}

