<?php
class yes_wayfair {
	var $code, $title, $description, $enabled, $customer_uk, $customer_de, $customer_ir, $customer_at, $dummy_products_id; 

	function __construct() {
		$this->code = 'yes_wayfair';
		$this->title = MODULE_OTHER_YES_WAYFAIR_TEXT_TITLE;
		$this->description = MODULE_OTHER_YES_WAYFAIR_TEXT_DESCRIPTION;
                if( defined('MODULE_OTHER_YES_WAYFAIR_STATUS')){
                    $this->sort_order = MODULE_OTHER_YES_WAYFAIR_SORT_ORDER;
                    $this->enabled = ((MODULE_OTHER_YES_WAYFAIR_STATUS == 'True') ? true : false);
                    $this->customer_uk = MODULE_OTHER_YES_WAYFAIR_CUSTOMER_UK;
                    $this->customer_de = MODULE_OTHER_YES_WAYFAIR_CUSTOMER_DE;
                    $this->customer_ir = MODULE_OTHER_YES_WAYFAIR_CUSTOMER_IR;
                    $this->customer_at = MODULE_OTHER_YES_WAYFAIR_CUSTOMER_AT;
                    $this->dummy_products_id = MODULE_OTHER_YES_WAYFAIR_DUMMY_PRODUCTS_ID;
                }
	}


	function check() {
		if (!isset($this->_check)) {
			$check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_OTHER_YES_WAYFAIR_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}

	function install() {
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_YES_WAYFAIR_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_WAYFAIR_SORT_ORDER', '0',  '6', '2', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_WAYFAIR_CUSTOMER_DE', '',  '6', '3', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_WAYFAIR_CUSTOMER_UK', '',  '6', '4', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_WAYFAIR_CUSTOMER_IR', '',  '6', '5', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_WAYFAIR_CUSTOMER_AT', '',  '6', '6', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_WAYFAIR_DUMMY_PRODUCTS_ID', '',  '6', '7', now())");
		xtc_db_query("CREATE TABLE IF NOT EXISTS `wayfair_orders` ( `wayfair_orders_id` INT NOT NULL AUTO_INCREMENT , `orders_id` INT NOT NULL , `po_number` VARCHAR(16) NOT NULL , `supplier_id` VARCHAR(16) NOT NULL , `dropship_qualifier` VARCHAR(2) NOT NULL , `vat_number` VARCHAR(16) NOT NULL , `date_added` DATETIME NOT NULL , PRIMARY KEY (`wayfair_orders_id`), INDEX (`orders_id`)) ENGINE = InnoDB;");
		xtc_db_query("CREATE TABLE IF NOT EXISTS `wayfair_products` ( `wayfair_products_id` INT NOT NULL AUTO_INCREMENT , `products_id` INT NOT NULL, date_added DATETIME NOT NULL , PRIMARY KEY (`wayfair_products_id`), INDEX (`products_id`)) ENGINE = InnoDB;");
	}

	function remove() {
		xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
	}

	function keys() {
		return array(
			'MODULE_OTHER_YES_WAYFAIR_STATUS', 
			'MODULE_OTHER_YES_WAYFAIR_SORT_ORDER',
			'MODULE_OTHER_YES_WAYFAIR_CUSTOMER_DE',
			'MODULE_OTHER_YES_WAYFAIR_CUSTOMER_UK',
			'MODULE_OTHER_YES_WAYFAIR_CUSTOMER_IR',
			'MODULE_OTHER_YES_WAYFAIR_CUSTOMER_AT',
			'MODULE_OTHER_YES_WAYFAIR_DUMMY_PRODUCTS_ID'
		);
	}
}
