<?php
/* -----------------------------------------------------------------------------------------
   $Id: banktransfer.php,v 1.2 2014/03/13 15:01:31 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(banktransfer.php,v 1.16 2003/03/02 22:01:50); www.oscommerce.com 
   (c) 2003	 nextcommerce (banktransfer.php,v 1.9 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   -----------------------------------------------------------------------------------------
   Third Party contributions:
   OSC German Banktransfer v0.85a       	Autor:	Dominik Guder <osc@guder.org>
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/


  class banktransfer {

    var $code, $title, $description, $enabled;


    function __construct() {
      global $order;

      $this->code = 'banktransfer';
      $this->title = MODULE_PAYMENT_BANKTRANSFER_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_BANKTRANSFER_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_PAYMENT_BANKTRANSFER_SORT_ORDER')) ? MODULE_PAYMENT_BANKTRANSFER_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_PAYMENT_BANKTRANSFER_STATUS') and MODULE_PAYMENT_BANKTRANSFER_STATUS == 'True') ? true : false);
      if($this->enabled === true){
        $this->min_order = MODULE_PAYMENT_BANKTRANSFER_MIN_ORDER;

        if ((int)MODULE_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID > 0) {
          $this->order_status = MODULE_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID;
        }
      }
      if (is_object($order)) $this->update_status();

      if ($_POST['banktransfer_fax'] == "on")
        $this->email_footer = MODULE_PAYMENT_BANKTRANSFER_TEXT_EMAIL_FOOTER;
    }


    function update_status() {
        global $order;
        $customer_id = (int)$_SESSION['customer_id'];
        $check_order_query = yes_query(
            "select orders_id from " . TABLE_ORDERS . " where customers_id =:customers_id",
            ['customers_id'=>$customer_id],
        );
        $order_check = sizeOf($check_order_query);
        if ($order_check >= MODULE_PAYMENT_BANKTRANSFER_MIN_ORDER) {
            $check_flag = false;
        }else{
            if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_BANKTRANSFER_ZONE > 0) ) {
                $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
                    intval(MODULE_PAYMENT_BANKTRANSFER_ZONE),
                    intval($order->billing['country']['id']),
                    intval($order->billing['zone_id'])
                );
            }
            if ($check_flag == false) {
                $this->enabled = false;
            }
        }

        if ($this->enabled == true) {
            if ($order->content_type == 'virtual') {
                $this->enabled = false;
            }
        }
    }

    function javascript_validation() {
      $js = 'if (payment_value == "' . $this->code . '") {' . "\n" .
            '  var banktransfer_blz = document.checkout_payment.banktransfer_blz.value;' . "\n" .
            '  var banktransfer_number = document.checkout_payment.banktransfer_number.value;' . "\n" .
            '  var banktransfer_owner = document.checkout_payment.banktransfer_owner.value;' . "\n" .
            '  var banktransfer_fax = document.checkout_payment.banktransfer_fax.checked;' . "\n" .
            '  if (banktransfer_fax == false) {' . "\n" .
            '    if (banktransfer_blz == "") {' . "\n" .
            '      error_message = error_message + "' . JS_BANK_BLZ . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '    if (banktransfer_number == "") {' . "\n" .
            '      error_message = error_message + "' . JS_BANK_NUMBER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '    if (banktransfer_owner == "") {' . "\n" .
            '      error_message = error_message + "' . JS_BANK_OWNER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '  }' . "\n" .
            '}' . "\n";
      return $js;
    }

    function selection() {
      global $order;



      $selection = array('id' => $this->code,
                         'module' => $this->title,
      	                 'fields' => array(array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE,
      	                                         'field' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_INFO),
      	                                   array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_OWNER,
      	                                         'field' => xtc_draw_input_field('banktransfer_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'])),
      	                                   array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_BLZ,
      	                                         'field' => xtc_draw_input_field('banktransfer_blz', $_GET['banktransfer_blz'], 'size="8" maxlength="8"')),
      	                                   array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_NUMBER,
      	                                         'field' => xtc_draw_input_field('banktransfer_number',  $_GET['banktransfer_number'], 'size="16" maxlength="32"')),
      	                                   array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_NAME,
      	                                         'field' => xtc_draw_input_field('banktransfer_bankname')),
      	                                   array('title' => '',
      	                                         'field' => xtc_draw_hidden_field('recheckok', $_POST['recheckok']))
      	                                   ));

      if (MODULE_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION =='true'){
        $selection['fields'][] = array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE,
      	                               'field' => MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE2 . '<a href="' . MODULE_PAYMENT_BANKTRANSFER_URL_NOTE . '" target="_blank"><b>' . MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE3 . '</b></a>' . MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE4);
      	$selection['fields'][] = array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_FAX,
      	                               'field' => xtc_draw_checkbox_field('banktransfer_fax', 'on'));

      }

      return $selection;
    }

    function pre_confirmation_check(){

      if ($_POST['banktransfer_fax'] == false) {
        include(DIR_WS_CLASSES . 'banktransfer_validation.php');

        $banktransfer_validation = new AccountCheck;
        $banktransfer_result = $banktransfer_validation->CheckAccount($_POST['banktransfer_number'], $_POST['banktransfer_blz']);

        if ($banktransfer_result > 0 ||  $_POST['banktransfer_owner'] == '') {
          if ($_POST['banktransfer_owner'] == '') {
            $error = 'Name des Kontoinhabers fehlt!';
            $recheckok = '';
          } else {
            switch ($banktransfer_result) {
              case 1: // number & blz not ok
                $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_1;
                $recheckok = 'true';
                break;
              case 5: // BLZ not found
                $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_5;
                $recheckok = 'true';
                break;
              case 8: // no blz entered
                $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_8;
                $recheckok = '';
                break;
              case 9: // no number entered
                $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_9;
                $recheckok = '';
                break;
              default:
                $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_4;
                $recheckok = 'true';
                break;
            }
          }

          if ($_POST['recheckok'] != 'true') {
            $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) . '&banktransfer_owner=' . urlencode($_POST['banktransfer_owner']) . '&banktransfer_number=' . urlencode($_POST['banktransfer_number']) . '&banktransfer_blz=' . urlencode($_POST['banktransfer_blz']) . '&banktransfer_bankname=' . urlencode($_POST['banktransfer_bankname']) . '&recheckok=' . $recheckok;

if(defined('USE_EASYCHECKOUT') and USE_EASYCHECKOUT == 'True'){
    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING, $payment_error_return, 'SSL', true, false));
}else{
    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
}
          }
        }
        $this->banktransfer_owner = $_POST['banktransfer_owner'];
        $this->banktransfer_blz = $_POST['banktransfer_blz'];
        $this->banktransfer_number = $_POST['banktransfer_number'];
        $this->banktransfer_prz = $banktransfer_validation->PRZ;
        $this->banktransfer_status = $banktransfer_result;
        if ($banktransfer_validation->Bankname != '')
          $this->banktransfer_bankname = $banktransfer_validation->Bankname;
        else
          $this->banktransfer_bankname = $_POST['banktransfer_bankname'];
      }
    }

    function confirmation() {
      global $banktransfer_val, $banktransfer_owner, $banktransfer_bankname, $banktransfer_blz, $banktransfer_number, $checkout_form_action, $checkout_form_submit;

      if (!$_POST['banktransfer_owner'] == '') {
        $confirmation = array('title' => $this->title,
                              'fields' => array(array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_OWNER,
                                                      'field' => $this->banktransfer_owner),
                                                array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_BLZ,
                                                      'field' => $this->banktransfer_blz),
                                                array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_NUMBER,
                                                      'field' => $this->banktransfer_number),
                                                array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_NAME,
                                                      'field' => $this->banktransfer_bankname)
                                                ));
      }
      if ($_POST['banktransfer_fax'] == "on") {
        $confirmation = array('fields' => array(array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_FAX)));
        $this->banktransfer_fax = "on";
      }
      return $confirmation;
    }

    function process_button() {
      global $_POST;

      $process_button_string = xtc_draw_hidden_field('banktransfer_blz', $this->banktransfer_blz) .
                               xtc_draw_hidden_field('banktransfer_bankname', $this->banktransfer_bankname).
                               xtc_draw_hidden_field('banktransfer_number', $this->banktransfer_number) .
                               xtc_draw_hidden_field('banktransfer_owner', $this->banktransfer_owner) .
                               xtc_draw_hidden_field('banktransfer_status', $this->banktransfer_status) .
                               xtc_draw_hidden_field('banktransfer_prz', $this->banktransfer_prz) .
                               xtc_draw_hidden_field('banktransfer_fax', $this->banktransfer_fax);

      return $process_button_string;

    }

    function before_process() {
      return false;
    }

    function after_process() {
      global $insert_id, $_POST, $banktransfer_val, $banktransfer_owner, $banktransfer_bankname, $banktransfer_blz, $banktransfer_number, $banktransfer_status, $banktransfer_prz, $banktransfer_fax, $checkout_form_action, $checkout_form_submit;
      $insert_sql_array = [
          'orders_id'=>(int)$insert_id, 
          'banktransfer_blz'=>$_POST['banktransfer_blz'], 
          'banktransfer_bankname'=>$_POST['banktransfer_bankname'], 
          'banktransfer_number'=>$_POST['banktransfer_number'], 
          'banktransfer_owner'=>$_POST['banktransfer_owner'], 
          'banktransfer_status'=>$_POST['banktransfer_status'], 
          'banktransfer_prz'=>$_POST['banktransfer_prz'],
          'banktransfer_fax'=>$_POST['banktransfer_fax']??''
      ];
      yes_db_perform('banktransfer',$insert_sql_array);
    }

    function get_error() {

      $error = array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR,
                     'error' => stripslashes(urldecode($_GET['error'])));

      return $error;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_BANKTRANSFER_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_ZONE', '0',  '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
	  xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_ALLOWED', '', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_SORT_ORDER', '0', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION', 'false',  '6', '2', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_DATABASE_BLZ', 'false', '6', '0', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_URL_NOTE', 'fax.html', '6', '0', now())");
      xtc_db_query("CREATE TABLE IF NOT EXISTS banktransfer (orders_id int(11) NOT NULL default '0', banktransfer_owner varchar(64) default NULL, banktransfer_number varchar(24) default NULL, banktransfer_bankname varchar(255) default NULL, banktransfer_blz varchar(8) default NULL, banktransfer_status int(11) default NULL, banktransfer_prz char(2) default NULL, banktransfer_fax char(2) default NULL, KEY orders_id(orders_id))");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_MIN_ORDER', '0',  '6', '0', now())");
    }


    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_BANKTRANSFER_STATUS','MODULE_PAYMENT_BANKTRANSFER_ALLOWED', 'MODULE_PAYMENT_BANKTRANSFER_ZONE', 'MODULE_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID', 'MODULE_PAYMENT_BANKTRANSFER_SORT_ORDER', 'MODULE_PAYMENT_BANKTRANSFER_DATABASE_BLZ', 'MODULE_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION', 'MODULE_PAYMENT_BANKTRANSFER_MIN_ORDER', 'MODULE_PAYMENT_BANKTRANSFER_URL_NOTE');
    }
  }
