<?php
/* -----------------------------------------------------------------------------------------
   $Id: cc_credit.php,v 1.2 2017/03/01 08:57:35 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com 
   (c) 2003	 nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License
	  
	 module written by Thomas Linke: tom@xtc-webservice.de
   ---------------------------------------------------------------------------------------*/


  class cc_credit {
    var $code, $title, $description, $enabled;


    function __construct() {
      global $order;

      $this->code = 'cc_credit';
      $this->title = MODULE_PAYMENT_CC_CREDIT_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_CC_CREDIT_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_PAYMENT_CC_CREDIT_SORT_ORDER')) ? MODULE_PAYMENT_CC_CREDIT_SORT_ORDER:0;
      $this->enabled = ((defined('MODULE_PAYMENT_CC_CREDIT_STATUS') and MODULE_PAYMENT_CC_CREDIT_STATUS == 'True') ? true : false);
      if($this->enabled === true){
        $this->min_order = MODULE_PAYMENT_CC_CREDIT_MIN_ORDER;
        $this->min_value = MODULE_PAYMENT_CC_CREDIT_MIN_VALUE;
        if ((int)MODULE_PAYMENT_CC_CREDIT_ORDER_STATUS_ID > 0) {
          $this->order_status = MODULE_PAYMENT_CC_CREDIT_ORDER_STATUS_ID;
        }
      }

      if (is_object($order)) $this->update_status();
			$this->form_action_url = 'checkout_process_cc_credit.php';
    }


    function update_status(){
        global $order;
	if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1){
            $total = $order->info['total']+$order->info['tax'];
        }else{
            $total = $order->info['total'];
        }

        $check_order_query = yes_query(
            "select count(*) as count from " . TABLE_ORDERS . " where customers_id =:customers_id",
            ['customers_id'=>(int)$_SESSION['customer_id']]
        );
        $order_check = sizeOf($check_order_query);

	if ($order_check['count'] < MODULE_PAYMENT_CC_CREDIT_MIN_ORDER || $total < MODULE_PAYMENT_CC_CREDIT_MIN_VALUE){
            $check_flag = false;
            $this->enabled = false;
        }else{
            $check_flag = true;
            if ( ($this->enabled == true) && ((int)MODULE_CC_CREDIT_INVOICE_ZONE > 0) ) {
                $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
                    intval(MODULE_PAYMENT_CC_CREDIT_ZONE),
                    intval($order->delivery['country']['id']),
                    intval($order->delivery['zone_id'])
                );
            }
            if ($check_flag == false) {
                $this->enabled = false;
            }
        }

        if ($this->enabled == true) {
            if ($order->content_type == 'virtual') {
                $this->enabled = false;
            }
        }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return false;
    }
    
    /**
     * Da wir den process_button bei EASYCHECKOUT nicht haben, muessen die
     * Daten in der checkout_process_cc_credit.php bereitgestellt werden
     * @return array Die Daten die an santander uebergeben werden muessen
     */
    function yes_get_process_data(){
        global $order, $xtPrice;
        if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1){
            $total=$order->info['total']+$order->info['tax'];
        } else {
            $total=$order->info['total'];
        }
        $my_currency = 'EUR';
	if ($_SESSION['currency']==$my_currency){
            $amount=round($total, $xtPrice->get_decimal_places($my_currency));
            $shipping=round($order->info['shipping_cost'], $xtPrice->get_decimal_places($my_currency));
        }else{
            $amount=round($xtPrice->xtcCalculateCurrEx($total,$my_currency) , $xtPrice->get_decimal_places($my_currency));
            $shipping=round($xtPrice->xtcCalculateCurrEx($order->info['shipping_cost'],$my_currency) , $xtPrice->get_decimal_places($my_currency));
        }
        return array(
            'haendlernummer'=>MODULE_PAYMENT_CC_CREDIT_ID,
            'kaufpreis'=>$amount,
            'warenbezeichnung'=>$_SESSION['customer_id']
        );
    }

    function process_button()
		{
      global $order, $xtPrice;

			if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1)
			{
				$total=$order->info['total']+$order->info['tax'];
      } else 
			{
				$total=$order->info['total'];
      }

			$my_currency = 'EUR';
			
			if ($_SESSION['currency']==$my_currency)
			{
      	$amount=round($total, $xtPrice->get_decimal_places($my_currency));
	      $shipping=round($order->info['shipping_cost'], $xtPrice->get_decimal_places($my_currency));
      } 
			else
			{
      	$amount=round($xtPrice->xtcCalculateCurrEx($total,$my_currency) , $xtPrice->get_decimal_places($my_currency));
	      $shipping=round($xtPrice->xtcCalculateCurrEx($order->info['shipping_cost'],$my_currency) , $xtPrice->get_decimal_places($my_currency));
      }

      $process_button_string = xtc_draw_hidden_field('haendlernummer', MODULE_PAYMENT_CC_CREDIT_ID) .
                               xtc_draw_hidden_field('kaufpreis', $amount) .
                               xtc_draw_hidden_field('warenbezeichnung', $_SESSION['customer_id']);

      return $process_button_string;
    }

    function before_process() {
      return false;
    }

    function after_process() {
        global $insert_id;
        if ($this->order_status) {
            $update_sql_array = [
                'orders_status'=>$this->order_status
            ];
            yes_db_perform(TABLE_ORDERS,$update_sql_array,'update',[
                'orders_id'=>$insert_id
            ]);
        }
    }

    function get_error() {
        return false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_CC_CREDIT_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_CC_CREDIT_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	  	xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_CC_CREDIT_ALLOWED', '', '6', '2', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_CC_CREDIT_ZONE', '0',  '6', '3', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_CC_CREDIT_SORT_ORDER', '0',  '6', '4', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_CC_CREDIT_MIN_ORDER', '0',  '6', '5', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_CC_CREDIT_MIN_VALUE', '0',  '6', '6', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_CC_CREDIT_ORDER_STATUS_ID', '0',  '6', '7', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_CC_CREDIT_ID', '0000000000',  '6', '8', now())");
   }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array(
				'MODULE_PAYMENT_CC_CREDIT_ID',
				'MODULE_PAYMENT_CC_CREDIT_STATUS',
				'MODULE_PAYMENT_CC_CREDIT_ALLOWED', 
				'MODULE_PAYMENT_CC_CREDIT_ZONE', 
				'MODULE_PAYMENT_CC_CREDIT_ORDER_STATUS_ID', 
				'MODULE_PAYMENT_CC_CREDIT_MIN_ORDER', 
				'MODULE_PAYMENT_CC_CREDIT_SORT_ORDER', 
				'MODULE_PAYMENT_CC_CREDIT_MIN_VALUE');
    }
  }
