<?php
/* includes/modules/payment/paypal_ppp/hook_login_client.php
.---------------------------------------------------------------------------.
|    Software: PayPal-Plus-Module                                           |
|     Version: 0.5beta                                                      |
|        Date: 2015-09-30                                                   |
| Description: hook to login a customer                                     |
|     Contact: info@andreas-guder.de                                        |
| ------------------------------------------------------------------------- |
|      Author: Andreas Guder                                                |
|     Contact: info@andreas-guder.de                                        |
| Copyright (c) 2015, Andreas Guder.                                        |
| ------------------------------------------------------------------------- |
|     License:  GNU Public License V2.0                                     |
|               http://www.gnu.org/licenses/gpl-2.0.html                    |
'--------------------------------------------------------------------------'
*/

if (!function_exists('xtc_get_countriesList'))
require_once DIR_FS_INC.'xtc_get_countries.inc.php';
$must_utf8_decode = strtolower($_SESSION['language_charset']) != 'utf-8' ? true : false;
if ($must_utf8_decode)
{
  foreach ($aShippingAddress as $key => $value)
    $aShippingAddress[$key] = utf8_decode($value);
  foreach ($aCustomersData as $key => $value)
    $aCustomersData[$key] = utf8_decode($value);
}
  
  $q = xtc_db_query("SELECT * FROM `".TABLE_CUSTOMERS."` WHERE `customers_email_address`='".xtc_db_input($aCustomersData['email_address'])."' ORDER BY `customers_last_modified` DESC LIMIT 0,1");
  if (xtc_db_num_rows($q) === 1)
  {
    $cData = xtc_db_fetch_array($q);
    xtc_db_free_result($q);
    $_SESSION['account_type'] = $cData['account_type'];
    
    $_SESSION['customer_first_name'] = $cData['customers_firstname'];
    $_SESSION['customer_last_name'] = $cData['customers_lastname'];
    $_SESSION['customer_default_address_id'] = $cData['customers_default_address_id'];
    $_SESSION['customer_vat_id'] = $cData['customers_vat_id'];
    $_SESSION['customer_id'] = $cData['customers_id'];
          
    $q = xtc_db_query("SELECT * FROM `".TABLE_ADDRESS_BOOK."` WHERE `address_book_id`='".$cData['customers_default_address_id']."'");
    $aData = xtc_db_fetch_array($q);
    xtc_db_free_result($q);
    if ($aData)
    {
      $_SESSION['customer_country_id'] = $aData['entry_country_id'];
      $_SESSION['customer_zone_id'] = $aData['entry_zone_id'];
    }
    else
    {
      $_SESSION['customer_country_id'] = STORE_COUNTRY;
      $_SESSION['customer_zone_id'] = 0;
    }
    
    // check send-to
    $sendto = empty($_SESSION['sendto']) ? $cData['customers_default_address_id'] : $_SESSION['sendto'];
    
    $check_address_query = xtc_db_query("SELECT * FROM `".TABLE_ADDRESS_BOOK."` WHERE `customers_id` = '".(int) $_SESSION['customer_id']."' and address_book_id = '".(int)$sendto."'");
    $check_address = xtc_db_fetch_array($check_address_query);
    $insert_address = false;
    $renew = false;
    if ($check_address)
    {
      // compare_address
      if (!$renew && $check_address['entry_lastname'] != $aShippingAddress['lastname'])
        $renew = true;
      if (!$renew && $check_address['entry_street_address'] != $aShippingAddress['street'])
        $renew = true;
      if (!$renew && $check_address['entry_city'] != $aShippingAddress['city'])
        $renew = true;
    }
    else
    {
      $insert_address = true;
    }
    if ($insert_address || $renew)
    {
      // Adresse anlegen
      $sql_data_array = array (
        'customers_id'          => $_SESSION['customer_id'],
        'entry_firstname'       => $aShippingAddress['firstname'],
        'entry_lastname'        => $aShippingAddress['lastname'],
        'entry_street_address'  => $aShippingAddress['street'],
        'entry_suburb'          => $aShippingAddress['suburb'],
        'entry_postcode'        => $aShippingAddress['postal_code'],
        'entry_city'            => $aShippingAddress['city'],
        'entry_state'           => $aShippingAddress['state'],
        'address_date_added'    => 'now()',
        'address_last_modified' => 'now()'
      );
      if (!empty($aShippingAddress['country_code']))
      {
        $q = xtc_db_fetch_array(xtc_db_query("SELECT `countries_id` FROM `".TABLE_COUNTRIES."` WHERE `countries_iso_code_2`='".xtc_db_input($aShippingAddress['country_code'])."'"));
        if ($q)
          $sql_data_array['entry_country_id'] = $q['countries_id'];
        else
          $sql_data_array['entry_country_id'] = STORE_COUNTRY;
      }
      else
      {
        $sql_data_array['entry_country_id'] = STORE_COUNTRY;
      }
      xtc_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);
      $_SESSION['sendto'] = xtc_db_insert_id();
      $tmp = xtc_get_countriesList($sql_data_array['entry_country_id'], true);
      $_SESSION['delivery_zone'] = $tmp['countries_iso_code_2'];
    }
  }
  else
  {
    // it is a new client, login as guest
    xtc_db_free_result($q);
    if (!isset($customers_status) || $customers_status == 0) 
      $customers_status = DEFAULT_CUSTOMERS_STATUS_ID_GUEST != 0 ? DEFAULT_CUSTOMERS_STATUS_ID_GUEST : 1;
  
    $sql_data_array = array (
      'customers_status'        => $customers_status,
      'customers_firstname'     => $aCustomersData['firstname'],
      'customers_lastname'      => $aCustomersData['lastname'],
      'customers_email_address' => $aCustomersData['email_address'],
      'customers_vat_id'        => $aCustomersData['tax_id'],
      'customers_telephone'     => $aCustomersData['phone'],
      'customers_newsletter'    => 0,
      'account_type'            => '1',
      'customers_date_added'    => 'now()',
      'customers_last_modified' => 'now()'
    );
    if (!empty($aCustomersData['date_of_birth']))
      $sql_data_array['customers_dob'] = $aCustomersData['date_of_birth'];
      
    xtc_db_perform(TABLE_CUSTOMERS, $sql_data_array);
    $_SESSION['customer_id'] = xtc_db_insert_id();
    
    // Adresse anlegen
    $sql_data_array = array (
      'customers_id'          => $_SESSION['customer_id'],
      'entry_firstname'       => $aShippingAddress['firstname'],
      'entry_lastname'        => $aShippingAddress['lastname'],
      'entry_street_address'  => $aShippingAddress['street'],
      'entry_suburb'          => $aShippingAddress['suburb'],
      'entry_postcode'        => $aShippingAddress['postal_code'],
      'entry_city'            => $aShippingAddress['city'],
      'entry_state'           => $aShippingAddress['state'],
      'address_date_added'    => 'now()',
      'address_last_modified' => 'now()'
    );
    if (!empty($aShippingAddress['country_code']))
    {
      $q = xtc_db_fetch_array(xtc_db_query("SELECT `countries_id` FROM `".TABLE_COUNTRIES."` WHERE `countries_iso_code_2`='".xtc_db_input($aShippingAddress['country_code'])."'"));
      if ($q)
        $sql_data_array['entry_country_id'] = $q['countries_id'];
      else
        $sql_data_array['entry_country_id'] = STORE_COUNTRY;
    }
    else
    {
      $sql_data_array['entry_country_id'] = STORE_COUNTRY;
    }
    xtc_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);
    $_SESSION['customer_default_address_id'] = xtc_db_insert_id();
    $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
    $tmp = xtc_get_countriesList($sql_data_array['entry_country_id'], true);
    $_SESSION['delivery_zone'] = $tmp['countries_iso_code_2'];
    
    $_SESSION['customer_first_name']    = $aCustomersData['firstname'];
    $_SESSION['customer_last_name']     = $aCustomersData['lastname'];
    $_SESSION['customer_country_id']    = $sql_data_array['entry_country_id'];
    $_SESSION['customer_zone_id']       = 0;
    $_SESSION['customer_vat_id']        = $aCustomersData['tax_id'];
    
    xtc_db_query("UPDATE " . TABLE_CUSTOMERS . " SET customers_default_address_id = '" . (int)$_SESSION['customer_default_address_id'] . "' WHERE customers_id = '" . (int)$_SESSION['customer_id'] . "'");
    xtc_db_query("INSERT INTO " . TABLE_CUSTOMERS_INFO . " (customers_info_id, customers_info_number_of_logons, customers_info_date_account_created) VALUES ('" . (int)$_SESSION['customer_id'] . "', '0', now())");
  }
  $_SESSION['cart']->restore_contents();
?>