<?php
class yes_amazon_pay {

    var $code, //name of the module
	    $title, //title name in list
	    $description,
	    $enabled;

    /**
     * Constructor
     */
    function __construct() {
        global $order;
        $this->code = 'yes_amazon_pay';
        $this->title =MODULE_PAYMENT_YES_AMAZON_PAY_TEXT_TITLE;
        $this->sort_order = (defined('MODULE_PAYMENT_YES_AMAZON_PAY_SORT_ORDER')) ? MODULE_PAYMENT_YES_AMAZON_PAY_SORT_ORDER : 0;
        $this->enabled = (defined('MODULE_PAYMENT_YES_AMAZON_PAY_STATUS') and MODULE_PAYMENT_YES_AMAZON_PAY_STATUS == 'True') ? true : false;
        $this->description = MODULE_PAYMENT_YES_AMAZON_PAY_TEXT_DESCRIPTION;

        if (is_object($order)) {
            $this->update_status();
        }
    }

    /**
     * Function that checks if payment_module is available for this zone
     * Function is called when displaying the available payments
     */
    function update_status() {
        global $order;

        if (($this->enabled == true) && ((int) MODULE_PAYMENT_YES_AMAZON_PAY_ZONE > 0)) {
            $billing_country_id = (!strstr($_SERVER['SCRIPT_URL'],'/admin/') and function_exists('xtc_catalog_href_link')) ? $order->billing['country']['id'] : $order->billing['country_id'];
            $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
                intval(MODULE_PAYMENT_YES_AMAZON_PAY_ZONE),
                intval($billing_country_id),
                intval($order->billing['zone_id'])
            );
            if ($check_flag == false) {
                    $this->enabled = false;
            }
        }
        
        if (($this->enabled == true) && $this->conf->yes_amazon_pay->delivery_differs_disable && MODULE_PAYMENT_YES_AMAZON_PAY_DELIVERY_DISABLE == "Ja") {
            $check_delivery_differs = $this->_check_delivery_differs($order);
            if ($check_delivery_differs) {
                $this->enabled = false;
            }
        }        
    }

    /**
     * Function that returns javascript code that will validate the data required from user for the payment
     *
     * @return string
     */
    function javascript_validation() {
        return '';
    }

    /**
     * Function that returns what should be displayed on Available payment types page
     *
     * @return array
     */
    function selection() {
        global $order;
	$selection = array('id' => $this->code, 'module' => $title,
	    'fields' => $fields
	);
	if(defined('MODULE_PAYMENT_SECUPAY_YES_AMAZON_PAY_TEXT_INFO')){
		$selection['description'] = MODULE_PAYMENT_SECUPAY_YES_AMAZON_PAY_TEXT_INFO;
	}
	// MARIO (YES): process button starten um secupay_ls_total zu setzen
	$this->process_button();
        return $selection;
    }

    /**
     * Function that checks if configuration key is available in database
     */
    function check() {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_PAYMENT_YES_AMAZON_PAY_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function pre_confirmation_check() {
    }

    function confirmation() {
        global $order;

        $confirmation = array('title' => $this->title,
            'fields' => array()
        );
        return $confirmation;
    }

    function process_button() {
        global $order;
        $total = $order->info['total'];
        return false;
    }
    
    /**
     * Function that handles successfull payment, or does the request on Secupay API
     */
    function before_process() {
        global $order;
    }

    /**
     * function that writes to log and db
     */
    function after_process() {
        global $insert_id;
    }

    /**
     * Function that installs Secupay Invoice payment module
     */
    function install() {
	xtc_db_query("DELETE FROM configuration WHERE configuration_key LIKE 'MODULE_PAYMENT_YES_AMAZON_PAY_%'");
        $insert_sql_array = array(
		'configuration_key'=>'MODULE_PAYMENT_YES_AMAZON_PAY_STATUS',
		'configuration_value'=>'False',
		'configuration_group_id'=>6,
		'sort_order'=>0,
		'last_modified'=>'',
		'date_added'=>'now()',
		'use_function'=>'',
		'set_function'=>"xtc_cfg_select_option(array('True', 'False'),"
	);
	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        $insert_sql_array = array(
		'configuration_key'=>'MODULE_PAYMENT_YES_AMAZON_PAY_SORT_ORDER',
		'configuration_value'=>0,
		'configuration_group_id'=>6,
		'sort_order'=>1,
		'last_modified'=>'',
		'date_added'=>'now()',
		'use_function'=>'',
		'set_function'=>''
	);
	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        $insert_sql_array = array(
		'configuration_key'=>'MODULE_PAYMENT_YES_AMAZON_PAY_ZONE',
		'configuration_value'=>'',
		'configuration_group_id'=>6,
		'sort_order'=>2,
		'last_modified'=>'',
		'date_added'=>'now()',
		'use_function'=>'xtc_get_zone_class_title',
		'set_function'=>'xtc_cfg_pull_down_zone_classes('
	);
	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        $insert_sql_array = array(
		'configuration_key'=>'MODULE_PAYMENT_YES_AMAZON_PAY_MERCHANT_ID',
		'configuration_value'=>'',
		'configuration_group_id'=>6,
		'sort_order'=>3,
		'last_modified'=>'',
		'date_added'=>'now()',
		'use_function'=>'',
		'set_function'=>''
	);
	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);

        $insert_sql_array = array(
		'configuration_key'=>'MODULE_PAYMENT_YES_AMAZON_PAY_ACCESS_KEY',
		'configuration_value'=>'',
		'configuration_group_id'=>6,
		'sort_order'=>4,
		'last_modified'=>'',
		'date_added'=>'now()',
		'use_function'=>'',
		'set_function'=>''
	);
	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);

        $insert_sql_array = array(
		'configuration_key'=>'MODULE_PAYMENT_YES_AMAZON_PAY_SECRET_KEY',
		'configuration_value'=>'',
		'configuration_group_id'=>6,
		'sort_order'=>5,
		'last_modified'=>'',
		'date_added'=>'now()',
		'use_function'=>'',
		'set_function'=>''
	);
	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);

        $insert_sql_array = array(
		'configuration_key'=>'MODULE_PAYMENT_YES_AMAZON_PAY_CLIENT_ID',
		'configuration_value'=>'',
		'configuration_group_id'=>6,
		'sort_order'=>6,
		'last_modified'=>'',
		'date_added'=>'now()',
		'use_function'=>'',
		'set_function'=>''
	);
	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);

        $insert_sql_array = array(
		'configuration_key'=>'MODULE_PAYMENT_YES_AMAZON_PAY_REGION',
		'configuration_value'=>'',
		'configuration_group_id'=>6,
		'sort_order'=>7,
		'last_modified'=>'',
		'date_added'=>'now()',
		'use_function'=>'',
		'set_function'=>''
	);
	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);

        $insert_sql_array = array(
		'configuration_key'=>'MODULE_PAYMENT_YES_AMAZON_PAY_SANDBOX',
		'configuration_value'=>'False',
		'configuration_group_id'=>6,
		'sort_order'=>8,
		'last_modified'=>'',
		'date_added'=>'now()',
		'use_function'=>'',
		'set_function'=>"xtc_cfg_select_option(array('True', 'False'),"
	);
	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
    }

    /**
     * Function that removes payment module
     */
    function remove() {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys(){
	return 	 array(
		'MODULE_PAYMENT_YES_AMAZON_PAY_STATUS',
		'MODULE_PAYMENT_YES_AMAZON_PAY_SORT_ORDER',
		'MODULE_PAYMENT_YES_AMAZON_PAY_ZONE',
		'MODULE_PAYMENT_YES_AMAZON_PAY_MERCHANT_ID',
		'MODULE_PAYMENT_YES_AMAZON_PAY_ACCESS_KEY',
		'MODULE_PAYMENT_YES_AMAZON_PAY_SECRET_KEY',
		'MODULE_PAYMENT_YES_AMAZON_PAY_CLIENT_ID',
		'MODULE_PAYMENT_YES_AMAZON_PAY_REGION',
		'MODULE_PAYMENT_YES_AMAZON_PAY_SANDBOX'
       );
   }

	public function getOpenerJavascript(){

	}
	public function getLoginButton(){
		return 'amz button';
	}


}
